#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}


function main(){
    cd ${EXEC_HOME}/../pyscripts/
    result_status=$(. /opt/oss/manager/agent/bin/engr_profile.sh;python -c "import sys;sys.path.append('${EXEC_HOME}/../pyscripts/');import restore_redis_info;print(restore_redis_info.main('before_upgrade'))")

    if [[ $? == "0" ]]
    then
        if [[ ${result_status} == "0" ]]
        then
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "restore redis info success."
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "restore redis info failed."
            exit 1
        fi
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "restore redis info failed."
        exit 1
    fi
}

main $@ >> ${log_file} 2>&1