#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
IPS=${4}
temporary_dir=$(sh ${EXEC_HOME}/../get_temporary_dir.sh)
temporary_path=${temporary_dir}/check_result

echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}

function main(){
    check_result_path="${temporary_path}/check_result_summarized"
    #将结果归档至汇总路径
    IPS_array=(${IPS//,/ })
    for ip_port in ${IPS_array[@]}
    do
        ip_port_array=(${ip_port//:9094/ })
        ip=${ip_port_array[0]}
        rsync ossadm@[$ip]:${temporary_path}/check_gauss_data-${ip}.txt $check_result_path/ 2>/dev/null
        rsync ossadm@[$ip]:${temporary_path}/check_gauss_dbuser-${ip}.txt $check_result_path/ 2>/dev/null
        rsync ossadm@[$ip]:${temporary_path}/check_zenith_data-${ip}.txt $check_result_path/ 2>/dev/null
        rsync ossadm@[$ip]:${temporary_path}/check_zenith_dbuser-${ip}.txt $check_result_path/ 2>/dev/null
        rsync ossadm@[$ip]:${temporary_path}/check_nae_log-${ip}.txt $check_result_path/ 2>/dev/null
        rsync ossadm@[$ip]:${temporary_path}/check_omp_file-${ip}.txt $check_result_path/ 2>/dev/null
        rsync ossadm@[$ip]:${temporary_path}/check_root-${ip}.txt $check_result_path/ 2>/dev/null
        rsync ossadm@[$ip]:${temporary_path}/check_ossadm-${ip}.txt $check_result_path/ 2>/dev/null
        rsync ossadm@[$ip]:${temporary_path}/check_sopuser_dir-${ip}.txt $check_result_path/ 2>/dev/null
        rsync ossadm@[$ip]:${temporary_path}/check_sopuser_file-${ip}.txt $check_result_path/ 2>/dev/null
    done

    cp -rf ${temporary_path}/check_package_result-127.0.0.1.txt $check_result_path/ 2>/dev/null
    cp -rf ${temporary_path}/check_db_sync_status.txt $check_result_path/ 2>/dev/null

    #根据文件是否为空判断是否有检查异常
    if [ "$(ls -A $check_result_path)" ]; then
        for file in ${check_result_path}/*
        do
            if [[ ! -s $file ]]
            then
                rm -rf $file
                continue
            fi
        done
    fi

    check_result=0
    #将结果输出到屏幕
    if [ "$(ls -A $check_result_path)" ]; then
        echo ""
        echo "----------------------- Check result before upgrade Failed, please Contact Huawei engineers for confirmation -----------------------"
        for file in ${check_result_path}/*
        do
            file_content=`cat $file`
            temp_file=`basename $file .txt`
            check_item=${temp_file%-*}
            check_item_ip=${temp_file#*-}
            case $check_item in
            check_gauss_data)
                echo "[ WARNING ] [$check_item_ip] Dirty files exist in the Gauss directory: $file_content"
                check_result=1
                ;;
            check_gauss_dbuser)
                echo "[ WARNING ] [$check_item_ip] The Gauss directory contains files or directories that do not have the dbuser permission: $file_content"
                check_result=1
                ;;
            check_zenith_data)
                echo "[ WARNING ] [$check_item_ip] Dirty files exist in the zenith directory: $file_content"
                ;;
            check_zenith_dbuser)
                echo "[ WARNING ] [$check_item_ip] Files or directories that do not have the dbuser permission exist in the zenith directory: $file_content"
                check_result=1
                ;;
            check_nae_log)
                echo "[ WARNING ] [$check_item_ip] Log files larger than 1 GB exist in the following directories: $file_content"
                check_result=1
                ;;
            check_backup_task)
                echo "[ WARNING ] Failed backup tasks exist in the recent task list."
                check_result=1
                ;;
            check_big_table)
                echo "[ WARNING ] The size of the following database tables in $check_item_ip is greater than 10 GB:"
                check_result=1
                echo "$file_content"
                ;;
            check_omp_file)
                echo "[ WARNING ]  [$check_item_ip] Files or directories that do not have the ossadm or 750 permission exist in the omp directory:"
                check_result=1
                echo "$file_content"
                ;;
            check_root)
                echo "[ WARNING ]  [$check_item_ip] Files or directories that do not have the root permission:"
                check_result=1
                echo "$file_content"
                ;;
            check_ossadm)
                echo "[ WARNING ]  [$check_item_ip] Files or directories that do not have the right permission exist in the /home/ossadm or /home/ossadm/.ssh:"
                check_result=1
                echo "$file_content"
                ;;
            check_sopuser_dir)
                echo "[ WARNING ]  [$check_item_ip] User sopuser exists in R19C00. You are advised to run the following command to delete：userdel -rf xxx"
                check_result=1
                echo "$file_content"
                ;;
            check_sopuser_file)
                echo "[ WARNING ]  [$check_item_ip] The /home/sopuser file exists in R19C00. You are advised to run the following command to delete the file: rm -rf /home/sopuser"
                check_result=1
                echo "$file_content"
                ;;
            check_package_result)
                echo "[ WARNING ] The package management check item failed, please contact Huawei technical support. "
                ;;
            check_db_sync_status)
                echo "[ WARNING ] There are synchronization delays in the database, please contact Huawei technical support. "
                check_result=1
                echo "$file_content"
                ;;
            *)
                echo "Check item is in abnormal,please check."
                check_result=1
            esac
        done
        echo "----------------------- Check result over before upgrade ----------------------------------"
        if [[ "${check_result}" == "1" ]]
        then
            exit 1
        fi
    fi


}

main $@ 2>>${log_file}