#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}


function main(){

    # 修改bgp网卡用途，删除LOCALHA，修复回退过程中浮动IP丢失的问题
    if [[ ! -d /opt/oss/${tenant_name}/apps/BgpService ]]
    then
        echo "BgpService is not installed, skip it."
        exit 0
    fi

    cd ${EXEC_HOME}/../pyscripts/utils
    . /opt/oss/manager/agent/bin/engr_profile.sh
    ${PYTHONHOME}/bin/python -c "import common_method;print(common_method.CommonMethod().query_product('${tenant_name}', '${EXEC_HOME}', retry_times=3))"
    result=$?
    if [[ "${result}" == "0" ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "query_product successfully."
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "query_product failed."
        exit 1
    fi

    # 修改bgp网卡用途，删除LOCALHA
    ${PYTHONHOME}/bin/python ${EXEC_HOME}/../pyscripts/modify_bgp_usage.py ${EXEC_HOME}/networkinfo_${tenant_name}.json
    result=$?
    if [[ "${result}" == "0" ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "modify bgp usage successfully"
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "modify bgp usage failed"
        exit 1
    fi

}

main $@ >> ${log_file} 2>&1