#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}

function main()
{
    # MCHIROIRService缩容导致管理面升级失败 规避
    sh ${EXEC_HOME}/../plugins/pre_upgrade_AppController.sh
    result=$?
    if [[ "${result}" == "0" ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "pre upgrade AppController successfully." | tee -a ${log_file}
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "pre upgrade AppController failed." | tee -a ${log_file}
        exit 1
    fi

}
main $@ >> ${log_file} 2>&1