#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}


function main(){
    # 备份GlobalSearchService-elasticsearch的data目录数据,规避升级到R21C10后回退启动失败的问题
    back_data_dir="/opt/oss/upgrade_dir_for_ossuser/elasticsearch_bak"
    es_data_dir="/opt/oss/share/*/GlobalSearchService/elasticsearch/data"
    /opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global -app "GlobalSearchService" | grep "elasticsearch" | awk '{print $6}' | while read line
    do
        echo "backup elasticsearch data in $line"
        ssh ossadm@"$line" << remotessh
            sudo -u ossuser rm -rf ${back_data_dir}
            sudo -u ossuser mkdir ${back_data_dir}
            sudo -u ossuser cp -r ${es_data_dir} ${back_data_dir}
            exit
remotessh
    done
}

main $@ >> ${log_file} 2>&1