#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}

function main()
{
    cd ${EXEC_HOME}/../plugins/datasource_aoc_upgrade
    sh ./DCN_Datasource_upgrade.sh
    result=$?
    if [[ "${result}" == "0" ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "datasource_aoc_upgrade successfully."
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "datasource_aoc_upgrade failed."
        exit 1
    fi
}
main $@ >> ${log_file} 2>&1