#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
float_ip_type=${4}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}


function main(){
    #删除bgp浮动ip
    . /opt/oss/manager/agent/bin/engr_profile.sh
    bash /opt/oss/manager/tools/resmgr/queryproduct.sh -pn $tenant_name -output ${EXEC_HOME}
    $PYTHONHOME/bin/python ${EXEC_HOME}/../pyscripts/delete_float_ip.py ${EXEC_HOME}/networkinfo_$tenant_name.json "$float_ip_type"
    result=$?
    if [[ "${result}" == "0" ]]
        then
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "delete $float_ip_type successfully"
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "delete $float_ip_type  failed"
            exit 1
    fi
}

main $@ >> ${log_file} 2>&1