#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}

function main()
{
    #获取环境上containlist_old.json
    . /opt/oss/manager/bin/engr_profile.sh
    ${PYTHONHOME}/bin/python ${EXEC_HOME}/../pyscripts/export_containerlist.py ${tenant_name} /opt/upgrade/containerlist_old.json
    result=$?
    if [[ "${result}" == "0" ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "export containerlist_old.json successfully."
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "export containerlist_old.json failed."
        exit 1
    fi
}
main $@ >> ${log_file} 2>&1