#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}

function main()
{
    upgrade_path_array=(${upgrade_path//-/ })
    des_path=${upgrade_path_array[1]}
    cd ${EXEC_HOME}/../V100R020C10XXX-${des_path}
    chown -R ossadm:ossgroup migrate_r20c10_to_r21c00
    cd ${EXEC_HOME}/../V100R020C10XXX-${des_path}/migrate_r20c10_to_r21c00
    sh ./upgrade.sh
    result=$?
    if [[ "${result}" == "0" ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "migrate_r20c10_to_r21c00 successfully."
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "migrate_r20c10_to_r21c00 failed."
        exit 1
    fi
}
main $@ >> ${log_file} 2>&1