--1.资源池配额中安全策略由policy_name改成policy_id
update tab_secm_common_resource_item r, TAB_SECM_SECURITY_POLICY p 
    set r.service_id = p.pkid 
    where r.ne_resource_type = 4
        and r.service_id = p.policy_name;
delete from tab_secm_common_resource_item 
    where ne_resource_type = 4 
        and regexp_instr(service_id, '^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$') <= 0;

--3.vsys关联关系
DECLARE
  VSYS_CURSOR         SYS_REFCURSOR;
  V_VSYS_ID           TAB_SECM_SECURECENTER_VSYS.ID % TYPE;
  V_NE_ID             TAB_SECM_SECURECENTER_VSYS.NE_ID % TYPE;
  V_INTERFACES        TAB_SECM_SECURECENTER_VSYS.INTERFACES % TYPE;
  V_PUBLIC_INTERFACES TAB_SECM_SECURECENTER_VSYS.PUBLIC_INTERFACES % TYPE;
  V_IMPORT_FLOWS      TAB_SECM_SECURECENTER_VSYS.IMPORT_FLOWS % TYPE;
  V_UUID              VARCHAR(64);
  V_OBJECT_NAME       VARCHAR(512);
  COMMA_CUR_INDEX     NUMBER;
  COMMA_NEXT_INDEX    NUMBER;
BEGIN
  OPEN            VSYS_CURSOR
  FOR SELECT ID, NE_ID, INTERFACES, PUBLIC_INTERFACES, IMPORT_FLOWS FROM TAB_SECM_SECURECENTER_VSYS; LOOP
    FETCH VSYS_CURSOR INTO V_VSYS_ID,V_NE_ID,V_INTERFACES,V_PUBLIC_INTERFACES,V_IMPORT_FLOWS;
    EXIT WHEN VSYS_CURSOR%NOTFOUND;
    COMMA_CUR_INDEX  := 1;
    COMMA_NEXT_INDEX := 1;
    WHILE COMMA_NEXT_INDEX > 0 LOOP
      COMMA_NEXT_INDEX := LOCATE(',', V_INTERFACES, COMMA_CUR_INDEX);
      IF COMMA_CUR_INDEX = COMMA_NEXT_INDEX THEN
        COMMA_CUR_INDEX := COMMA_CUR_INDEX + 1;
        CONTINUE;
      END IF;
      IF COMMA_NEXT_INDEX > 0 THEN
        V_OBJECT_NAME   := SUBSTRING(V_INTERFACES, COMMA_CUR_INDEX, COMMA_NEXT_INDEX - COMMA_CUR_INDEX);
        COMMA_CUR_INDEX := COMMA_NEXT_INDEX + 1;
      ELSE
        V_OBJECT_NAME := SUBSTRING(V_INTERFACES, COMMA_CUR_INDEX);
      END IF;
      IF (V_OBJECT_NAME IS NOT NULL AND TRIM(V_OBJECT_NAME) != '') THEN
        V_UUID := LOWER(UUID);
        V_UUID := SUBSTRING(V_UUID FROM 1 
        FOR 8)||'-'||SUBSTRING(V_UUID FROM 9 FOR 4)||'-'||SUBSTRING(V_UUID FROM 13 FOR 4)||'-'||SUBSTRING(V_UUID FROM 17 FOR 4)||'-'||SUBSTRING(V_UUID FROM 21 FOR 12);
        INSERT INTO TAB_SECM_SECURECENTER_VSYS_RELATED_OBJECT
          (ID, NE_ID, VSYS_ID, OBJECT_TYPE, OBJECT_NAME)
        VALUES
          (V_UUID, V_NE_ID, V_VSYS_ID, 'INTERFACE', V_OBJECT_NAME);
      END IF;
    END LOOP;
    COMMA_CUR_INDEX  := 1;
    COMMA_NEXT_INDEX := 1;
    WHILE COMMA_NEXT_INDEX > 0 LOOP
      COMMA_NEXT_INDEX := LOCATE(',', V_PUBLIC_INTERFACES, COMMA_CUR_INDEX);
      IF COMMA_CUR_INDEX = COMMA_NEXT_INDEX THEN
        COMMA_CUR_INDEX := COMMA_CUR_INDEX + 1;
        CONTINUE;
      END IF;
      IF COMMA_NEXT_INDEX > 0 THEN
        V_OBJECT_NAME   :=  SUBSTRING(V_PUBLIC_INTERFACES, COMMA_CUR_INDEX, COMMA_NEXT_INDEX - COMMA_CUR_INDEX);
        COMMA_CUR_INDEX := COMMA_NEXT_INDEX + 1;
      ELSE
        V_OBJECT_NAME :=  SUBSTRING(V_PUBLIC_INTERFACES, COMMA_CUR_INDEX);
      END IF;
      IF (V_OBJECT_NAME IS NOT NULL AND TRIM(V_OBJECT_NAME) != '') THEN
        V_UUID := LOWER(UUID);
        V_UUID := SUBSTRING(V_UUID FROM 1 
        FOR 8)||'-'||SUBSTRING(V_UUID FROM 9 FOR 4)||'-'||SUBSTRING(V_UUID FROM 13 FOR 4)||'-'||SUBSTRING(V_UUID FROM 17 FOR 4)||'-'||SUBSTRING(V_UUID FROM 21 FOR 12);
        INSERT INTO TAB_SECM_SECURECENTER_VSYS_RELATED_OBJECT
          (ID, NE_ID, VSYS_ID, OBJECT_TYPE, OBJECT_NAME)
        VALUES
          (V_UUID,
           V_NE_ID,
           V_VSYS_ID,
           'PUBLIC_INTERFACE',
           V_OBJECT_NAME);
      END IF;
    END LOOP;
    COMMA_CUR_INDEX  := 1;
    COMMA_NEXT_INDEX := 1;

    WHILE COMMA_NEXT_INDEX > 0 LOOP
      COMMA_NEXT_INDEX := LOCATE(',', V_IMPORT_FLOWS, COMMA_CUR_INDEX);
      IF COMMA_CUR_INDEX = COMMA_NEXT_INDEX THEN
        COMMA_CUR_INDEX := COMMA_CUR_INDEX + 1;
        CONTINUE;
      END IF;
      IF COMMA_NEXT_INDEX > 0 THEN
        V_OBJECT_NAME   :=SUBSTRING(V_IMPORT_FLOWS, COMMA_CUR_INDEX, COMMA_NEXT_INDEX - COMMA_CUR_INDEX);
        COMMA_CUR_INDEX := COMMA_NEXT_INDEX + 1;
      ELSE
        V_OBJECT_NAME :=SUBSTRING(V_IMPORT_FLOWS, COMMA_CUR_INDEX);
      END IF;
      IF (V_OBJECT_NAME IS NOT NULL AND TRIM(V_OBJECT_NAME) != '') THEN
        V_UUID := LOWER(UUID);
        V_UUID := SUBSTRING(V_UUID FROM 1 
        FOR 8)||'-'||SUBSTRING(V_UUID FROM 9 FOR 4)||'-'||SUBSTRING(V_UUID FROM 13 FOR 4)||'-'||SUBSTRING(V_UUID FROM 17 FOR 4)||'-'||SUBSTRING(V_UUID FROM 21 FOR 12);
        INSERT INTO TAB_SECM_SECURECENTER_VSYS_RELATED_OBJECT
          (ID, NE_ID, VSYS_ID, OBJECT_TYPE, OBJECT_NAME)
        VALUES
          (V_UUID, V_NE_ID, V_VSYS_ID, 'IMPORT_FLOW', V_OBJECT_NAME);
      END IF;
    END LOOP;
  END LOOP;
END;
/
--4.
