#!/bin/bash

export JAVA_HOME=$(find /opt/oss/rtsp -name 'jre*' -type d | awk 'END {print}')
export OSS_ROOT=/opt/oss/manager

if [[ -f "/opt/oss/manager/var/tenants/NCECOMMONE/containerlist.json" ]]
then
     tenant_name=NCECOMMONE
else
     tenant_name=NCE
fi


EXEC_HOME=$(pwd)
need_dir=/opt/oss/upgrade_dir_for_ossuser/datasource_first_migrate
APP_CONF_FILE_REAL=$(sudo -u ossuser find /opt/oss/${tenant_name}/apps/DCNOpenEMService/etc/sysconf -name 'DCNOpenEMService*.json' | awk 'END {print}')

sudo -u ossuser rm -rf ${need_dir}
sudo -u ossuser mkdir -p ${need_dir}
sudo -u ossuser cp -f $APP_CONF_FILE_REAL ${need_dir}/DCNOpenEMService.json
sudo -u ossuser chmod 440 ${need_dir}/DCNOpenEMService.json
export APP_CONF_FILE=${need_dir}/DCNOpenEMService.json
export CIPHER_ROOT=$OSS_ROOT/etc/cipher
cd ${EXEC_HOME}
rm -rf ${EXEC_HOME}/lib/logs/
$JAVA_HOME/bin/java -jar $EXEC_HOME/datasource-aoc-upgrade*.jar dcnnepersistentdb


unset JAVA_HOME
unset OSS_ROOT
unset APP_CONF_FILE
unset CIPHER_ROOT
time=$(date "+%Y-%m-%d %H:%M:%S")
count=`grep -o 'migrate aoc 1.0(e2e) datasource upgrade success and end' $EXEC_HOME/lib/logs/migrate_tool.log | wc -l`
if [[ "${count}" == "1" ]]
then
        sudo -u ossuser rm -rf ${need_dir}/*
        echo "[${time}] migrate aoc 1.0(e2e) datasource upgrade successfully."
else
        echo "[${time}] migrate aoc 1.0(e2e) datasource upgrade failed,Please see the migrate_tool.log"
        exit 1
fi

