#!/bin/bash
CUR_PATH=$(dirname $(readlink -f $0))
TENANT_NAME=$1
log_dir=`sh ${CUR_PATH}/../../get_log_dir.sh`

export JAVA_HOME=$(find /opt/oss/rtsp -name 'jre*' -type d | awk 'END {print}')
export OSS_ROOT=/opt/oss/$TENANT_NAME
export CIPHER_ROOT=$OSS_ROOT/etc/cipher
APP_ROOT=/opt/oss/$TENANT_NAME/apps/DCNOpenEMService

export APP_CONF_FILE_REAL=$(sudo -u ossuser find ${APP_ROOT}/etc/sysconf -name 'DCNOpenEMService*.json' | awk 'END {print}')

need_dir=/opt/oss/upgrade_dir_for_ossuser/datasource_second_migrate
sudo -u ossuser rm -rf ${need_dir}
sudo -u ossuser mkdir -p ${need_dir}

sudo -u ossuser cp -f $APP_CONF_FILE_REAL ${need_dir}/DCNOpenEMService.json
sudo -u ossuser chmod 750 ${need_dir}/DCNOpenEMService.json
sudo -u ossuser mkdir -p ${need_dir}/etc
sudo -u ossuser cp -rf $OSS_ROOT/etc/cipher ${need_dir}/etc/
sudo -u ossuser cp -rf $OSS_ROOT/etc/ssl ${need_dir}/etc/
sudo -u ossuser chmod 750 ${need_dir}/etc/ -R
export APP_CONF_FILE=${need_dir}/DCNOpenEMService.json
export OSS_ROOT=${need_dir}
export CIPHER_ROOT=$OSS_ROOT/etc/cipher
echo "START RUN datastore-migrate JAR"
echo "$JAVA_HOME/bin/java -jar ${CUR_PATH}/datastore-migrate-*-jar-with-dependencies.jar ${CUR_PATH}/yang offline dcnnepersistentdb 0 2 0"
rm -rf ${CUR_PATH}/log/
$JAVA_HOME/bin/java -jar $CUR_PATH/datastore-migrate-*-jar-with-dependencies.jar $CUR_PATH/yang offline dcnnepersistentdb 0 2 0

unset JAVA_HOME
unset OSS_ROOT
unset APP_CONF_FILE
unset CIPHER_ROOT

echo "END RUN datastore-migrate JAR"

# 拷贝日志
cp -rf ${CUR_PATH}/log/* ${log_dir}

count=`grep -o 'the total time is:' ${CUR_PATH}/log/datastore-migrate.log | wc -l`
if [ $count == 0 ]
then
    echo "datastore migrate failed,please check."
    exit 1
else
    sudo -u ossuser rm -rf ${need_dir}/*
    echo "datastore migrate success"
fi






