# coding=utf-8
'''
UnLock_north.py
'''
import os
import sys
import time
import datetime
from util import httpclient

SUCCESS = 0
REQ_FAILED = 1
SYSTEM_ID = sys.argv[1]
SYSTEM_NAME = sys.argv[2]
USER_NAME = sys.argv[3]
USER_PWD = sys.argv[4]
IP = sys.argv[5]
PORT = sys.argv[6]
UI_PORT = sys.argv[7]

try:
    DESCRIPTION = sys.argv[8]
except IndexError:
    DESCRIPTION = ""
URL = '/rest/resource/v3/instances/objects/DCNExtSystemConnection'

def get_local_ip():
    '''
    get_local_ip
    :return:
    '''
    local_ip = os.popen(
        "LOCAL_IP=`cat /opt/oss/manager/var/agent/managerip.conf|"
        "grep localip|awk -F '=' '{print $NF}'`;echo $LOCAL_IP").read()
    local_ip.replace(' ', '')
    _ip = local_ip.replace('\n', '')
    return _ip


# get IR connection
def get_connection():
    '''
    get_connection
    :return:
    '''
    _ip = get_local_ip()
    http_connection = httpclient.CommonHttpClient(_ip, 32018, True, False)
    return http_connection


def main():
    '''
    主函数
    :return:
    '''
    input_param = [{"object":{"resId": SYSTEM_ID, "name": " ", "systemType":\
        "FabricInsight", "systemName": SYSTEM_NAME, "userName": USER_NAME, \
        "userPwd": USER_PWD, "ip": IP, "port": PORT, "uiPort": UI_PORT, \
        "description": DESCRIPTION, "aliveTime": 0, "alarmFlag": "false"}}]
    response = get_connection().post(URL, input_param) #调用接口 + 上传拼接好的json
    print(
        '[' + datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S") + '] ' +\
        "receive dt response: " + repr(response)
    )
    http_status = response[0]
    retry_flag = 1
    while http_status != 200 and retry_flag <= 30:
        print(
            '[' + datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S") + '] ' +\
            'request failed, retry:\n' + str(response)
        )
        response = get_connection().post(URL, input_param)
        http_status = response[0]
        time.sleep(6)
        retry_flag = retry_flag + 1

    if http_status == 200:
        print(
            '[' + datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S") + '] ' +\
            "request sucess finally."
        )
        return SUCCESS

    print(
        '[' + datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S") + '] ' +\
        "request failed, status code:" + repr(http_status)
    )
    return REQ_FAILED


sys.exit(main())
