#!/bin/bash

CUR_PATH=$(cd "$(dirname "$0")"; pwd)
script_name=`basename $0`

print_log()
{
    local content=$*
    log_filename="$CUR_PATH/update_mdcservice.log"
    echo $log_filename 
    CURTIME=`date '+%Y-%m-%d %H:%M:%S'`
    echo "Log: $CURTIME $$ $script_name : $content" | tee -a $log_filename
}

#获取数据库信息（query database)
get_dbip_port() {
    dbinfo=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep -E "$1"|grep Master`

    if [ -z "$dbinfo" ]
    then
        print_log "$LINENO single db instance"
        dbinfo=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep -E "$1"`
        MACHINE_IP=`echo $dbinfo|awk '{print $6}'`
        port=`echo $dbinfo|awk '{print $7}'`
        db_master_name=`echo $dbinfo|awk '{print $3}'`
        db_slave_name=''
        db_type=`echo $dbinfo|awk '{print $9}'`
    else
        MACHINE_IP=`echo $dbinfo|awk '{print $6}'`
        port=`echo $dbinfo|awk '{print $7}'`
        db_master_name=`echo $dbinfo|awk '{print $3}'`
        db_slave_name=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep -E "$1"|grep Slave|awk '{print $3}'`
        db_type=`echo $dbinfo|awk '{print $9}'`
    fi

    
}


main(){

    service_name=MdcService
    instance_name=dcnnwcommondb
    instance_db_name="dcnmdcpersistentdb"
    #查询是否存在微服务器
    if [ `/opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global | grep $service_name | wc -l` -le 0 ]
    then
      print_log "$LINENO $instance_db_name $service_name does not exist"
      exit 0
    fi
    #运行函数：获取数据库ip,port, admin password
    get_dbip_port $instance_name

    # get_db_info
    db_info=`. /opt/oss/manager/agent/bin/engr_profile.sh;python -c "import sys;sys.path.append('${CUR_PATH}/../../pyscripts/');import get_db_pass;pec=get_db_pass.epc;fmt='';pec1=pec.getLogger('db_info');pec_s=pec.StreamHandler();pec_s.setFormatter(fmt);pec1.addHandler(pec_s);pec1.critical(get_db_pass.main('${instance_name}', '${instance_db_name}', 'zenith'))" 2>&1`
    result=$?
    if [[ "${result}" == "0" ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get db_info successfully."
        result_array=(${db_info//,/ })
        adminPP=${result_array[2]}
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get db_info failed."
        exit 1
    fi

    if [ -z "$adminPP" ]
    then
        print_log "$LINENO $instance_db_name acquire DB passwd failed,exit"
        exit 1
    else
        print_log "$LINENO $instance_db_name acquire DB passwd success "
    fi
    sql_result=`sudo -s -u dbuser<<EOF
    source /home/dbuser/.bashrc
    /opt/zenith/app/bin/zsql ${instance_db_name}/${adminPP}@${MACHINE_IP}:${port} -f $CUR_PATH/fetch_data.sql
EOF`
    str='0 rows fetched'
    if [[ $sql_result =~ $str ]]
    then
        echo "dcnmdcpersistentdb does not have values"
        exit 0
    else
		echo "dcnmdcpersistentdb has values"
		echo $sql_result
		sql_result_data=${sql_result:1147}
		resultDataFile=$CUR_PATH/result_data.txt
		if [ ! -f $resultDataFile ];then
			echo "result_data.txt文件不存在"
		else
			rm -f $resultDataFile
			echo "旧result_data.txt文件已删除"
		fi
		echo $sql_result_data >> $resultDataFile
		echo "create result_data.txt success."
		num=`grep -o "_create_time" $resultDataFile | wc -l`
		echo "num is:"$num
		if [ $num -eq 0 ];then
			exit 0
		fi
		insertDataFile=$CUR_PATH/insert_data.txt
		if [ ! -f $insertDataFile ];then
			echo "insert_data.txt文件不存在"
		else
			rm -f $insertDataFile
			echo "旧insert_data.txt文件已删除"
		fi		
		tempNum=1
		while [ $tempNum -le $num ]
		do
			data=`echo $sql_result_data | awk -F '_create_time' '{print $'$tempNum'}'`
			echo $data >> $insertDataFile
			tempNum=$(( $tempNum + 1 ))
		done

		while read line
		do
			systemId=`echo $line | sed -E 's/.*id_(.{1,})_id.*/\1/'`
			systemName=`echo $line | sed -r 's/.*name_(.{1,})_name.*/\1/'`
			userName=`echo $line | sed -r 's/.*rest_account_(.{1,})_rest_account.*/\1/'`
			userPwd=`echo $line | sed -r 's/.*rest_password_(.{1,})_rest_password.*/\1/'`
			ip=`echo $line | sed -r 's/.*ip_(.{1,})_ip.*/\1/'`
			port=`echo $line | sed -r 's/.*rest_port_(.{1,})_rest_port.*/\1/'`
			description=`echo $line | sed -r 's/.*desc_(.{0,})_desc.*/\1/'`
			updateTime=`echo $line | sed -r 's/.*update_time_(.{0,})_update_time.*/\1/'`
			createTime=`echo $line | sed -r 's/.*create_time_(.{0,}).*/\1/'`
			if [ "${description}X" == "X" ]; then
				description="null"
			fi
			if [ "${updateTime}X" == "X" ]; then
				updateTime=$createTime
			fi
			updateTimeStamp=$((`date -d "$updateTime" +%s`*1000+10#`date "+%N"`/1000000))
			createTimeStamp=$((`date -d "$createTime" +%s`*1000+10#`date "+%N"`/1000000))
			. /opt/oss/manager/agent/bin/engr_profile.sh; python $CUR_PATH/send_ir.py $systemId $systemName $userName $userPwd $ip $port $description $updateTimeStamp $createTimeStamp 
			result=$?
			if [[ "${result}" == "0" ]]
			then
				print_log "$LINENO record $systemId $systemName $userName $ip $port $description $updateTimeStamp $createTimeStamp save to DT success."
				echo "data " $systemId $systemName $userName $ip $port $description $updateTimeStamp $createTimeStamp "save to DT success."
			else
				echo "send_ir.py failed."
				exit 1
			fi
		done < $insertDataFile

		if [ -f $resultDataFile ];then
			rm -f $resultDataFile
		fi
		if [ -f $insertDataFile ];then
			rm -f $insertDataFile
		fi		
    fi
}
main
