--3.19.10.0.050_BEGIN
select alter_columns('ADD', 'tab_dcn_fabric_service_pbr', 'backup_si', 'int');
select alter_columns('ADD', 'tab_dcn_fabric_service_pbr', 'extra_pbr_for_bypass', 'boolean default false');

select alter_columns('ADD', 'tab_dcn_sfc_forward_connector', 'backup_si', 'nvarchar2(255)');
select alter_columns('ADD', 'tab_dcn_sfc_sf_locator', 'share_ip', 'nvarchar2(255)');
select alter_columns('ADD', 'tab_dcn_sfc_sf_locator', 'share_ipv6', 'nvarchar2(255)');
select alter_columns('ADD', 'tab_dcn_sfc_sf_locator', 'fail_mode_type', 'nvarchar2(64)');

select alter_columns('ADD', 'tab_dcn_sfco_sfcapp_r_vas', 'fail_mode', 'nvarchar2(64)');
select alter_columns('ADD', 'tab_dcn_sfco_sfcapp_r_vas', 'ipv4_track_nqa_status', 'nvarchar2(64)');
select alter_columns('ADD', 'tab_dcn_sfco_sfcapp_r_vas', 'ipv6_track_nqa_status', 'nvarchar2(64)');

create table if not exists tab_dcn_sfc_forward_connector_extra (
	id						character varying(255) not null,
	ingress_port_id			character varying(255),
	spi						integer,
	si						integer,
	backup_si				integer,
	next_hop				character varying(255),
	tenant_id				character varying(255),
	host_connector_id		character varying(255),
	acl_addr_family			character varying(64),
	action					character varying(64),
	encapsulation			character varying(64),
	constraint tab_dcn_sfc_forward_connector_extra_pkey primary key (id)
);
alter table tab_dcn_sfc_forward_connector_extra OWNER TO ossdbuser;

create table if not exists tab_dcn_sfco_sfcapp_vas_share_ip (
	id						character varying(255) not null,
	sfcapp_id				character varying(255),
	router_id				character varying(255),
	vas_id					character varying(255),
	vas_ip					character varying(255),
	vas_ipv6				character varying(255),
	share_ip				character varying(255),
	share_ipv6				character varying(255),
	constraint tab_dcn_sfco_sfcapp_vas_share_ip_pkey primary key (id)
);
alter table tab_dcn_sfco_sfcapp_vas_share_ip OWNER TO ossdbuser;

select alter_columns('ADD', 'tab_dcn_sfc_scpolicy_classification', 'is_extra_item', 'boolean default false');
select alter_columns('ADD', 'tab_dcn_fabric_service_epg_param', 'is_extra_item', 'boolean default false');
select alter_columns('ADD', 'tab_dcn_fabric_service_ipepg_param', 'is_extra_item', 'boolean default false');
select alter_columns('ADD', 'tab_dcn_fabric_service_microseg', 'is_extra_item', 'boolean default false');
select alter_columns('ADD', 'tab_dcn_fabric_manage_nodeipsegment', 'is_extra_item', 'boolean default false');
update tab_dcn_sfc_scpolicy_classification set is_extra_item = false;
update tab_dcn_fabric_service_epg_param set is_extra_item = false;
update tab_dcn_fabric_service_ipepg_param set is_extra_item = false;
update tab_dcn_fabric_service_microseg set is_extra_item = false;
update tab_dcn_fabric_manage_nodeipsegment set is_extra_item = false;
CREATE OR REPLACE FUNCTION func_upgrade_contract_rule() RETURNS INTEGER AS $body$
DECLARE
	v_cnt int;
	v_mode int;
BEGIN
    FOR record_coms IN select contract_id, tenant_id from tab_dcn_sfco_contract LOOP
		if trim(record_coms.tenant_id) is null or record_coms.tenant_id = '00000000-0000-0000-0000-000000000000' then
			EXECUTE IMMEDIATE 'select count(distinct(e.mode)) from tab_dcn_epg_entity e where e.id in (select s.src_epg from tab_dcn_sfco_sfcapp s where s.contract_id = '''||record_coms.contract_id||''') and e.mode is not null' into v_cnt;
			if v_cnt = 1 then 
				EXECUTE IMMEDIATE 'select distinct(e.mode) from tab_dcn_epg_entity e where e.id in (select s.src_epg from tab_dcn_sfco_sfcapp s where s.contract_id = '''||record_coms.contract_id||''') and e.mode is not null' into v_mode;
				if v_mode = 0 then
					update tab_dcn_sfco_contract_rule set ip_type = 'any' where contract_id = record_coms.contract_id;
				end if;
			end if;
		else
			EXECUTE IMMEDIATE 'select count(distinct(mode)) from tab_dcn_epg_entity where tenant_id = '''||record_coms.tenant_id||''' and mode is not null' into v_cnt;
			if v_cnt = 1 then 
				EXECUTE IMMEDIATE 'select distinct(mode) from tab_dcn_epg_entity where tenant_id = '''||record_coms.tenant_id||''' and mode is not null' into v_mode;
				if v_mode = 0 then
					update tab_dcn_sfco_contract_rule set ip_type = 'any' where contract_id = record_coms.contract_id;
				end if;
			end if;
		end if;
    END LOOP; 
    RETURN 0;
END;
$body$ language plpgsql;
/
ALTER FUNCTION func_upgrade_contract_rule() OWNER TO ossdbuser;
select func_upgrade_contract_rule();
drop function if exists func_upgrade_contract_rule;
--3.19.10.0.050_END

--3.19.10.0.056_BEGIN
select alter_columns('ADD', 'tab_dcn_sfc_rsp_detail', 'fail_mode', 'nvarchar2(64)');

select alter_columns('ADD', 'tab_dcn_sfc_sfp_detail', 'sfg_name', 'character varying(255)');
select alter_columns('ADD', 'tab_dcn_sfc_sfp_detail', 'fail_mode', 'nvarchar2(64)');

create table if not exists tab_dcn_sfc_sfg ( 
    sfg_name character varying(255) not null,
	sf_names character varying[],
    share_ip character varying(255),
    share_ipv6 character varying(255),
	tenant_id character varying(255),
	algorithm character varying(255),
    nsh_aware boolean not null,
	constraint pk_dcn_sfc_sfg primary key (sfg_name)
);
alter table tab_dcn_sfc_sfg OWNER TO ossdbuser;
--3.19.10.0.056_END

--3.19.10.0.106000_BEGIN
select alter_columns('ADD', 'tab_dcn_sfc_forward_connector_extra', 'egress_port_id', 'character varying(255)');
--3.19.10.0.106000_END

--3.19.10.100.003000_BEGIN
CREATE TABLE IF NOT EXISTS public.tab_dcn_sfc_configuration( 
   key nvarchar2(128) not null,
   value nvarchar2(128),
   CONSTRAINT pk_dcn_sfc_configuration PRIMARY KEY (key)
);
ALTER TABLE public.tab_dcn_sfc_configuration OWNER TO ossdbuser;
insert into tab_dcn_sfc_configuration(key, value) select 'is-micro-segment-new-model','true' where not exists (select * from tab_dcn_sfc_configuration where key = 'is-micro-segment-new-model');
--3.19.10.100.003000_END

--3.19.10.100.0500_BEGIN
select alter_columns('ADD', 'tab_dcn_sfc_forward_connector_extra', 'si_is_final', 'boolean default false');
--3.19.10.100.0500_END

select alter_columns('ADD', 'tab_dcn_sfc_sfp', 'path_id_v6', 'integer');
select alter_columns('ADD', 'tab_dcn_sfc_rsp', 'path_id_v6', 'integer');

CREATE OR REPLACE FUNCTION func_upgrade_sfp_path_id_v6() RETURNS INTEGER AS $body$
DECLARE
	v_cnt int;
	max_path_id int;
BEGIN
	EXECUTE IMMEDIATE 'select count(*) from tab_dcn_sfco_sfpapp_pathid_pool' into v_cnt;
	if v_cnt = 0 then
		max_path_id = 0;
	else
		EXECUTE IMMEDIATE 'select max(path_id) from tab_dcn_sfco_sfpapp_pathid_pool' into max_path_id;
	end if;
    FOR record_coms IN select name, path_id_v6 from tab_dcn_sfc_sfp LOOP
		if trim(record_coms.path_id_v6) is null then
			EXECUTE IMMEDIATE 'select count(*) from tab_dcn_sfco_sfpapp_pathid_pool where id = '''||record_coms.name||'_v6''' into v_cnt;
			if v_cnt = 0 then
				max_path_id = max_path_id + 1;
				insert into tab_dcn_sfco_sfpapp_pathid_pool(id, path_id) values(''||record_coms.name||'_v6', max_path_id);
				update tab_dcn_sfc_sfp set path_id_v6 = max_path_id where name = record_coms.name;
				update tab_dcn_sfc_rsp set path_id_v6 = max_path_id where name = record_coms.name;
			end if;
		end if;
    END LOOP; 
    RETURN 0;
END;
$body$ language plpgsql;
/
ALTER FUNCTION func_upgrade_sfp_path_id_v6() OWNER TO ossdbuser;
select func_upgrade_sfp_path_id_v6();
drop function if exists func_upgrade_sfp_path_id_v6;