--3.19.10.070_BEGIN
create table if not exists TAB_DCN_NE_GROUP_MEMBER_MLAG  ( 
   id nvarchar2(128)  primary key not null,
   parent_ne_group_id nvarchar2(128) not null,
   dfs_group_id nvarchar2(128) not null,
   mlag_id nvarchar2(128) not null,
   member_one_id nvarchar2(128),
   member_one_name nvarchar2(256),
   member_one_port_name nvarchar2(256),
   member_two_id nvarchar2(128),
   member_two_name nvarchar2(256),
   member_two_port_name nvarchar2(256),
   create_time timestamp with time zone ,
   update_time timestamp with time zone
);
ALTER TABLE public.TAB_DCN_NE_GROUP_MEMBER_MLAG OWNER TO ossdbuser;

drop index if exists idx_dcn_ne_group_member_mlag_parent_ne_group_id;
create index idx_dcn_ne_group_member_mlag_parent_ne_group_id on TAB_DCN_NE_GROUP_MEMBER_MLAG(parent_ne_group_id);
drop index if exists idx_dcn_ne_group_member_one_id_parent_ne_group_id;
create index idx_dcn_ne_group_member_one_id_parent_ne_group_id on TAB_DCN_NE_GROUP_MEMBER_MLAG(member_one_id);
drop index if exists idx_dcn_ne_group_member_two_id_parent_ne_group_id;
create index idx_dcn_ne_group_member_two_id_parent_ne_group_id on TAB_DCN_NE_GROUP_MEMBER_MLAG(member_two_id);

create table if not exists tab_dcn_day0_fingerprint_status
(
  id character varying(64) primary key not null,
  switch_one_trust_device boolean not null ,
  switch_two_validate boolean not null,
  update_time  timestamp default current_timestamp
);
alter table tab_dcn_day0_fingerprint_status owner TO ossdbuser;
create or replace function init_fingerprint_status returns integer as $body$
declare
  v_count_fingerprint_status int:=0;
begin
    
    EXECUTE IMMEDIATE 'select count(1) from tab_dcn_day0_fingerprint_status' into v_count_fingerprint_status;
    if v_count_fingerprint_status=0 then
		insert into tab_dcn_day0_fingerprint_status(id,switch_one_trust_device,switch_two_validate) values('00000000-0000-0000-0002-000000000001',false,false);		
     end if;
return 0;
end;
$body$ language plpgsql;
/
select init_fingerprint_status();
drop function if exists init_fingerprint_status();
--3.19.10.070_END

--3.19.10.200.1070_BEGIN
delete from tab_dcn_day0_res_threshold where res_type ='dhcp';
insert into tab_dcn_day0_res_threshold(id,res_type,threshold_value,recv_threshold_value,remark) values('17','dhcp','90','50','DHCP Relay Ip');
--3.19.10.200.1070_END

--3.19.10.200.1290_BEGIN
delete from tab_dcn_day0_res_threshold where res_type ='share/type:Interconnection/Ip';
insert into tab_dcn_day0_res_threshold(id,res_type,threshold_value,recv_threshold_value,remark) values('16','share/type:Interconnection/Ip','90','50','Share Ip');

create table if not exists tab_dcn_day0_resource_share_ip
 (
   id nvarchar2(64) not null,
   begin_ip nvarchar2(32),
   end_ip nvarchar2(32),
   mask integer,
   priority_type integer,
   constraint pk_dcn_day0_resource_share_ip primary key (id)
);
alter table tab_dcn_day0_resource_share_ip OWNER TO ossdbuser;

drop index if exists idx_dcn_day0_resource_share_ip_beginip_endip;
create index idx_dcn_day0_resource_share_ip_beginip_endip on public.tab_dcn_day0_resource_share_ip (begin_ip,end_ip);

create table if not exists tab_dcn_day0_ip_v6_share_pool
(
   id nvarchar2(64) not null,
   url nvarchar2(256) not null,
   pool_type nvarchar2(16) not null,
   begin_ip nvarchar2(128)  not null,
   begin_ip_value numeric,
   end_ip nvarchar2(128) ,
   end_ip_value numeric,
   mask int not null,
   current_value numeric,
   total_num numeric,
   segment_id nvarchar2(64) not null,
   create_time timestamp default current_timestamp,
   constraint pk_dcn_day0_ip_v6_share_pool primary key (id)
);

alter table tab_dcn_day0_ip_v6_share_pool OWNER TO ossdbuser;

CREATE OR REPLACE RULE tab_dcn_day0_res_threshold_rule
AS ON INSERT TO tab_dcn_day0_res_threshold
WHERE EXISTS (SELECT 1
              FROM tab_dcn_day0_res_threshold
              WHERE res_type= new.res_type) DO
INSTEAD NOTHING;

insert into tab_dcn_day0_res_threshold(id,res_type, THRESHOLD_VALUE,RECV_THRESHOLD_VALUE,REMARK) values('18','OSPF','90','50','OSPF');
insert into tab_dcn_day0_res_threshold(id,res_type, THRESHOLD_VALUE,RECV_THRESHOLD_VALUE,REMARK) values('19','router/type:Interconnection/Ip','90','50','Router');
        
--3.19.10.200.1290_END