--3.19.10.0.031_BEGIN
CREATE OR REPLACE FUNCTION update_fabric_bgp_inner(v_old_route_id varchar2, v_new_route_id varchar2, v_peer_ip varchar2, v_as_num varchar2) RETURNS BOOLEAN AS $update_fabric_bgp_inner$
DECLARE
v_route_id_num INTEGER :=0;
v_new_route_id_num INTEGER :=0;
begin
EXECUTE IMMEDIATE 'select count(r.*) from tab_dcn_fabric_service_route r inner join tab_dcn_fabric_service_protocol p on p.route_id = r.id where r.id = '''||v_old_route_id||'''' into v_route_id_num;
if v_route_id_num=0 then
return true;
end if;
FOR bgp IN select distinct b.PROTOCOL_ID from tab_dcn_fabric_service_bgplink b inner join tab_dcn_fabric_service_protocol p on b.PROTOCOL_ID = p.ID where p.route_id = v_old_route_id and b.IPV4_PEER_IP = v_peer_ip and PEER_AS = v_as_num
LOOP
EXECUTE IMMEDIATE 'select count(*) from tab_dcn_fabric_service_route where ID = '''||v_new_route_id||'''' into v_new_route_id_num;
if v_new_route_id_num=0 then
insert into tab_dcn_fabric_service_route(ID, TRANSACTION_ID, TENANT_ID, LOGIC_ROUTER_ID, CREATE_TIME, DESCRIPTION)
select v_new_route_id ID, oldroute.TRANSACTION_ID TRANSACTION_ID, oldroute.TENANT_ID TENANT_ID, oldroute.LOGIC_ROUTER_ID LOGIC_ROUTER_ID, oldroute.CREATE_TIME CREATE_TIME, 'k8sbgp' DESCRIPTION
from tab_dcn_fabric_service_route oldroute where oldroute.ID = v_old_route_id;
end if;
update tab_dcn_fabric_service_protocol set ROUTE_ID = v_new_route_id where ID = bgp.PROTOCOL_ID;
update tab_dcn_fabric_service_bgplinkdeploy set ROUTE_ID = v_new_route_id where ROUTE_ID = v_old_route_id and IP_PEER_IP = v_peer_ip and PEER_AS = v_as_num;
end loop;
EXECUTE IMMEDIATE 'select count(r.*) from tab_dcn_fabric_service_route r inner join tab_dcn_fabric_service_protocol p on p.route_id = r.id where r.id = '''||v_old_route_id||'''' into v_route_id_num;
EXECUTE IMMEDIATE 'select count(r.*) from tab_dcn_fabric_service_route r inner join tab_dcn_fabric_service_staticroute s on s.route_id = r.id where r.id = '''||v_old_route_id||'''' into v_new_route_id_num;
if v_route_id_num=0 then
if v_new_route_id_num=0 then
delete from tab_dcn_fabric_service_route where id = v_old_route_id;
end if;
end if;
return true;
end;
$update_fabric_bgp_inner$ language plpgsql;
/
ALTER FUNCTION update_fabric_bgp_inner(v_old_route_id varchar2, v_new_route_id varchar2, v_peer_ip varchar2, v_as_num varchar2) OWNER TO ossdbuser;


CREATE OR REPLACE FUNCTION func_upgrade_tr5_container_bgp() RETURNS INTEGER AS $body$
BEGIN
for bgp in (select logic_route_id, peer_ipv4_address, peer_as_number, device_group_id, node_id from tab_dcn_k8s_bgp_route bgp) LOOP
for l23bgp in select id, router_id from tab_dcn_gbp_bgp_config where router_id::uuid = bgp.logic_route_id and peer_ip=bgp.peer_ipv4_address and peer_as_num=bgp.peer_as_number and device_group_id::uuid=bgp.device_group_id and address_family_type='1'
loop
update_fabric_bgp_inner(l23bgp.router_id, bgp.node_id::varchar, bgp.peer_ipv4_address, bgp.peer_as_number);
update tab_dcn_gbp_bgp_config set bgp_route_id = bgp.node_id ,producer='component-k8s' where id = l23bgp.id;
end loop;
end loop;
RETURN 0;
END;
$body$ language plpgsql;
/
ALTER FUNCTION func_upgrade_tr5_container_bgp() OWNER TO ossdbuser;
select func_upgrade_tr5_container_bgp();
drop function if exists func_upgrade_tr5_container_bgp;
drop function if exists update_fabric_bgp_inner;

CREATE OR REPLACE FUNCTION func_insert_svo_rowlock() RETURNS INTEGER AS $body$
declare
	v_router_type varchar;
BEGIN
	DBMS_OUTPUT.PUT_LINE('begin func_insert_svo_rowlock');
	for bgp in (select distinct router_id from tab_dcn_gbp_bgp_config bgp where bgp_peer_type=1 and producer='component-k8s') LOOP
		if exists (select 1 from tab_dcn_gbp_logic_router where id=bgp.router_id) then
			EXECUTE IMMEDIATE 'select type from tab_dcn_gbp_logic_router where id='''||bgp.router_id||'''' into v_router_type;
			if not exists (select 1 from tab_dcn_svo_rowlock where res_id='IndirectBgp_'||bgp.router_id||'_'||v_router_type) then
				DBMS_OUTPUT.PUT_LINE(concat('insert res_id : ', 'IndirectBgp_'||bgp.router_id||'_'||v_router_type));
				insert into tab_dcn_svo_rowlock (res_id) values ('IndirectBgp_'||bgp.router_id||'_'||v_router_type);
			end if;
		end if;
	end loop;
RETURN 0;
END;
$body$ language plpgsql;
/
ALTER FUNCTION func_insert_svo_rowlock() OWNER TO ossdbuser;
select func_insert_svo_rowlock();
drop function if exists func_insert_svo_rowlock;
--3.19.10.0.031_END

--3.19.10.0.062_BEGIN
drop table if exists tab_dcn_container_service;
create table tab_dcn_container_service
(
	id uuid primary key,
	name varchar(256) not null,
	tenant_id uuid not null,
	namespace varchar(128) not null,
	type varchar(128) not null,
	cluster_ip varchar(128) null,
	status varchar(256) null,
	k8s_id uuid not null
);
alter table tab_dcn_container_service owner to ossdbuser;

drop table if exists tab_dcn_container_service_port;
create table tab_dcn_container_service_port
(
    port_id uuid primary key,
    service_id uuid not null,
	port int default 0,
	protocol varchar(256) null,
	target_port int default 0,
	node_port int default 0
);
alter table tab_dcn_container_service_port owner to ossdbuser;

drop table if exists tab_dcn_container_endpoint;
create table tab_dcn_container_endpoint
(
    id uuid null,
    service_id uuid not null,
    ip varchar(128) not null,
    kind varchar(256) null,
    primary key(service_id,ip)
);
alter table tab_dcn_container_endpoint owner to ossdbuser;

drop index if exists idx_tab_dcn_container_service_k8s_id;
create index idx_tab_dcn_container_service_k8s_id on tab_dcn_container_service (k8s_id asc)
;
drop index if exists idx_tab_dcn_container_service_tenant_id;
create index idx_tab_dcn_container_service_tenant_id on tab_dcn_container_service (tenant_id asc)
;
drop index if exists idx_tab_dcn_container_service_port_service_id;
create index idx_tab_dcn_container_service_port_service_id on tab_dcn_container_service_port (service_id asc)
;
drop index if exists idx_tab_dcn_container_endpoint_service_id;
create index idx_tab_dcn_container_endpoint_service_id on tab_dcn_container_endpoint (service_id asc)
;
--3.19.10.0.062_END

--3.19.10.200.1070_BEGIN
create table if not exists tab_dcn_k8sapp_cert
(
  service_id varchar(128) primary key,
  last_label varchar(128) null
);
alter table public.tab_dcn_k8sapp_cert owner to ossdbuser;
--3.19.10.200.1070_END