--3.19.10.200.1050_BEGIN
DROP FUNCTION IF EXISTS upgrade_host_group_link_ref;
CREATE OR REPLACE FUNCTION upgrade_host_group_link_ref() RETURNS boolean as $$ 
    begin
		if exists (select 1 from tab_dcn_oam_host_group_member where trim(host_id) is not null) then
			FOR host_group_member in select * from tab_dcn_oam_host_group_member where trim(host_id) is not null LOOP 
					FOR host_device_info in select * from devicedescriptionentity where DEVICETYPE ='HOST' and NAME = host_group_member.HOST_NAME LOOP
							if exists (select 1 from linkentity where LINKTYPE = 'HOST' and RIGHTRESOURCEID = host_device_info.id) then
								FOR host_link_info in select * from linkentity where LINKTYPE = 'HOST' and RIGHTRESOURCEID = host_device_info.id LOOP
										if host_link_info.id != null then
											bulk_upgrade_link_ref(host_link_info.id,'host-group','component-hostgroup-service',host_link_info.LEFTRESOURCEID,host_link_info.LEFTLTPID,host_link_info.LEFTLTPNAME,host_link_info.RIGHTRESOURCEID,host_link_info.RIGHTLTPID,host_link_info.RIGHTLTPNAME);
										end if;
								END LOOP;
							end if;
					END LOOP;
			END LOOP;
		end if;
		return true;
    end
$$ language plpgsql strict;
ALTER FUNCTION upgrade_host_group_link_ref() OWNER TO ossdbuser;

select upgrade_host_group_link_ref();

DROP FUNCTION IF EXISTS isintranetorextranet;
CREATE OR REPLACE FUNCTION isintranetorextranet(_array_element jsonb) RETURNS boolean as $$ 
    begin
		if _array_element ->> 'name' = 'isintranetorextranet' and _array_element ->> 'value' != '4' then 
			return true;
		end if;
		return false;
    end
$$ language plpgsql strict;
ALTER FUNCTION isintranetorextranet(jsonb) OWNER TO ossdbuser;

DROP FUNCTION IF EXISTS upgrade_inout_escape_link_ref;
CREATE OR REPLACE FUNCTION upgrade_inout_escape_link_ref() RETURNS boolean as $$ 
  declare 
        _isintranetorextranet boolean := false;
    begin
			FOR link_info in select * from linkentity where TEATTRIBUTEENTITYS != '[]' LOOP
					select isintranetorextranet(jsonb_array_elements(( jsonb_array_elements(link_info.TEATTRIBUTEENTITYS) ::JSON -> 'userDefinedConstraintEntitys')::JSONB)::JSONB) into _isintranetorextranet;
						if _isintranetorextranet  then
							 bulk_upgrade_link_ref(link_info.id,'escape-link','dcn-topo-service-mgr',link_info.LEFTRESOURCEID,link_info.LEFTLTPID,link_info.LEFTLTPNAME,link_info.RIGHTRESOURCEID,link_info.RIGHTLTPID,link_info.RIGHTLTPNAME);
						end if;
			END LOOP;
		return true;
    end
$$ language plpgsql strict;
ALTER FUNCTION upgrade_inout_escape_link_ref() OWNER TO ossdbuser;

select upgrade_inout_escape_link_ref();


DROP FUNCTION IF EXISTS upgrade_inout_escape_link_ref;
DROP FUNCTION IF EXISTS isintranetorextranet;
DROP FUNCTION IF EXISTS upgrade_host_group_link_ref;
----3.19.10.200.1050_END