--19.2.0.001_BEGIN
DROP TABLE IF EXISTS TAB_SECM_USER_TENANT_RELATION;
CREATE TABLE TAB_SECM_USER_TENANT_RELATION (
  ID          VARCHAR(128) NOT NULL PRIMARY KEY,
  TENANT_ID   VARCHAR(128),
  USER_ID     VARCHAR(128),
  CREATE_TIME TIMESTAMP WITH TIME ZONE,
  UPDATE_TIME TIMESTAMP WITH TIME ZONE
);
ALTER TABLE TAB_SECM_USER_TENANT_RELATION OWNER TO OSSDBUSER;
--19.2.0.001_END

--19.2.0.001_BEGIN
ALTER TABLE TAB_SECM_DEVICEMONITOR_DEVICERESOURCE ADD SESSION_USAGE BIGINT;
--19.2.0.001_END

--19.3.0.063_BEGIN
update tab_secm_devicemonitor_deviceresource set session_usage=0 where session_usage is null;
--19.3.0.063_END

--19.2.0.001_BEGIN
DROP INDEX IF EXISTS TAB_SECM_DEVICE_GROUP_RELATION_GROUP_ID_IDX;
CREATE INDEX TAB_SECM_DEVICE_GROUP_RELATION_GROUP_ID_IDX
  ON TAB_SECM_DEVICE_GROUP_RELATION
  USING BTREE
  (group_id COLLATE PG_CATALOG."default");

ALTER TABLE TAB_SECM_DEVICE_GROUP_RELATION ADD COLUMN MEMBER_TYPE SMALLINT DEFAULT 0;
--19.2.0.001_END

--19.4.0.B111_BEGIN
select alter_columns('add','TAB_SECM_TENANT_MONITOR_CONFIG','SCREEN_SIZE','CHARACTER VARYING(128)');
--19.4.0.B111_END

--19.2.0.001_BEGIN
DROP TABLE IF EXISTS TAB_SECM_APP_DISPLAY_CONFIG;
CREATE TABLE TAB_SECM_APP_DISPLAY_CONFIG (
    PKID    CHARACTER VARYING(128) primary key NOT NULL,
    APP_NAME   varchar (128) null,
	APP_TYPE	INTEGER,
    TENANT_ID    CHARACTER VARYING(128)
);

ALTER TABLE TAB_SECM_APP_DISPLAY_CONFIG OWNER TO OSSDBUSER;

DROP TABLE IF EXISTS TAB_SECM_SECURECENTER_DEVICE_MONITOR;
CREATE TABLE TAB_SECM_SECURECENTER_DEVICE_MONITOR (
    PKID    CHARACTER VARYING(128) primary key NOT NULL,
    DEVICE_ID   CHARACTER VARYING(128),
	MONITOR_ORDER INTEGER,
    TENANT_ID    CHARACTER VARYING(128)
);

ALTER TABLE TAB_SECM_SECURECENTER_DEVICE_MONITOR OWNER TO OSSDBUSER;

DROP TABLE IF EXISTS TAB_SECM_TENANT_MONITOR_CONFIG;
CREATE TABLE TAB_SECM_TENANT_MONITOR_CONFIG (
    TENANT_ID    CHARACTER VARYING(128) primary key NOT NULL,
    MONITOR_SCREEN_NAME   CHARACTER VARYING(128),
	REFRESH_INTERVAL INTEGER
);

ALTER TABLE TAB_SECM_TENANT_MONITOR_CONFIG OWNER TO OSSDBUSER;

ALTER TABLE TAB_SECM_DEVICEMONITOR_INTERFACE_INFO ADD COLUMN INTERFACE_MONITOR INTEGER DEFAULT 0;
--19.2.0.001_END

--19.2.0.022_BEGIN
select alter_columns('add','TAB_SECM_DEVICEMONITOR_INTERFACE_INFO','NET_MASK','CHARACTER VARYING(255)');
select alter_columns('add','TAB_SECM_DEVICEMONITOR_INTERFACE_INFO','INTERFACE_TYPE','CHARACTER VARYING(255)');
--19.2.0.022_END

--19.2.0.060_BEGIN
DROP TABLE IF EXISTS TAB_SECM_DEVICEMONITOR_INFO_SUM;
CREATE TABLE TAB_SECM_DEVICEMONITOR_INFO_SUM (
PKID varchar(128)  primary key NOT NULL ,
DEVICE_ID CHARACTER VARYING(128),
SEND_RATE_SUM BIGINT,
RECEIVE_RATE_SUM BIGINT,
CREATE_TIME CHARACTER VARYING(255)
);
ALTER TABLE public.TAB_SECM_DEVICEMONITOR_INFO_SUM OWNER TO OSSDBUSER;
--19.2.0.060_END

--19.3.0.022_BEGIN
select alter_columns('add','TAB_SECM_DEVICEMONITOR_INTERFACE_INFO','DEVICE_DN','CHARACTER VARYING(128)');
update TAB_SECM_DEVICEMONITOR_INTERFACE_INFO set DEVICE_DN = DEVICE_ID;
select alter_columns('add','TAB_SECM_DEVICEMONITOR_INTERFACE_INFO','IPV4_ADDRESS','TEXT');
select alter_columns('add','TAB_SECM_DEVICEMONITOR_INTERFACE_INFO','IPV6_ADDRESS','TEXT');
select alter_columns('add','TAB_SECM_DEVICEMONITOR_INTERFACE_INFO','IPV6_PREFIX','TEXT');
select alter_columns('add','TAB_SECM_DEVICEMONITOR_INTERFACE_INFO','VSYS_NAME','CHARACTER VARYING(128)');
select alter_columns('alter','TAB_SECM_DEVICEMONITOR_INTERFACE_INFO','NET_MASK','TEXT');
--19.3.0.022_END

--19.4.0.B111_BEGIN
DROP TABLE IF EXISTS tab_secm_city_info;
  CREATE TABLE tab_secm_city_info
   (
    ID  CHARACTER VARYING(128) primary key NOT NULL,
	CITY_NAME_CN CHARACTER VARYING(256),
	CITY_NAME_EN CHARACTER VARYING(256),
	PROVINCE_NAME_CN CHARACTER VARYING(256),
	PROVINCE_NAME_EN CHARACTER VARYING(256),
	COUNTRY_NAME_CN CHARACTER VARYING(256),
	COUNTRY_NAME_EN CHARACTER VARYING(256)
   );
ALTER TABLE public.tab_secm_city_info OWNER TO OSSDBUSER;
 
insert into tab_secm_city_info values('0', '', '', '', '', '未知区域', 'unknown-zone');
insert into tab_secm_city_info values('1', '', '', '北京', 'BeiJing', '中国', 'China');
insert into tab_secm_city_info values('2', '', '', '上海', 'ShangHai', '中国', 'China');
insert into tab_secm_city_info values('3', '', '', '天津', 'TianJin', '中国', 'China');
insert into tab_secm_city_info values('4', '', '', '重庆', 'ChongQing', '中国', 'China');
insert into tab_secm_city_info values('5', '', '', '中国香港', 'HongKong,China', '中国', 'China');
insert into tab_secm_city_info values('6', '', '', '中国澳门', 'Macao,China', '中国', 'China');
insert into tab_secm_city_info values('7', '', '', '台湾', 'Taiwan', '中国', 'China');
insert into tab_secm_city_info values('8', '合肥市', 'Hefei', '安徽', 'Anhui', '中国', 'China');
insert into tab_secm_city_info values('9', '芜湖市', 'Wuhu', '安徽', 'Anhui', '中国', 'China');
insert into tab_secm_city_info values('10', '蚌埠市', 'Bengbu', '安徽', 'Anhui', '中国', 'China');
insert into tab_secm_city_info values('11', '淮南市', 'Huainan', '安徽', 'Anhui', '中国', 'China');
insert into tab_secm_city_info values('12', '马鞍山市', 'MaAnshan', '安徽', 'Anhui', '中国', 'China');
insert into tab_secm_city_info values('13', '淮北市', 'Huaibei', '安徽', 'Anhui', '中国', 'China');
insert into tab_secm_city_info values('14', '铜陵市', 'TongLing', '安徽', 'Anhui', '中国', 'China');
insert into tab_secm_city_info values('15', '安庆市', 'Anqing', '安徽', 'Anhui', '中国', 'China');
insert into tab_secm_city_info values('16', '黄山市', 'Huangshan', '安徽', 'Anhui', '中国', 'China');
insert into tab_secm_city_info values('17', '滁州市', 'Chuzhou', '安徽', 'Anhui', '中国', 'China');
insert into tab_secm_city_info values('18', '阜阳市', 'Fuyang', '安徽', 'Anhui', '中国', 'China');
insert into tab_secm_city_info values('19', '宿州市', 'Suzhou', '安徽', 'Anhui', '中国', 'China');
insert into tab_secm_city_info values('20', '六安市', 'Lu''an', '安徽', 'Anhui', '中国', 'China');
insert into tab_secm_city_info values('21', '亳州市', 'Haozhou', '安徽', 'Anhui', '中国', 'China');
insert into tab_secm_city_info values('22', '池州市', 'Chizhou', '安徽', 'Anhui', '中国', 'China');
insert into tab_secm_city_info values('23', '宣城市', 'Xuancheng', '安徽', 'Anhui', '中国', 'China');
insert into tab_secm_city_info values('24', '福州市', 'Fuzhou', '福建', 'Fujian', '中国', 'China');
insert into tab_secm_city_info values('25', '厦门市', 'Xiamen', '福建', 'Fujian', '中国', 'China');
insert into tab_secm_city_info values('26', '莆田市', 'Putian', '福建', 'Fujian', '中国', 'China');
insert into tab_secm_city_info values('27', '三明市', 'Sanming', '福建', 'Fujian', '中国', 'China');
insert into tab_secm_city_info values('28', '泉州市', 'Quanzhou', '福建', 'Fujian', '中国', 'China');
insert into tab_secm_city_info values('29', '漳州市', 'Zhangzhou', '福建', 'Fujian', '中国', 'China');
insert into tab_secm_city_info values('30', '南平市', 'Nanping', '福建', 'Fujian', '中国', 'China');
insert into tab_secm_city_info values('31', '龙岩市', 'Longyan', '福建', 'Fujian', '中国', 'China');
insert into tab_secm_city_info values('32', '宁德市', 'Ningde', '福建', 'Fujian', '中国', 'China');
insert into tab_secm_city_info values('33', '兰州市', 'Lanzhou', '甘肃', 'Gansu', '中国', 'China');
insert into tab_secm_city_info values('34', '嘉峪关市', 'Jiayuguan', '甘肃', 'Gansu', '中国', 'China');
insert into tab_secm_city_info values('35', '金昌市', 'Jingchang', '甘肃', 'Gansu', '中国', 'China');
insert into tab_secm_city_info values('36', '白银市', 'Baiying', '甘肃', 'Gansu', '中国', 'China');
insert into tab_secm_city_info values('37', '天水市', 'Tianshui', '甘肃', 'Gansu', '中国', 'China');
insert into tab_secm_city_info values('38', '武威市', 'Wuwei', '甘肃', 'Gansu', '中国', 'China');
insert into tab_secm_city_info values('39', '张掖市', 'Zhangye', '甘肃', 'Gansu', '中国', 'China');
insert into tab_secm_city_info values('40', '平凉市', 'Pingliang', '甘肃', 'Gansu', '中国', 'China');
insert into tab_secm_city_info values('41', '酒泉市', 'Jiuquan', '甘肃', 'Gansu', '中国', 'China');
insert into tab_secm_city_info values('42', '庆阳市', 'Qingyang', '甘肃', 'Gansu', '中国', 'China');
insert into tab_secm_city_info values('43', '定西市', 'Dingxi', '甘肃', 'Gansu', '中国', 'China');
insert into tab_secm_city_info values('44', '陇南市', 'Longnan', '甘肃', 'Gansu', '中国', 'China');
insert into tab_secm_city_info values('45', '临夏回族自治州', 'Linxia Hui Autonomous Prefecture', '甘肃', 'Gansu', '中国', 'China');
insert into tab_secm_city_info values('46', '甘南藏族自治州', 'Gannan Tibetan Autonomous Prefecture', '甘肃', 'Gansu', '中国', 'China');
insert into tab_secm_city_info values('47', '广州市', 'Guangzhou', '广东', 'Guangdong', '中国', 'China');
insert into tab_secm_city_info values('48', '韶关市', 'Shaoguan', '广东', 'Guangdong', '中国', 'China');
insert into tab_secm_city_info values('49', '深圳市', 'Shenzhen', '广东', 'Guangdong', '中国', 'China');
insert into tab_secm_city_info values('50', '珠海市', 'Zhuhai', '广东', 'Guangdong', '中国', 'China');
insert into tab_secm_city_info values('51', '汕头市', 'Shantou', '广东', 'Guangdong', '中国', 'China');
insert into tab_secm_city_info values('52', '佛山市', 'Foushan', '广东', 'Guangdong', '中国', 'China');
insert into tab_secm_city_info values('53', '江门市', 'Jiangmen', '广东', 'Guangdong', '中国', 'China');
insert into tab_secm_city_info values('54', '湛江市', 'Zhanjiang', '广东', 'Guangdong', '中国', 'China');
insert into tab_secm_city_info values('55', '茂名市', 'Maoming', '广东', 'Guangdong', '中国', 'China');
insert into tab_secm_city_info values('56', '肇庆市', 'Zhaoqing', '广东', 'Guangdong', '中国', 'China');
insert into tab_secm_city_info values('57', '惠州市', 'Huizhou', '广东', 'Guangdong', '中国', 'China');
insert into tab_secm_city_info values('58', '梅州市', 'Meizhou', '广东', 'Guangdong', '中国', 'China');
insert into tab_secm_city_info values('59', '汕尾市', 'Shanwei', '广东', 'Guangdong', '中国', 'China');
insert into tab_secm_city_info values('60', '河源市', 'Heyuan', '广东', 'Guangdong', '中国', 'China');
insert into tab_secm_city_info values('61', '阳江市', 'Yangjiang', '广东', 'Guangdong', '中国', 'China');
insert into tab_secm_city_info values('62', '清远市', 'Qingyuan', '广东', 'Guangdong', '中国', 'China');
insert into tab_secm_city_info values('63', '东莞市', 'Dongguang', '广东', 'Guangdong', '中国', 'China');
insert into tab_secm_city_info values('64', '中山市', 'Zhongshan', '广东', 'Guangdong', '中国', 'China');
insert into tab_secm_city_info values('65', '潮州市', 'Chaozhou', '广东', 'Guangdong', '中国', 'China');
insert into tab_secm_city_info values('66', '揭阳市', 'Jieyang', '广东', 'Guangdong', '中国', 'China');
insert into tab_secm_city_info values('67', '云浮市', 'Yunfu', '广东', 'Guangdong', '中国', 'China');
insert into tab_secm_city_info values('68', '南宁市', 'Nanning', '广西', 'Guangxi', '中国', 'China');
insert into tab_secm_city_info values('69', '柳州市', 'Liuzhou', '广西', 'Guangxi', '中国', 'China');
insert into tab_secm_city_info values('70', '桂林市', 'Guilin', '广西', 'Guangxi', '中国', 'China');
insert into tab_secm_city_info values('71', '梧州市', 'Wuzhou', '广西', 'Guangxi', '中国', 'China');
insert into tab_secm_city_info values('72', '北海市', 'Beihai', '广西', 'Guangxi', '中国', 'China');
insert into tab_secm_city_info values('73', '防城港市', 'Fangchenggang', '广西', 'Guangxi', '中国', 'China');
insert into tab_secm_city_info values('74', '钦州市', 'Qingzhou', '广西', 'Guangxi', '中国', 'China');
insert into tab_secm_city_info values('75', '贵港市', 'Guigang', '广西', 'Guangxi', '中国', 'China');
insert into tab_secm_city_info values('76', '玉林市', 'Yulin', '广西', 'Guangxi', '中国', 'China');
insert into tab_secm_city_info values('77', '百色市', 'Baise', '广西', 'Guangxi', '中国', 'China');
insert into tab_secm_city_info values('78', '贺州市', 'Hezhou', '广西', 'Guangxi', '中国', 'China');
insert into tab_secm_city_info values('79', '河池市', 'Hechi', '广西', 'Guangxi', '中国', 'China');
insert into tab_secm_city_info values('80', '来宾市', 'Laibin', '广西', 'Guangxi', '中国', 'China');
insert into tab_secm_city_info values('81', '崇左市', 'Chongzuo', '广西', 'Guangxi', '中国', 'China');
insert into tab_secm_city_info values('82', '贵阳市', 'Guiyang', '贵州', 'Guizhou', '中国', 'China');
insert into tab_secm_city_info values('83', '六盘水市', 'Liupanshui ', '贵州', 'Guizhou', '中国', 'China');
insert into tab_secm_city_info values('84', '遵义市', 'Zunyi', '贵州', 'Guizhou', '中国', 'China');
insert into tab_secm_city_info values('85', '安顺市', 'Anshun', '贵州', 'Guizhou', '中国', 'China');
insert into tab_secm_city_info values('86', '毕节市', 'Bijie', '贵州', 'Guizhou', '中国', 'China');
insert into tab_secm_city_info values('87', '铜仁市', 'Tongren', '贵州', 'Guizhou', '中国', 'China');
insert into tab_secm_city_info values('88', '黔西南布依族苗族自治州', 'Southwest Guizhou Autonomous Prefecture', '贵州', 'Guizhou', '中国', 'China');
insert into tab_secm_city_info values('89', '黔东南苗族侗族自治州', 'Qiandongnan Miao and Dong Autonomous Prefectur', '贵州', 'Guizhou', '中国', 'China');
insert into tab_secm_city_info values('90', '黔南布依族苗族自治州', 'Qiannan Buyi and Miao Autonomous Prefecture', '贵州', 'Guizhou', '中国', 'China');
insert into tab_secm_city_info values('91', '海口市', 'Haikou', '海南', 'Hainan', '中国', 'China');
insert into tab_secm_city_info values('92', '三亚市', 'Sanya', '海南', 'Hainan', '中国', 'China');
insert into tab_secm_city_info values('93', '三沙市', 'Sansha', '海南', 'Hainan', '中国', 'China');
insert into tab_secm_city_info values('94', '儋州市', 'Danzhou', '海南', 'Hainan', '中国', 'China');
insert into tab_secm_city_info values('95', '五指山市', 'Wuzhishan', '海南', 'Hainan', '中国', 'China');
insert into tab_secm_city_info values('96', '琼海市', 'Qionghai', '海南', 'Hainan', '中国', 'China');
insert into tab_secm_city_info values('97', '文昌市', 'Wenchang', '海南', 'Hainan', '中国', 'China');
insert into tab_secm_city_info values('98', '万宁市', 'Wangning', '海南', 'Hainan', '中国', 'China');
insert into tab_secm_city_info values('99', '东方市', 'Dongfang', '海南', 'Hainan', '中国', 'China');
insert into tab_secm_city_info values('100', '定安县', 'Dingan', '海南', 'Hainan', '中国', 'China');
insert into tab_secm_city_info values('101', '屯昌县', 'Tunchang', '海南', 'Hainan', '中国', 'China');
insert into tab_secm_city_info values('102', '澄迈县', 'Chengmai', '海南', 'Hainan', '中国', 'China');
insert into tab_secm_city_info values('103', '临高县', 'Lingao', '海南', 'Hainan', '中国', 'China');
insert into tab_secm_city_info values('104', '白沙黎族自治县', 'Baisha Li Autonomous County', '海南', 'Hainan', '中国', 'China');
insert into tab_secm_city_info values('105', '昌江黎族自治县', 'Changjiang Li Autonomous County', '海南', 'Hainan', '中国', 'China');
insert into tab_secm_city_info values('106', '乐东黎族自治县', 'Ledong Li Autonomous County', '海南', 'Hainan', '中国', 'China');
insert into tab_secm_city_info values('107', '陵水黎族自治县', 'Lingshui Li Autonomous County', '海南', 'Hainan', '中国', 'China');
insert into tab_secm_city_info values('108', '保亭黎族苗族自治县', 'Baoting', '海南', 'Hainan', '中国', 'China');
insert into tab_secm_city_info values('109', '琼中黎族苗族自治县', 'Qiongzhong', '海南', 'Hainan', '中国', 'China');
insert into tab_secm_city_info values('110', '石家庄市', 'Shijiazhuang', '河北', 'Hebei', '中国', 'China');
insert into tab_secm_city_info values('111', '唐山市', 'Tangshan', '河北', 'Hebei', '中国', 'China');
insert into tab_secm_city_info values('112', '秦皇岛市', 'Qinghuangdao', '河北', 'Hebei', '中国', 'China');
insert into tab_secm_city_info values('113', '邯郸市', 'Handan', '河北', 'Hebei', '中国', 'China');
insert into tab_secm_city_info values('114', '邢台市', 'Xingtai', '河北', 'Hebei', '中国', 'China');
insert into tab_secm_city_info values('115', '保定市', 'Baoding', '河北', 'Hebei', '中国', 'China');
insert into tab_secm_city_info values('116', '张家口市', 'Zhangjiakou', '河北', 'Hebei', '中国', 'China');
insert into tab_secm_city_info values('117', '承德市', 'Chengde', '河北', 'Hebei', '中国', 'China');
insert into tab_secm_city_info values('118', '沧州市', 'Cangzhou', '河北', 'Hebei', '中国', 'China');
insert into tab_secm_city_info values('119', '廊坊市', 'Langfang', '河北', 'Hebei', '中国', 'China');
insert into tab_secm_city_info values('120', '衡水市', 'Hengshui', '河北', 'Hebei', '中国', 'China');
insert into tab_secm_city_info values('121', '哈尔滨市', 'Harbin', '黑龙江', 'Heilongjiang', '中国', 'China');
insert into tab_secm_city_info values('122', '齐齐哈尔市', 'Qiqihar', '黑龙江', 'Heilongjiang', '中国', 'China');
insert into tab_secm_city_info values('123', '鸡西市', 'Jixi', '黑龙江', 'Heilongjiang', '中国', 'China');
insert into tab_secm_city_info values('124', '鹤岗市', 'Hegang', '黑龙江', 'Heilongjiang', '中国', 'China');
insert into tab_secm_city_info values('125', '双鸭山市', 'Shuangyashan', '黑龙江', 'Heilongjiang', '中国', 'China');
insert into tab_secm_city_info values('126', '大庆市', 'Daqing', '黑龙江', 'Heilongjiang', '中国', 'China');
insert into tab_secm_city_info values('127', '伊春市', 'Yichun', '黑龙江', 'Heilongjiang', '中国', 'China');
insert into tab_secm_city_info values('128', '佳木斯市', 'Jiamusi', '黑龙江', 'Heilongjiang', '中国', 'China');
insert into tab_secm_city_info values('129', '七台河市', 'Qitaihe', '黑龙江', 'Heilongjiang', '中国', 'China');
insert into tab_secm_city_info values('130', '牡丹江市', 'Mudanjiang', '黑龙江', 'Heilongjiang', '中国', 'China');
insert into tab_secm_city_info values('131', '黑河市', 'Heihe', '黑龙江', 'Heilongjiang', '中国', 'China');
insert into tab_secm_city_info values('132', '绥化市', 'Suihua', '黑龙江', 'Heilongjiang', '中国', 'China');
insert into tab_secm_city_info values('133', '大兴安岭地区', 'Da Hinggan Ling Prefecture', '黑龙江', 'Heilongjiang', '中国', 'China');
insert into tab_secm_city_info values('134', '郑州市', 'Zhengzhou', '河南', 'Henan', '中国', 'China');
insert into tab_secm_city_info values('135', '开封市', 'Kaifeng', '河南', 'Henan', '中国', 'China');
insert into tab_secm_city_info values('136', '洛阳市', 'Luoyang', '河南', 'Henan', '中国', 'China');
insert into tab_secm_city_info values('137', '平顶山市', 'Pingdingshan', '河南', 'Henan', '中国', 'China');
insert into tab_secm_city_info values('138', '安阳市', 'Anyang', '河南', 'Henan', '中国', 'China');
insert into tab_secm_city_info values('139', '鹤壁市', 'Hebi', '河南', 'Henan', '中国', 'China');
insert into tab_secm_city_info values('140', '新乡市', 'Xinxiang', '河南', 'Henan', '中国', 'China');
insert into tab_secm_city_info values('141', '焦作市', 'Jiaozuo', '河南', 'Henan', '中国', 'China');
insert into tab_secm_city_info values('142', '濮阳市', 'Puyang ', '河南', 'Henan', '中国', 'China');
insert into tab_secm_city_info values('143', '许昌市', 'Xuchang', '河南', 'Henan', '中国', 'China');
insert into tab_secm_city_info values('144', '漯河市', 'Luohe', '河南', 'Henan', '中国', 'China');
insert into tab_secm_city_info values('145', '三门峡市', 'Sanmenxia', '河南', 'Henan', '中国', 'China');
insert into tab_secm_city_info values('146', '南阳市', 'Nanyang', '河南', 'Henan', '中国', 'China');
insert into tab_secm_city_info values('147', '商丘市', 'Shangqiu', '河南', 'Henan', '中国', 'China');
insert into tab_secm_city_info values('148', '信阳市', 'Xinyang', '河南', 'Henan', '中国', 'China');
insert into tab_secm_city_info values('149', '周口市', 'Zhoukou', '河南', 'Henan', '中国', 'China');
insert into tab_secm_city_info values('150', '驻马店市', 'Zhumadian', '河南', 'Henan', '中国', 'China');
insert into tab_secm_city_info values('151', '济源市', 'Jiyuan', '河南', 'Henan', '中国', 'China');
insert into tab_secm_city_info values('152', '武汉市', 'Wuhan', '湖北', 'Hubei', '中国', 'China');
insert into tab_secm_city_info values('153', '黄石市', 'Huangshi', '湖北', 'Hubei', '中国', 'China');
insert into tab_secm_city_info values('154', '十堰市', 'Shiyan', '湖北', 'Hubei', '中国', 'China');
insert into tab_secm_city_info values('155', '宜昌市', 'Yichang', '湖北', 'Hubei', '中国', 'China');
insert into tab_secm_city_info values('156', '襄阳市', 'Xiangyang', '湖北', 'Hubei', '中国', 'China');
insert into tab_secm_city_info values('157', '鄂州市', 'Ezhou', '湖北', 'Hubei', '中国', 'China');
insert into tab_secm_city_info values('158', '荆门市', 'Jingmen', '湖北', 'Hubei', '中国', 'China');
insert into tab_secm_city_info values('159', '孝感市', 'Xiaogan', '湖北', 'Hubei', '中国', 'China');
insert into tab_secm_city_info values('160', '荆州市', 'Jingzhou', '湖北', 'Hubei', '中国', 'China');
insert into tab_secm_city_info values('161', '黄冈市', 'Huanggang', '湖北', 'Hubei', '中国', 'China');
insert into tab_secm_city_info values('162', '咸宁市', 'Xianning', '湖北', 'Hubei', '中国', 'China');
insert into tab_secm_city_info values('163', '随州市', 'Suizhou', '湖北', 'Hubei', '中国', 'China');
insert into tab_secm_city_info values('164', '恩施土家族苗族自治州', 'Enshi Tujia and Miao Autonomous Prefecture', '湖北', 'Hubei', '中国', 'China');
insert into tab_secm_city_info values('165', '仙桃市', 'Xiantao', '湖北', 'Hubei', '中国', 'China');
insert into tab_secm_city_info values('166', '潜江市', 'Qianjiang', '湖北', 'Hubei', '中国', 'China');
insert into tab_secm_city_info values('167', '天门市', 'Tianmen', '湖北', 'Hubei', '中国', 'China');
insert into tab_secm_city_info values('168', '神农架林区', 'Shennongjia Forestry District，Hubei Shennongjia', '湖北', 'Hubei', '中国', 'China');
insert into tab_secm_city_info values('169', '长沙市', 'Changsha', '湖南', 'Hunan', '中国', 'China');
insert into tab_secm_city_info values('170', '株洲市', 'Zhuzhou', '湖南', 'Hunan', '中国', 'China');
insert into tab_secm_city_info values('171', '湘潭市', 'Xiangtan', '湖南', 'Hunan', '中国', 'China');
insert into tab_secm_city_info values('172', '衡阳市', 'Hengyang', '湖南', 'Hunan', '中国', 'China');
insert into tab_secm_city_info values('173', '邵阳市', 'Shaoyang', '湖南', 'Hunan', '中国', 'China');
insert into tab_secm_city_info values('174', '岳阳市', 'Yueyang', '湖南', 'Hunan', '中国', 'China');
insert into tab_secm_city_info values('175', '常德市', 'Changde', '湖南', 'Hunan', '中国', 'China');
insert into tab_secm_city_info values('176', '张家界市', 'Zhangjiajie', '湖南', 'Hunan', '中国', 'China');
insert into tab_secm_city_info values('177', '益阳市', 'Yiyang', '湖南', 'Hunan', '中国', 'China');
insert into tab_secm_city_info values('178', '郴州市', 'Chenzhou', '湖南', 'Hunan', '中国', 'China');
insert into tab_secm_city_info values('179', '永州市', 'Yongzhou', '湖南', 'Hunan', '中国', 'China');
insert into tab_secm_city_info values('180', '怀化市', 'Huaihua', '湖南', 'Hunan', '中国', 'China');
insert into tab_secm_city_info values('181', '娄底市', 'Loudi', '湖南', 'Hunan', '中国', 'China');
insert into tab_secm_city_info values('182', '湘西土家族苗族自治州', 'Xiangxi Tujia and Miao Autonomous Prefecture', '湖南', 'Hunan', '中国', 'China');
insert into tab_secm_city_info values('183', '南京市', 'Nanjing', '江苏', 'Jiangsu', '中国', 'China');
insert into tab_secm_city_info values('184', '无锡市', 'Wuxi', '江苏', 'Jiangsu', '中国', 'China');
insert into tab_secm_city_info values('185', '徐州市', 'Xuzhou', '江苏', 'Jiangsu', '中国', 'China');
insert into tab_secm_city_info values('186', '常州市', 'Changzhou', '江苏', 'Jiangsu', '中国', 'China');
insert into tab_secm_city_info values('187', '苏州市', 'Suzhou', '江苏', 'Jiangsu', '中国', 'China');
insert into tab_secm_city_info values('188', '南通市', 'Nantong', '江苏', 'Jiangsu', '中国', 'China');
insert into tab_secm_city_info values('189', '连云港市', 'Lianyungang', '江苏', 'Jiangsu', '中国', 'China');
insert into tab_secm_city_info values('190', '淮安市', 'Huaian', '江苏', 'Jiangsu', '中国', 'China');
insert into tab_secm_city_info values('191', '盐城市', 'Yancheng', '江苏', 'Jiangsu', '中国', 'China');
insert into tab_secm_city_info values('192', '扬州市', 'Yangzhou', '江苏', 'Jiangsu', '中国', 'China');
insert into tab_secm_city_info values('193', '镇江市', 'Zhenjiang', '江苏', 'Jiangsu', '中国', 'China');
insert into tab_secm_city_info values('194', '泰州市', 'Taizhou', '江苏', 'Jiangsu', '中国', 'China');
insert into tab_secm_city_info values('195', '宿迁市', 'Suqian', '江苏', 'Jiangsu', '中国', 'China');
insert into tab_secm_city_info values('196', '南昌市', 'Nanchang', '江西', 'Jiangxi', '中国', 'China');
insert into tab_secm_city_info values('197', '萍乡市', 'Pingxiang', '江西', 'Jiangxi', '中国', 'China');
insert into tab_secm_city_info values('198', '景德镇市', 'Jingdezhen', '江西', 'Jiangxi', '中国', 'China');
insert into tab_secm_city_info values('199', '九江市', 'Jiujiang', '江西', 'Jiangxi', '中国', 'China');
insert into tab_secm_city_info values('200', '新余市', 'Xinyu', '江西', 'Jiangxi', '中国', 'China');
insert into tab_secm_city_info values('201', '鹰潭市', 'Yingtan', '江西', 'Jiangxi', '中国', 'China');
insert into tab_secm_city_info values('202', '赣州市', 'Ganzhou', '江西', 'Jiangxi', '中国', 'China');
insert into tab_secm_city_info values('203', '吉安市', 'Ji’an ', '江西', 'Jiangxi', '中国', 'China');
insert into tab_secm_city_info values('204', '宜春市', 'Yichun', '江西', 'Jiangxi', '中国', 'China');
insert into tab_secm_city_info values('205', '抚州市', 'Fuzhou', '江西', 'Jiangxi', '中国', 'China');
insert into tab_secm_city_info values('206', '上饶市', 'Shangrao', '江西', 'Jiangxi', '中国', 'China');
insert into tab_secm_city_info values('207', '长春市', 'Changchun', '吉林', 'Jilin', '中国', 'China');
insert into tab_secm_city_info values('208', '吉林市', 'Jilin', '吉林', 'Jilin', '中国', 'China');
insert into tab_secm_city_info values('209', '四平市', 'Siping', '吉林', 'Jilin', '中国', 'China');
insert into tab_secm_city_info values('210', '辽源市', 'Liaoyuan', '吉林', 'Jilin', '中国', 'China');
insert into tab_secm_city_info values('211', '通化市', 'Tonghua', '吉林', 'Jilin', '中国', 'China');
insert into tab_secm_city_info values('212', '白山市', 'Baishan', '吉林', 'Jilin', '中国', 'China');
insert into tab_secm_city_info values('213', '松原市', 'Songyuan', '吉林', 'Jilin', '中国', 'China');
insert into tab_secm_city_info values('214', '白城市', 'Baicheng', '吉林', 'Jilin', '中国', 'China');
insert into tab_secm_city_info values('215', '延边朝鲜族自治州', 'Yanbian Korean Autonomous Prefecture', '吉林', 'Jilin', '中国', 'China');
insert into tab_secm_city_info values('216', '沈阳市', 'Shenyang', '辽宁', 'Liaoning', '中国', 'China');
insert into tab_secm_city_info values('217', '大连市', 'Dalian', '辽宁', 'Liaoning', '中国', 'China');
insert into tab_secm_city_info values('218', '鞍山市', 'Anshan', '辽宁', 'Liaoning', '中国', 'China');
insert into tab_secm_city_info values('219', '抚顺市', 'Fushun', '辽宁', 'Liaoning', '中国', 'China');
insert into tab_secm_city_info values('220', '本溪市', 'Benxi', '辽宁', 'Liaoning', '中国', 'China');
insert into tab_secm_city_info values('221', '丹东市', 'Dandong', '辽宁', 'Liaoning', '中国', 'China');
insert into tab_secm_city_info values('222', '锦州市', 'Jinzhou', '辽宁', 'Liaoning', '中国', 'China');
insert into tab_secm_city_info values('223', '营口市', 'Yingkou', '辽宁', 'Liaoning', '中国', 'China');
insert into tab_secm_city_info values('224', '阜新市', 'Fuxin', '辽宁', 'Liaoning', '中国', 'China');
insert into tab_secm_city_info values('225', '辽阳市', 'Liaoyang', '辽宁', 'Liaoning', '中国', 'China');
insert into tab_secm_city_info values('226', '盘锦市', 'Panjing', '辽宁', 'Liaoning', '中国', 'China');
insert into tab_secm_city_info values('227', '铁岭市', 'Tieling', '辽宁', 'Liaoning', '中国', 'China');
insert into tab_secm_city_info values('228', '朝阳市', 'Chaoyang', '辽宁', 'Liaoning', '中国', 'China');
insert into tab_secm_city_info values('229', '葫芦岛市', 'Huludao', '辽宁', 'Liaoning', '中国', 'China');
insert into tab_secm_city_info values('230', '呼和浩特市', 'Huhehaote', '内蒙古', 'Neimenggu', '中国', 'China');
insert into tab_secm_city_info values('231', '包头市', 'Baotou', '内蒙古', 'Neimenggu', '中国', 'China');
insert into tab_secm_city_info values('232', '乌海市', 'Wughai', '内蒙古', 'Neimenggu', '中国', 'China');
insert into tab_secm_city_info values('233', '赤峰市', 'Chifeng', '内蒙古', 'Neimenggu', '中国', 'China');
insert into tab_secm_city_info values('234', '通辽市', 'Tongliao', '内蒙古', 'Neimenggu', '中国', 'China');
insert into tab_secm_city_info values('235', '鄂尔多斯市', 'Ordos', '内蒙古', 'Neimenggu', '中国', 'China');
insert into tab_secm_city_info values('236', '巴彦淖尔市', 'Bayan Nur', '内蒙古', 'Neimenggu', '中国', 'China');
insert into tab_secm_city_info values('237', '乌兰察布市', 'Ulanqab', '内蒙古', 'Neimenggu', '中国', 'China');
insert into tab_secm_city_info values('238', '兴安盟', 'Hinggan League', '内蒙古', 'Neimenggu', '中国', 'China');
insert into tab_secm_city_info values('239', '锡林郭勒盟', 'Xilingol League', '内蒙古', 'Neimenggu', '中国', 'China');
insert into tab_secm_city_info values('240', '阿拉善盟', 'Alxa League', '内蒙古', 'Neimenggu', '中国', 'China');
insert into tab_secm_city_info values('241', '呼伦贝尔市', 'Hulun Buir', '内蒙古', 'Neimenggu', '中国', 'China');
insert into tab_secm_city_info values('242', '银川市', 'Yingchuan', '宁夏', 'Ningxia', '中国', 'China');
insert into tab_secm_city_info values('243', '石嘴山市', 'Shizuishan', '宁夏', 'Ningxia', '中国', 'China');
insert into tab_secm_city_info values('244', '吴忠市', 'Wuzhong', '宁夏', 'Ningxia', '中国', 'China');
insert into tab_secm_city_info values('245', '固原市', 'Guyuan', '宁夏', 'Ningxia', '中国', 'China');
insert into tab_secm_city_info values('246', '中卫市', 'Zhongwei', '宁夏', 'Ningxia', '中国', 'China');
insert into tab_secm_city_info values('247', '西宁市', 'Xining', '青海', 'Qinghai', '中国', 'China');
insert into tab_secm_city_info values('248', '海东市', 'Haidong', '青海', 'Qinghai', '中国', 'China');
insert into tab_secm_city_info values('249', '海北藏族自治州', 'Tibetan Autonomous Prefecture of Haibei', '青海', 'Qinghai', '中国', 'China');
insert into tab_secm_city_info values('250', '黄南藏族自治州', 'Tibetan Autonomous Prefecture of Huangnan', '青海', 'Qinghai', '中国', 'China');
insert into tab_secm_city_info values('251', '海南藏族自治州', 'Tibetan Autonomous Prefecture of Hainan', '青海', 'Qinghai', '中国', 'China');
insert into tab_secm_city_info values('252', '果洛藏族自治州', 'Tibetan Autonomous Prefecture of Golog', '青海', 'Qinghai', '中国', 'China');
insert into tab_secm_city_info values('253', '玉树藏族自治州', 'Yushu Tibetan Autonomous Prefecture', '青海', 'Qinghai', '中国', 'China');
insert into tab_secm_city_info values('254', '海西蒙古族藏族自治州', 'Haixi Mongolian and Tibetan Autonomous Prefecture', '青海', 'Qinghai', '中国', 'China');
insert into tab_secm_city_info values('255', '济南市', 'Jinan', '山东', 'Shandong', '中国', 'China');
insert into tab_secm_city_info values('256', '青岛市', 'Qingdao', '山东', 'Shandong', '中国', 'China');
insert into tab_secm_city_info values('257', '淄博市', 'Zibo', '山东', 'Shandong', '中国', 'China');
insert into tab_secm_city_info values('258', '东营市', 'Dongying', '山东', 'Shandong', '中国', 'China');
insert into tab_secm_city_info values('259', '烟台市', 'Yantai', '山东', 'Shandong', '中国', 'China');
insert into tab_secm_city_info values('260', '潍坊市', 'Weifang', '山东', 'Shandong', '中国', 'China');
insert into tab_secm_city_info values('261', '济宁市', 'Jining', '山东', 'Shandong', '中国', 'China');
insert into tab_secm_city_info values('262', '泰安市', 'Taian', '山东', 'Shandong', '中国', 'China');
insert into tab_secm_city_info values('263', '威海市', 'Weihai', '山东', 'Shandong', '中国', 'China');
insert into tab_secm_city_info values('264', '日照市', 'Rizhao', '山东', 'Shandong', '中国', 'China');
insert into tab_secm_city_info values('265', '莱芜市', 'Laiwu', '山东', 'Shandong', '中国', 'China');
insert into tab_secm_city_info values('266', '临沂市', 'Linyi', '山东', 'Shandong', '中国', 'China');
insert into tab_secm_city_info values('267', '德州市', 'Dezhou', '山东', 'Shandong', '中国', 'China');
insert into tab_secm_city_info values('268', '聊城市', 'Liaocheng', '山东', 'Shandong', '中国', 'China');
insert into tab_secm_city_info values('269', '滨州市', 'Binzhou', '山东', 'Shandong', '中国', 'China');
insert into tab_secm_city_info values('270', '菏泽市', 'Heze', '山东', 'Shandong', '中国', 'China');
insert into tab_secm_city_info values('271', '枣庄市', 'Zaozhuang', '山东', 'Shandong', '中国', 'China');
insert into tab_secm_city_info values('272', '太原市', 'Taiyuan', '山西', 'Shanxi', '中国', 'China');
insert into tab_secm_city_info values('273', '大同市', 'Datong', '山西', 'Shanxi', '中国', 'China');
insert into tab_secm_city_info values('274', '阳泉市', 'Yangquan', '山西', 'Shanxi', '中国', 'China');
insert into tab_secm_city_info values('275', '长治市', 'Changzhi', '山西', 'Shanxi', '中国', 'China');
insert into tab_secm_city_info values('276', '晋城市', 'Jingcheng', '山西', 'Shanxi', '中国', 'China');
insert into tab_secm_city_info values('277', '朔州市', 'Shuozhou', '山西', 'Shanxi', '中国', 'China');
insert into tab_secm_city_info values('278', '晋中市', 'Jingzhong', '山西', 'Shanxi', '中国', 'China');
insert into tab_secm_city_info values('279', '运城市', 'Yuncheng', '山西', 'Shanxi', '中国', 'China');
insert into tab_secm_city_info values('280', '忻州市', 'Xinzhou', '山西', 'Shanxi', '中国', 'China');
insert into tab_secm_city_info values('281', '临汾市', 'Linfen', '山西', 'Shanxi', '中国', 'China');
insert into tab_secm_city_info values('282', '吕梁市', 'Lvliang', '山西', 'Shanxi', '中国', 'China');
insert into tab_secm_city_info values('283', '西安市', 'Xi’an', '陕西', 'Shaanxi', '中国', 'China');
insert into tab_secm_city_info values('284', '铜川市', 'Tongchuan', '陕西', 'Shaanxi', '中国', 'China');
insert into tab_secm_city_info values('285', '咸阳市', 'Xianyang', '陕西', 'Shaanxi', '中国', 'China');
insert into tab_secm_city_info values('286', '渭南市', 'Weinan', '陕西', 'Shaanxi', '中国', 'China');
insert into tab_secm_city_info values('287', '延安市', 'Yan’an', '陕西', 'Shaanxi', '中国', 'China');
insert into tab_secm_city_info values('288', '汉中市', 'Hanzhong', '陕西', 'Shaanxi', '中国', 'China');
insert into tab_secm_city_info values('289', '榆林市', 'Yulin', '陕西', 'Shaanxi', '中国', 'China');
insert into tab_secm_city_info values('290', '安康市', 'Ankang', '陕西', 'Shaanxi', '中国', 'China');
insert into tab_secm_city_info values('291', '商洛市', 'Shangluo', '陕西', 'Shaanxi', '中国', 'China');
insert into tab_secm_city_info values('292', '宝鸡市', 'Baoji', '陕西', 'Shaanxi', '中国', 'China');
insert into tab_secm_city_info values('293', '成都市', 'Chengdu', '四川', 'Sichuan', '中国', 'China');
insert into tab_secm_city_info values('294', '自贡市', 'Zigong', '四川', 'Sichuan', '中国', 'China');
insert into tab_secm_city_info values('295', '攀枝花市', 'Panzhihua', '四川', 'Sichuan', '中国', 'China');
insert into tab_secm_city_info values('296', '泸州市', 'Luozhou', '四川', 'Sichuan', '中国', 'China');
insert into tab_secm_city_info values('297', '德阳市', 'Deyang', '四川', 'Sichuan', '中国', 'China');
insert into tab_secm_city_info values('298', '绵阳市', 'Mianyang', '四川', 'Sichuan', '中国', 'China');
insert into tab_secm_city_info values('299', '广元市', 'Guangyuan', '四川', 'Sichuan', '中国', 'China');
insert into tab_secm_city_info values('300', '遂宁市', 'Suining', '四川', 'Sichuan', '中国', 'China');
insert into tab_secm_city_info values('301', '内江市', 'Neijiang', '四川', 'Sichuan', '中国', 'China');
insert into tab_secm_city_info values('302', '乐山市', 'Leshan', '四川', 'Sichuan', '中国', 'China');
insert into tab_secm_city_info values('303', '南充市', 'Nanchong', '四川', 'Sichuan', '中国', 'China');
insert into tab_secm_city_info values('304', '眉山市', 'Meishan', '四川', 'Sichuan', '中国', 'China');
insert into tab_secm_city_info values('305', '宜宾市', 'Yibin', '四川', 'Sichuan', '中国', 'China');
insert into tab_secm_city_info values('306', '广安市', 'Guang''an', '四川', 'Sichuan', '中国', 'China');
insert into tab_secm_city_info values('307', '达州市', 'Dazhou', '四川', 'Sichuan', '中国', 'China');
insert into tab_secm_city_info values('308', '雅安市', 'Ya''an', '四川', 'Sichuan', '中国', 'China');
insert into tab_secm_city_info values('309', '巴中市', 'Bazhong', '四川', 'Sichuan', '中国', 'China');
insert into tab_secm_city_info values('310', '资阳市', 'Ziyang', '四川', 'Sichuan', '中国', 'China');
insert into tab_secm_city_info values('311', '阿坝藏族羌族自治州', 'Tibetan Qiang Autonomous Prefecture of Ngawa', '四川', 'Sichuan', '中国', 'China');
insert into tab_secm_city_info values('312', '甘孜藏族自治州', 'Tibetan Autonomous Prefecture of Garz�', '四川', 'Sichuan', '中国', 'China');
insert into tab_secm_city_info values('313', '凉山彝族自治州', 'Liangshan Yi Autonomous Prefecture', '四川', 'Sichuan', '中国', 'China');
insert into tab_secm_city_info values('314', '乌鲁木齐市', 'Wulumuqi', '新疆', 'Xinjiang', '中国', 'China');
insert into tab_secm_city_info values('315', '克拉玛依市', 'Kelamayi', '新疆', 'Xinjiang', '中国', 'China');
insert into tab_secm_city_info values('316', '吐鲁番市', 'Tulufan', '新疆', 'Xinjiang', '中国', 'China');
insert into tab_secm_city_info values('317', '昌吉回族自治州', 'Changji Hui Autonomous Prefecture', '新疆', 'Xinjiang', '中国', 'China');
insert into tab_secm_city_info values('318', '博尔塔拉蒙古自治州', 'Bortala Mongol Autonomous Prefecture', '新疆', 'Xinjiang', '中国', 'China');
insert into tab_secm_city_info values('319', '巴音郭楞蒙古自治州', 'Bayingol Mongolian Autonomous Prefecture', '新疆', 'Xinjiang', '中国', 'China');
insert into tab_secm_city_info values('320', '阿克苏地区', 'Aksu Prefecture', '新疆', 'Xinjiang', '中国', 'China');
insert into tab_secm_city_info values('321', '克孜勒苏柯尔克孜', 'Kizilsu Kirghiz Autonomous Prefecture', '新疆', 'Xinjiang', '中国', 'China');
insert into tab_secm_city_info values('322', '喀什地区', 'Kashgar Prefecture', '新疆', 'Xinjiang', '中国', 'China');
insert into tab_secm_city_info values('323', '和田地区', 'Hotan Prefecture', '新疆', 'Xinjiang', '中国', 'China');
insert into tab_secm_city_info values('324', '伊犁哈萨克自治州', 'Ili Kazak Autonomous Prefecture', '新疆', 'Xinjiang', '中国', 'China');
insert into tab_secm_city_info values('325', '塔城地区', 'Tarbagatay Prefecture', '新疆', 'Xinjiang', '中国', 'China');
insert into tab_secm_city_info values('326', '阿勒泰地区', 'Altay Prefecture', '新疆', 'Xinjiang', '中国', 'China');
insert into tab_secm_city_info values('327', '石河子市', 'Shihezi', '新疆', 'Xinjiang', '中国', 'China');
insert into tab_secm_city_info values('328', '阿拉尔市', 'Alaer', '新疆', 'Xinjiang', '中国', 'China');
insert into tab_secm_city_info values('329', '图木舒克市', 'Tumushuke', '新疆', 'Xinjiang', '中国', 'China');
insert into tab_secm_city_info values('330', '五家渠市', 'Wujiaqu', '新疆', 'Xinjiang', '中国', 'China');
insert into tab_secm_city_info values('331', '北屯市', 'Beitun', '新疆', 'Xinjiang', '中国', 'China');
insert into tab_secm_city_info values('332', '铁门关市', 'Tiemenguan', '新疆', 'Xinjiang', '中国', 'China');
insert into tab_secm_city_info values('333', '双河市', 'Shuanghe', '新疆', 'Xinjiang', '中国', 'China');
insert into tab_secm_city_info values('334', '可克达拉市', 'Kekedala', '新疆', 'Xinjiang', '中国', 'China');
insert into tab_secm_city_info values('335', '拉萨市', 'Lasa', '西藏', 'Xizang', '中国', 'China');
insert into tab_secm_city_info values('336', '日喀则市', 'Rikaze', '西藏', 'Xizang', '中国', 'China');
insert into tab_secm_city_info values('337', '昌都市', 'Changdu', '西藏', 'Xizang', '中国', 'China');
insert into tab_secm_city_info values('338', '山南市', 'Shannan', '西藏', 'Xizang', '中国', 'China');
insert into tab_secm_city_info values('339', '那曲地区', 'Naqu Prefecture', '西藏', 'Xizang', '中国', 'China');
insert into tab_secm_city_info values('340', '阿里地区', 'Ngari Prefecture', '西藏', 'Xizang', '中国', 'China');
insert into tab_secm_city_info values('341', '林芝市', 'Linzhi', '西藏', 'Xizang', '中国', 'China');
insert into tab_secm_city_info values('342', '昆明市', 'Kunming', '云南', 'Yunnan', '中国', 'China');
insert into tab_secm_city_info values('343', '曲靖市', 'Qunjing', '云南', 'Yunnan', '中国', 'China');
insert into tab_secm_city_info values('344', '玉溪市', 'Yuxi', '云南', 'Yunnan', '中国', 'China');
insert into tab_secm_city_info values('345', '保山市', 'Baoshan', '云南', 'Yunnan', '中国', 'China');
insert into tab_secm_city_info values('346', '昭通市', 'Zhaotong', '云南', 'Yunnan', '中国', 'China');
insert into tab_secm_city_info values('347', '丽江市', 'Lijiang', '云南', 'Yunnan', '中国', 'China');
insert into tab_secm_city_info values('348', '普洱市', 'Puer', '云南', 'Yunnan', '中国', 'China');
insert into tab_secm_city_info values('349', '临沧市', 'Lincang', '云南', 'Yunnan', '中国', 'China');
insert into tab_secm_city_info values('350', '楚雄彝族自治州', 'Chuxiong', '云南', 'Yunnan', '中国', 'China');
insert into tab_secm_city_info values('351', '红河哈尼族彝族自治州', 'Hani-Yi Autonomous Prefecture of Honghe', '云南', 'Yunnan', '中国', 'China');
insert into tab_secm_city_info values('352', '文山壮族苗族自治州', 'Wenshan Zhuang and Miao Autonomous Prefecture', '云南', 'Yunnan', '中国', 'China');
insert into tab_secm_city_info values('353', '西双版纳傣族自治州', 'Dai Autonomous Prefecture of Xishuangbanna', '云南', 'Yunnan', '中国', 'China');
insert into tab_secm_city_info values('354', '大理白族自治州', 'Dali Bai Autonomous Prefecture', '云南', 'Yunnan', '中国', 'China');
insert into tab_secm_city_info values('355', '德宏傣族景颇族自治州', 'Dehong  Autonomous Prefecture', '云南', 'Yunnan', '中国', 'China');
insert into tab_secm_city_info values('356', '怒江傈僳族自治州', 'Nujiang of the Lisu Autonomous Prefecture', '云南', 'Yunnan', '中国', 'China');
insert into tab_secm_city_info values('357', '迪庆藏族自治州', 'Diqing Tibetan Autonomous Prefecture', '云南', 'Yunnan', '中国', 'China');
insert into tab_secm_city_info values('358', '杭州市', 'Hangzhou', '浙江', 'Zhejiang', '中国', 'China');
insert into tab_secm_city_info values('359', '宁波市', 'Ningbo', '浙江', 'Zhejiang', '中国', 'China');
insert into tab_secm_city_info values('360', '温州市', 'Wenzhou', '浙江', 'Zhejiang', '中国', 'China');
insert into tab_secm_city_info values('361', '嘉兴市', 'Jiaxing', '浙江', 'Zhejiang', '中国', 'China');
insert into tab_secm_city_info values('362', '湖州市', 'Huzhou', '浙江', 'Zhejiang', '中国', 'China');
insert into tab_secm_city_info values('363', '绍兴市', 'Shaoxing', '浙江', 'Zhejiang', '中国', 'China');
insert into tab_secm_city_info values('364', '金华市', 'Jinhua', '浙江', 'Zhejiang', '中国', 'China');
insert into tab_secm_city_info values('365', '衢州市', 'Quzhou', '浙江', 'Zhejiang', '中国', 'China');
insert into tab_secm_city_info values('366', '舟山市', 'Zhoushan', '浙江', 'Zhejiang', '中国', 'China');
insert into tab_secm_city_info values('367', '台州市', 'Taizhou', '浙江', 'Zhejiang', '中国', 'China');
insert into tab_secm_city_info values('368', '丽水市', 'Lishui', '浙江', 'Zhejiang', '中国', 'China');
insert into tab_secm_city_info values('369', '', '', '', '', '安道尔', 'Andorra');
insert into tab_secm_city_info values('370', '', '', '', '', '阿联酋', 'UnitedArabEmirate');
insert into tab_secm_city_info values('371', '', '', '', '', '阿富汗', 'Afghanistan');
insert into tab_secm_city_info values('372', '', '', '', '', '安提瓜和巴布达', 'AntiguaandBarbuda');
insert into tab_secm_city_info values('373', '', '', '', '', '阿尔巴尼亚', 'Albania');
insert into tab_secm_city_info values('374', '', '', '', '', '亚美尼亚', 'Armenia');
insert into tab_secm_city_info values('375', '', '', '', '', '荷属安的列斯群岛', 'NetherlandsAntille');
insert into tab_secm_city_info values('376', '', '', '', '', '安哥拉', 'Angola');
insert into tab_secm_city_info values('377', '', '', '', '', '安圭拉岛', 'Anguilla');
insert into tab_secm_city_info values('378', '', '', '', '', '阿根廷', 'Argentina');
insert into tab_secm_city_info values('379', '', '', '', '', '美属萨摩亚', 'AmericanSamoa');
insert into tab_secm_city_info values('380', '', '', '', '', '奥地利', 'Austria');
insert into tab_secm_city_info values('381', '', '', '', '', '澳大利亚', 'Australia');
insert into tab_secm_city_info values('382', '', '', '', '', '阿鲁巴', 'Aruba');
insert into tab_secm_city_info values('383', '', '', '', '', '奥兰群岛', 'AlandIslands');
insert into tab_secm_city_info values('384', '', '', '', '', '阿塞拜疆', 'Azerbaijan');
insert into tab_secm_city_info values('385', '', '', '', '', '波斯尼亚和黑塞哥维那', 'BosniaandHerz');
insert into tab_secm_city_info values('386', '', '', '', '', '巴巴多斯', 'Barbados');
insert into tab_secm_city_info values('387', '', '', '', '', '孟加拉国', 'Bangladesh');
insert into tab_secm_city_info values('388', '', '', '', '', '比利时', 'Belgium');
insert into tab_secm_city_info values('389', '', '', '', '', '布基纳法索', 'BurkinaFaso');
insert into tab_secm_city_info values('390', '', '', '', '', '保加利亚', 'Bulgaria');
insert into tab_secm_city_info values('391', '', '', '', '', '巴林', 'Bahrain');
insert into tab_secm_city_info values('392', '', '', '', '', '布隆迪', 'Burundi');
insert into tab_secm_city_info values('393', '', '', '', '', '贝宁', 'Benin');
insert into tab_secm_city_info values('394', '', '', '', '', '百慕大群岛', 'BermudaIsands');
insert into tab_secm_city_info values('395', '', '', '', '', '文莱', 'BruneiDarussalam');
insert into tab_secm_city_info values('396', '', '', '', '', '玻利维亚', 'Bolivia');
insert into tab_secm_city_info values('397', '', '', '', '', '巴西', 'Brazil');
insert into tab_secm_city_info values('398', '', '', '', '', '巴哈马', 'Bahamas');
insert into tab_secm_city_info values('399', '', '', '', '', '不丹', 'Bhutan');
insert into tab_secm_city_info values('400', '', '', '', '', '布韦岛', 'BouvetIsland');
insert into tab_secm_city_info values('401', '', '', '', '', '博茨瓦纳', 'Botswana');
insert into tab_secm_city_info values('402', '', '', '', '', '伯利兹', 'Belize');
insert into tab_secm_city_info values('403', '', '', '', '', '加拿大', 'Canada');
insert into tab_secm_city_info values('404', '', '', '', '', '中非共和国', 'CentralAfricanRepublic');
insert into tab_secm_city_info values('405', '', '', '', '', '瑞士', 'Switzerland');
insert into tab_secm_city_info values('406', '', '', '', '', '库克群岛', 'CookIslands');
insert into tab_secm_city_info values('407', '', '', '', '', '智利', 'Chile');
insert into tab_secm_city_info values('408', '', '', '', '', '喀麦隆', 'Cameroon');
insert into tab_secm_city_info values('409', '', '', '', '', '哥伦比亚', 'Colombia');
insert into tab_secm_city_info values('410', '', '', '', '', '哥斯达黎加', 'CostaRica');
insert into tab_secm_city_info values('411', '', '', '', '', '佛得角', 'CapeVerde');
insert into tab_secm_city_info values('412', '', '', '', '', '塞浦路斯', 'Cyprus');
insert into tab_secm_city_info values('413', '', '', '', '', '捷克', 'CzechRepublic');
insert into tab_secm_city_info values('414', '', '', '', '', '德国', 'Germany');
insert into tab_secm_city_info values('415', '', '', '', '', '吉布提', 'Djibouti');
insert into tab_secm_city_info values('416', '', '', '', '', '丹麦', 'Denmark');
insert into tab_secm_city_info values('417', '', '', '', '', '多米尼克', 'Dominica');
insert into tab_secm_city_info values('418', '', '', '', '', '多米尼加共和国', 'DominicanRepublic');
insert into tab_secm_city_info values('419', '', '', '', '', '阿尔及利亚', 'Algeria');
insert into tab_secm_city_info values('420', '', '', '', '', '厄瓜多尔', 'Ecuador');
insert into tab_secm_city_info values('421', '', '', '', '', '爱沙尼亚', 'Estonia');
insert into tab_secm_city_info values('422', '', '', '', '', '埃及', 'Egypt');
insert into tab_secm_city_info values('423', '', '', '', '', '西撒哈拉', 'WesternSahara');
insert into tab_secm_city_info values('424', '', '', '', '', '厄立特里亚', 'Eritrea');
insert into tab_secm_city_info values('425', '', '', '', '', '西班牙', 'Spain');
insert into tab_secm_city_info values('426', '', '', '', '', '埃塞俄比亚', 'Ethiopia');
insert into tab_secm_city_info values('427', '', '', '', '', '芬兰', 'Finland');
insert into tab_secm_city_info values('428', '', '', '', '', '斐济群岛', 'Fiji');
insert into tab_secm_city_info values('429', '', '', '', '', '福克兰群岛(马尔维纳斯群岛)', 'Falkland');
insert into tab_secm_city_info values('430', '', '', '', '', '密克罗尼西亚', 'FederatedStatesofMicronesia');
insert into tab_secm_city_info values('431', '', '', '', '', '法罗群岛', 'FaroeIslands');
insert into tab_secm_city_info values('432', '', '', '', '', '法国', 'France');
insert into tab_secm_city_info values('433', '', '', '', '', '加蓬', 'Gabon');
insert into tab_secm_city_info values('434', '', '', '', '', '英国', 'UnitedKingdom');
insert into tab_secm_city_info values('435', '', '', '', '', '格林纳达', 'Grenada');
insert into tab_secm_city_info values('436', '', '', '', '', '格鲁吉亚', 'Georgia');
insert into tab_secm_city_info values('437', '', '', '', '', '法属圭亚那', 'FrenchGuiana');
insert into tab_secm_city_info values('438', '', '', '', '', '根西岛', 'Guernsey');
insert into tab_secm_city_info values('439', '', '', '', '', '加纳', 'Ghana');
insert into tab_secm_city_info values('440', '', '', '', '', '直布罗陀', 'Gibraltar');
insert into tab_secm_city_info values('441', '', '', '', '', '格陵兰', 'Greenland');
insert into tab_secm_city_info values('442', '', '', '', '', '冈比亚', 'Gambia');
insert into tab_secm_city_info values('443', '', '', '', '', '几内亚', 'Guinea');
insert into tab_secm_city_info values('444', '', '', '', '', '瓜德罗普岛', 'Guadeloupe');
insert into tab_secm_city_info values('445', '', '', '', '', '赤道几内亚', 'EquatorialGuinea');
insert into tab_secm_city_info values('446', '', '', '', '', '希腊', 'Greece');
insert into tab_secm_city_info values('447', '', '', '', '', '南乔治亚和南桑德威奇群岛', 'SouthGeorgiaandtheSouthSandwichIslands');
insert into tab_secm_city_info values('448', '', '', '', '', '危地马拉', 'Guatemala');
insert into tab_secm_city_info values('449', '', '', '', '', '关岛', 'Guam');
insert into tab_secm_city_info values('450', '', '', '', '', '几内亚比绍', 'BissauGuinea');
insert into tab_secm_city_info values('451', '', '', '', '', '圭亚那', 'Guyana');
insert into tab_secm_city_info values('452', '', '', '', '', '赫德和麦克唐纳群岛', 'HeardIslandandMcDonaldIslands');
insert into tab_secm_city_info values('453', '', '', '', '', '洪都拉斯', 'Honduras');
insert into tab_secm_city_info values('454', '', '', '', '', '克罗地亚', 'Croatia');
insert into tab_secm_city_info values('455', '', '', '', '', '海地', 'Haiti');
insert into tab_secm_city_info values('456', '', '', '', '', '匈牙利', 'Hungary');
insert into tab_secm_city_info values('457', '', '', '', '', '印度尼西亚', 'Indonesia');
insert into tab_secm_city_info values('458', '', '', '', '', '爱尔兰', 'Ireland');
insert into tab_secm_city_info values('459', '', '', '', '', '以色列', 'Israel');
insert into tab_secm_city_info values('460', '', '', '', '', '马恩岛', 'IsleofMan');
insert into tab_secm_city_info values('461', '', '', '', '', '印度', 'India');
insert into tab_secm_city_info values('462', '', '', '', '', '不列颠印度洋属土', 'BritishIndianOceanTerritory');
insert into tab_secm_city_info values('463', '', '', '', '', '冰岛', 'Iceland');
insert into tab_secm_city_info values('464', '', '', '', '', '意大利', 'Italy');
insert into tab_secm_city_info values('465', '', '', '', '', '泽西', 'Jersey');
insert into tab_secm_city_info values('466', '', '', '', '', '牙买加', 'Jamaica');
insert into tab_secm_city_info values('467', '', '', '', '', '约旦', 'Jordan');
insert into tab_secm_city_info values('468', '', '', '', '', '日本', 'Japan');
insert into tab_secm_city_info values('469', '', '', '', '', '肯尼亚', 'Kenya');
insert into tab_secm_city_info values('470', '', '', '', '', '吉尔吉斯斯坦', 'Kyrgyzstan');
insert into tab_secm_city_info values('471', '', '', '', '', '柬埔寨', 'Cambodia');
insert into tab_secm_city_info values('472', '', '', '', '', '基里巴斯', 'Kiribati');
insert into tab_secm_city_info values('473', '', '', '', '', '科摩罗', 'Comoros');
insert into tab_secm_city_info values('474', '', '', '', '', '圣基茨和尼维斯', 'SaintKittsandNevis');
insert into tab_secm_city_info values('475', '', '', '', '', '韩国', 'RepublicofKorea');
insert into tab_secm_city_info values('476', '', '', '', '', '科威特', 'Kuwait');
insert into tab_secm_city_info values('477', '', '', '', '', '开曼群岛', 'CaymanIslands');
insert into tab_secm_city_info values('478', '', '', '', '', '哈萨克斯坦', 'Kazakhstan');
insert into tab_secm_city_info values('479', '', '', '', '', '老挝', 'LaoPeople''sDemocraticRepublic');
insert into tab_secm_city_info values('480', '', '', '', '', '圣卢西亚', 'SaintLucia');
insert into tab_secm_city_info values('481', '', '', '', '', '法属圣马丁', 'SaintMartin');
insert into tab_secm_city_info values('482', '', '', '', '', '列支敦士登', 'Liechtenstein');
insert into tab_secm_city_info values('483', '', '', '', '', '斯里兰卡', 'SriLanka');
insert into tab_secm_city_info values('484', '', '', '', '', '利比里亚', 'Liberia');
insert into tab_secm_city_info values('485', '', '', '', '', '莱索托', 'Lesotho');
insert into tab_secm_city_info values('486', '', '', '', '', '立陶宛', 'Lithuania');
insert into tab_secm_city_info values('487', '', '', '', '', '卢森堡', 'Luxembourg');
insert into tab_secm_city_info values('488', '', '', '', '', '拉脱维亚', 'Latvia');
insert into tab_secm_city_info values('489', '', '', '', '', '摩洛哥', 'Morocco');
insert into tab_secm_city_info values('490', '', '', '', '', '摩纳哥', 'Monaco');
insert into tab_secm_city_info values('491', '', '', '', '', '摩尔多瓦', 'RepublicofMoldova');
insert into tab_secm_city_info values('492', '', '', '', '', '黑山', 'Montenegro');
insert into tab_secm_city_info values('493', '', '', '', '', '马达加斯加', 'Madagascar');
insert into tab_secm_city_info values('494', '', '', '', '', '马绍尔群岛', 'MarshallIslands');
insert into tab_secm_city_info values('495', '', '', '', '', '马其顿', 'TheFormerYugoslavRepublicofMacedonia');
insert into tab_secm_city_info values('496', '', '', '', '', '马里', 'Mali');
insert into tab_secm_city_info values('497', '', '', '', '', '蒙古', 'Mongolia');
insert into tab_secm_city_info values('498', '', '', '', '', '北马里亚纳群岛', 'NorthernMarianaIslands');
insert into tab_secm_city_info values('499', '', '', '', '', '马提尼克岛', 'Martinique');
insert into tab_secm_city_info values('500', '', '', '', '', '毛里塔尼亚', 'Mauritania');
insert into tab_secm_city_info values('501', '', '', '', '', '蒙特塞拉特岛', 'Montserrat');
insert into tab_secm_city_info values('502', '', '', '', '', '马耳他', 'Malta');
insert into tab_secm_city_info values('503', '', '', '', '', '毛里求斯', 'Mauritius');
insert into tab_secm_city_info values('504', '', '', '', '', '马尔代夫', 'Maldives');
insert into tab_secm_city_info values('505', '', '', '', '', '马拉维', 'Malawi');
insert into tab_secm_city_info values('506', '', '', '', '', '墨西哥', 'Mexico');
insert into tab_secm_city_info values('507', '', '', '', '', '马来西亚', 'Malaysia');
insert into tab_secm_city_info values('508', '', '', '', '', '莫桑比克', 'Mozambique');
insert into tab_secm_city_info values('509', '', '', '', '', '纳米比亚', 'Namibia');
insert into tab_secm_city_info values('510', '', '', '', '', '新喀里多尼亚', 'NewCaledonia');
insert into tab_secm_city_info values('511', '', '', '', '', '尼日尔', 'Niger');
insert into tab_secm_city_info values('512', '', '', '', '', '诺福克岛', 'NorfolkIsland');
insert into tab_secm_city_info values('513', '', '', '', '', '尼日利亚', 'Nigeria');
insert into tab_secm_city_info values('514', '', '', '', '', '尼加拉瓜', 'Nicaragua');
insert into tab_secm_city_info values('515', '', '', '', '', '荷兰', 'Netherlands');
insert into tab_secm_city_info values('516', '', '', '', '', '挪威', 'Norway');
insert into tab_secm_city_info values('517', '', '', '', '', '尼泊尔', 'Nepal');
insert into tab_secm_city_info values('518', '', '', '', '', '瑙鲁', 'Nauru');
insert into tab_secm_city_info values('519', '', '', '', '', '纽埃', 'Niue');
insert into tab_secm_city_info values('520', '', '', '', '', '新西兰', 'NewZealand');
insert into tab_secm_city_info values('521', '', '', '', '', '阿曼', 'Oman');
insert into tab_secm_city_info values('522', '', '', '', '', '巴拿马', 'Panama');
insert into tab_secm_city_info values('523', '', '', '', '', '秘鲁', 'Peru');
insert into tab_secm_city_info values('524', '', '', '', '', '法属波利尼西亚', 'FrenchPolynesia');
insert into tab_secm_city_info values('525', '', '', '', '', '巴布亚新几内亚', 'PapuaNewGuinea');
insert into tab_secm_city_info values('526', '', '', '', '', '菲律宾', 'Philippines');
insert into tab_secm_city_info values('527', '', '', '', '', '巴基斯坦', 'Pakistan');
insert into tab_secm_city_info values('528', '', '', '', '', '波兰', 'Poland');
insert into tab_secm_city_info values('529', '', '', '', '', '圣皮埃尔岛和密克隆岛', 'PierreandMiquelonSaint');
insert into tab_secm_city_info values('530', '', '', '', '', '波多黎各', 'PuertoRico');
insert into tab_secm_city_info values('531', '', '', '', '', '巴勒斯坦', 'OccupiedPalestinianTerritory');
insert into tab_secm_city_info values('532', '', '', '', '', '葡萄牙', 'Portugal');
insert into tab_secm_city_info values('533', '', '', '', '', '帕劳群岛', 'Palau');
insert into tab_secm_city_info values('534', '', '', '', '', '巴拉圭', 'Paraguay');
insert into tab_secm_city_info values('535', '', '', '', '', '卡塔尔', 'Qatar');
insert into tab_secm_city_info values('536', '', '', '', '', '留尼汪岛', 'Reunion');
insert into tab_secm_city_info values('537', '', '', '', '', '罗马尼亚', 'Romania');
insert into tab_secm_city_info values('538', '', '', '', '', '塞尔维亚', 'Serbia');
insert into tab_secm_city_info values('539', '', '', '', '', '俄罗斯', 'RussianFederation');
insert into tab_secm_city_info values('540', '', '', '', '', '卢旺达', 'Rwanda');
insert into tab_secm_city_info values('541', '', '', '', '', '沙特阿拉伯', 'SaudiArabia');
insert into tab_secm_city_info values('542', '', '', '', '', '所罗门群岛', 'SolomonIslands');
insert into tab_secm_city_info values('543', '', '', '', '', '塞舌尔', 'Seychelles');
insert into tab_secm_city_info values('544', '', '', '', '', '瑞典', 'Sweden');
insert into tab_secm_city_info values('545', '', '', '', '', '新加坡', 'Singapore');
insert into tab_secm_city_info values('546', '', '', '', '', '斯洛文尼亚', 'Slovenia');
insert into tab_secm_city_info values('547', '', '', '', '', '斯瓦尔巴群岛和扬马延', 'SvalbardandJanMayen');
insert into tab_secm_city_info values('548', '', '', '', '', '斯洛伐克', 'Slovakia');
insert into tab_secm_city_info values('549', '', '', '', '', '塞拉利昂', 'SierraLeone');
insert into tab_secm_city_info values('550', '', '', '', '', '圣马力诺', 'SanMarino');
insert into tab_secm_city_info values('551', '', '', '', '', '塞内加尔', 'Senegal');
insert into tab_secm_city_info values('552', '', '', '', '', '苏里南', 'Suriname');
insert into tab_secm_city_info values('553', '', '', '', '', '圣多美和普林西比', 'SaoTomeandPrincipe');
insert into tab_secm_city_info values('554', '', '', '', '', '萨尔瓦多', 'ElSalvador');
insert into tab_secm_city_info values('555', '', '', '', '', '斯威士兰', 'Swaziland');
insert into tab_secm_city_info values('556', '', '', '', '', '特克斯和凯科斯群岛', 'TurksandCaicosIslands');
insert into tab_secm_city_info values('557', '', '', '', '', '乍得', 'Chad');
insert into tab_secm_city_info values('558', '', '', '', '', '多哥', 'Togo');
insert into tab_secm_city_info values('559', '', '', '', '', '泰国', 'Thailand');
insert into tab_secm_city_info values('560', '', '', '', '', '塔吉克斯坦', 'Tajikistan');
insert into tab_secm_city_info values('561', '', '', '', '', '托克劳', 'Tokelau');
insert into tab_secm_city_info values('562', '', '', '', '', '东帝汶', 'LesteTimor');
insert into tab_secm_city_info values('563', '', '', '', '', '土库曼斯坦', 'Turkmenistan');
insert into tab_secm_city_info values('564', '', '', '', '', '突尼斯', 'Tunisia');
insert into tab_secm_city_info values('565', '', '', '', '', '汤加', 'Tonga');
insert into tab_secm_city_info values('566', '', '', '', '', '土耳其', 'Turkey');
insert into tab_secm_city_info values('567', '', '', '', '', '特立尼达和多巴哥', 'TrinidadandTobago');
insert into tab_secm_city_info values('568', '', '', '', '', '图瓦卢', 'Tuvalu');
insert into tab_secm_city_info values('569', '', '', '', '', '坦桑尼亚', 'UnitedRepublicOfTanzania');
insert into tab_secm_city_info values('570', '', '', '', '', '乌克兰', 'Ukraine');
insert into tab_secm_city_info values('571', '', '', '', '', '乌干达', 'Uganda');
insert into tab_secm_city_info values('572', '', '', '', '', '美国', 'UnitedStates');
insert into tab_secm_city_info values('573', '', '', '', '', '乌拉圭', 'Uruguay');
insert into tab_secm_city_info values('574', '', '', '', '', '乌兹别克斯坦', 'Uzbekistan');
insert into tab_secm_city_info values('575', '', '', '', '', '梵蒂冈', 'HolySee(VaticanCityState)');
insert into tab_secm_city_info values('576', '', '', '', '', '圣文森特和格林纳丁斯', 'SaintVincentandtheGrenadines');
insert into tab_secm_city_info values('577', '', '', '', '', '委内瑞拉', 'Venezuela');
insert into tab_secm_city_info values('578', '', '', '', '', '英属维尔京群岛', 'BritishVirginIslands');
insert into tab_secm_city_info values('579', '', '', '', '', '美属维尔京群岛', 'U.S.VirginIslands');
insert into tab_secm_city_info values('580', '', '', '', '', '越南', 'VietNam');
insert into tab_secm_city_info values('581', '', '', '', '', '瓦努阿图', 'Vanuatu');
insert into tab_secm_city_info values('582', '', '', '', '', '瓦利斯和富图纳群岛', 'WallisandFutunaIslands');
insert into tab_secm_city_info values('583', '', '', '', '', '萨摩亚', 'Samoa');
insert into tab_secm_city_info values('584', '', '', '', '', '也门', 'Yemen');
insert into tab_secm_city_info values('585', '', '', '', '', '马约特岛', 'Mayotte');
insert into tab_secm_city_info values('586', '', '', '', '', '南非', 'SouthAfrica');
insert into tab_secm_city_info values('587', '', '', '', '', '赞比亚', 'Zambia');

select alter_columns('add','tab_secm_securecenter_device','city_id','CHARACTER VARYING(128)');

--19.4.0.B111_END

--19.4.0.B116_BEGIN
--接口速率新增表
DROP TABLE IF EXISTS TAB_SECM_DEVICE_NOT_MONITOR;
CREATE TABLE TAB_SECM_DEVICE_NOT_MONITOR (
    DEVICE_ID    CHARACTER VARYING(128)  primary key NOT NULL,
	TENANT_ID    CHARACTER VARYING(128)
);
ALTER TABLE TAB_SECM_DEVICE_NOT_MONITOR OWNER TO OSSDBUSER;

DROP TABLE IF EXISTS TAB_SECM_DEVICE_MONITOR_FREQUENCY;
CREATE TABLE TAB_SECM_DEVICE_MONITOR_FREQUENCY (
	FREQUENCY INTEGER
);
ALTER TABLE TAB_SECM_DEVICE_MONITOR_FREQUENCY OWNER TO OSSDBUSER;
insert into TAB_SECM_DEVICE_MONITOR_FREQUENCY (frequency) values(5);

--增加字段
select alter_columns('add','TAB_SECM_DEVICEMONITOR_INTERFACE_INFO','COLLECTION_STATUS','INTEGER default -1');
--19.4.0.B116_END

--19.2.0.001_BEGIN
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95h0','02352CBV','NIP6305E');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95h1','02352CBW','NIP6310E');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95h2','02352CBX','NIP6510E');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95h3','02352DAS','NIP6550E');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95h4','02352CPV','NIP6610E');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95h5','02352CPW','NIP6610ED');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95h6','02352CPP','NIP6620E');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95h7','02352CPQ','NIP6620ED');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95h8','02352ETN','NIP6550ED-AC');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95h9','02352EVT','NIP6620E-DC');
--19.2.0.001_END

--19.2.0.022_BEGIN
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95i0','02350CVY','NIP6610');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95i1','02350CWA','NIP6320');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95i2','02350CWB','NIP6320D');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95i3','02350CWC','NIP6330');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95i4','02350CWT','NIP6330D');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95i5','02350CWU','NIP6620');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95i6','02350CWV','NIP6620D');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95i8','02350CWF','NIP6650D-AC');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95i9','02350CWH','NIP6680-AC');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95k0','02351CNV','NIP6830');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95k1','02350CWD','NIP6650-DC');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95k3','02350CWJ','NIP6680-DC');
--19.2.0.022_END


--19.2.0.066_BEGIN

-- 去A 款型
delete from tab_secm_esn_device_spart where id in ('59c0ca5c-d6bb-4159-88cd-b2a8393a95f4','59c0ca5c-d6bb-4159-88cd-b2a8393a95f5','59c0ca5c-d6bb-4159-88cd-b2a8393a95f6','59c0ca5c-d6bb-4159-88cd-b2a8393a95f7','59c0ca5c-d6bb-4159-88cd-b2a8393a95f8',
'59c0ca5c-d6bb-4159-88cd-b2a8393a95f9','59c0ca5c-d6bb-4159-88cd-b2a8393a95fa','59c0ca5c-d6bb-4159-88cd-b2a8393a95fb','59c0ca5c-d6bb-4159-88cd-b2a8393a95fc','59c0ca5c-d6bb-4159-88cd-b2a8393a95fd',
'59c0ca5c-d6bb-4159-88cd-b2a8393a95fe','59c0ca5c-d6bb-4159-88cd-b2a8393a95ff','59c0ca5c-d6bb-4159-88cd-b2a8393a95g0','59c0ca5c-d6bb-4159-88cd-b2a8393a95g1','59c0ca5c-d6bb-4159-88cd-b2a8393a95g2',
'59c0ca5c-d6bb-4159-88cd-b2a8393a95g3','59c0ca5c-d6bb-4159-88cd-b2a8393a95g4','59c0ca5c-d6bb-4159-88cd-b2a8393a95g5','59c0ca5c-d6bb-4159-88cd-b2a8393a95g6','59c0ca5c-d6bb-4159-88cd-b2a8393a95g7',
'59c0ca5c-d6bb-4159-88cd-b2a8393a95g8','59c0ca5c-d6bb-4159-88cd-b2a8393a95g9','59c0ca5c-d6bb-4159-88cd-b2a8393a95ga','59c0ca5c-d6bb-4159-88cd-b2a8393a95gb','59c0ca5c-d6bb-4159-88cd-b2a8393a95gc',
'59c0ca5c-d6bb-4159-88cd-b2a8393a95gd','59c0ca5c-d6bb-4159-88cd-b2a8393a95ge','59c0ca5c-d6bb-4159-88cd-b2a8393a95gf');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95f4','02352QVB','USG6307E');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95f5','02352QUV','USG6311E');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95f6','02352QVC','USG6331E');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95f7','02352PQH','USG6510E');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95f8','02352QVD','USG6530E');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95f9','02353AEP','USG6305E');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95fa','02353AFN','USG6309E');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95fb','02353AFP','USG6315E');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95fc','02353AFQ','USG6325E');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95fd','02353AFR','USG6335E');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95fe','02353AFS','USG6355E');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95ff','02353AFV','USG6365E');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95g0','02353AFW','USG6385E');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95g1','02352RQM','USG6395E');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95g2','02353AFX','USG6525E');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95g3','02353AEK','USG6555E');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95g4','02353AEJ','USG6565E');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95g5','02353ADA','USG6585E');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95g6','02352RQL','USG6615E');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95g7','02352RQN','USG6625E');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95g8','02352RQD','USG6635E');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95g9','02352RPS','USG6655E');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95ga','02353AGF','Eudemon200E-G85');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95gb','02353AGL','Eudemon1000E-G15');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95gc','02353AGM','Eudemon1000E-G15');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95gd','02353BED','Eudemon1000E-G25');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95ge','02353BEF','Eudemon1000E-G35');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95gf','02353BEG','Eudemon1000E-G55');
--19.2.0.066_END









--19.3.0.013_BEGIN

delete from tab_secm_esn_device_spart where id in ('59c0ca5c-d6bb-4159-88cd-b2a8393a95k4','59c0ca5c-d6bb-4159-88cd-b2a8393a95k5','59c0ca5c-d6bb-4159-88cd-b2a8393a95k6','59c0ca5c-d6bb-4159-88cd-b2a8393a95k7','59c0ca5c-d6bb-4159-88cd-b2a8393a95k8','59c0ca5c-d6bb-4159-88cd-b2a8393a95k9',
'59c0ca5c-d6bb-4159-88cd-b2a8393a95ka','59c0ca5c-d6bb-4159-88cd-b2a8393a95kb','59c0ca5c-d6bb-4159-88cd-b2a8393a95kc','59c0ca5c-d6bb-4159-88cd-b2a8393a95kd','59c0ca5c-d6bb-4159-88cd-b2a8393a95ke','59c0ca5c-d6bb-4159-88cd-b2a8393a95kf','59c0ca5c-d6bb-4159-88cd-b2a8393a95kg',
'59c0ca5c-d6bb-4159-88cd-b2a8393a95kh','59c0ca5c-d6bb-4159-88cd-b2a8393a95ki','59c0ca5c-d6bb-4159-88cd-b2a8393a95kj','59c0ca5c-d6bb-4159-88cd-b2a8393a95kk','59c0ca5c-d6bb-4159-88cd-b2a8393a95kl','59c0ca5c-d6bb-4159-88cd-b2a8393a95km','59c0ca5c-d6bb-4159-88cd-b2a8393a95kn',
'59c0ca5c-d6bb-4159-88cd-b2a8393a95ko','59c0ca5c-d6bb-4159-88cd-b2a8393a95kp','59c0ca5c-d6bb-4159-88cd-b2a8393a95kq','59c0ca5c-d6bb-4159-88cd-b2a8393a95kr','59c0ca5c-d6bb-4159-88cd-b2a8393a95ks','59c0ca5c-d6bb-4159-88cd-b2a8393a95kt','59c0ca5c-d6bb-4159-88cd-b2a8393a95ku',
'59c0ca5c-d6bb-4159-88cd-b2a8393a95kv','59c0ca5c-d6bb-4159-88cd-b2a8393a95kw','59c0ca5c-d6bb-4159-88cd-b2a8393a95kx','59c0ca5c-d6bb-4159-88cd-b2a8393a95ky','59c0ca5c-d6bb-4159-88cd-b2a8393a95kz','59c0ca5c-d6bb-4159-88cd-b2a8393a95l0','59c0ca5c-d6bb-4159-88cd-b2a8393a95l1',
'59c0ca5c-d6bb-4159-88cd-b2a8393a95l2','59c0ca5c-d6bb-4159-88cd-b2a8393a95l3','59c0ca5c-d6bb-4159-88cd-b2a8393a95l4','59c0ca5c-d6bb-4159-88cd-b2a8393a95l5','59c0ca5c-d6bb-4159-88cd-b2a8393a95l7','59c0ca5c-d6bb-4159-88cd-b2a8393a95l8','59c0ca5c-d6bb-4159-88cd-b2a8393a95l9',
'59c0ca5c-d6bb-4159-88cd-b2a8393a95la','59c0ca5c-d6bb-4159-88cd-b2a8393a95lb','59c0ca5c-d6bb-4159-88cd-b2a8393a95lc','59c0ca5c-d6bb-4159-88cd-b2a8393a95ld','59c0ca5c-d6bb-4159-88cd-b2a8393a95le','59c0ca5c-d6bb-4159-88cd-b2a8393a95lh','59c0ca5c-d6bb-4159-88cd-b2a8393a95li',
'59c0ca5c-d6bb-4159-88cd-b2a8393a95lj','59c0ca5c-d6bb-4159-88cd-b2a8393a95lk','59c0ca5c-d6bb-4159-88cd-b2a8393a95ll','59c0ca5c-d6bb-4159-88cd-b2a8393a95lm','59c0ca5c-d6bb-4159-88cd-b2a8393a95ln','59c0ca5c-d6bb-4159-88cd-b2a8393a95lo','59c0ca5c-d6bb-4159-88cd-b2a8393a95lp',
'59c0ca5c-d6bb-4159-88cd-b2a8393a95lq','59c0ca5c-d6bb-4159-88cd-b2a8393a95lr','59c0ca5c-d6bb-4159-88cd-b2a8393a95ls','59c0ca5c-d6bb-4159-88cd-b2a8393a95lt','59c0ca5c-d6bb-4159-88cd-b2a8393a95lu','59c0ca5c-d6bb-4159-88cd-b2a8393a95lv');

insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95k4','50050075','USG6510');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95k5','50050076','USG6510');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95k6','50050077','USG6310S');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95k7','50050078','USG6310S');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95k8','02351CSR','Eudemon200E-N3');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95k9','02351CSS','Eudemon200E-N3');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95ka','02351CST','Eudemon1000E-N5');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95kb','02351CSU','Eudemon1000E-N5');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95kc','02351CSV','Eudemon1000E-N7');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95kd','02351CSW','Eudemon1000E-N7');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95ke','02351KEQ','USG6330');

insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95kf','02353AGG','Eudemon200E-G85');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95kg','02353BEE','Eudemon1000E-G25');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95kh','02352RQE','USG6635E');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95ki','02353ADD','Eudemon1000E-G35');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95kj','02353BEH','Eudemon1000E-G55');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95kk','02351APD','NIP6860');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95kl','02351AQT','NIP6800-X8');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95km','02352CKU','USG6630E');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95kn','03056624','USG9500');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95ko','03056627','USG9500');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95kp','03056630','USG9500');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95kq','03056637','USG9500');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95kr','03056634','USG9500');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95ks','03056635','USG9500');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95kt','03056640','USG9500');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95ku','03056638','USG9500');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95kv','03058033','Eudemon8000E-X');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95kw','03058034','USG9500');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95kx','03058044','NIP6800');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95ky','03058048','NIP6800');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95kz','03056682','USG9500');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95l0','03056683','USG9500');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95l1','03056305','Eudemon8000E-X');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95l2','03056628','USG9500');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95l3','03056629','USG9500');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95l4','03056631','USG9500');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95l5','03056632','USG9500');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95l7','03056633','USG9500');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95l8','03056636','USG9500');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95l9','03056639','USG9500');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95la','03057872','USG9500');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95lb','03057873','USG9500');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95lc','03057874','NIP6800');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95ld','03057875','NIP6800');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95le','03057876','Eudemon8000E-X');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95lh','03058035','USG9500');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95li','03058036','Eudemon8000E-X8');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95lj','03058045','NIP6800');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95lk','03058047','NIP6800');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95ll','03058562','Eudemon8000E-X');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95lm','03058569','USG9500');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95ln','03056684','USG9500');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95lo','03056685','USG9500');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95lp','03056686','USG9500');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95lq','03056688','USG9500');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95lr','03056308','Eudemon8000E-X');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95ls','03056309','Eudemon8000E-X');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95lt','0305G0BJ','Eudemon8000E-X');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95lu','03056489','Eudemon8000E-X');
insert into tab_secm_esn_device_spart (id, spart, model) values('59c0ca5c-d6bb-4159-88cd-b2a8393a95lv','02351CNX','USG9520');

delete from tab_secm_esn_device_spart where model like 'USG61%';

--19.3.0.013_END


--19.3.0.025_BEGIN
delete from tab_secm_esn_device_spart where id in ('158846cf-0c9d-40e2-846d-5b823b08e7d3','158846cf-0c9d-40e2-846d-5b823b08e7d4','50e7f38f-bb0e-4798-8134-920d8179b94a','50e7f38f-bb0e-4798-8134-920d8179b94b','94be12e4-3a1a-4b55-b963-505c12245619','c04a1e28-a6a5-4ff4-9fb6-2debdb290067'
,'c04a1e28-a6a5-4ff4-9fb6-2debdb290068','76013b33-cc7a-4214-88bf-bb164fc7db63','3ab17402-9192-439c-abbd-c8e6a767d3e2','2cd693db-52f8-4324-a67e-0b80eaa22a3c');

insert into tab_secm_esn_device_spart (id, spart, model) values('158846cf-0c9d-40e2-846d-5b823b08e7d3','50050082','USG6101');
insert into tab_secm_esn_device_spart (id, spart, model) values('158846cf-0c9d-40e2-846d-5b823b08e7d4','50050084','USG6102');
insert into tab_secm_esn_device_spart (id, spart, model) values('50e7f38f-bb0e-4798-8134-920d8179b94a','02351KRN','USG6106');
insert into tab_secm_esn_device_spart (id, spart, model) values('50e7f38f-bb0e-4798-8134-920d8179b94b','02351KRP','USG6108');
insert into tab_secm_esn_device_spart (id, spart, model) values('94be12e4-3a1a-4b55-b963-505c12245619','02351KRQ','USG6110');
insert into tab_secm_esn_device_spart (id, spart, model) values('c04a1e28-a6a5-4ff4-9fb6-2debdb290067','02351KRR','USG6120');
insert into tab_secm_esn_device_spart (id, spart, model) values('c04a1e28-a6a5-4ff4-9fb6-2debdb290068','02351KRS','USG6130');
insert into tab_secm_esn_device_spart (id, spart, model) values('76013b33-cc7a-4214-88bf-bb164fc7db63','02351KRU','USG6150');
insert into tab_secm_esn_device_spart (id, spart, model) values('3ab17402-9192-439c-abbd-c8e6a767d3e2','02351KRV','USG6160');
insert into tab_secm_esn_device_spart (id, spart, model) values('2cd693db-52f8-4324-a67e-0b80eaa22a3c','02351KRW','USG6180');
--19.3.0.025_END

--19.3.0.032_BEGIN
delete from tab_secm_esn_device_spart where id in ('2cd693db-52f8-4324-a67e-0b80eaa22a3d','2cd693db-52f8-4324-a67e-0b80eaa22a3e');
insert into tab_secm_esn_device_spart (id, spart, model) values('2cd693db-52f8-4324-a67e-0b80eaa22a3d','50050087','USG6103');
insert into tab_secm_esn_device_spart (id, spart, model) values('2cd693db-52f8-4324-a67e-0b80eaa22a3e','02351KRK','USG6105');
--19.3.0.032_END

--19.2.0.021_BEGIN
select alter_columns('add', 'tab_secm_hrp_config','used_num','int default 0');
--19.2.0.021_END

--19.2.1.001_BEGIN
replace INTO tab_secm_sdb_version VALUES ('IPS', 2019091107);
--19.2.1.001_END

--19.2.0.001_BEGIN
delete from TAB_SECM_SSH_SERVER_IP where key = 'sftpPort' and tenantId = '00000000-0000-0000-0000-000000000000';
insert into TAB_SECM_SSH_SERVER_IP (id, key, value, tenantId, description) values('34c0ca5c-d6bb-4159-88cd-b2a8393a9500','sftpPort','-1','00000000-0000-0000-0000-000000000000','sftp port info');
--19.2.0.001_END


--19.2.0.057_BEGIN
select alter_columns('add', 'tab_secm_ssh','create_flag','boolean default false');
--19.2.0.057_END

--19.2.0.001_BEGIN
select alter_columns('add','tab_secm_securecenter_device','status_update_time','TIMESTAMP WITHOUT TIME ZONE');
select alter_columns('alter','tab_secm_device_contrast_result','ngfw_id','CHARACTER VARYING(512)');
select alter_columns('alter','tab_secm_device_contrast_result','deploy_id','CHARACTER VARYING(512)');
select alter_columns('add','tab_secm_securecenter_device','gis_latitude','CHARACTER VARYING(20)');
select alter_columns('add','tab_secm_securecenter_device','gis_longitude','CHARACTER VARYING(20)');
update tab_secm_securecenter_device set dev_type='FIREWALL' where (dev_type = '' or dev_type is null) and virtual = 0;
update tab_secm_securecenter_device set gis_latitude='0' where virtual = 0 and group_type != 'backup' and (gis_latitude is null or gis_latitude = '');
update tab_secm_securecenter_device set gis_longitude='0' where virtual = 0 and group_type != 'backup' and (gis_longitude is null or gis_longitude = '');
DROP INDEX IF EXISTS tab_secm_securecenter_device_idx10;
CREATE INDEX tab_secm_securecenter_device_idx10
ON tab_secm_securecenter_device
USING BTREE (group_id);
--19.2.0.001_END

--19.2.0.031_BEGIN
alter table tab_secm_device_contrast_result add column recover boolean default false;
--19.2.0.031_END

--19.2.0.055_BEGIN
select alter_columns('alter','tab_secm_accetp_change_task','ERROR_MSG','VARCHAR(10240)');
--19.2.0.055_END



--19.2.0.064_BEGIN
select alter_columns('add','tab_secm_securecenter_device','license_flag','boolean default false');
update tab_secm_securecenter_device set license_flag = true where device_type not in ('USG unknown', 'Unknown');
update tab_secm_securecenter_device set device_type = 'Unknown' where device_type = 'USG unknown';
--19.2.0.064_END


--19.3.0.022_BEGIN
drop table if exists tab_secm_button_switch;
CREATE TABLE tab_secm_button_switch
(
	pkid VARCHAR(128) primary key NOT NULL,
	adom_id varchar(128),
	status varchar(128),
	button_type varchar(128),
	create_time varchar(128),
	update_time varchar(128)
);
ALTER TABLE public.tab_secm_button_switch OWNER TO OSSDBUSER;
--19.3.0.022_END

--19.3.0.052_BEGIN
DROP TABLE IF EXISTS tab_secm_fingerprint_status;
CREATE TABLE tab_secm_fingerprint_status
(
    id VARCHAR(128) primary key NOT NULL,
    trust_first_learning_switch boolean,
    lock_first_learning_switch boolean,
    update_time TIMESTAMP
);
ALTER TABLE public.tab_secm_fingerprint_status OWNER TO OSSDBUSER;
--19.3.0.052_END

--19.4.0.111_BEGIN
select alter_columns('add','TAB_SECM_SECURECENTER_VSYS','ARRANGE_SHARE_PUBLIC_IP','CHARACTER VARYING(128)[]');

update TAB_SECM_SECURECENTER_VSYS set ARRANGE_SHARE_PUBLIC_IP = ASSIGN_SHARE_PUBLIC_IP where id in (
    select id from TAB_SECM_SECURECENTER_DEVICE where producter='ac_dcn');
--19.4.0.111_END

--19.3.0.B001_BEGIN
--系统模板
DROP TABLE IF EXISTS TAB_SECM_SYSTEM_TEMPLATE;
CREATE TABLE TAB_SECM_SYSTEM_TEMPLATE
(
    PKID             VARCHAR(64) PRIMARY KEY NOT NULL,     --系统模板ID
    NAME             VARCHAR(128),                         --名称
    DESCRIPTION      VARCHAR(128),                         --描述
    DEPLOY_STATUS    INTEGER DEFAULT(0),                   --部署状态：0未部署/1已部署/2部署中/3部署失败/4部分部署/5无需部署
    ADOM_ID          VARCHAR(64),                          --租户ID
    UPDATE_TIME      BIGINT                                --更新时间
);
ALTER TABLE PUBLIC.TAB_SECM_SYSTEM_TEMPLATE OWNER TO OSSDBUSER;
ALTER TABLE TAB_SECM_SYSTEM_TEMPLATE ADD CONSTRAINT UK_UNIQUE_SYSTEM_TEMPLATE UNIQUE (NAME, ADOM_ID);

--模板设备关联关系表
DROP TABLE IF EXISTS TAB_SECM_SYSTEM_TEMPLATE_RELATION_DEVICE;
CREATE TABLE TAB_SECM_SYSTEM_TEMPLATE_RELATION_DEVICE
(
    PKID            VARCHAR(64) PRIMARY KEY NOT NULL,     --ID
    TEMPLATE_ID     VARCHAR(64),                          --系统模板ID
    DEVICE_ID       VARCHAR(64)                           --设备/设备组ID
);
ALTER TABLE PUBLIC.TAB_SECM_SYSTEM_TEMPLATE_RELATION_DEVICE OWNER TO OSSDBUSER;


--模板设备关联关系表
DROP TABLE IF EXISTS TAB_SECM_SYSTEM_TEMPLATE_RELATION_SUB_DEVICE;
CREATE TABLE TAB_SECM_SYSTEM_TEMPLATE_RELATION_SUB_DEVICE
(
    PKID                  VARCHAR(64) PRIMARY KEY NOT NULL,     --ID
    TEMPLATE_ID           VARCHAR(64),                          --系统模板ID
    DEVICE_GROUP_ID       VARCHAR(64),                          --设备组ID
    DEVICE_ID             VARCHAR(64),                          --设备ID
    DEPLOY_STATUS         INTEGER DEFAULT(0),                   --部署状态：0未部署/1已部署/2部署中/3部署失败/4部分部署/5无需部署
    UPDATE_TIME           BIGINT                                --更新时间
);
ALTER TABLE PUBLIC.TAB_SECM_SYSTEM_TEMPLATE_RELATION_SUB_DEVICE OWNER TO OSSDBUSER;
CREATE INDEX SYSTEM_TEMPLATE_RELATION_SUB_DEVICE_INDEX ON TAB_SECM_SYSTEM_TEMPLATE_RELATION_SUB_DEVICE(DEVICE_GROUP_ID);

--系统模板页面元素定制表
DROP TABLE IF EXISTS TAB_SECM_SYSTEM_TEMPLATE_WEB_DESIGN;
CREATE TABLE TAB_SECM_SYSTEM_TEMPLATE_WEB_DESIGN
(
    FIELD_KEY             VARCHAR(32) PRIMARY KEY NOT NULL,     --字段KEY值
    FIELD_ZH              VARCHAR(256),                         --字段中文名
    FIELD_EN              VARCHAR(256),                         --字段英文名
    WEB_WIDGET_TYPE       VARCHAR(32),                          --控件类型
    WIDGET_ZH             VARCHAR(32),                          --类似radio这样的控件的中文说明（用|分割多个）
    WIDGET_EN             VARCHAR(32),                          --类似radio这样的控件的英文说明（用|分割多个）
    WIDGET_NOTE_ZH        VARCHAR(128),                         --控件提示中文信息
    WIDGET_NOTE_EN        VARCHAR(128),                         --控件提示英文信息
    VALIDATION_RULE       VARCHAR(128),                         --控件输入页面校验规则
    VALIDATION_RULE_EXT   VARCHAR(128),                         --控件输入后台扩展校验规则
    TIP_ZH                VARCHAR(256),                         --校验失败提示中文信息
    TIP_EN                VARCHAR(256),                         --校验失败提示英文信息
    FIELD_START           VARCHAR(32),                          --模块其实索引字段标记，每个功能模块第一个选中字段标记即可
    REQUIRED              INTEGER,                              --是否需要必填标记
    SHOW_INDEX            INTEGER                               --显示顺序
);
ALTER TABLE PUBLIC.TAB_SECM_SYSTEM_TEMPLATE_WEB_DESIGN OWNER TO OSSDBUSER;

INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_WEB_DESIGN VALUES('url_filter.remote', 'URL远程查询', 'URL Remote Query Server', 'checkbox', '', '', '', '', '', '(true)|(false)', '', '', 'url_filter', 0, 0);
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_WEB_DESIGN VALUES('url_filter.operation', '操作类型', 'Operation Type', 'radio', '更新|删除', 'Update|Delete', '', '', '', '(update)|(delete)', '', '', '', 0, 1);
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_WEB_DESIGN VALUES('url_filter.country', '国家码', 'Country Code', 'combobox', '', '', '', '', '', '', '', '', '', 1, 2);
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_WEB_DESIGN VALUES('url_filter.server_ip', '本地服务器地址', 'Local Server Address', 'text', '', '', '', '', '^([1-9]|[1-9]\d|1[0-1]\d|12[0-6]|12[8-9]|1[3-9]\d|2[0-1]\d|22[0-3])(\.([0-9]|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])){3}$', '', '请输入合法的IPv4地址，仅支持A、B、C类地址，并且不能是回环地址|无效数据', 'Please enter A valid IPv4 address. Only class A, B, and C addresses exclude loopback address are supported|Invalid data', '', 1, 3);
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_WEB_DESIGN VALUES('url_filter.server_port', '端口', 'Port', 'text', '', '', '<1-65535>', '<1-65535>', '(^[1-9]\d{0,3}$)|(^[1-5]\d{4}$)|(^6[0-4]\d{3}$)|(^65[0-4]\d{2}$)|(^655[0-2]\d$)|(^6553[0-5]$)', '', '请输入1~65535|无效数据', 'Input 1~65535 please|Invalid data', '', 1, 4);
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_WEB_DESIGN VALUES('url_filter.malicious', '恶意URL超时时间', 'Malicious URL TimeOut', 'text', '', '', '<1-10080>分钟', '<1-10080> minutes', '(^[1-9]\d{0,3}$)|(^100[0-7]\d$)|(^10080$)', '', '请输入1~10080|无效数据', 'Input 1~10080 please|Invalid data', '', 1, 5);
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_WEB_DESIGN VALUES('url_filter.consistency', '加密流量一致性校验', 'Encrypted Traffic Consistency Check', 'switch', '', '', '', '', '', '(true)|(false)', '', '', '', 0, 6);
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_WEB_DESIGN VALUES('dns.config', 'DNS服务器配置', 'DNS Server', 'checkbox', '', '', '', '', '', '(true)|(false)', '', '', 'dns', 0, 7);
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_WEB_DESIGN VALUES('dns.operation', '操作类型', 'Operation Type', 'radio', '更新|删除', 'Update|Delete', '', '', '', '(update)|(delete)', '', '', '', 0, 8);
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_WEB_DESIGN VALUES('dns.primary_dns_server', '首选DNS服务器', 'Primary DNS Server', 'text', '', '', '', '', '^([1-9]|[1-9]\d|1[0-1]\d|12[0-6]|12[8-9]|1[3-9]\d|2[0-1]\d|22[0-3])(\.([0-9]|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])){3}$', '', '请输入合法的IPv4地址，仅支持A、B、C类地址，并且不能是回环地址|无效数据', 'Please enter A valid IPv4 address. Only class A, B, and C addresses exclude loopback address are supported|Invalid data', '', 1, 9);
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_WEB_DESIGN VALUES('dns.secondary_dns_server', '备用DNS服务器', 'Secodary DNS Server', 'text', '', '', '', '', '(^$)|(^([1-9]|[1-9]\d|1[0-1]\d|12[0-6]|12[8-9]|1[3-9]\d|2[0-1]\d|22[0-3])(\.([0-9]|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])){3}$)', '', '请输入合法的IPv4地址，仅支持A、B、C类地址，并且不能是回环地址|无效数据', 'Please enter A valid IPv4 address. Only class A, B, and C addresses exclude loopback address are supported|Invalid data', '', 0, 10);

--系统模板详细数据信息存储表
DROP TABLE IF EXISTS TAB_SECM_SYSTEM_TEMPLATE_DETAIL;
CREATE TABLE TAB_SECM_SYSTEM_TEMPLATE_DETAIL
(
    PKID             VARCHAR(64) PRIMARY KEY NOT NULL,     --ID
    TEMPLATE_ID      VARCHAR(64),                          --系统模板ID
    FIELD_KEY        VARCHAR(32),                          --字段KEY值
    FIELD_VALUE      VARCHAR(128),                         --字段VALUE值
    FIELD_TYPE       VARCHAR(128)                          --对象类型（具体实现看，FIELD_KEY已经可以区分类型）
);
ALTER TABLE PUBLIC.TAB_SECM_SYSTEM_TEMPLATE_DETAIL OWNER TO OSSDBUSER;
CREATE INDEX SYSTEM_TEMPLATE_DETAIL_URLTEMPLATE_ID_INDEX ON TAB_SECM_SYSTEM_TEMPLATE_DETAIL(TEMPLATE_ID);

--国家码映射表
DROP TABLE IF EXISTS TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE;
CREATE TABLE TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE
(
    CODE             VARCHAR(4),                           --国家代码
    NAME_EN          VARCHAR(128),                         --中文名
    NAME_ZH          VARCHAR(128)                          --英文名
);
ALTER TABLE PUBLIC.TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE OWNER TO OSSDBUSER;


INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('AD', 'ANDORRA', '安道尔');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('AE', 'UNITED ARAB EMIRATES', '阿联酋');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('AF', 'AFGHANISTAN', '阿富汗');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('AG', 'ANTIGUA AND BARBUDA', '安提瓜和巴布达');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('AL', 'ALBANIA', '阿尔巴尼亚');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('AM', 'ARMENIA', '亚美尼亚');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('AN', 'NETHERLANDS ANTILLES', '荷属安的列斯');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('AO', 'ANGOLA', '安哥拉');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('AQ', 'ANGUILLA', '南极洲');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('AR', 'ARGENTINA', '阿根廷');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('AS', 'AMERICAN SAMOA', '美属萨摩亚');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('AT', 'AUSTRIA', '奥地利');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('AU', 'AUSTRALIA', '澳大利亚');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('AW', 'ARUBA', '阿鲁巴');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('AZ', 'AZERBAIJAN', '阿塞拜疆');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('BA', 'BOSNIA AND HERZEGOVINA', '波黑');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('BB', 'BARBADOS', '巴巴多斯');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('BD', 'BANGLADESH', '孟加拉国');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('BE', 'BELGIUM', '比利时');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('BF', 'BURKINA FASO', '布基纳法索');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('BG', 'BULGARIA', '保加利亚');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('BH', 'BAHRAIN', '巴林');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('BI', 'BURUNDI', '布隆迪');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('BJ', 'BENIN', '贝宁');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('BM', 'BERMUDA', '百慕大');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('BN', 'BRUNEI DARUSSALAM', '文莱');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('BO', 'BOLIVIA', '玻利维亚');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('BR', 'BRAZIL', '巴西');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('BS', 'BAHAMAS', '巴哈马');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('BT', 'BHUTAN', '不丹');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('BV', 'BOUVET ISLAND', '布维岛');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('BW', 'BOTSWANA', '博茨瓦纳');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('BY', 'BELARUS', '白俄罗斯');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('BZ', 'BELIZE', '伯利兹');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('CA', 'CANADA', '加拿大');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('CD', 'THE DEMOCRATIC REPUBLIC OF THE CONGO', '刚果（金）');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('CF', 'CENTRAL AFRICAN REPUBLIC', '中非');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('CG', 'CONGO', '刚果（布）');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('CH', 'SWITZERLAND', '瑞士');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('CI', 'COTE D''IVOIRE', '科特迪瓦');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('CK', 'COOK ISLANDS', '库克群岛');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('CL', 'CHILE', '智利');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('CM', 'CAMEROON', '喀麦隆');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('CN', 'CHINA', '中国');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('CO', 'COLOMBIA', '哥伦比亚');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('CR', 'COSTA RICA', '哥斯达黎加');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('CS', 'SERBIA AND MONTENEGRO', '古巴');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('CU', 'CUBA', '佛得角');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('CV', 'CAPE VERDE', '圣诞岛');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('CY', 'CYPRUS', '塞浦路斯');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('CZ', 'CZECH REPUBLIC', '捷克');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('DE', 'GERMANY', '德国');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('DJ', 'DJIBOUTI', '吉布提');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('DK', 'DENMARK', '丹麦');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('DM', 'DOMINICA', '多米尼克');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('DO', 'DOMINICAN REPUBLIC', '多米尼加');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('DZ', 'ALGERIA', '阿尔及利亚');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('EC', 'ECUADOR', '厄瓜多尔');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('EE', 'ESTONIA', '爱沙尼亚');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('EG', 'EGYPT', '埃及');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('ER', 'ERITREA', '厄立特里亚');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('ES', 'SPAIN', '西班牙');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('ET', 'ETHIOPIA', '埃塞俄比亚');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('FI', 'FINLAND', '芬兰');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('FJ', 'FIJI', '斐济');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('FK', 'FALKLAND ISLANDS (MALVINAS)', '福克兰群岛（马尔维纳斯）');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('FM', 'FEDERATED STATES OF MICRONESIA', '密克罗尼西亚联邦');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('FO', 'FAROE ISLANDS', '法罗群岛');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('FR', 'FRANCE', '法国');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('GA', 'GABON', '加蓬');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('GB', 'UNITED KINGDOM', '英国');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('GD', 'GRENADA', '格林纳达');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('GE', 'GEORGIA', '格鲁吉亚');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('GF', 'FRENCH GUIANA', '法属圭亚那');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('GG', 'GUERNSEY', '格恩西岛');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('GH', 'GHANA', '加纳');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('GI', 'GIBRALTAR', '直布罗陀');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('GL', 'GREENLAND', '格陵兰');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('GM', 'GAMBIA', '冈比亚');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('GN', 'GUINEA', '几内亚');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('GP', 'GUADELOUPE', '瓜德罗普');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('GQ', 'EQUATORIAL GUINEA', '赤道几内亚');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('GR', 'GREECE', '希腊');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('GS', 'SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS', '南乔治亚岛和南桑德韦奇岛');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('GT', 'GUATEMALA', '危地马拉');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('GU', 'GUAM', '关岛');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('GW', 'GUINEA-BISSAU', '几内亚比绍');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('GY', 'GUYANA', '圭亚那');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('HK', 'HONG KONG', '香港');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('HN', 'HONDURAS', '洪都拉斯');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('HR', 'CROATIA', '克罗地亚');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('HT', 'HAITI', '海地');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('HU', 'HUNGARY', '匈牙利');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('ID', 'INDONESIA', '印度尼西亚');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('IE', 'IRELAND', '爱尔兰');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('IL', 'ISRAEL', '以色列');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('IM', 'ISLE OF MAN', '英国属地曼岛');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('IN', 'INDIA', '印度');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('IO', 'BRITISH INDIAN OCEAN TERRITORY', '英属印度洋领地');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('IQ', 'IRAQ', '伊拉克');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('IR', 'ISLAMIC REPUBLIC OF IRAN', '伊朗');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('IS', 'ICELAND', '冰岛');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('IT', 'ITALY', '意大利');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('JE', 'JERSEY', '泽西岛');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('JM', 'JAMAICA', '牙买加');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('JO', 'KENYA', '约旦');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('JP', 'JAPAN', '日本');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('KE', 'KENYA', '肯尼亚');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('KG', 'KYRGYZSTAN', '吉尔吉斯斯坦');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('KH', 'CAMBODIA', '柬埔寨');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('KI', 'KIRIBATI', '基里巴斯');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('KM', 'COMOROS', '科摩罗');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('KN', 'SAINT KITTS AND NEVIS', '圣基茨和尼维斯');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('KP', 'DEMOCRATIC PEOPLE''S REPUBLIC OF KOREA', '朝鲜');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('KR', 'REPUBLIC OF KOREA', '韩国');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('KW', 'KUWAIT', '科威特');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('KY', 'CAYMAN ISLANDS', '开曼群岛');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('KZ', 'KAZAKHSTAN', '哈萨克斯坦');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('LA', 'LAO PEOPLE''S DEMOCRATIC REPUBLIC', '老挝');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('LB', 'LEBANON', '黎巴嫩');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('LC', 'SAINT LUCIA', '圣卢西亚');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('LI', 'LIECHTENSTEIN', '列支敦士登');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('LK', 'SRI LANKA', '斯里兰卡');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('LR', 'LIBERIA', '利比里亚');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('LS', 'LESOTHO', '莱索托');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('LT', 'LITHUANIA', '立陶宛');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('LU', 'LUXEMBOURG', '卢森堡');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('LV', 'LATVIA', '拉脱维亚');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('LY', 'LIBYAN ARAB JAMAHIRIYA', '利比亚');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('MA', 'MOROCCO', '摩洛哥');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('MC', 'MONACO', '摩纳哥');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('MD', 'REPUBLIC OF MOLDOVA', '摩尔多瓦');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('ME', 'MONTENEGRO', '黑山');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('MF', 'SAINT MARTIN', '圣马丁岛');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('MG', 'MADAGASCAR', '马达加斯加');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('MH', 'MARSHALL ISLANDS', '马绍尔群岛');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('MK', 'THE FORMER YUGOSLAV REPUBLIC OF MACEDONIA', '前南马其顿');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('ML', 'MALI', '马里');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('MM', 'MYANMAR', '缅甸');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('MN', 'MONGOLIA', '蒙古');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('MO', 'MACAO', '澳门');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('MP', 'NORTHERN MARIANA ISLANDS', '北马里亚纳');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('MQ', 'MARTINIQU', '马提尼克');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('MR', 'MAURITANIA', '毛利塔尼亚');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('MS', 'MONTSERRAT', '蒙特塞拉特');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('MT', 'MALTA', '马耳他');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('MU', 'MAURITIUS', '毛里求斯');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('MV', 'MALDIVES', '马尔代夫');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('MW', 'MALAWI', '马拉维');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('MX', 'MEXICO', '墨西哥');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('MY', 'MALAYSIA', '马来西亚');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('MZ', 'MOZAMBIQUE', '莫桑比克');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('NA', 'NAMIBIA', '纳米比亚');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('NC', 'NEW CALEDONIA', '新喀里多尼亚');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('NE', 'NIGER', '尼日尔');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('NF', 'NORFOLK ISLAND', '诺福克岛');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('NG', 'NIGERIA', '尼日利亚');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('NI', 'NICARAGUA', '尼加拉瓜');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('NL', 'NETHERLANDS', '荷兰');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('NO', 'NORWAY', '挪威');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('NP', 'NEPAL', '尼泊尔');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('NR', 'NAURU', '瑙鲁');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('NU', 'NIUE', '纽埃');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('NZ', 'NEW ZEALAND', '新西兰');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('OM', 'OMAN', '阿曼');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('PA', 'PANAMA', '巴拿马');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('PE', 'PERU', '秘鲁');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('PF', 'FRENCH POLYNESIA', '法属波利尼西亚');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('PG', 'PAPUA NEW GUINEA', '巴布亚新几内亚');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('PH', 'PHILIPPINES', '菲律宾');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('PK', 'PAKISTAN', '巴基斯坦');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('PL', 'POLAND', '波兰');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('PM', 'SAINT PIERRE AND MIQUELON', '圣皮埃尔和密克隆');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('PR', 'PUERTO RICO', '波多黎各');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('PS', 'PALESTINIAN TERRITORY, OCCUPIED', '巴勒斯坦');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('PT', 'PORTUGAL', '葡萄牙');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('PW', 'PALAU', '帕劳');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('PY', 'PARAGUAY', '巴拉圭');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('QA', 'QATAR', '卡塔尔');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('RE', 'REUNION', '留尼汪');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('RO', 'ROMANIA', '罗马尼亚');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('RS', 'SERBIA', '塞尔维亚');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('RU', 'RUSSIAN FEDERATION', '俄罗斯联邦');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('RW', 'RWANDA', '卢旺达');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('SA', 'SAUDI ARABIA', '沙特阿拉伯');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('SB', 'SOLOMON ISLANDS', '所罗门群岛');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('SC', 'SEYCHELLES', '塞舌尔');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('SD', 'SUDAN', '苏丹');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('SE', 'SWEDEN', '瑞典');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('SG', 'SINGAPORE', '新加坡');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('SI', 'SLOVENIA', '斯洛文尼亚');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('SK', 'SLOVAKIA', '斯洛伐克');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('SL', 'SIERRA LEONE', '塞拉利昂');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('SM', 'SAN MARINO', '圣马力诺');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('SN', 'SENEGAL', '塞内加尔');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('SO', 'SOMALIA', '索马里');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('SR', 'SURINAME', '苏里南');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('ST', 'SAO TOME AND PRINCIPE', '圣多美和普林西比');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('SV', 'EL SALVADOR', '萨尔瓦多');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('SY', 'SYRIAN ARAB REPUBLIC', '叙利亚');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('SZ', 'SWAZILAND', '斯威士兰');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('TC', 'TURKS AND CAICOS ISLANDS', '特克斯和凯科斯群岛');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('TD', 'CHAD', '乍得');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('TF', 'FRENCH SOUTHERN TERRITORIES', '法属南部领地');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('TG', 'TOGO', '多哥');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('TH', 'THAILAND', '泰国');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('TJ', 'TAJIKISTAN', '塔吉克斯坦');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('TK', 'TOKELAU', '托克劳');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('TM', 'TURKMENISTAN', '土库曼斯坦');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('TN', 'TUNISIA', '突尼斯');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('TO', 'TONGA', '汤加');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('TP', 'TIMOR-LESTE', '东帝汶民主共和国');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('TR', 'TURKEY', '土耳其');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('TT', 'TRINIDAD AND TOBAGO', '特立尼达和多巴哥');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('TV', 'TUVALU', '图瓦卢');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('TW', 'TAIWAN', '台湾');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('TZ', 'UNITED REPUBLIC OF TANZANIA', '坦桑尼亚');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('UA', 'UKRAINE', '乌克兰');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('UG', 'UGANDA', '乌干达');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('UM', 'UNITED STATES MINOR OUTLYING ISLANDS', '美国本土外小岛屿');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('US', 'UNITED STATES', '美国');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('UY', 'URUGUAY', '乌拉圭');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('UZ', 'UZBEKISTAN', '乌兹别克斯坦');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('VA', 'HOLY SEE (VATICAN CITY STATE)', '梵蒂冈');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('VC', 'SAINT VINCENT AND THE GRENADINES', '圣文森特和格林纳丁斯');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('VE', 'VENEZUELA', '委内瑞拉');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('VG', 'VIRGIN ISLANDS, BRITISH', '英属维尔京群岛');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('VI', 'VIRGIN ISLANDS, U.S.', '美属维尔京群岛');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('VN', 'VIET NAM', '越南');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('VU', 'VANUATU', '瓦努阿图');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('WF', 'WALLIS AND FUTUNA', '瓦利斯和富图纳');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('WS', 'SAMOA', '萨摩亚');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('YE', 'YEMEN', '也门');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('YT', 'MAYOTTE', '马约特');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('ZA', 'SOUTH AFRICA', '南非');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('ZM', 'ZAMBIA', '赞比亚');
INSERT INTO TAB_SECM_SYSTEM_TEMPLATE_COUNTRY_CODE VALUES('ZW', 'ZIMBABWE', '津巴布韦');
--19.3.0.B001_END
--19.3.0.B031_BEGIN
UPDATE TAB_SECM_SYSTEM_TEMPLATE_WEB_DESIGN SET FIELD_EN = 'Secondary DNS Server' WHERE FIELD_KEY = 'dns.secondary_dns_server';
--19.3.0.B031_END

--19.3.0.063_BEGIN
select alter_columns('alter','tab_secm_upgrademgr_task','oldversion','CHARACTER VARYING(100)');
select alter_columns('alter','tab_secm_upgrademgr_task','targetversion','CHARACTER VARYING(100)');
select alter_columns('alter','tab_secm_upgrademgr_upgrade_detail','oldversion','CHARACTER VARYING(100)');
select alter_columns('alter','tab_secm_upgrademgr_upgrade_detail','targetversion','CHARACTER VARYING(100)');
--19.3.0.063_END

--19.3.0.022_BEGIN
select alter_columns('add','t_campus_cfgframe_cfgtemp','itemId','VARCHAR(256)');
--19.3.0.022_END

--19.4.0.170_BEGIN
select alter_columns('add','t_campus_cfgframe_cfgtemp','siteId','VARCHAR(256)');
--19.4.0.170_END

--19.4.0.115_BEGIN
DROP TABLE IF EXISTS tab_secm_cert_binding;
CREATE TABLE tab_secm_cert_binding
(
    id         varchar(256) primary key NOT NULL, -- 主键
    app_name   VARCHAR(256),                      -- 应用策略名称
    service_id VARCHAR(256),                      -- 服务证书ID
    create_time TIMESTAMP                         -- 创建时间
);
ALTER TABLE public.tab_secm_cert_binding
    OWNER TO OSSDBUSER;

insert into tab_secm_cert_binding(id,app_name,service_id,create_time) values ('00001','00001','00001',null);


DROP TABLE IF EXISTS tab_secm_cert_service;
CREATE TABLE tab_secm_cert_service
(
    id          varchar(256) primary key NOT NULL, -- 主键
    name        VARCHAR(256),                      -- 服务证书名称
    description VARCHAR(512)                       -- 描述
);
ALTER TABLE public.tab_secm_cert_service
    OWNER TO OSSDBUSER;
--19.4.0.115_END







