--19.2.0.056_BEGIN
delete from tab_secm_pf_sig_filter_obj where PKID = '72000103';
INSERT INTO tab_secm_pf_sig_filter_obj (PKID ,PARENTID ,NAME ,OBJ_CN ,TYPE) VALUES ('72000103','72000072','Webshell','Webshell',2);
--19.2.0.056_END

--19.4.0.171_BEGIN
alter table tab_secm_serviceset_item_ngfw modify  dest_port varchar(4096);
alter table tab_secm_serviceset_item_ngfw modify  source_port varchar(4096);
alter table tab_secm_serviceset_item_deploy modify  dest_port varchar(4096);
alter table tab_secm_serviceset_item_deploy modify  source_port varchar(4096);
alter table tab_secm_serviceset_item modify  dest_port varchar(4096);
alter table tab_secm_serviceset_item modify  source_port varchar(4096);
--19.4.0.171_END

--19.2.0.001_BEGIN
--tab_secm_g_obj_address_pool
select alter_columns('add','tab_secm_g_obj_address_pool','description','VARCHAR(128)');
select alter_columns('add','tab_secm_g_obj_address_pool','universal','boolean default false');
select alter_columns('add','tab_secm_g_obj_address_pool','unique_code','VARCHAR(128)');

--tab_secm_deploy_obj_address_pool
select alter_columns('add','tab_secm_deploy_obj_address_pool','description','VARCHAR(128)');
select alter_columns('add','tab_secm_deploy_obj_address_pool','universal','boolean default false');
select alter_columns('add','tab_secm_deploy_obj_address_pool','unique_code','VARCHAR(128)');

--tab_secm_ngfw_obj_address_pool
select alter_columns('add','tab_secm_ngfw_obj_address_pool','description','VARCHAR(128)');
select alter_columns('add','tab_secm_ngfw_obj_address_pool','universal','boolean default false');
select alter_columns('add','tab_secm_ngfw_obj_address_pool','unique_code','VARCHAR(128)');
select alter_columns('add','tab_secm_ngfw_obj_address_pool','ADOM_ID','VARCHAR(255)');
--19.2.0.001_END

--19.3.0.060_BEGIN
drop index IF EXISTS IDX_tab_secm_ngfw_obj_add_pool_item_pool_id;
create INDEX IDX_tab_secm_ngfw_obj_add_pool_item_pool_id ON tab_secm_ngfw_obj_add_pool_item (pool_id);
--19.3.0.060_BEGIN

--19.2.0.001_BEGIN
select alter_columns('add','tab_secm_addressset','universal','boolean default false');
update tab_secm_addressset set universal = false where universal is null;

--tab_secm_addressset_deploy
select alter_columns('add','tab_secm_addressset_deploy','universal','boolean default false');
select alter_columns('add','tab_secm_addressset_deploy','adom_id','VARCHAR(255)');

--tab_secm_addressset_ngfw
select alter_columns('add','tab_secm_addressset_ngfw', 'universal', 'boolean default false');
select alter_columns('add','tab_secm_addressset_ngfw', 'adom_id', 'VARCHAR(255)');
--19.2.0.001_END


--19.2.0.011_BEGIN
select alter_columns('add', 'tab_secm_addressset', 'poly', 'boolean default false');
select alter_columns('add', 'tab_secm_addressset_deploy', 'poly', 'boolean default false');
select alter_columns('add', 'tab_secm_addressset_ngfw', 'poly', 'boolean default false');

--19.2.0.011_END

--19.3.0.001_BEGIN
select alter_columns('add', 'tab_secm_addressset', 'PRODUCER', 'VARCHAR(128)');
--19.3.0.001_END

--19.4.0.165_BEGIN
update tab_secm_addressset set POLY = true where LOCKED_BY ='AUTO';
--19.4.0.165_END

--19.2.0.001_BEGIN
select alter_columns('add', 'tab_secm_antivirus', 'universal', 'boolean default false');
update tab_secm_antivirus set universal = true where pkid = '30000000-0000-0000-0000-000000000000';
update tab_secm_antivirus set universal = false where universal is null;
--19.2.0.001_END

--19.2.0.001_BEGIN

----------------- 预定义应用 BEGIN --------------
----rename id to pkid----
alter table tab_secm_obj_app
    drop CONSTRAINT IF EXISTS tab_secm_obj_app_pkey;
alter table tab_secm_obj_app_category
    drop CONSTRAINT IF EXISTS tab_secm_obj_app_category_pkey;
alter table tab_secm_obj_app_supercategory
    drop CONSTRAINT IF EXISTS tab_secm_obj_app_supercategory_pkey;
alter table tab_secm_obj_app_datamode
    drop CONSTRAINT IF EXISTS tab_secm_obj_app_datamode_pkey;
alter table tab_secm_obj_app_label
    drop CONSTRAINT IF EXISTS tab_secm_obj_app_label_pkey;

select rename_column_if_exists('tab_secm_obj_app', 'id', 'pkid');
select rename_column_if_exists('tab_secm_obj_app_category', 'id', 'pkid');
select rename_column_if_exists('tab_secm_obj_app_supercategory', 'id', 'pkid');
select rename_column_if_exists('tab_secm_obj_app_datamode', 'id', 'pkid');
select rename_column_if_exists('tab_secm_obj_app_label', 'id', 'pkid');
select rename_column_if_exists('tab_secm_obj_app_rel', 'id', 'pkid');

alter table tab_secm_obj_app
    add PRIMARY KEY (pkid);
alter table tab_secm_obj_app_category
    add PRIMARY KEY (pkid);
alter table tab_secm_obj_app_supercategory
    add PRIMARY KEY (pkid);
alter table tab_secm_obj_app_datamode
    add PRIMARY KEY (pkid);
alter table tab_secm_obj_app_label
    add PRIMARY KEY (pkid);
----rename id to pkid finish----

select rename_column_if_exists('tab_secm_obj_app', 'old_app_name', 'old_name');

select alter_columns('alter', 'tab_secm_obj_app', 'locked', 'integer');
select alter_columns('add', 'tab_secm_obj_app', 'pre_defined', 'integer default 0');
select alter_columns('add', 'tab_secm_obj_app', 'universal', 'boolean default TRUE');
update TAB_SECM_OBJ_APP
set PRE_DEFINED = 1,
    UNIVERSAL   = TRUE;


----------------- 预定义应用 END --------------
--19.2.0.001_END

--19.2.0.001_BEGIN
drop table if exists TAB_SECM_RES_APP_GROUP;
CREATE TABLE TAB_SECM_RES_APP_GROUP
(
  --主键
  PKID VARCHAR(128) primary key NOT NULL,
  NAME varchar(255) NULL,
  OLD_NAME  varchar(255) NULL,
  DESCRIPTION VARCHAR(3072) NULL ,
  universal boolean ,
  LOCKED smallint NULL ,
  LOCKED_BY VARCHAR(255) NULL ,
  UNIQUE_CODE bigint NULL ,
  ADOM_ID VARCHAR(255) NULL
);
ALTER TABLE public.TAB_SECM_RES_APP_GROUP OWNER TO OSSDBUSER;
DROP INDEX IF EXISTS idx_secm_obj_app_name;
CREATE INDEX idx_secm_obj_app_name ON TAB_SECM_RES_APP_GROUP (lower(NAME));


drop table if exists TAB_SECM_RES_APP_GROUP_NGFW;
CREATE TABLE TAB_SECM_RES_APP_GROUP_NGFW
(
  --主键
  PKID VARCHAR(128) primary key NOT NULL,
  NAME varchar(255) NULL,
  OLD_NAME  varchar(255) NULL,
  DESCRIPTION VARCHAR(3072) NULL ,
  universal boolean ,
  LOCKED smallint NULL ,
  LOCKED_BY VARCHAR(255) NULL ,
  UNIQUE_CODE bigint NULL ,
  ADOM_ID VARCHAR(255) NULL,
  DEVICE_DN VARCHAR(255) NULL,
  UD_APPS varchar(10240)
);
ALTER TABLE public.TAB_SECM_RES_APP_GROUP_NGFW OWNER TO OSSDBUSER;

drop table if exists TAB_SECM_RES_APP_GROUP_DEPLOY;
CREATE TABLE TAB_SECM_RES_APP_GROUP_DEPLOY
(
  --主键
  PKID VARCHAR(128) primary key NOT NULL,
  NAME varchar(255) NULL,
  OLD_NAME  varchar(255) NULL,
  DESCRIPTION VARCHAR(3072) NULL ,
  universal boolean ,
  LOCKED smallint NULL ,
  LOCKED_BY VARCHAR(255) NULL ,
  UNIQUE_CODE bigint NULL ,
  ADOM_ID VARCHAR(255) NULL,
  DEVICE_DN VARCHAR(255) NULL,
  UD_APPS varchar(10240)
);
ALTER TABLE public.TAB_SECM_RES_APP_GROUP_DEPLOY OWNER TO OSSDBUSER;

drop table if exists TAB_SECM_APP_GROUP_REL_APP;
CREATE TABLE TAB_SECM_APP_GROUP_REL_APP
(
  PKID serial primary key,
  APP_GROUP_ID varchar(128) NOT NULL,
  APPLICATION_ID  varchar(128) NOT NULL
);
ALTER TABLE public.TAB_SECM_APP_GROUP_REL_APP OWNER TO OSSDBUSER;

drop table if exists TAB_SECM_APP_GROUP_REL_APP_DEPLOY;
CREATE TABLE TAB_SECM_APP_GROUP_REL_APP_DEPLOY
(
  PKID serial primary key,
  APP_GROUP_ID varchar(128) NOT NULL,
  APPLICATION_ID  varchar(128) NOT NULL,
  DEVICE_DN VARCHAR(255) NULL
);
ALTER TABLE public.TAB_SECM_APP_GROUP_REL_APP_DEPLOY OWNER TO OSSDBUSER;

drop table if exists TAB_SECM_APP_GROUP_REL_APP_NGFW;
CREATE TABLE TAB_SECM_APP_GROUP_REL_APP_NGFW
(
  PKID serial primary key,
  APP_GROUP_ID varchar(128) NOT NULL,
  APPLICATION_ID  varchar(128) NOT NULL,
  DEVICE_DN VARCHAR(255) NULL
);
ALTER TABLE public.TAB_SECM_APP_GROUP_REL_APP_NGFW OWNER TO OSSDBUSER;
--19.2.0.001_END

--19.2.0.001_BEGIN
select alter_columns('add', 'TAB_SECM_G_PF_APT', 'universal', 'boolean default false');
update TAB_SECM_G_PF_APT set universal = false where universal is null;
--19.2.0.001_END


--19.3.0.060_BEGIN
drop index IF EXISTS IDX_TAB_SECM_NGFW_PF_FILTER_RULE_REL_RULE_ID;
create INDEX IDX_TAB_SECM_NGFW_PF_FILTER_RULE_REL_RULE_ID ON TAB_SECM_NGFW_PF_FILTER_RULE_REL (RULE_ID);

drop index IF EXISTS IDX_TAB_SECM_NGFW_PF_APT_DEVICE_DN;
create INDEX IDX_TAB_SECM_NGFW_PF_APT_DEVICE_DN ON TAB_SECM_NGFW_PF_APT (DEVICE_DN);
--19.3.0.060_END

--19.3.0.035_BEGIN
delete from tab_secm_pf_sig_filter where ips_id in (select pkid from tab_secm_pf_ips where PRE_DEFINED = 1);
insert into tab_secm_pf_sig_filter(pkid,name,sigset_order,target,severity,os,action,ips_id) values ('71000010','default',0,'11','1110','11111',0,'70000000-0000-0000-0000-000000000000');
insert into tab_secm_pf_sig_filter(pkid,name,sigset_order,target,severity,os,action,ips_id) values ('71000013','default',0,'11','1110','11111',0,'70000000-0000-0000-0000-000000000001');
insert into tab_secm_pf_sig_filter(pkid,name,sigset_order,target,severity,os,action,ips_id) values ('71000016','default',0,'11','1110','11111',0,'70000000-0000-0000-0000-000000000002');
insert into tab_secm_pf_sig_filter(pkid,name,sigset_order,target,severity,os,action,ips_id) values ('71000017','default',0,'11','1110','11111',0,'70000000-0000-0000-0000-000000000003');
insert into tab_secm_pf_sig_filter(pkid,name,sigset_order,target,severity,os,action,ips_id) values ('71000011','default',0,'11','1110','11111',1,'70000000-0000-0000-0000-000000000004');
insert into tab_secm_pf_sig_filter(pkid,name,sigset_order,target,severity,os,action,ips_id) values ('71000014','default',0,'11','1110','11111',0,'70000000-0000-0000-0000-000000000005');
insert into tab_secm_pf_sig_filter(pkid,name,sigset_order,target,severity,os,action,ips_id) values ('71000015','default',0,'11','1110','11111',0,'70000000-0000-0000-0000-000000000006');
insert into tab_secm_pf_sig_filter(pkid,name,sigset_order,target,severity,os,action,ips_id) values ('71000012','default',0,'11','1110','11111',0,'70000000-0000-0000-0000-000000000007');
insert into tab_secm_pf_sig_filter(pkid,name,sigset_order,target,severity,os,action,ips_id) values ('71000019','default',0,'11','1110','11111',2,'70000000-0000-0000-0000-000000000008');
insert into tab_secm_pf_sig_filter(pkid,name,sigset_order,target,severity,os,action,ips_id) values ('71000018','default',0,'11','1110','11111',0,'70000000-0000-0000-0000-000000000009');
--19.3.0.035_END

--19.2.0.001_BEGIN
-- ----------------------------
-- Table structure for tab_secm_ipsec_group
-- ----------------------------
DROP TABLE IF EXISTS tab_secm_ipsec_group;
CREATE TABLE tab_secm_ipsec_group (
    group_id VARCHAR(128) NOT NULL primary key, --'策略组ID'
    name VARCHAR(256) NOT NULL, --'名称'
    description VARCHAR(512), --'描述'
    topotype VARCHAR(256), --'组网类型 枚举值(全连接和星形链接)'
    deploy_status INTEGER DEFAULT 0,--部署状态
    service_count INTEGER,--业务数量
    smart_link boolean, --是否开启智能选路
    key_type VARCHAR(32),--密钥类型
    default_key VARCHAR(1024), ---缺省秘钥
    reverse_route varchar(32), ----反向注入路由
    route_level varchar(32), ----路由优先级
    source VARCHAR(32),--来源
    CREATED_TIME TIMESTAMP WITH TIME ZONE, --'创建时间'
    UPDATED_TIME TIMESTAMP WITH TIME ZONE --'更新时间'
);
ALTER TABLE tab_secm_ipsec_group OWNER TO OSSDBUSER;

-- ----------------------------
-- Table structure for tbl_ipsec_svrtunnel
-- ----------------------------
DROP TABLE IF EXISTS tab_secm_ipsec_service_tunnel;
CREATE TABLE tab_secm_ipsec_service_tunnel (
  service_id varchar(512) NOT NULL primary key,
  service_name varchar(512) NOT NULL,
  local_ne_id varchar(128) DEFAULT NULL,--本端设备id
  remote_ne_id varchar(128) DEFAULT NULL,--对端设备id
  local_device_name varchar(512) DEFAULT NULL,--本端设备名称
  remote_device_name varchar(512) DEFAULT NULL,--远端设备名称
  local_if_name varchar(64) DEFAULT NULL,--本端接口名
  remote_if_name varchar(64) DEFAULT NULL,--对端接口名
  local_if_ip varchar(512) DEFAULT NULL,--本端接口ip
  remote_if_ip varchar(512) DEFAULT NULL,--对端接口ip
  local_policy_name varchar(127) DEFAULT NULL,--ipsec_policy表的ne_policy_name
  remote_policy_name varchar(127) DEFAULT NULL,--ipsec_policy表的ne_policy_name
  group_id varchar(64) DEFAULT NULL,
  network_type VARCHAR(32) DEFAULT NULL,--组网类型
  deploy_status INTEGER DEFAULT 0, --部署状态
  source VARCHAR(32),------------------来源
  is_delete boolean,------------------软删除标记
  CREATED_TIME TIMESTAMP WITH TIME ZONE, --'创建时间'
  UPDATED_TIME TIMESTAMP WITH TIME ZONE --'更新时间'
);
ALTER TABLE tab_secm_ipsec_service_tunnel OWNER TO OSSDBUSER;

-- ----------------------------
-- Table structure for tab_secm_IPSEC_POLICY
-- ----------------------------
DROP TABLE IF EXISTS tab_secm_ipsec_policy;
CREATE TABLE tab_secm_ipsec_policy (
  id varchar(512) NOT NULL primary key,
  ne_id varchar(128) NOT NULL,--设备id
  ne_policy_name varchar(128) NOT NULL,--ipsec-vpn/ipsec-connection/name        设备级唯一
  vsys varchar(32) DEFAULT 'public',--ipsec-vpn/ipsec-connection/vsys  来源于接口的VSYS
  secnario varchar(32) NOT NULL DEFAULT 'p2p-protection',--ipsec-vpn/ipsec-connection/secnario 默认填 p2p-protection
  peer_ip varchar(512) DEFAULT NULL,--ipsec-vpn/ipsec-connection/peer-address
  local_if_name varchar(64) DEFAULT NULL,--ipsec-vpn/ipsec-connection/local-information/interface-name
  local_ip varchar(32) DEFAULT NULL,--ipsec-vpn/ipsec-connection/local-information/local-address/ip-address
  --ipsec-vpn/ipsec-connection/local-information/local-address/use-interface-address 可能不需要
  ike_peer_name varchar(32) DEFAULT NULL,--ike-peer表的peer_name
  proposal_name varchar(256) DEFAULT NULL,--ipsec-vpn/ipsec-connection/ipsec-proposal    ipsec-proposal表的proposal_id
  security_acl varchar(64) DEFAULT NULL,--ipsec-vpn/ipsec-connection/acl   同acl表的acl_id
  pfs varchar(128) DEFAULT NULL,--ipsec-vpn/ipsec-connection/pfs
  sa_duration_sec decimal(10,0) DEFAULT NULL,--ipsec-vpn/ipsec-connection/lifetime-seconds
  sa_duration_kb decimal(10,0) DEFAULT NULL,--ipsec-vpn/ipsec-connection/lifetime-kilobytes
  admin_state varchar(16) DEFAULT 'Up',
  service_id varchar(128), --belong to ipsec_svrtunnel
  deploy_status INTEGER DEFAULT 0, --部署状态
  is_delete boolean,------------------软删除标记
  failed_reason varchar(512),------------失败原因
  smart_link_profile varchar(32), -------智能选路模板名称
  reverse_route varchar(32), ----反向注入路由
  route_level varchar(32), ----路由优先级
  dynamic_ip boolean, ---是否是动态ip
  peer_interface_name varchar(1024),
  CREATED_TIME TIMESTAMP WITH TIME ZONE, --'创建时间'
  UPDATED_TIME TIMESTAMP WITH TIME ZONE --'更新时间'
);
ALTER TABLE tab_secm_ipsec_policy OWNER TO OSSDBUSER;
ALTER TABLE tab_secm_ipsec_policy ADD CONSTRAINT UNIQUE_IPSEC_POLICY UNIQUE(NE_POLICY_NAME, VSYS, NE_ID);

-- ----------------------------
-- Table structure for tab_secm_ipsec_ikepeer
-- ----------------------------
DROP TABLE IF EXISTS tab_secm_ipsec_ikepeer;
CREATE TABLE tab_secm_ipsec_ikepeer (
  id varchar(128) NOT NULL primary key,
  ne_id varchar(128) NOT NULL,  --设备id
  peer_name varchar(32) DEFAULT NULL,   --ike对等体名
  proposal_id decimal(10,0) DEFAULT NULL, --ike提议主键（+ne_id） ipsec-vpn/ipsec-connection/ike-param/ike-proposal
  ike_version varchar(16) DEFAULT NULL, --ipsec-connection/ike-param/ike-version
  phase1_mode varchar(16) DEFAULT NULL, --ipsec-vpn/ipsec-connection/ike-param/phase1-mode
  local_id_type varchar(16) DEFAULT NULL,--ipsec-vpn/ipsec-connection/ike-param/local-id/type
  local_name varchar(256) DEFAULT NULL,--ipsec-vpn/ipsec-connection/ike-param/local-id/value
  remote_id_type varchar(16) DEFAULT NULL,--ipsec-vpn/ipsec-connection/ike-param/peer-id/type
  remote_name varchar(256) DEFAULT NULL,--ipsec-vpn/ipsec-connection/ike-param/peer-id/value
  pki_domain varchar(128) DEFAULT NULL,--psec-vpn/ipsec-connection/ike-param/certificate/pki-realm-name
  local_cert_name varchar(128) DEFAULT NULL,--ipsec-vpn/ipsec-connection/ike-param/certificate/local-certificate-filename
  remote_cert_name varchar(128) DEFAULT NULL,--ipsec-vpn/ipsec-connection/ike-param/certificate/peer-certificate-filename
  pre_shared_key varchar(1024) DEFAULT NULL,--ipsec-vpn/ipsec-connection/ike-param/pre-shared-key
  dpd_type varchar(16) DEFAULT NULL,--ipsec-vpn/ipsec-connection/ike-param/dpd/type
  dpd_interval decimal(10,0) DEFAULT NULL,--ipsec-vpn/ipsec-connection/ike-param/dpd/interval
  dpd_timeout decimal(10,0) DEFAULT NULL,--ipsec-vpn/ipsec-connection/ike-param/dpd/timeout
  ipsec_policy_id varchar(512),--belong to ipsec policy
  CREATED_TIME TIMESTAMP WITH TIME ZONE, --'创建时间'
  UPDATED_TIME TIMESTAMP WITH TIME ZONE --'更新时间'
);
ALTER TABLE tab_secm_ipsec_ikepeer OWNER TO OSSDBUSER;

-- ----------------------------
-- Table structure for tab_secm_ipsec_ikeproposal
-- ----------------------------
DROP TABLE IF EXISTS tab_secm_ipsec_ikeproposal;
CREATE TABLE tab_secm_ipsec_ikeproposal (
  id varchar(128) NOT NULL primary key,
  ne_id varchar(128) NOT NULL,--设备id
  proposal_id decimal(10,0) NOT NULL,--ipsec-vpn/ike-proposal/id        设备级唯一
  encrypt_algorithm varchar(128),--ipsec-vpn/ike-proposal/encryption-algorithm  存在多选，分号分隔 ';'
  authen_algorithm varchar(128),--ipsec-vpn/ike-proposal/auth-algorithm         存在多选，分号分隔 ';'
  integrity_algorithm varchar(128) DEFAULT NULL,--ipsec-vpn/ike-proposal/integrity-algorithm    存在多选，分号分隔 ';'
  prf varchar(128) DEFAULT NULL,--ipsec-vpn/ike-proposal/prf        存在多选，分号分隔 ';'
  dh_group varchar(128) DEFAULT NULL,--ipsec-vpn/ike-proposal/dh    存在多选，分号分隔 ';'
  auth_mode varchar(16) DEFAULT NULL,--ipsec-vpn/ike-proposal/auth-mode
  sa_duration decimal(10,0) DEFAULT NULL,--ipsec-vpn/ike-proposal/lifetime
  ike_peer_id varchar(128),--belong to ike peer
  CREATED_TIME TIMESTAMP WITH TIME ZONE, --'创建时间'
  UPDATED_TIME TIMESTAMP WITH TIME ZONE --'更新时间'
);
ALTER TABLE tab_secm_ipsec_ikeproposal OWNER TO OSSDBUSER;

-- ----------------------------
-- Records of tab_secm_ipsec_ikeproposal
-- ----------------------------


-- ----------------------------
-- Table structure for tab_secm_ipsec_ipsecproposal
-- ----------------------------
DROP TABLE IF EXISTS tab_secm_ipsec_ipsecproposal;
CREATE TABLE tab_secm_ipsec_ipsecproposal (
  id varchar(128) NOT NULL primary key,
  ne_id varchar(128) NOT NULL,--设备id
  proposal_name varchar(32) NOT NULL,--ipsec-vpn/ipsec-proposal/name    设备级唯一
  trans_protocal varchar(32) DEFAULT NULL,--ipsec-vpn/ipsec-proposal/transform-protocol
  encap_mode varchar(32) DEFAULT NULL,--ipsec-vpn/ipsec-proposal/encapsulation-mode
  ah_authen varchar(128) DEFAULT NULL,--ipsec-vpn/ipsec-proposal/ah-auth-algorithm  存在多选，分号分隔 ';'
  esp_authen varchar(128) DEFAULT NULL,--ipsec-vpn/ipsec-proposal/esp-auth-algorithm    存在多选，分号分隔 ';'
  esp_encrypt varchar(128) DEFAULT NULL,--ipsec-vpn/ipsec-proposal/esp-encryption-algorithm 存在多选，分号分隔 ';'
  ipsec_policy_id varchar(512),--belong to ipsec policy
  CREATED_TIME TIMESTAMP WITH TIME ZONE, --'创建时间'
  UPDATED_TIME TIMESTAMP WITH TIME ZONE --'更新时间'
);
ALTER TABLE tab_secm_ipsec_ipsecproposal OWNER TO OSSDBUSER;

-- ----------------------------
-- Table structure for tab_secm_ipsec_security_acl
-- ----------------------------
DROP TABLE IF EXISTS tab_secm_ipsec_security_acl;
CREATE TABLE tab_secm_ipsec_security_acl (
  id varchar(128) NOT NULL primary key,
  ne_id varchar(128) NOT NULL,--设备id
  acl_id decimal(10,0) NOT NULL,--access-lists/access-list/access-control-list-name   设备级唯一
  vsys varchar(32) DEFAULT 'public',--access-lists/access-list/hw-acl:vsys
  rule_num decimal(10,0) DEFAULT NULL ,--access-lists/access-list/access-list-entries/access-list-entry/rule-name
  protocol_name decimal(3,0) DEFAULT NULL,--access-lists/access-list/access-list-entries/access-list-entry/matches/protocol     0-255
  src_address varchar(32) DEFAULT NULL,--access-lists/access-list/access-list-entries/access-list-entry/matches/source-ipv4-network   any时值为空
  dst_address varchar(32) DEFAULT NULL,--access-lists/access-list/access-list-entries/access-list-entry/matches/destination-ipv4-network   any是值为空
  src_lower_port decimal(6,0) DEFAULT NULL,--access-lists/access-list/access-list-entries/access-list-entry/matches/source-port-range   :  lower-port               0-65535
  src_upper_port decimal(6,0) DEFAULT NULL,--access-lists/access-list/access-list-entries/access-list-entry/matches/source-port-range   :  upper-port         0-65535
  dst_lower_port decimal(6,0) DEFAULT NULL,--access-lists/access-list/access-list-entries/access-list-entry/matches/destination-port-range  :  lower-port           0-65535
  dst_upper_port decimal(6,0) DEFAULT NULL,--access-lists/access-list/access-list-entries/access-list-entry/matches/destination-port-range  :  upper-port     0-65535
  action_type varchar(16) DEFAULT NULL,--access-lists/access-list/access-list-entries/access-list-entry/actions   加密：permit   不加密：deny
  ipsec_policy_id varchar(512),--belong to ipsec policy
  source varchar(32) DEFAULT NULL, --'来源字段'
  CREATED_TIME TIMESTAMP WITH TIME ZONE, --'创建时间'
  UPDATED_TIME TIMESTAMP WITH TIME ZONE --'更新时间'
);
ALTER TABLE tab_secm_ipsec_security_acl OWNER TO OSSDBUSER;

DROP TABLE IF EXISTS tab_secm_ipsec_policy_deploy;
CREATE TABLE tab_secm_ipsec_policy_deploy (
  id varchar(512) NOT NULL primary key,
  ne_id varchar(128) NOT NULL,--设备id
  ne_policy_name varchar(128) NOT NULL,--ipsec-vpn/ipsec-connection/name        设备级唯一
  vsys varchar(32) DEFAULT 'public',--ipsec-vpn/ipsec-connection/vsys
  secnario varchar(32) NOT NULL DEFAULT 'p2p-protection',--ipsec-vpn/ipsec-connection/secnario 目前无作用，默认填 p2p-protection
  peer_ip varchar(512) DEFAULT NULL,--ipsec-vpn/ipsec-connection/peer-address
  local_if_name varchar(64) DEFAULT NULL,--ipsec-vpn/ipsec-connection/local-information/interface-name
  local_ip varchar(32) DEFAULT NULL,--ipsec-vpn/ipsec-connection/local-information/local-address/ip-address
  --ipsec-vpn/ipsec-connection/local-information/local-address/use-interface-address 可能不需要
  ike_peer_name varchar(32) DEFAULT NULL,--ike-peer表的peer_name
  proposal_name varchar(256) DEFAULT NULL,--ipsec-vpn/ipsec-connection/ipsec-proposal    ipsec-proposal表的proposal_id
  security_acl varchar(64) DEFAULT NULL,--ipsec-vpn/ipsec-connection/acl   同acl表的acl_id
  pfs varchar(128) DEFAULT NULL,--ipsec-vpn/ipsec-connection/pfs
  sa_duration_sec decimal(10,0) DEFAULT NULL,--ipsec-vpn/ipsec-connection/lifetime-seconds
  sa_duration_kb decimal(10,0) DEFAULT NULL,--ipsec-vpn/ipsec-connection/lifetime-kilobytes
  smart_link_profile varchar(32), -------智能选路模板名称
  reverse_route varchar(32), ----反向注入路由
  route_level varchar(32), ----路由优先级
  admin_state varchar(16) DEFAULT 'Up',
  group_id varchar(128), --belong to ipsec_group
  source varchar(16), --来源
  dynamic_ip boolean, ---是否是动态ip
  peer_interface_name varchar(1024),
  CREATED_TIME TIMESTAMP WITH TIME ZONE, --'创建时间'
  UPDATED_TIME TIMESTAMP WITH TIME ZONE --'更新时间'
);
ALTER TABLE tab_secm_ipsec_policy_deploy OWNER TO OSSDBUSER;
ALTER TABLE TAB_SECM_IPSEC_POLICY_DEPLOY ADD CONSTRAINT UNIQUE_IPSEC_POLICY_DEVICE_DEPLOY UNIQUE(NE_POLICY_NAME, VSYS, NE_ID);
-- ----------------------------
-- Table structure for tab_secm_ipsec_ikepeer_deploy
-- ----------------------------
DROP TABLE IF EXISTS tab_secm_ipsec_ikepeer_deploy;
CREATE TABLE tab_secm_ipsec_ikepeer_deploy (
  id varchar(128) NOT NULL primary key,
  ne_id varchar(128) NOT NULL,  --设备id
  peer_name varchar(32) NULL,   --ike对等体名
  proposal_id decimal(10,0) DEFAULT NULL, --ike提议主键（+device_id） ipsec-vpn/ipsec-connection/ike-param/ike-proposal
  ike_version varchar(16) DEFAULT NULL, --ipsec-connection/ike-param/ike-version
  phase1_mode varchar(16) DEFAULT NULL, --ipsec-vpn/ipsec-connection/ike-param/phase1-mode
  local_id_type varchar(16) DEFAULT NULL,--ipsec-vpn/ipsec-connection/ike-param/local-id/type
  local_name varchar(256) DEFAULT NULL,--ipsec-vpn/ipsec-connection/ike-param/local-id/value
  remote_id_type varchar(16) DEFAULT NULL,--ipsec-vpn/ipsec-connection/ike-param/peer-id/type
  remote_name varchar(256) DEFAULT NULL,--ipsec-vpn/ipsec-connection/ike-param/peer-id/value
  pki_domain varchar(128) DEFAULT NULL,--psec-vpn/ipsec-connection/ike-param/certificate/pki-realm-name
  local_cert_name varchar(128) DEFAULT NULL,--ipsec-vpn/ipsec-connection/ike-param/certificate/local-certificate-filename
  remote_cert_name varchar(128) DEFAULT NULL,--ipsec-vpn/ipsec-connection/ike-param/certificate/peer-certificate-filename
  pre_shared_key varchar(1024) DEFAULT NULL,--ipsec-vpn/ipsec-connection/ike-param/pre-shared-key
  dpd_type varchar(16) DEFAULT NULL,--ipsec-vpn/ipsec-connection/ike-param/dpd/type
  dpd_interval decimal(10,0) DEFAULT NULL,--ipsec-vpn/ipsec-connection/ike-param/dpd/interval
  dpd_timeout decimal(10,0) DEFAULT NULL,--ipsec-vpn/ipsec-connection/ike-param/dpd/timeout
  ipsec_policy_id varchar(512),--belong to ipsec policy
  CREATED_TIME TIMESTAMP WITH TIME ZONE, --'创建时间'
  UPDATED_TIME TIMESTAMP WITH TIME ZONE --'更新时间'
);
ALTER TABLE tab_secm_ipsec_ikepeer_deploy OWNER TO OSSDBUSER;
-- ----------------------------
-- Table structure for tab_secm_ipsec_ikeproposal_deploy
-- ----------------------------
DROP TABLE IF EXISTS tab_secm_ipsec_ikeproposal_deploy;
CREATE TABLE tab_secm_ipsec_ikeproposal_deploy (
  id varchar(128) NOT NULL primary key,
  ne_id varchar(128) NOT NULL,--设备id
  proposal_id decimal(10,0) NOT NULL,--ipsec-vpn/ike-proposal/id        设备级唯一
  encrypt_algorithm varchar(128),--ipsec-vpn/ike-proposal/encryption-algorithm  存在多选，分号分隔 ';'
  authen_algorithm varchar(128),--ipsec-vpn/ike-proposal/auth-algorithm         存在多选，分号分隔 ';'
  integrity_algorithm varchar(128) DEFAULT NULL,--ipsec-vpn/ike-proposal/integrity-algorithm    存在多选，分号分隔 ';'
  prf varchar(128) DEFAULT NULL,--ipsec-vpn/ike-proposal/prf        存在多选，分号分隔 ';'
  dh_group varchar(128) DEFAULT NULL,--ipsec-vpn/ike-proposal/dh    存在多选，分号分隔 ';'
  auth_mode varchar(16) DEFAULT NULL,--ipsec-vpn/ike-proposal/auth-mode
  sa_duration decimal(10,0) DEFAULT NULL,--ipsec-vpn/ike-proposal/lifetime
  ike_peer_id varchar(128),--belong to ike peer
  peer_ids varchar(128)[],--belong to ike peer
  CREATED_TIME TIMESTAMP WITH TIME ZONE, --'创建时间'
  UPDATED_TIME TIMESTAMP WITH TIME ZONE --'更新时间'
);
ALTER TABLE tab_secm_ipsec_ikeproposal_deploy OWNER TO OSSDBUSER;
ALTER TABLE TAB_SECM_IPSEC_IKEPROPOSAL_DEPLOY ADD CONSTRAINT UNIQUE_IKEPROPOSAL_NAME_DEVICE_DEPLOY UNIQUE(PROPOSAL_ID, NE_ID);
-- ----------------------------
-- Records of tab_secm_ipsec_ikeproposal_deploy
-- ----------------------------


-- ----------------------------
-- Table structure for tab_secm_ipsec_ipsecproposal_deploy
-- ----------------------------
DROP TABLE IF EXISTS tab_secm_ipsec_ipsecproposal_deploy;
CREATE TABLE tab_secm_ipsec_ipsecproposal_deploy (
  id varchar(128) NOT NULL primary key,
  ne_id varchar(128) NOT NULL,--设备id
  proposal_name varchar(32) NOT NULL,--ipsec-vpn/ipsec-proposal/name    设备级唯一
  trans_protocal varchar(32) DEFAULT NULL,--ipsec-vpn/ipsec-proposal/transform-protocol
  encap_mode varchar(32) DEFAULT NULL,--ipsec-vpn/ipsec-proposal/encapsulation-mode
  ah_authen varchar(128) DEFAULT NULL,--ipsec-vpn/ipsec-proposal/ah-auth-algorithm  存在多选，分号分隔 ';'
  esp_authen varchar(128) DEFAULT NULL,--ipsec-vpn/ipsec-proposal/esp-auth-algorithm    存在多选，分号分隔 ';'
  esp_encrypt varchar(128) DEFAULT NULL,--ipsec-vpn/ipsec-proposal/esp-encryption-algorithm 存在多选，分号分隔 ';'
  ipsec_policy_id varchar(512),--belong to ipsec policy
  ipsec_policy_ids varchar(512)[],--belong to ipsec policy
  CREATED_TIME TIMESTAMP WITH TIME ZONE, --'创建时间'
  UPDATED_TIME TIMESTAMP WITH TIME ZONE --'更新时间'
);
ALTER TABLE tab_secm_ipsec_ipsecproposal_deploy OWNER TO OSSDBUSER;
ALTER TABLE TAB_SECM_IPSEC_IPSECPROPOSAL_DEPLOY ADD CONSTRAINT UNIQUE_IPSECPROPOSAL_NAME_DEVICE_DEPLOY UNIQUE(PROPOSAL_NAME, NE_ID);
-- ----------------------------
-- Table structure for tab_secm_ipsec_security_acl_deploy
-- ----------------------------
DROP TABLE IF EXISTS tab_secm_ipsec_security_acl_deploy;
CREATE TABLE tab_secm_ipsec_security_acl_deploy (
  id varchar(128) NOT NULL primary key,
  ne_id varchar(128) NOT NULL,--设备id
  acl_id decimal(10,0) NOT NULL,--access-lists/access-list/access-control-list-name   设备级唯一
  vsys varchar(32) DEFAULT 'public',--access-lists/access-list/hw-acl:vsys
  rule_num decimal(10,0) DEFAULT NULL ,--access-lists/access-list/access-list-entries/access-list-entry/rule-name
  protocol_name decimal(3,0) DEFAULT NULL,--access-lists/access-list/access-list-entries/access-list-entry/matches/protocol     0-255
  src_address varchar(32) DEFAULT NULL,--access-lists/access-list/access-list-entries/access-list-entry/matches/source-ipv4-network   any时值为空
  dst_address varchar(32) DEFAULT NULL,--access-lists/access-list/access-list-entries/access-list-entry/matches/destination-ipv4-network   any是值为空
  src_lower_port decimal(6,0) DEFAULT NULL,--access-lists/access-list/access-list-entries/access-list-entry/matches/source-port-range   :  lower-port               0-65535
  src_upper_port decimal(6,0) DEFAULT NULL,--access-lists/access-list/access-list-entries/access-list-entry/matches/source-port-range   :  upper-port         0-65535
  dst_lower_port decimal(6,0) DEFAULT NULL,--access-lists/access-list/access-list-entries/access-list-entry/matches/destination-port-range  :  lower-port           0-65535
  dst_upper_port decimal(6,0) DEFAULT NULL,--access-lists/access-list/access-list-entries/access-list-entry/matches/destination-port-range  :  upper-port     0-65535
  action_type varchar(16) DEFAULT NULL,--access-lists/access-list/access-list-entries/access-list-entry/actions   加密：permit   不加密：deny
  ipsec_policy_id varchar(512),--belong to ipsec policy
  ipsec_policy_ids varchar(512)[],--belong to ipsec policy
  address_object_id varchar(128),--地址对象ID，预留，后续拓展使用
  CREATED_TIME TIMESTAMP WITH TIME ZONE, --'创建时间'
  UPDATED_TIME TIMESTAMP WITH TIME ZONE --'更新时间'
);
ALTER TABLE tab_secm_ipsec_security_acl_deploy OWNER TO OSSDBUSER;
ALTER TABLE TAB_SECM_IPSEC_SECURITY_ACL_DEPLOY ADD CONSTRAINT UNIQUE_ACL_NAME_DEVICE_DEPLOY UNIQUE(ACL_ID, RULE_NUM, VSYS, NE_ID);

DROP TABLE IF EXISTS tab_secm_ipsec_policy_ngfw;
CREATE TABLE tab_secm_ipsec_policy_ngfw (
  id varchar(512) NOT NULL primary key,
  ne_id varchar(128) NOT NULL,--设备id
  ne_policy_name varchar(128) NOT NULL,--ipsec-vpn/ipsec-connection/name        设备级唯一
  vsys varchar(32) DEFAULT 'public',--ipsec-vpn/ipsec-connection/vsys  目前无作用，默认public
  secnario varchar(32) NOT NULL DEFAULT 'p2p-protection',--ipsec-vpn/ipsec-connection/secnario 目前无作用，默认填 p2p-protection
  peer_ip varchar(512) DEFAULT NULL,--ipsec-vpn/ipsec-connection/peer-address
  local_if_name varchar(64) DEFAULT NULL,--ipsec-vpn/ipsec-connection/local-information/interface-name
  local_ip varchar(32) DEFAULT NULL,--ipsec-vpn/ipsec-connection/local-information/local-address/ip-address
  --ipsec-vpn/ipsec-connection/local-information/local-address/use-interface-address 可能不需要
  ike_peer_name varchar(32) DEFAULT NULL,--ike-peer表的peer_name
  proposal_name varchar(256) DEFAULT NULL,--ipsec-vpn/ipsec-connection/ipsec-proposal    ipsec-proposal表的proposal_id
  security_acl varchar(64) DEFAULT NULL,--ipsec-vpn/ipsec-connection/acl   同acl表的acl_id
  pfs varchar(128) DEFAULT NULL,--ipsec-vpn/ipsec-connection/pfs
  sa_duration_sec decimal(10,0) DEFAULT NULL,--ipsec-vpn/ipsec-connection/lifetime-seconds
  sa_duration_kb decimal(10,0) DEFAULT NULL,--ipsec-vpn/ipsec-connection/lifetime-kilobytes
  smart_link_profile varchar(32), -------智能选路模板名称
  reverse_route varchar(32), ----反向注入路由
  route_level varchar(32), ----路由优先级
  admin_state varchar(16) DEFAULT 'Up',
  dynamic_ip boolean, ---是否是动态ip
  peer_interface_name varchar(1024),
  CREATED_TIME TIMESTAMP WITH TIME ZONE, --'创建时间'
  UPDATED_TIME TIMESTAMP WITH TIME ZONE --'更新时间'
);
ALTER TABLE tab_secm_ipsec_policy_ngfw OWNER TO OSSDBUSER;
ALTER TABLE TAB_SECM_IPSEC_POLICY_NGFW ADD CONSTRAINT UNIQUE_IPSEC_POLICY_DEVICE_NGFW UNIQUE(NE_POLICY_NAME, VSYS, NE_ID);
-- ----------------------------
-- Table structure for tab_secm_ipsec_ikepeer_ngfw
-- ----------------------------
DROP TABLE IF EXISTS tab_secm_ipsec_ikepeer_ngfw;
CREATE TABLE tab_secm_ipsec_ikepeer_ngfw (
  id varchar(128) NOT NULL primary key,
  ne_id varchar(128) NOT NULL,  --设备id
  peer_name varchar(32) DEFAULT NULL,   --ike对等体名
  proposal_id decimal(10,0) DEFAULT NULL, --ike提议主键（+device_id） ipsec-vpn/ipsec-connection/ike-param/ike-proposal
  ike_version varchar(16) DEFAULT NULL, --ipsec-connection/ike-param/ike-version
  phase1_mode varchar(16) DEFAULT NULL, --ipsec-vpn/ipsec-connection/ike-param/phase1-mode
  local_id_type varchar(16) DEFAULT NULL,--ipsec-vpn/ipsec-connection/ike-param/local-id/type
  local_name varchar(256) DEFAULT NULL,--ipsec-vpn/ipsec-connection/ike-param/local-id/value
  remote_id_type varchar(16) DEFAULT NULL,--ipsec-vpn/ipsec-connection/ike-param/peer-id/type
  remote_name varchar(256) DEFAULT NULL,--ipsec-vpn/ipsec-connection/ike-param/peer-id/value
  pki_domain varchar(128) DEFAULT NULL,--psec-vpn/ipsec-connection/ike-param/certificate/pki-realm-name
  local_cert_name varchar(128) DEFAULT NULL,--ipsec-vpn/ipsec-connection/ike-param/certificate/local-certificate-filename
  remote_cert_name varchar(128) DEFAULT NULL,--ipsec-vpn/ipsec-connection/ike-param/certificate/peer-certificate-filename
  pre_shared_key varchar(1024) DEFAULT NULL,--ipsec-vpn/ipsec-connection/ike-param/pre-shared-key
  dpd_type varchar(16) DEFAULT NULL,--ipsec-vpn/ipsec-connection/ike-param/dpd/type
  dpd_interval decimal(10,0) DEFAULT NULL,--ipsec-vpn/ipsec-connection/ike-param/dpd/interval
  dpd_timeout decimal(10,0) DEFAULT NULL,--ipsec-vpn/ipsec-connection/ike-param/dpd/timeout
  ipsec_policy_id varchar(512),--belong to ipsec policy
  CREATED_TIME TIMESTAMP WITH TIME ZONE, --'创建时间'
  UPDATED_TIME TIMESTAMP WITH TIME ZONE --'更新时间'
);
ALTER TABLE tab_secm_ipsec_ikepeer_ngfw OWNER TO OSSDBUSER;
-- ----------------------------
-- Table structure for tab_secm_ipsec_ikeproposal_ngfw
-- ----------------------------
DROP TABLE IF EXISTS tab_secm_ipsec_ikeproposal_ngfw;
CREATE TABLE tab_secm_ipsec_ikeproposal_ngfw (
  id varchar(128) NOT NULL primary key,
  ne_id varchar(128) NOT NULL,--设备id
  proposal_id decimal(10,0) NOT NULL,--ipsec-vpn/ike-proposal/id        设备级唯一
  encrypt_algorithm varchar(128),--ipsec-vpn/ike-proposal/encryption-algorithm  存在多选，分号分隔 ';'
  authen_algorithm varchar(128),--ipsec-vpn/ike-proposal/auth-algorithm         存在多选，分号分隔 ';'
  integrity_algorithm varchar(128) DEFAULT NULL,--ipsec-vpn/ike-proposal/integrity-algorithm    存在多选，分号分隔 ';'
  prf varchar(128) DEFAULT NULL,--ipsec-vpn/ike-proposal/prf        存在多选，分号分隔 ';'
  dh_group varchar(128) DEFAULT NULL,--ipsec-vpn/ike-proposal/dh    存在多选，分号分隔 ';'
  auth_mode varchar(16) DEFAULT NULL,--ipsec-vpn/ike-proposal/auth-mode
  sa_duration decimal(10,0) DEFAULT NULL,--ipsec-vpn/ike-proposal/lifetime
  ike_peer_id varchar(128),--belong to ike peer
  peer_ids varchar(128)[],--belong to ike peer
  CREATED_TIME TIMESTAMP WITH TIME ZONE, --'创建时间'
  UPDATED_TIME TIMESTAMP WITH TIME ZONE --'更新时间'
);
ALTER TABLE tab_secm_ipsec_ikeproposal_ngfw OWNER TO OSSDBUSER;
ALTER TABLE TAB_SECM_IPSEC_IKEPROPOSAL_NGFW ADD CONSTRAINT UNIQUE_IKEPROPOSAL_NAME_DEVICE_NGFW UNIQUE(PROPOSAL_ID, NE_ID);
-- ----------------------------
-- Records of tab_secm_ipsec_ikeproposal_ngfw
-- ----------------------------


-- ----------------------------
-- Table structure for tab_secm_ipsec_ipsecproposal_ngfw
-- ----------------------------
DROP TABLE IF EXISTS tab_secm_ipsec_ipsecproposal_ngfw;
CREATE TABLE tab_secm_ipsec_ipsecproposal_ngfw (
  id varchar(128) NOT NULL primary key,
  ne_id varchar(128) NOT NULL,--设备id
  proposal_name varchar(32) NOT NULL,--ipsec-vpn/ipsec-proposal/name    设备级唯一
  trans_protocal varchar(32) DEFAULT NULL,--ipsec-vpn/ipsec-proposal/transform-protocol
  encap_mode varchar(32) DEFAULT NULL,--ipsec-vpn/ipsec-proposal/encapsulation-mode
  ah_authen varchar(128) DEFAULT NULL,--ipsec-vpn/ipsec-proposal/ah-auth-algorithm  存在多选，分号分隔 ';'
  esp_authen varchar(128) DEFAULT NULL,--ipsec-vpn/ipsec-proposal/esp-auth-algorithm    存在多选，分号分隔 ';'
  esp_encrypt varchar(128) DEFAULT NULL,--ipsec-vpn/ipsec-proposal/esp-encryption-algorithm 存在多选，分号分隔 ';'
  ipsec_policy_id varchar(512),--belong to ipsec policy
  ipsec_policy_ids varchar(512)[],--belong to ipsec policy
  CREATED_TIME TIMESTAMP WITH TIME ZONE, --'创建时间'
  UPDATED_TIME TIMESTAMP WITH TIME ZONE --'更新时间'
);
ALTER TABLE tab_secm_ipsec_ipsecproposal_ngfw OWNER TO OSSDBUSER;
ALTER TABLE TAB_SECM_IPSEC_IPSECPROPOSAL_NGFW ADD CONSTRAINT UNIQUE_IPSECPROPOSAL_NAME_DEVICE_NGFW UNIQUE(PROPOSAL_NAME, NE_ID);
-- ----------------------------
-- Table structure for tab_secm_ipsec_security_acl_ngfw
-- ----------------------------
DROP TABLE IF EXISTS tab_secm_ipsec_security_acl_ngfw;
CREATE TABLE tab_secm_ipsec_security_acl_ngfw (
  id varchar(128) NOT NULL primary key,
  ne_id varchar(128) NOT NULL,--设备id
  acl_id decimal(10,0) NOT NULL,--access-lists/access-list/access-control-list-name   设备级唯一
  vsys varchar(32) DEFAULT 'public',--access-lists/access-list/hw-acl:vsys
  rule_num decimal(10,0) DEFAULT NULL ,--access-lists/access-list/access-list-entries/access-list-entry/rule-name
  protocol_name decimal(3,0) DEFAULT NULL,--access-lists/access-list/access-list-entries/access-list-entry/matches/protocol     0-255
  src_address varchar(32) DEFAULT NULL,--access-lists/access-list/access-list-entries/access-list-entry/matches/source-ipv4-network   any时值为空
  dst_address varchar(32) DEFAULT NULL,--access-lists/access-list/access-list-entries/access-list-entry/matches/destination-ipv4-network   any是值为空
  src_lower_port decimal(6,0) DEFAULT NULL,--access-lists/access-list/access-list-entries/access-list-entry/matches/source-port-range   :  lower-port               0-65535
  src_upper_port decimal(6,0) DEFAULT NULL,--access-lists/access-list/access-list-entries/access-list-entry/matches/source-port-range   :  upper-port         0-65535
  dst_lower_port decimal(6,0) DEFAULT NULL,--access-lists/access-list/access-list-entries/access-list-entry/matches/destination-port-range  :  lower-port           0-65535
  dst_upper_port decimal(6,0) DEFAULT NULL,--access-lists/access-list/access-list-entries/access-list-entry/matches/destination-port-range  :  upper-port     0-65535
  action_type varchar(16) DEFAULT NULL,--access-lists/access-list/access-list-entries/access-list-entry/actions   加密：permit   不加密：deny
  ipsec_policy_id varchar(512),--belong to ipsec policy
  ipsec_policy_ids varchar(512)[],--belong to ipsec policy
  address_object_id varchar(512),--地址对象ID，预留，后续拓展使用
  CREATED_TIME TIMESTAMP WITH TIME ZONE, --'创建时间'
  UPDATED_TIME TIMESTAMP WITH TIME ZONE --'更新时间'
);
ALTER TABLE tab_secm_ipsec_security_acl_ngfw OWNER TO OSSDBUSER;
ALTER TABLE TAB_SECM_IPSEC_SECURITY_ACL_NGFW ADD CONSTRAINT UNIQUE_ACL_NAME_DEVICE_NGFW UNIQUE(ACL_ID, RULE_NUM, VSYS, NE_ID);
-- ----------------------------
-- Table structure for tab_secm_Ipsec_device
-- ----------------------------
DROP TABLE IF EXISTS tab_secm_Ipsec_policy_template;
CREATE TABLE tab_secm_Ipsec_policy_template(
    ID VARCHAR(128) NOT NULL PRIMARY KEY,  --'主键 主键，UUID'
    NAME VARCHAR(128) NOT NULL,   --'名称 IPsec策略模板的名称'
    DESCRIPTION VARCHAR(512),    --'描述'
    NE_ID VARCHAR(128),    --'设备id 作为本端设备的时候，该字段不能为空'
    vsys_name VARCHAR(128),
    INTERFACE_NAME VARCHAR(128),    --'接口名称 作为本端设备的时候，该字段不能为空'
    DEVICE_NAME VARCHAR(128),    --'设备名称 作为本端设备的时候，该字段不能为空'
    INTERFACE_IP VARCHAR(64),   --'接口ip'
    ADDRESS_IP VARCHAR(512),    --'加密网段 cidr格式的ipv4地址，逗号分隔，最大20个。'
    CERT_NAME VARCHAR(256),    --'证书名称'
    PKI_NAME VARCHAR(256),    --'PKI域名'
    local_id_type VARCHAR(256),    --'本端ID类型'
    local_id_value VARCHAR(256),    --'本端ID 值'
    pre_shared_key VARCHAR(1024),  --'预共享密钥'
    dynamic_ip boolean, --'是否使用动态ip'
    any_remote_id boolean, ---'是否接受任意对端Id'
    CREATED_TIME TIMESTAMP WITH TIME ZONE, --'创建时间'
    UPDATED_TIME TIMESTAMP WITH TIME ZONE --'更新时间'
);
ALTER TABLE tab_secm_Ipsec_policy_template OWNER TO OSSDBUSER;

-- ----------------------------
-- Table structure for tab_secm_Ipsec_device_mapping
-- ----------------------------
DROP TABLE IF EXISTS tab_secm_Ipsec_policy_template_mapping;
CREATE TABLE tab_secm_Ipsec_policy_template_mapping(
    ID VARCHAR(128) NOT NULL PRIMARY KEY,  --'主键' ,
    GROUP_ID VARCHAR(128) NOT NULL,  --'ipSec策略组ID' ,
    IPSEC_DEVICE_ID VARCHAR(128) NOT NULL,  --'策略模板ID' ,
    ROLE VARCHAR(32) NOT NULL DEFAULT 'Spoke'  --'角色 该设备模板在该业务组中的角色。枚举值：Hub/Spoke' ,
);
ALTER TABLE tab_secm_Ipsec_policy_template_mapping OWNER TO OSSDBUSER;

-- ----------------------------
-- Table structure for tab_secm_ipsec_smartLink_profile
-- ----------------------------
DROP TABLE IF EXISTS tab_secm_ipsec_smartLink_profile;
CREATE TABLE tab_secm_ipsec_smartLink_profile(
    ID VARCHAR(128) NOT NULL PRIMARY KEY,  --'主键' ,
    NE_ID varchar(128) NOT NULL,  --'设备id' ,
    PROFILE_NAME VARCHAR(128) NOT NULL,  --'模板名称' ,
    POLICY_ID VARCHAR(512),  --'策略ID' ,
    VSYS_NAME VARCHAR(64),   --'VSYSNAME' ,
    LINK_QUALITY_DETECTION boolean, --'是否打开探测开关'，
    LINK_SWITCH_MODE VARCHAR(32),  --'选路切换模式',
    MAX_SWITCH_CYCLES INTEGER,  --'链路切换次数',
    TIME_INTERVAL INTEGER, --'时间发送间隔',
    PACKET_NUMBER INTEGER, --'探测报文总数',
    SOURCE_ADDRESS VARCHAR(32), --'探测原地址',
    DESTINATION_ADDRESS VARCHAR(32), --'探测目的地址',
    LOSS_RATE INTEGER, --'丢包率',
    DELAY INTEGER, --'时延',
    CREATED_TIME TIMESTAMP WITH TIME ZONE, --'创建时间'
    UPDATED_TIME TIMESTAMP WITH TIME ZONE --'更新时间'
);
ALTER TABLE tab_secm_ipsec_smartLink_profile OWNER TO OSSDBUSER;

-- ----------------------------
-- Table structure for tab_secm_ipsec_smartLink_profile_deploy
-- ----------------------------
DROP TABLE IF EXISTS tab_secm_ipsec_smartLink_profile_deploy;
CREATE TABLE tab_secm_ipsec_smartLink_profile_deploy(
    ID VARCHAR(128) NOT NULL PRIMARY KEY,  --'主键' ,
    NE_ID varchar(128) NOT NULL,  --'设备id' ,
    PROFILE_NAME VARCHAR(128) NOT NULL,  --'模板名称' ,
    POLICY_IDS VARCHAR(512)[],  --'策略ID' ,
    VSYS_NAME VARCHAR(64),   --'VSYSNAME' ,
    LINK_QUALITY_DETECTION boolean, --'是否打开探测开关'，
    LINK_SWITCH_MODE VARCHAR(32),  --'选路切换模式',
    MAX_SWITCH_CYCLES INTEGER,  --'链路切换次数',
    TIME_INTERVAL INTEGER, --'时间发送间隔',
    PACKET_NUMBER INTEGER, --'探测报文总数',
    SOURCE_ADDRESS VARCHAR(32), --'探测原地址',
    DESTINATION_ADDRESS VARCHAR(32), --'探测目的地址',
    LOSS_RATE INTEGER, --'丢包率',
    DELAY INTEGER, --'时延',
    CREATED_TIME TIMESTAMP WITH TIME ZONE, --'创建时间'
    UPDATED_TIME TIMESTAMP WITH TIME ZONE --'更新时间'
);
ALTER TABLE tab_secm_ipsec_smartLink_profile_deploy OWNER TO OSSDBUSER;

-- ----------------------------
-- Table structure for tab_secm_ipsec_smartLink_profile_ngfw
-- ----------------------------
DROP TABLE IF EXISTS tab_secm_ipsec_smartLink_profile_ngfw;
CREATE TABLE tab_secm_ipsec_smartLink_profile_ngfw(
    ID VARCHAR(128) NOT NULL PRIMARY KEY,  --'主键' ,
    NE_ID varchar(128) NOT NULL,  --'设备id' ,
    PROFILE_NAME VARCHAR(128) NOT NULL,  --'模板名称' ,
    POLICY_IDS VARCHAR(512)[],  --'策略ID' ,
    VSYS_NAME VARCHAR(64),   --'VSYSNAME' ,
    INTERFACE_NAME VARCHAR(64),   --'INTERFACE NAME' ,
    PEER_IP VARCHAR(512),   --'PEER IP' ,
    LINK_QUALITY_DETECTION boolean, --'是否打开探测开关'，
    LINK_SWITCH_MODE VARCHAR(32),  --'选路切换模式',
    MAX_SWITCH_CYCLES INTEGER,  --'链路切换次数',
    TIME_INTERVAL INTEGER, --'时间发送间隔',
    PACKET_NUMBER INTEGER, --'探测报文总数',
    SOURCE_ADDRESS VARCHAR(32), --'探测原地址',
    DESTINATION_ADDRESS VARCHAR(32), --'探测目的地址',
    LOSS_RATE INTEGER, --'丢包率',
    DELAY INTEGER, --'时延',
    CREATED_TIME TIMESTAMP WITH TIME ZONE, --'创建时间'
    UPDATED_TIME TIMESTAMP WITH TIME ZONE --'更新时间'
);
ALTER TABLE tab_secm_ipsec_smartLink_profile_ngfw OWNER TO OSSDBUSER;

-- ----------------------------
-- Table structure for tab_secm_ipsec_ike_user
-- ----------------------------
DROP TABLE IF EXISTS tab_secm_ipsec_ike_user;
CREATE TABLE tab_secm_ipsec_ike_user(
    ID VARCHAR(128) NOT NULL PRIMARY KEY,  --'主键' ,
    NE_ID varchar(128) NOT NULL,  --'设备id' ,
    USER_NAME VARCHAR(128) NOT NULL,  --'用户名' ,
    POLICY_ID VARCHAR(512) NOT NULL,  --'策略ID' ,
    DESCRIPTION VARCHAR(32),   --'描述' ,
    ID_TYPE VARCHAR(64), --'id类型'，
    ID_VALUE VARCHAR(64),  --'ID值',
    PRE_SHARED_KEY VARCHAR(1024),  --'预共享密钥',
    SPOKE_TEMPLATE_ID VARCHAR(64),
    CREATED_TIME TIMESTAMP WITH TIME ZONE, --'创建时间'
    UPDATED_TIME TIMESTAMP WITH TIME ZONE --'更新时间'
);
ALTER TABLE tab_secm_ipsec_ike_user OWNER TO OSSDBUSER;


-- ----------------------------
-- Table structure for tab_secm_ipsec_ike_user_deploy
-- ----------------------------
DROP TABLE IF EXISTS tab_secm_ipsec_ike_user_deploy;
CREATE TABLE tab_secm_ipsec_ike_user_deploy(
    ID VARCHAR(128) NOT NULL PRIMARY KEY,  --'主键' ,
    NE_ID varchar(128) NOT NULL,  --'设备id' ,
    USER_NAME VARCHAR(128) NOT NULL,  --'用户名' ,
    POLICY_ID VARCHAR(512) NOT NULL,  --'策略ID' ,
    DESCRIPTION VARCHAR(32),   --'描述' ,
    ID_TYPE VARCHAR(64), --'id类型'，
    ID_VALUE VARCHAR(64),  --'ID值',
    PRE_SHARED_KEY VARCHAR(1024),  --'预共享密钥',
    CREATED_TIME TIMESTAMP WITH TIME ZONE, --'创建时间'
    UPDATED_TIME TIMESTAMP WITH TIME ZONE --'更新时间'
);
ALTER TABLE tab_secm_ipsec_ike_user_deploy OWNER TO OSSDBUSER;

-- ----------------------------
-- Table structure for tab_secm_ipsec_ike_user_ngfw
-- ----------------------------
DROP TABLE IF EXISTS tab_secm_ipsec_ike_user_ngfw;
CREATE TABLE tab_secm_ipsec_ike_user_ngfw(
    ID VARCHAR(128) NOT NULL PRIMARY KEY,  --'主键' ,
    NE_ID varchar(128) NOT NULL,  --'设备id' ,
    USER_NAME VARCHAR(128) NOT NULL,  --'用户名' ,
    POLICY_ID VARCHAR(512) NOT NULL,  --'策略ID' ,
    DESCRIPTION VARCHAR(32),   --'描述' ,
    ID_TYPE VARCHAR(64), --'id类型'，
    ID_VALUE VARCHAR(64),  --'ID值',
    PRE_SHARED_KEY VARCHAR(1024),  --'预共享密钥',
    CREATED_TIME TIMESTAMP WITH TIME ZONE, --'创建时间'
    UPDATED_TIME TIMESTAMP WITH TIME ZONE --'更新时间'
);
ALTER TABLE tab_secm_ipsec_ike_user_ngfw OWNER TO OSSDBUSER;

-- ----------------------------
-- Table structure for tab_secm_ipsec_monitor_ngfw
-- ----------------------------
DROP TABLE IF EXISTS tab_secm_ipsec_monitor_ngfw;
CREATE TABLE tab_secm_ipsec_monitor_ngfw(
    ID VARCHAR(128) NOT NULL PRIMARY KEY,  --'主键' ,
    NE_ID VARCHAR(128) NOT NULL,  --'设备id' ,
    NE_NAME VARCHAR(512),  --'设备名称' ,
    IPSEC_POLICY_NAME VARCHAR(512),  --'IPSEC策略名称' ,
    LOCAL_INTERFACE VARCHAR(512),   --'本端接口' ,
    REMOTE_IP VARCHAR(512),   --'远端IP地址' ,
    STATUS VARCHAR(64), --'IPSEC连接状态'，
    LOST_COUNT INTEGER,  --'失去连接数',
    LAST_CON_TIME TIMESTAMP WITH TIME ZONE, --'最后一次连接时间'
    LAST_LOST_TIME TIMESTAMP WITH TIME ZONE, --'最后一次失去连接时间'
    CREATED_TIME TIMESTAMP WITH TIME ZONE, --'创建时间'
    UPDATED_TIME TIMESTAMP WITH TIME ZONE --'更新时间'
);
ALTER TABLE tab_secm_ipsec_monitor_ngfw OWNER TO OSSDBUSER;


----废弃表删除
DROP TABLE IF EXISTS tab_secm_ipsec_presharedkey;
DROP TABLE IF EXISTS tab_secm_ipsec_presharedkey_info;
DROP TABLE IF EXISTS tab_secm_ipsec_ikepeer_group;
DROP TABLE IF EXISTS tab_secm_ipsec_ikeproposal_group;
DROP TABLE IF EXISTS tab_secm_ipsec_policy_group;
DROP TABLE IF EXISTS tab_secm_ipsec_ipsecproposal_group;
DROP TABLE IF EXISTS TAB_SECM_IPSEC_SVRTUNNEL;
--19.2.0.001_END

--19.2.0.020_BEGIN
-- ----------------------------
-- Table structure for tab_secm_ipsec_monitor_ngfw
-- ----------------------------
select alter_columns('add', 'tab_secm_ipsec_monitor_ngfw_item', 'SHOW', 'boolean default true');
select alter_columns('add', 'tab_secm_ipsec_monitor_ngfw_item', 'NEGOTIATE_TIME', 'TIMESTAMP WITH TIME ZONE');

-- ----------------------------
-- Table structure for tab_secm_ipsec_monitor_ngfw_item
-- ----------------------------
DROP TABLE IF EXISTS tab_secm_ipsec_monitor_ngfw_item;
CREATE TABLE tab_secm_ipsec_monitor_ngfw_item(
    ID VARCHAR(128) NOT NULL PRIMARY KEY,  --'主键' ,
    NE_NAME VARCHAR(512),  --'设备名称' ,
    IPSEC_MONITOR_ID VARCHAR(128) NOT NULL,  --'关联的ipsec主键id' ,
    IPSEC_POLICY_NAME VARCHAR(512),  --'IPSEC策略名称' ,
    STATUS VARCHAR(64), --'IPSEC连接状态'，
    CREATED_TIME TIMESTAMP WITH TIME ZONE --'创建时间'
);
ALTER TABLE tab_secm_ipsec_monitor_ngfw_item OWNER TO OSSDBUSER;
--19.2.0.020_END

--19.2.0.021_BEGIN
select alter_columns('alter','tab_secm_ipsec_group','description','NVARCHAR2(512)');
select alter_columns('alter','tab_secm_ipsec_group','name','NVARCHAR2(256)');

select alter_columns('alter','tab_secm_Ipsec_policy_template','name','NVARCHAR2(128)');
select alter_columns('alter','tab_secm_Ipsec_policy_template','description','NVARCHAR2(512)');
select alter_columns('alter','tab_secm_Ipsec_policy_template','local_id_value','NVARCHAR2(256)');

select alter_columns('alter','TAB_SECM_IPSEC_IKEPEER','local_name','NVARCHAR2(256)');
select alter_columns('alter','TAB_SECM_IPSEC_IKEPEER','remote_name','NVARCHAR2(256)');
select alter_columns('alter','tab_secm_ipsec_ikepeer_deploy','local_name','NVARCHAR2(256)');
select alter_columns('alter','tab_secm_ipsec_ikepeer_deploy','remote_name','NVARCHAR2(256)');
select alter_columns('alter','tab_secm_ipsec_ikepeer_ngfw','local_name','NVARCHAR2(256)');
select alter_columns('alter','tab_secm_ipsec_ikepeer_ngfw','remote_name','NVARCHAR2(256)');

select alter_columns('drop','TAB_SECM_IPSEC_IKEPEER','local_name','default');
select alter_columns('drop','TAB_SECM_IPSEC_IKEPEER','remote_name','default');
select alter_columns('drop','tab_secm_ipsec_ikepeer_deploy','local_name','default');
select alter_columns('drop','tab_secm_ipsec_ikepeer_deploy','remote_name','default');
select alter_columns('drop','tab_secm_ipsec_ikepeer_ngfw','local_name','default');
select alter_columns('drop','tab_secm_ipsec_ikepeer_ngfw','remote_name','default');

select alter_columns('set','TAB_SECM_IPSEC_IKEPEER','local_name','default null');
select alter_columns('set','TAB_SECM_IPSEC_IKEPEER','remote_name','default null');
select alter_columns('set','tab_secm_ipsec_ikepeer_deploy','local_name','default null');
select alter_columns('set','tab_secm_ipsec_ikepeer_deploy','remote_name','default null');
select alter_columns('set','tab_secm_ipsec_ikepeer_ngfw','local_name','default null');
select alter_columns('set','tab_secm_ipsec_ikepeer_ngfw','remote_name','default null');

select alter_columns('alter','tab_secm_ipsec_ike_user','DESCRIPTION','NVARCHAR2(64)');
select alter_columns('alter','tab_secm_ipsec_ike_user','ID_VALUE','NVARCHAR2(256)');
select alter_columns('alter','tab_secm_ipsec_ike_user_deploy','DESCRIPTION','NVARCHAR2(64)');
select alter_columns('alter','tab_secm_ipsec_ike_user_deploy','ID_VALUE','NVARCHAR2(256)');
select alter_columns('alter','tab_secm_ipsec_ike_user_ngfw','DESCRIPTION','NVARCHAR2(64)');
select alter_columns('alter','tab_secm_ipsec_ike_user_ngfw','ID_VALUE','NVARCHAR2(256)');
--19.2.0.021_END

--19.2.0.058_BEGIN
----新增模板和接口映射表
DROP TABLE IF EXISTS TAB_SECM_IPSEC_POLICY_TEMPLATE_INTERFACE_MAPPING;
CREATE TABLE TAB_SECM_IPSEC_POLICY_TEMPLATE_INTERFACE_MAPPING(
    ID VARCHAR(512) NOT NULL PRIMARY KEY,
    IPSEC_POLICY_TEMPLATE_ID VARCHAR(64),  --'设备模板ID',
    INTERFACE_ALIAS NVARCHAR2(512) DEFAULT NULL, --'接口别名',
    INTERFACE_NAME VARCHAR(512),  --'接口名',
    INTERFACE_IP VARCHAR(128)  --'接口IP'
);
ALTER TABLE TAB_SECM_IPSEC_POLICY_TEMPLATE_INTERFACE_MAPPING OWNER TO OSSDBUSER;

----智能选路链路映射表
DROP TABLE IF EXISTS TAB_SECM_IPSEC_SMARTLINK_PROFILE_LINK;
CREATE TABLE TAB_SECM_IPSEC_SMARTLINK_PROFILE_LINK(
    ID VARCHAR(512) NOT NULL PRIMARY KEY,
    PROFILE_ID VARCHAR(128) NOT NULL,  --'智能选路ID',
    LINK_ID BIGINT,  --'链路ID',
    INTERFACE_NAME VARCHAR(128),  --'本端接口名'
    LOCAL_ADDRESS VARCHAR(128),  --'本端IP'
    REMOTE_ADDRESS VARCHAR(128), --'对端IP'
    LINK_ORDER INTEGER --链路顺序
);
ALTER TABLE TAB_SECM_IPSEC_SMARTLINK_PROFILE_LINK OWNER TO OSSDBUSER;

----智能选路链路部署映射表
DROP TABLE IF EXISTS TAB_SECM_IPSEC_SMARTLINK_PROFILE_LINK_DEPLOY;
CREATE TABLE TAB_SECM_IPSEC_SMARTLINK_PROFILE_LINK_DEPLOY(
    ID VARCHAR(512) NOT NULL PRIMARY KEY,
    PROFILE_ID VARCHAR(128) NOT NULL,  --'智能选路ID',
    LINK_ID BIGINT,  --'链路ID',
    INTERFACE_NAME VARCHAR(128),  --'本端接口名'
    LOCAL_ADDRESS VARCHAR(128),  --'本端IP'
    REMOTE_ADDRESS VARCHAR(128), --'对端IP'
    LINK_ORDER INTEGER --链路顺序
);
ALTER TABLE TAB_SECM_IPSEC_SMARTLINK_PROFILE_LINK_DEPLOY OWNER TO OSSDBUSER;

----智能选路链路同步映射表
DROP TABLE IF EXISTS TAB_SECM_IPSEC_SMARTLINK_PROFILE_LINK_NGFW;
CREATE TABLE TAB_SECM_IPSEC_SMARTLINK_PROFILE_LINK_NGFW(
    ID VARCHAR(512) NOT NULL PRIMARY KEY,
    PROFILE_ID VARCHAR(128) NOT NULL,  --'智能选路ID',
    LINK_ID BIGINT,  --'链路ID',
    INTERFACE_NAME VARCHAR(128),  --'本端接口名'
    LOCAL_ADDRESS VARCHAR(128),  --'本端IP'
    REMOTE_ADDRESS VARCHAR(128), --'对端IP'
    LINK_ORDER INTEGER --链路顺序
);
ALTER TABLE TAB_SECM_IPSEC_SMARTLINK_PROFILE_LINK_NGFW OWNER TO OSSDBUSER;

----策略和接口配置映射表
DROP TABLE IF EXISTS TAB_SECM_IPSEC_POLICY_LOCAL_INTERFACE_MAPPING;
CREATE TABLE TAB_SECM_IPSEC_POLICY_LOCAL_INTERFACE_MAPPING(
    ID VARCHAR(512) NOT NULL PRIMARY KEY,
    IPSEC_POLICY_ID VARCHAR(512),  --'策略ID',
    INTERFACE_ALIAS NVARCHAR2(512) DEFAULT NULL, --'接口别名',
    INTERFACE_NAME VARCHAR(512),  --'接口名',
    INTERFACE_IP VARCHAR(128)  --'接口IP'
);
ALTER TABLE TAB_SECM_IPSEC_POLICY_LOCAL_INTERFACE_MAPPING OWNER TO OSSDBUSER;

----策略和接口部署映射表
DROP TABLE IF EXISTS TAB_SECM_IPSEC_POLICY_LOCAL_INTERFACE_MAPPING_DEPLOY;
CREATE TABLE TAB_SECM_IPSEC_POLICY_LOCAL_INTERFACE_MAPPING_DEPLOY(
    ID VARCHAR(512) NOT NULL PRIMARY KEY,
    IPSEC_POLICY_ID VARCHAR(512),  --'策略ID',
    INTERFACE_ALIAS NVARCHAR2(512) DEFAULT NULL, --'接口别名',
    INTERFACE_NAME VARCHAR(512),  --'接口名',
    INTERFACE_IP VARCHAR(128)  --'接口IP'
);
ALTER TABLE TAB_SECM_IPSEC_POLICY_LOCAL_INTERFACE_MAPPING_DEPLOY OWNER TO OSSDBUSER;

----策略和接口同步映射表
DROP TABLE IF EXISTS TAB_SECM_IPSEC_POLICY_LOCAL_INTERFACE_MAPPING_NGFW;
CREATE TABLE TAB_SECM_IPSEC_POLICY_LOCAL_INTERFACE_MAPPING_NGFW(
    ID VARCHAR(512) NOT NULL PRIMARY KEY,
    IPSEC_POLICY_ID VARCHAR(512),  --'策略ID',
    INTERFACE_ALIAS NVARCHAR2(512) DEFAULT NULL, --'接口别名',
    INTERFACE_NAME VARCHAR(512),  --'接口名',
    INTERFACE_IP VARCHAR(128)  --'接口IP'
);
ALTER TABLE TAB_SECM_IPSEC_POLICY_LOCAL_INTERFACE_MAPPING_NGFW OWNER TO OSSDBUSER;

select alter_columns('alter','tab_secm_ipsec_service_tunnel','local_if_name','varchar(512)');
select alter_columns('alter','tab_secm_ipsec_service_tunnel','remote_if_name','varchar(512)');
--19.2.0.058_END

--19.2.0.061_BEGIN
select alter_columns('add','tab_secm_ipsec_monitor_ngfw','SHOW','boolean');
select alter_columns('add','tab_secm_ipsec_monitor_ngfw','NEGOTIATE_TIME','TIMESTAMP WITH TIME ZONE');
--19.2.0.061_END

--19.2.0.063_BEGIN
----策略关系映射表
DROP TABLE IF EXISTS TAB_SECM_IPSEC_POLICY_MAPPING;
CREATE TABLE TAB_SECM_IPSEC_POLICY_MAPPING(
    OBJECT_ID VARCHAR(64) NOT NULL, ---关联对象的ID
    POLICY_ID VARCHAR(512) NOT NULL,  --'策略ID/IKE PEER ID',
    OBJECT_TYPE VARCHAR(512) NOT NULL,  --'类型:ACL IKE IPSEC',
    NE_ID VARCHAR(128) NOT NULL --设备ID
);
ALTER TABLE TAB_SECM_IPSEC_POLICY_MAPPING OWNER TO OSSDBUSER;

----策略关系映射部署表
DROP TABLE IF EXISTS TAB_SECM_IPSEC_POLICY_DEPLOY_MAPPING;
CREATE TABLE TAB_SECM_IPSEC_POLICY_DEPLOY_MAPPING(
    OBJECT_ID VARCHAR(64) NOT NULL, ---关联对象的ID
    POLICY_ID VARCHAR(512) NOT NULL,  --'策略ID/IKE PEER ID',
    OBJECT_TYPE VARCHAR(512) NOT NULL,  --'类型:ACL IKE IPSEC',
    NE_ID VARCHAR(128) NOT NULL --设备ID
);
ALTER TABLE TAB_SECM_IPSEC_POLICY_DEPLOY_MAPPING OWNER TO OSSDBUSER;

----策略关系映射表
DROP TABLE IF EXISTS TAB_SECM_IPSEC_POLICY_NGFW_MAPPING;
CREATE TABLE TAB_SECM_IPSEC_POLICY_NGFW_MAPPING(
    OBJECT_ID VARCHAR(64) NOT NULL, ---关联对象的ID
    POLICY_ID VARCHAR(512) NOT NULL,  --'策略ID/IKE PEER ID',
    OBJECT_TYPE VARCHAR(512) NOT NULL,  --'类型:ACL IKE IPSEC',
    NE_ID VARCHAR(128) NOT NULL --设备ID
);
ALTER TABLE TAB_SECM_IPSEC_POLICY_NGFW_MAPPING OWNER TO OSSDBUSER;

----IKE
insert into tab_secm_ipsec_policy_mapping select ike.id as object_id, peer.id as policy_id, 'ike-proposal' as object_type, ike.ne_id as ne_id from tab_secm_ipsec_ikeproposal as ike, tab_secm_ipsec_ikepeer as peer where ike.ne_id = peer.ne_id and ike.proposal_id = peer.proposal_id;
insert into tab_secm_ipsec_policy_deploy_mapping select ike.id as object_id, peer.id as policy_id, 'ike-proposal' as object_type, ike.ne_id as ne_id from tab_secm_ipsec_ikeproposal_deploy as ike, tab_secm_ipsec_ikepeer_deploy as peer where ike.ne_id = peer.ne_id and ike.proposal_id = peer.proposal_id;
insert into tab_secm_ipsec_policy_ngfw_mapping select ike.id as object_id, peer.id as policy_id, 'ike-proposal' as object_type, ike.ne_id as ne_id from tab_secm_ipsec_ikeproposal_ngfw as ike, tab_secm_ipsec_ikepeer_ngfw as peer where ike.ne_id = peer.ne_id and ike.proposal_id = peer.proposal_id;

----ACL
insert into tab_secm_ipsec_policy_mapping select acl.id as object_id, policy.id as policy_id, 'access-lists' as object_type, acl.ne_id as ne_id from tab_secm_ipsec_security_acl as acl, tab_secm_ipsec_policy as policy where acl.ne_id = policy.ne_id and acl.vsys = policy.vsys and acl.acl_id = policy.security_acl;
insert into tab_secm_ipsec_policy_deploy_mapping select acl.id as object_id, policy.id as policy_id, 'access-lists' as object_type, acl.ne_id as ne_id from tab_secm_ipsec_security_acl_deploy as acl, tab_secm_ipsec_policy_deploy as policy where acl.ne_id = policy.ne_id and acl.vsys = policy.vsys and acl.acl_id = policy.security_acl;
insert into tab_secm_ipsec_policy_ngfw_mapping select acl.id as object_id, policy.id as policy_id, 'access-lists' as object_type, acl.ne_id as ne_id from tab_secm_ipsec_security_acl_ngfw as acl, tab_secm_ipsec_policy_ngfw as policy where acl.ne_id = policy.ne_id and acl.vsys = policy.vsys and acl.acl_id = policy.security_acl;

----IPSEC
insert into tab_secm_ipsec_policy_mapping select ipsec.id as object_id, policy.id as policy_id, 'ipsec-proposal' as object_type, ipsec.ne_id as ne_id from tab_secm_ipsec_ipsecproposal as ipsec, tab_secm_ipsec_policy as policy where ipsec.ne_id = policy.ne_id and ipsec.proposal_name = policy.proposal_name;
insert into tab_secm_ipsec_policy_deploy_mapping select ipsec.id as object_id, policy.id as policy_id, 'ipsec-proposal' as object_type, ipsec.ne_id as ne_id from tab_secm_ipsec_ipsecproposal_deploy as ipsec, tab_secm_ipsec_policy_deploy as policy where ipsec.ne_id = policy.ne_id and ipsec.proposal_name = policy.proposal_name;
insert into tab_secm_ipsec_policy_ngfw_mapping select ipsec.id as object_id, policy.id as policy_id, 'ipsec-proposal' as object_type, ipsec.ne_id as ne_id from tab_secm_ipsec_ipsecproposal_ngfw as ipsec, tab_secm_ipsec_policy_ngfw as policy where ipsec.proposal_name = policy.proposal_name and ipsec.ne_id = policy.ne_id;

----SMART_LINK
insert into tab_secm_ipsec_policy_mapping select smartlink.id as object_id, policy.id as policy_id, 'smart-link' as object_type, smartlink.ne_id as ne_id from tab_secm_ipsec_smartLink_profile as smartlink, tab_secm_ipsec_policy as policy where smartlink.ne_id = policy.ne_id and smartlink.profile_name = policy.smart_link_profile;
insert into tab_secm_ipsec_policy_deploy_mapping select smartlink.id as object_id, policy.id as policy_id, 'smart-link' as object_type, smartlink.ne_id as ne_id from tab_secm_ipsec_smartLink_profile_deploy as smartlink, tab_secm_ipsec_policy_deploy as policy where smartlink.ne_id = policy.ne_id and smartlink.profile_name = policy.smart_link_profile;
insert into tab_secm_ipsec_policy_ngfw_mapping select smartlink.id as object_id, policy.id as policy_id, 'smart-link' as object_type, smartlink.ne_id as ne_id from tab_secm_ipsec_smartLink_profile_ngfw as smartlink, tab_secm_ipsec_policy_ngfw as policy where smartlink.profile_name = policy.smart_link_profile and smartlink.ne_id = policy.ne_id;
--19.2.0.063_END

--19.2.0.001_BEGIN
CREATE TABLE IF NOT EXISTS TAB_SECM_NAT_POLICY_GLOBAL_RESOURCE
(
  PKID VARCHAR(256) PRIMARY KEY NOT NULL,
  TERNANT_ID VARCHAR(256) NOT NULL,
  LEVEL VARCHAR(256),
  CURRENT_OFFSET INTEGER NOT NULL,
  BUFFER INTEGER,
  CREATETIME TIMESTAMP WITH TIME ZONE,
  UPDATETIME TIMESTAMP WITH TIME ZONE
);
ALTER TABLE PUBLIC.TAB_SECM_NAT_POLICY_GLOBAL_RESOURCE OWNER TO OSSDBUSER;
--19.2.0.001_END
--19.2.0.002_BEGIN
---配置表
declare
priority_level INT;
policy_count INT;
begin
for temp_record in (select rule_order, ADOM_ID from tab_secm_nat_policy where policy_name not in (select nat_policy_name from tab_secm_svo_nat_policy)) loop
  policy_count := (select count(1) from  tab_secm_nat_policy where rule_order < temp_record.rule_order and policy_name in (select nat_policy_name from tab_secm_svo_nat_policy) and ADOM_ID = temp_record.ADOM_ID);
  if(policy_count > 0 ) then
	priority_level := (select b.priority_level  from  tab_secm_nat_policy a ,tab_secm_svo_nat_policy b where a.rule_order < temp_record.rule_order and a.policy_name in (select nat_policy_name from tab_secm_svo_nat_policy) and a.policy_name = b.nat_policy_name and a.ADOM_ID = temp_record.ADOM_ID order by a.rule_order desc limit 1);
	if(priority_level = 50) then 
		update tab_secm_nat_policy  set rule_order = rule_order+3000 where rule_order = temp_record.rule_order and ADOM_ID = temp_record.ADOM_ID;
	end if;
	if(priority_level = 100) then 
		update tab_secm_nat_policy  set rule_order = rule_order+120000 where rule_order = temp_record.rule_order and ADOM_ID = temp_record.ADOM_ID;
	end if;
	if(priority_level = 200) then 
		update tab_secm_nat_policy  set rule_order = rule_order+240000 where rule_order = temp_record.rule_order and ADOM_ID = temp_record.ADOM_ID;
	end if;
	if(priority_level = 300) then 
		update tab_secm_nat_policy  set rule_order = rule_order+360000 where rule_order = temp_record.rule_order and ADOM_ID = temp_record.ADOM_ID;
	end if;
	if(priority_level = 400) then 
		update tab_secm_nat_policy  set rule_order = rule_order+480000 where rule_order = temp_record.rule_order and ADOM_ID = temp_record.ADOM_ID;
	end if;
	if(priority_level = 450) then 
		update tab_secm_nat_policy  set rule_order = rule_order+600000 where rule_order = temp_record.rule_order and ADOM_ID = temp_record.ADOM_ID;
	end if;
	if(priority_level = 500) then 
		update tab_secm_nat_policy  set rule_order = rule_order+720000 where rule_order = temp_record.rule_order and ADOM_ID = temp_record.ADOM_ID;
	end if;
  end if;
end loop;
end;
/
update tab_secm_nat_policy  set rule_order = rule_order+3000 where policy_name in (select nat_policy_name from tab_secm_svo_nat_policy where priority_level = 50);
update tab_secm_nat_policy  set rule_order = rule_order+120000 where policy_name in (select nat_policy_name from tab_secm_svo_nat_policy where priority_level = 100);
update tab_secm_nat_policy  set rule_order = rule_order+240000 where policy_name in (select nat_policy_name from tab_secm_svo_nat_policy where priority_level = 200);
update tab_secm_nat_policy  set rule_order = rule_order+360000 where policy_name in (select nat_policy_name from tab_secm_svo_nat_policy where priority_level = 300);
update tab_secm_nat_policy  set rule_order = rule_order+480000 where policy_name in (select nat_policy_name from tab_secm_svo_nat_policy where priority_level = 400);
update tab_secm_nat_policy  set rule_order = rule_order+600000 where policy_name in (select nat_policy_name from tab_secm_svo_nat_policy where priority_level = 450);
update tab_secm_nat_policy  set rule_order = rule_order+720000 where policy_name in (select nat_policy_name from tab_secm_svo_nat_policy where priority_level = 500);
---部署表
declare
priority_level INT;
policy_count INT;
begin
for temp_record in (select rule_order, DEVICE_DN from tab_secm_nat_policy_deploy where policy_name not in (select nat_policy_name from tab_secm_svo_nat_policy)) loop
  policy_count := (select count(1) from  tab_secm_nat_policy_deploy where rule_order < temp_record.rule_order and policy_name in (select nat_policy_name from tab_secm_svo_nat_policy) and DEVICE_DN = temp_record.DEVICE_DN);
  if(policy_count > 0 ) then
	priority_level := (select b.priority_level  from  tab_secm_nat_policy_deploy a ,tab_secm_svo_nat_policy b where a.rule_order < temp_record.rule_order and a.policy_name in (select nat_policy_name from tab_secm_svo_nat_policy) and a.policy_name = b.nat_policy_name and a.DEVICE_DN = temp_record.DEVICE_DN order by a.rule_order desc limit 1);
	if(priority_level = 50) then 
		update tab_secm_nat_policy_deploy  set rule_order = rule_order+3000 where rule_order = temp_record.rule_order and DEVICE_DN = temp_record.DEVICE_DN;
	end if;
	if(priority_level = 100) then 
		update tab_secm_nat_policy_deploy  set rule_order = rule_order+120000 where rule_order = temp_record.rule_order and DEVICE_DN = temp_record.DEVICE_DN;
	end if;
	if(priority_level = 200) then 
		update tab_secm_nat_policy_deploy  set rule_order = rule_order+240000 where rule_order = temp_record.rule_order and DEVICE_DN = temp_record.DEVICE_DN;
	end if;
	if(priority_level = 300) then 
		update tab_secm_nat_policy_deploy  set rule_order = rule_order+360000 where rule_order = temp_record.rule_order and DEVICE_DN = temp_record.DEVICE_DN;
	end if;
	if(priority_level = 400) then 
		update tab_secm_nat_policy_deploy  set rule_order = rule_order+480000 where rule_order = temp_record.rule_order and DEVICE_DN = temp_record.DEVICE_DN;
	end if;
	if(priority_level = 450) then 
		update tab_secm_nat_policy_deploy  set rule_order = rule_order+600000 where rule_order = temp_record.rule_order and DEVICE_DN = temp_record.DEVICE_DN;
	end if;
	if(priority_level = 500) then 
		update tab_secm_nat_policy_deploy  set rule_order = rule_order+720000 where rule_order = temp_record.rule_order and DEVICE_DN = temp_record.DEVICE_DN;
	end if;
  end if;
end loop;
end;
/
update tab_secm_nat_policy_deploy set rule_order = rule_order+3000 where policy_name in (select nat_policy_name from tab_secm_svo_nat_policy where priority_level = 50);
update tab_secm_nat_policy_deploy set rule_order = rule_order+120000 where policy_name in (select nat_policy_name from tab_secm_svo_nat_policy where priority_level = 100);
update tab_secm_nat_policy_deploy set rule_order = rule_order+240000 where policy_name in (select nat_policy_name from tab_secm_svo_nat_policy where priority_level = 200);
update tab_secm_nat_policy_deploy set rule_order = rule_order+360000 where policy_name in (select nat_policy_name from tab_secm_svo_nat_policy where priority_level = 300);
update tab_secm_nat_policy_deploy set rule_order = rule_order+480000 where policy_name in (select nat_policy_name from tab_secm_svo_nat_policy where priority_level = 400);
update tab_secm_nat_policy_deploy set rule_order = rule_order+600000 where policy_name in (select nat_policy_name from tab_secm_svo_nat_policy where priority_level = 450);
update tab_secm_nat_policy_deploy set rule_order = rule_order+720000 where policy_name in (select nat_policy_name from tab_secm_svo_nat_policy where priority_level = 500);
---同步表
update tab_secm_nat_policy_ngfw set rule_order = rule_order+3000 where policy_name in (select nat_policy_name from tab_secm_svo_nat_policy where priority_level = 50);
update tab_secm_nat_policy_ngfw set rule_order = rule_order+120000 where policy_name in (select nat_policy_name from tab_secm_svo_nat_policy where priority_level = 100);
update tab_secm_nat_policy_ngfw set rule_order = rule_order+240000 where policy_name in (select nat_policy_name from tab_secm_svo_nat_policy where priority_level = 200);
update tab_secm_nat_policy_ngfw set rule_order = rule_order+360000 where policy_name in (select nat_policy_name from tab_secm_svo_nat_policy where priority_level = 300);
update tab_secm_nat_policy_ngfw set rule_order = rule_order+480000 where policy_name in (select nat_policy_name from tab_secm_svo_nat_policy where priority_level = 400);
update tab_secm_nat_policy_ngfw set rule_order = rule_order+600000 where policy_name in (select nat_policy_name from tab_secm_svo_nat_policy where priority_level = 450);
update tab_secm_nat_policy_ngfw set rule_order = rule_order+720000 where policy_name in (select nat_policy_name from tab_secm_svo_nat_policy where priority_level = 500);
--19.2.0.002_END

--19.4.0.B110_BEGIN
select alter_columns('add','tab_secm_nat_policy_deploy','policy_id','varchar(128)');
select alter_columns('add','tab_secm_nat_policy_ngfw','policy_id','varchar(128)');

drop index IF EXISTS IDX_NAT_POLICY_ADOMID_NAME;
CREATE INDEX IDX_NAT_POLICY_ADOMID_NAME
  ON TAB_SECM_NAT_POLICY
  USING BTREE
  (ADOM_ID COLLATE PG_CATALOG."default", POLICY_NAME COLLATE PG_CATALOG."default");
drop index IF EXISTS IDX_NAT_POLICY_DEPLOY_DEVICE_DN;
CREATE INDEX IDX_NAT_POLICY_DEPLOY_DEVICE_DN ON TAB_SECM_NAT_POLICY_DEPLOY (DEVICE_DN);
drop index IF EXISTS IDX_NAT_POLICY_DEPLOY_POLICY_NAME;
CREATE INDEX IDX_NAT_POLICY_DEPLOY_POLICY_NAME ON TAB_SECM_NAT_POLICY_DEPLOY (POLICY_NAME);
drop index IF EXISTS IDX_NAT_POLICY_NGFW_DEVICE_DN;
CREATE INDEX IDX_NAT_POLICY_NGFW_DEVICE_DN ON TAB_SECM_NAT_POLICY_NGFW (DEVICE_DN);
drop index IF EXISTS IDX_NAT_POLICY_NGFW_POLICY_NAME;
CREATE INDEX IDX_NAT_POLICY_NGFW_POLICY_NAME ON TAB_SECM_NAT_POLICY_NGFW (POLICY_NAME);

update TAB_SECM_NAT_POLICY_DEPLOY d set d.POLICY_ID =
 case when (select count(pkid) from TAB_SECM_NAT_POLICY p where d.policy_name = p.policy_name and p.adom_id =
	(select adom_id from TAB_SECM_SECURECENTER_DEVICE dev where dev.id = d.device_dn)) > 1 then
 	(select rel.object_id from TAB_SECM_SECURITY_POLICY_RELATION_DEVICE rel where rel.device_dn = d.device_dn 
 		and rel.object_id in (select p.pkid from TAB_SECM_NAT_POLICY p where p.policy_name = d.policy_name))
 	when exists (select pkid from TAB_SECM_NAT_POLICY p where d.policy_name = p.policy_name and p.adom_id =
	(select adom_id from TAB_SECM_SECURECENTER_DEVICE dev where dev.id = d.device_dn)) then
 (select p.pkid from TAB_SECM_NAT_POLICY p where d.policy_name = p.policy_name and p.adom_id = 
	(select adom_id from TAB_SECM_SECURECENTER_DEVICE dev where dev.id = d.device_dn)) else
      d.pkid
  end;

update TAB_SECM_NAT_POLICY_NGFW d set d.POLICY_ID =
 case when (select count(pkid) from TAB_SECM_NAT_POLICY p where d.policy_name = p.policy_name and p.adom_id =
	(select adom_id from TAB_SECM_SECURECENTER_DEVICE dev where dev.id = d.device_dn)) > 1 then
 	(select rel.object_id from TAB_SECM_SECURITY_POLICY_RELATION_DEVICE rel where rel.device_dn = d.device_dn
 		and rel.object_id in (select p.pkid from TAB_SECM_NAT_POLICY p where p.policy_name = d.policy_name))
 	when exists (select pkid from TAB_SECM_NAT_POLICY p where d.policy_name = p.policy_name and p.adom_id =
	(select adom_id from TAB_SECM_SECURECENTER_DEVICE dev where dev.id = d.device_dn)) then
 (select p.pkid from TAB_SECM_NAT_POLICY p where d.policy_name = p.policy_name and p.adom_id = 
	(select adom_id from TAB_SECM_SECURECENTER_DEVICE dev where dev.id = d.device_dn)) else
      d.pkid
  end;
--19.4.0.B110_END
--19.4.0.B123_BEGIN
DROP INDEX IF EXISTS TAB_SECM_NAT_POLICY_RELATION_OBJECT_POLICY_ID;
CREATE INDEX TAB_SECM_NAT_POLICY_RELATION_OBJECT_POLICY_ID
    ON TAB_SECM_NAT_POLICY_RELATION_OBJECT
    USING BTREE
    (POLICY_ID);
--19.4.0.B123_END

--19.2.0.001_BEGIN
select alter_columns('add', 'TAB_SECM_TIME_RANGE', 'universal', 'boolean default false');
select alter_columns('add', 'TAB_SECM_TIME_RANGE_ITEM', 'universal', 'boolean default false');
update TAB_SECM_TIME_RANGE set universal=true where pre_defined=1;
update TAB_SECM_TIME_RANGE_ITEM set universal=true where time_range_id in (select pkid from TAB_SECM_TIME_RANGE where pre_defined=1);
update TAB_SECM_TIME_RANGE set universal = false where universal is null;
update TAB_SECM_TIME_RANGE_ITEM set universal = false where universal is null;
--19.2.0.001_END

--19.2.0.001_BEGIN
DROP TABLE IF EXISTS tab_secm_ipsec_interface;
CREATE TABLE tab_secm_ipsec_interface(
    pkid VARCHAR(64)   primary key NOT NULL,
    name VARCHAR(64),
    type VARCHAR(64),
    enable boolean,
    vsys_name VARCHAR(64),
    ipv4_address VARCHAR(64),
    security_zone VARCHAR(64),
    device_id VARCHAR(64),
    device_name VARCHAR(64) 
) ;
ALTER TABLE public.tab_secm_ipsec_interface OWNER TO OSSDBUSER;
--19.2.0.001_END

--19.2.0.058_BEGIN
select alter_columns('add','tab_secm_ipsec_interface','alias_name','VARCHAR(128)');
--19.2.0.058_END

--19.2.0.001_BEGIN
select alter_columns('add', 'tab_secm_security_policy_import_temp', 'POLICY_LABEL', 'varchar(10243)');
alter table tab_secm_security_policy add column is_deleted BOOLEAN NOT NULL default false;
alter table tab_secm_security_policy_relation_device add column is_deleted BOOLEAN NOT NULL default false;

alter table tab_secm_security_policy add policy_type integer default(0);
alter table tab_secm_security_policy_deploy add policy_id varchar(128);
alter table tab_secm_security_policy_deploy add policy_type integer default(0);
alter table tab_secm_security_policy_ngfw add policy_id varchar(128);
alter table tab_secm_security_policy_ngfw add policy_type integer default(0);
alter table tab_secm_security_policy_import_temp add policy_type integer default(0);
alter table tab_secm_security_policy_import_temp add base_policy_type integer;
alter table tab_secm_security_policy_import_temp add base_policy_device_dn varchar(4096);

update TAB_SECM_SECURITY_POLICY_DEPLOY d set d.POLICY_ID =
 case when (select count(pkid) from TAB_SECM_SECURITY_POLICY p where d.policy_name = p.policy_name and p.adom_id =
	(select adom_id from TAB_SECM_SECURECENTER_DEVICE dev where dev.id = d.device_dn)) > 1 then
 	(select rel.object_id from TAB_SECM_SECURITY_POLICY_RELATION_DEVICE rel where rel.device_dn = d.device_dn 
 		and rel.object_id in (select p.pkid from TAB_SECM_SECURITY_POLICY p where p.policy_name = d.policy_name))
 	when exists (select pkid from TAB_SECM_SECURITY_POLICY p where d.policy_name = p.policy_name and p.adom_id =
	(select adom_id from TAB_SECM_SECURECENTER_DEVICE dev where dev.id = d.device_dn)) then
 (select p.pkid from TAB_SECM_SECURITY_POLICY p where d.policy_name = p.policy_name and p.adom_id = 
	(select adom_id from TAB_SECM_SECURECENTER_DEVICE dev where dev.id = d.device_dn)) else
      d.pkid
  end;


update TAB_SECM_SECURITY_POLICY_NGFW d set d.POLICY_ID =
 case when (select count(pkid) from TAB_SECM_SECURITY_POLICY p where d.policy_name = p.policy_name and p.adom_id =
	(select adom_id from TAB_SECM_SECURECENTER_DEVICE dev where dev.id = d.device_dn)) > 1 then
 	(select rel.object_id from TAB_SECM_SECURITY_POLICY_RELATION_DEVICE rel where rel.device_dn = d.device_dn
 		and rel.object_id in (select p.pkid from TAB_SECM_SECURITY_POLICY p where p.policy_name = d.policy_name))
 	when exists (select pkid from TAB_SECM_SECURITY_POLICY p where d.policy_name = p.policy_name and p.adom_id =
	(select adom_id from TAB_SECM_SECURECENTER_DEVICE dev where dev.id = d.device_dn)) then
 (select p.pkid from TAB_SECM_SECURITY_POLICY p where d.policy_name = p.policy_name and p.adom_id = 
	(select adom_id from TAB_SECM_SECURECENTER_DEVICE dev where dev.id = d.device_dn)) else
      d.pkid
  end;

--设备关联子表
drop table if exists tab_secm_security_policy_relation_sub_device;
create TABLE tab_secm_security_policy_relation_sub_device
(
  --主键
  PKID VARCHAR(128) primary key NOT NULL,
  object_id VARCHAR(128) NOT NULL,
  device_group_id VARCHAR(128),
  device_dn varchar(128),
  change_status integer default(0),
  deploy_status integer default(0),
  is_deleted BOOLEAN NOT NULL default false
);
--根据device_group_id建立索引
create INDEX IDX_DEVICE_GROUP_ID
  ON tab_secm_security_policy_relation_sub_device
  USING BTREE
  (DEVICE_DN COLLATE PG_CATALOG."default");
--根据object_id建立索引
create INDEX IDX_SUB_OBJECT_ID
  ON tab_secm_security_policy_relation_sub_device
  USING BTREE
  (OBJECT_ID COLLATE PG_CATALOG."default");

alter table public.tab_secm_security_policy_relation_sub_device OWNER TO OSSDBUSER;


select alter_columns('add','tab_secm_security_policy_import_temp','application_group','varchar(4096)');

select alter_columns('add','TAB_SECM_DEVICE_CONTRAST_RESULT','visible','boolean default true');
--设备对比结果映射表
drop table IF EXISTS tab_secm_device_contrast_mapping;
create TABLE tab_secm_device_contrast_mapping
(
    id CHARACTER VARYING(128) primary key NOT NULL,
    policy_contrast_id CHARACTER VARYING(512),
    policy_object_type CHARACTER VARYING(64),
    ngfw_policy_id CHARACTER VARYING(512),
    deploy_policy_id CHARACTER VARYING(512),
    related_contrast_id CHARACTER VARYING(512),
    related_object_type CHARACTER VARYING(64),
    related_ngfw_id CHARACTER VARYING(512),
    related_deploy_id CHARACTER VARYING(512),
    CHANGE_TYPE CHARACTER VARYING(512),
    device_dn CHARACTER VARYING(128)
);
alter table public.tab_secm_device_contrast_mapping OWNER TO OSSDBUSER;
create INDEX tab_secm_device_contrast_mapping_DEVICE_DN_INDEX ON tab_secm_device_contrast_mapping(DEVICE_DN);

--19.2.0.001_END
--19.2.0.001_BEGIN
select alter_columns('add', 'tab_secm_pf_ips', 'universal', 'boolean default false');
select alter_columns('add', 'tab_secm_pf_ips', 'description_cn', 'VARCHAR(255)');
select alter_columns('add', 'tab_secm_pf_ips_ngfw', 'universal', 'boolean default false');
select alter_columns('add', 'tab_secm_pf_ips_ngfw', 'description_cn', 'VARCHAR(255)');
select alter_columns('add', 'tab_secm_pf_ips_deploy', 'universal', 'boolean default false');
select alter_columns('add', 'tab_secm_pf_ips_deploy', 'description_cn', 'VARCHAR(255)');
update tab_secm_pf_ips set universal=true where pre_defined=1;
update tab_secm_pf_ips set universal = false where universal is null;
select alter_columns('add', 'tab_secm_serviceset', 'universal', 'boolean default false');
select alter_columns('add', 'tab_secm_serviceset_deploy', 'POLY', 'int default 0');
select alter_columns('add', 'tab_secm_serviceset_deploy', 'ADOM_ID', 'VARCHAR(255)');
select alter_columns('add', 'tab_secm_serviceset_deploy', 'universal', 'boolean default false');
select alter_columns('add', 'tab_secm_serviceset_ngfw', 'POLY', 'int');
select alter_columns('add', 'tab_secm_serviceset_ngfw', 'ADOM_ID', 'VARCHAR(255)');
select alter_columns('add', 'tab_secm_serviceset_ngfw', 'universal', 'boolean default false');
update tab_secm_serviceset set universal=true where pre_defined=1;
update tab_secm_serviceset set universal = false where universal is null;
update tab_secm_serviceset_deploy set universal=true where pre_defined=1;
update tab_secm_serviceset_ngfw set POLY=0;
update tab_secm_serviceset_deploy set POLY=0;

select alter_columns('add', 'tab_secm_serviceset_rel_group_ngfw', 'DEVICE_DN', 'VARCHAR(128)');
select alter_columns('add', 'tab_secm_serviceset_rel_group_ngfw', 'ADOM_ID', 'VARCHAR(255)');
select alter_columns('add', 'tab_secm_serviceset_rel_group_deploy', 'DEVICE_DN', 'VARCHAR(128)');
select alter_columns('add', 'tab_secm_serviceset_rel_group_deploy', 'ADOM_ID', 'VARCHAR(255)');
select alter_columns('add', 'tab_secm_serviceset_item_ngfw', 'DEVICE_DN', 'VARCHAR(128)');
select alter_columns('add', 'tab_secm_serviceset_item_deploy', 'DEVICE_DN', 'VARCHAR(128)');

drop index IF EXISTS IDX_TAB_SECM_ADDRESSSET_ITEM_DEPLOY_ADDRSETID;
create INDEX IDX_TAB_SECM_ADDRESSSET_ITEM_DEPLOY_ADDRSETID ON tab_secm_addressset_item_deploy (addrset_id);
--19.2.0.001_END

--19.2.0.011_BEGIN
create INDEX INX_SECURITY_POLICY_RELATION_OBJECT_ID
  ON tab_secm_security_policy_relation_object
  USING BTREE
  (object_Id COLLATE PG_CATALOG."default");

create INDEX INX_SECURITY_POLICY_RELATION_OBJECT_TYPE
  ON tab_secm_security_policy_relation_object
  USING BTREE
  (object_Type COLLATE PG_CATALOG."default");

--19.2.0.011_END

--19.2.0.052_BEGIN
select alter_columns('add', 'TAB_SECM_INSTALLTASK_DETAIL_ITEM', 'OBJECT_TYPE', 'VARCHAR(255)');
select alter_columns('add', 'TAB_SECM_INSTALLTASK_DETAIL_ITEM', 'OBJECT_ID', 'VARCHAR(255)');
--19.2.0.052_END

--19.2.0.063_BEGIN
alter table tab_secm_security_policy_relation_sub_device add object_type integer default(1);
--19.2.0.063_END

--19.3.0.B001_BEGIN
select alter_columns('add', 'TAB_SECM_INSTALLTASK', 'DEVICE_TEMPLATE', 'INTEGER DEFAULT(0)');
--19.3.0.B001_END

--19.3.0.B031_BEGIN
drop index IF EXISTS IDX_SUB_DEVICE_OBJECT_ID_TYPE;
create INDEX IDX_SUB_DEVICE_OBJECT_ID_TYPE
ON TAB_SECM_SECURITY_POLICY_RELATION_SUB_DEVICE
USING BTREE
(DEVICE_DN, OBJECT_ID, OBJECT_TYPE);
--19.3.0.B031_END

--19.3.0.060_BEGIN
drop index IF EXISTS POLICY_RELATION_OBJECT_NGFW_DEVICE_DN_index;
create INDEX POLICY_RELATION_OBJECT_NGFW_DEVICE_DN_index ON TAB_SECM_SECURITY_POLICY_RELATION_OBJECT_NGFW (DEVICE_DN);

drop index IF EXISTS IDX_POLICY_DEPLOY_POLICY_ID;
create INDEX IDX_POLICY_DEPLOY_POLICY_ID ON tab_secm_security_policy_deploy (POLICY_ID);

drop index IF EXISTS IDX_tab_secm_serviceset_ngfw_device_dn;
create INDEX IDX_tab_secm_serviceset_ngfw_device_dn ON tab_secm_serviceset_ngfw (device_dn);
--19.3.0.060_END

--19.4.0.B111_BEGIN
select alter_columns('add', 'tab_secm_security_policy', 'is_merging', 'boolean default false');
--19.4.0.B111_END

--19.2.0.001_BEGIN
select alter_columns('add', 'tab_secm_zone', 'universal', 'boolean default false');
update tab_secm_zone
set universal = true
where pkid in ('20000000-0000-0000-0000-000000000000', '20000000-0000-0000-0000-000000000001',
               '20000000-0000-0000-0000-000000000002', '20000000-0000-0000-0000-000000000003');
update tab_secm_zone
set universal = false
where universal is null;
--19.2.0.001_END

--19.3.0.058_BEGIN
DROP INDEX IF EXISTS idx_tab_secm_zone_name;
CREATE INDEX idx_tab_secm_zone_name ON tab_secm_zone (zone_name);

DROP INDEX IF EXISTS idx_tab_secm_zone_rel_interface_zone_id;
CREATE INDEX idx_tab_secm_zone_rel_interface_zone_id ON tab_secm_zone_rel_interface (zone_id);
--19.3.0.058_BEGIN

--19.2.0.011_BEGIN
select alter_columns('add', 'tab_secm_serviceset_item', 'ICMP_NAME', 'VARCHAR(128)');
--19.2.0.011_END

--19.2.0.021_BEGIN
select alter_columns('add','tab_secm_serviceset','source','integer');
--19.2.0.021_END

--19.3.0.001_BEGIN
select alter_columns('add', 'tab_secm_serviceset', 'PRODUCER', 'VARCHAR(128)');
--19.3.0.001_END

--19.3.0.010_BEGIN
update tab_secm_serviceset_item set icmp_name = 'all(-1,-1)' where protocol_type = 'icmp' and icmp_type = -1 and icmp_code = '-1';
update tab_secm_serviceset_item set icmp_name = 'echo(8,0)' where protocol_type = 'icmp' and icmp_type = 8 and icmp_code = '0';
update tab_secm_serviceset_item set icmp_name = 'echo-reply(0,0)' where protocol_type = 'icmp' and icmp_type = 0 and icmp_code = '0';
update tab_secm_serviceset_item set icmp_name = 'fragmentneed-DFset(3,4)' where protocol_type = 'icmp' and icmp_type = 3 and icmp_code = '4';
update tab_secm_serviceset_item set icmp_name = 'host-redirect(5,1)' where protocol_type = 'icmp' and icmp_type = 5 and icmp_code = '1';
update tab_secm_serviceset_item set icmp_name = 'host-tos-redirect(5,3)' where protocol_type = 'icmp' and icmp_type = 5 and icmp_code = '3';
update tab_secm_serviceset_item set icmp_name = 'host-unreachable(3,1)' where protocol_type = 'icmp' and icmp_type = 3 and icmp_code = '1';
update tab_secm_serviceset_item set icmp_name = 'information-reply(16,0)' where protocol_type = 'icmp' and icmp_type = 16 and icmp_code = '0';
update tab_secm_serviceset_item set icmp_name = 'information-request(15,0)' where protocol_type = 'icmp' and icmp_type = 15 and icmp_code = '0';
update tab_secm_serviceset_item set icmp_name = 'net-redirect(5,0)' where protocol_type = 'icmp' and icmp_type = 5 and icmp_code = '0';
update tab_secm_serviceset_item set icmp_name = 'net-tos-redirect(5,2)' where protocol_type = 'icmp' and icmp_type = 5 and icmp_code = '2';
update tab_secm_serviceset_item set icmp_name = 'net-unreachable(3,0)' where protocol_type = 'icmp' and icmp_type = 3 and icmp_code = '0';
update tab_secm_serviceset_item set icmp_name = 'parameter-problem(12,0)' where protocol_type = 'icmp' and icmp_type = 12 and icmp_code = '0';
update tab_secm_serviceset_item set icmp_name = 'port-unreachable(3,3)' where protocol_type = 'icmp' and icmp_type = 3 and icmp_code = '3';
update tab_secm_serviceset_item set icmp_name = 'protocol-unreachable(3,2)' where protocol_type = 'icmp' and icmp_type = 3 and icmp_code = '2';
update tab_secm_serviceset_item set icmp_name = 'reassembly-timeout(11,1)' where protocol_type = 'icmp' and icmp_type = 11 and icmp_code = '1';
update tab_secm_serviceset_item set icmp_name = 'source-quench(4,0)' where protocol_type = 'icmp' and icmp_type = 4 and icmp_code = '0';
update tab_secm_serviceset_item set icmp_name = 'source-route-failed(3,5)' where protocol_type = 'icmp' and icmp_type = 3 and icmp_code = '5';
update tab_secm_serviceset_item set icmp_name = 'timestamp-reply(14,0)' where protocol_type = 'icmp' and icmp_type = 14 and icmp_code = '0';
update tab_secm_serviceset_item set icmp_name = 'timestamp-request(13,0)' where protocol_type = 'icmp' and icmp_type = 13 and icmp_code = '0';
update tab_secm_serviceset_item set icmp_name = 'ttl-exceeded(11,0)' where protocol_type = 'icmp' and icmp_type = 11 and icmp_code = '0';
update tab_secm_serviceset_item set icmp_name = '自定义' where protocol_type = 'icmp' and icmp_name is null;

update tab_secm_serviceset_item set icmp_name = 'all(-1,-1)' where protocol_type = 'icmpv6' and icmp_type = -1 and icmp_code = '-1';
update tab_secm_serviceset_item set icmp_name = 'Redirect(137,0)' where protocol_type = 'icmpv6' and icmp_type = 137 and icmp_code = '0';
update tab_secm_serviceset_item set icmp_name = 'echo(128,0)' where protocol_type = 'icmpv6' and icmp_type = 128 and icmp_code = '0';
update tab_secm_serviceset_item set icmp_name = 'echo-reply(129,0)' where protocol_type = 'icmpv6' and icmp_type = 129 and icmp_code = '0';
update tab_secm_serviceset_item set icmp_name = 'err-Header-field(4,0)' where protocol_type = 'icmpv6' and icmp_type = 4 and icmp_code = '0';
update tab_secm_serviceset_item set icmp_name = 'frag-time-exceeded(3,1)' where protocol_type = 'icmpv6' and icmp_type = 3 and icmp_code = '1';
update tab_secm_serviceset_item set icmp_name = 'hop-limit-exceeded(3,0)' where protocol_type = 'icmpv6' and icmp_type = 3 and icmp_code = '0';
update tab_secm_serviceset_item set icmp_name = 'host-admin-prohib(1,1)' where protocol_type = 'icmpv6' and icmp_type = 1 and icmp_code = '1';
update tab_secm_serviceset_item set icmp_name = 'host-unreachable(1,3)' where protocol_type = 'icmpv6' and icmp_type = 1 and icmp_code = '3';
update tab_secm_serviceset_item set icmp_name = 'neighbor-advertisement(136,0)' where protocol_type = 'icmpv6' and icmp_type = 136 and icmp_code = '0';
update tab_secm_serviceset_item set icmp_name = 'neighbor-solicitation(135,0)' where protocol_type = 'icmpv6' and icmp_type = 135 and icmp_code = '0';
update tab_secm_serviceset_item set icmp_name = 'network-unreachable(1,0)' where protocol_type = 'icmpv6' and icmp_type = 1 and icmp_code = '0';
update tab_secm_serviceset_item set icmp_name = 'packet-too-big(2,0)' where protocol_type = 'icmpv6' and icmp_type = 2 and icmp_code = '0';
update tab_secm_serviceset_item set icmp_name = 'port-unreachable(1,4)' where protocol_type = 'icmpv6' and icmp_type = 1 and icmp_code = '4';
update tab_secm_serviceset_item set icmp_name = 'router-advertisement(134,0)' where protocol_type = 'icmpv6' and icmp_type = 134 and icmp_code = '0';
update tab_secm_serviceset_item set icmp_name = 'router-solicitation(133,0)' where protocol_type = 'icmpv6' and icmp_type = 133 and icmp_code = '0';
update tab_secm_serviceset_item set icmp_name = 'unknown-ipv6-opt(4,2)' where protocol_type = 'icmpv6' and icmp_type = 4 and icmp_code = '2';
update tab_secm_serviceset_item set icmp_name = 'unknown-next-hdr(4,1)' where protocol_type = 'icmpv6' and icmp_type = 4 and icmp_code = '1';
update tab_secm_serviceset_item set icmp_name = '自定义' where protocol_type = 'icmpv6' and icmp_name is null;
--19.3.0.010_END

--19.3.0.023_BEGIN
insert into tab_secm_serviceset (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000122','imaps','imaps','object',1,'tcp/993');
insert into tab_secm_serviceset_item (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000100','50000000-0000-0000-0000-000000000122','tcp','0-65535','993',null,null,6);
insert into tab_secm_serviceset (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000123','kerberos-tcp','kerberos-tcp','object',1,'tcp/88');
insert into tab_secm_serviceset_item (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000101','50000000-0000-0000-0000-000000000123','tcp','0-65535','88',null,null,6);
insert into tab_secm_serviceset (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000124','kerberos-udp','kerberos-udp','object',1,'udp/88');
insert into tab_secm_serviceset_item (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000102','50000000-0000-0000-0000-000000000124','udp','0-65535','88',null,null,17);
insert into tab_secm_serviceset (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000125','mgcp-rtcp','mgcp-rtcp','object',1,'mgcp-rtcp protocol ( dynamic port )');
insert into tab_secm_serviceset (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000126','mgcp-rtp','mgcp-rtp','object',1,'mgcp-rtp protocol ( dynamic port )');
insert into tab_secm_serviceset (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000127','mysql','mysql','object',1,'tcp/3306');
insert into tab_secm_serviceset_item (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000103','50000000-0000-0000-0000-000000000127','tcp','0-65535','3306',null,null,6);
insert into tab_secm_serviceset (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000128','pop3s','pop3s','object',1,'tcp/995');
insert into tab_secm_serviceset_item (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000104','50000000-0000-0000-0000-000000000128','tcp','0-65535','995',null,null,6);
insert into tab_secm_serviceset (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000129','rdp-tcp','rdp-tcp','object',1,'tcp/3389');
insert into tab_secm_serviceset_item (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000105','50000000-0000-0000-0000-000000000129','tcp','0-65535','3389',null,null,6);
insert into tab_secm_serviceset (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000130','rdp-udp','rdp-udp','object',1,'udp/3389');
insert into tab_secm_serviceset_item (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000106','50000000-0000-0000-0000-000000000130','udp','0-65535','3389',null,null,17);
insert into tab_secm_serviceset (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000131','smb','smb','object',1,'tcp/445');
insert into tab_secm_serviceset_item (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000107','50000000-0000-0000-0000-000000000131','tcp','0-65535','445',null,null,6);
insert into tab_secm_serviceset (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000132','smtps','smtps','object',1,'tcp/465');
insert into tab_secm_serviceset_item (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000108','50000000-0000-0000-0000-000000000132','tcp','0-65535','465',null,null,6);
insert into tab_secm_serviceset (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000133','sqlserver','sqlserver','object',1,'tcp/1433');
insert into tab_secm_serviceset_item (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000109','50000000-0000-0000-0000-000000000133','tcp','0-65535','1433',null,null,6);
insert into tab_secm_serviceset (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000134','vxlan','vxlan','object',1,'udp/4789');
insert into tab_secm_serviceset_item (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000110','50000000-0000-0000-0000-000000000134','udp','0-65535','4789',null,null,17);

update tab_secm_serviceset_item set unique_code=0 where unique_code is null;
update tab_secm_serviceset_item set icmp_type=0 where icmp_type is null;
update tab_secm_serviceset_item set protocol_id=0 where protocol_id is null;
update tab_secm_serviceset set unique_code=0 where unique_code is null;
update tab_secm_serviceset set locked=0 where locked is null;
update tab_secm_serviceset set universal=true where pre_defined=1;
--19.3.0.023_END

--19.3.0.031_BEGIN
DROP INDEX IF EXISTS TAB_SECM_SERVICESET_ITEM_SERVICE_ID_PKEY;
CREATE INDEX TAB_SECM_SERVICESET_ITEM_SERVICE_ID_PKEY ON TAB_SECM_SERVICESET_ITEM USING BTREE (SERVICESET_ID);
DROP INDEX IF EXISTS TAB_SECM_SERVICESET_REL_GROUP_SERVICESET_ID_PKEY;
CREATE INDEX TAB_SECM_SERVICESET_REL_GROUP_SERVICESET_ID_PKEY ON TAB_SECM_SERVICESET_REL_GROUP USING BTREE (SERVICESET_ID);
--19.3.0.031_END

--19.3.0.032_BEGIN
delete from tab_secm_serviceset_item_deploy where serviceset_id in (select pkid from tab_secm_serviceset_deploy where pre_defined = '1');
update tab_secm_serviceset_rel_group_deploy A
inner join tab_secm_serviceset_deploy B on A.subserviceset_id = B.pkid and B.pre_defined = '1'
inner join tab_secm_serviceset C on C.serviceset_name = B.serviceset_name and C.pre_defined = '1'
set A.subserviceset_id = C.pkid;
delete from tab_secm_serviceset_deploy where pre_defined = '1'; 
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000000','ad','ad','object',1,'udp/1773');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000000','50000000-0000-0000-0000-000000000000','udp','0-65535','1773',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000001','ah','ah','object',1,'ah packet (ID of internet protocol:51)');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000001','50000000-0000-0000-0000-000000000001','ip',null,null,null,null,51);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000002','bgp','bgp','object',1,'tcp/179');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000002','50000000-0000-0000-0000-000000000002','tcp','0-65535','179',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000003','biff','biff','object',1,'udp/512');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000003','50000000-0000-0000-0000-000000000003','udp','0-65535','512',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000004','bootpc','bootpc','object',1,'udp/68');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000004','50000000-0000-0000-0000-000000000004','udp','0-65535','68',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000005','bootps','bootps','object',1,'udp/67');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000005','50000000-0000-0000-0000-000000000005','udp','0-65535','67',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000006','chargen','chargen','object',1,'tcp/19');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000006','50000000-0000-0000-0000-000000000006','tcp','0-65535','19',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000007','daytime','daytime','object',1,'tcp/13');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000007','50000000-0000-0000-0000-000000000007','tcp','0-65535','13',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000008','diameter','diameter','object',1,'tcp/3868, sctp/3868');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000008','50000000-0000-0000-0000-000000000008','tcp','0-65535','3868',null,null,6);
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000009','50000000-0000-0000-0000-000000000008','sctp','0-65535','3868',null,null,132);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000009','discard-tcp','discard-tcp','object',1,'tcp/9');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000010','50000000-0000-0000-0000-000000000009','tcp','0-65535','9',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000010','discard-udp','discard-udp','object',1,'udp/9');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000011','50000000-0000-0000-0000-000000000010','udp','0-65535','9',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000011','dns','dns','object',1,'udp/53');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000012','50000000-0000-0000-0000-000000000011','udp','0-65535','53',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000012','dns-tcp','dns-tcp','object',1,'tcp/53');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000013','50000000-0000-0000-0000-000000000012','tcp','0-65535','53',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000013','dnsix','dnsix','object',1,'udp/90');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000014','50000000-0000-0000-0000-000000000013','udp','0-65535','90',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000014','echo-tcp','echo-tcp','object',1,'tcp/7');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000015','50000000-0000-0000-0000-000000000014','tcp','0-65535','7',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000015','echo-udp','echo-udp','object',1,'udp/7');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000016','50000000-0000-0000-0000-000000000015','udp','0-65535','7',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000016','esp','esp','object',1,'esp packet (ID of internet protocol:50)');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000017','50000000-0000-0000-0000-000000000016','ip',null,null,null,null,50);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000017','exec','exec','object',1,'tcp/512');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000018','50000000-0000-0000-0000-000000000017','tcp','0-65535','512',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000018','fin-rst','fin-rst','object',1,'tcp fin and rst packet');
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000019','finger','finger','object',1,'tcp/79');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000019','50000000-0000-0000-0000-000000000019','tcp','0-65535','79',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000020','first-fin','first-fin','object',1,'tcp first fin packet');
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000021','fragment','fragment','object',1,'fragment packet');
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000022','ftp','ftp','object',1,'tcp/21');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000020','50000000-0000-0000-0000-000000000022','tcp','0-65535','21',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000023','ftp-data','ftp-data','object',1,'ftp data protocol ( dynamic port )');
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000024','gopher','gopher','object',1,'tcp/70');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000021','50000000-0000-0000-0000-000000000024','tcp','0-65535','70',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000025','gre','gre','object',1,'gre packet (ID of internet protocol:47)');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000022','50000000-0000-0000-0000-000000000025','ip',null,null,null,null,47);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000026','gtpc','gtpc','object',1,'udp/2123 ( gtpv1/gtpv2 )');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000023','50000000-0000-0000-0000-000000000026','udp','0-65535','2123',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000027','gtpu','gtpu','object',1,'udp/2152 ( gtpv1 )');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000024','50000000-0000-0000-0000-000000000027','udp','0-65535','2152',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000028','gtpv0','gtpv0','object',1,'udp/3386');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000025','50000000-0000-0000-0000-000000000028','udp','0-65535','3386',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000029','h225','h225','object',1,'tcp/1720');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000026','50000000-0000-0000-0000-000000000029','tcp','0-65535','1720',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000030','h245','h245','object',1,'h245 protocol');
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000031','h323','h323','object',1,'tcp/1719');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000027','50000000-0000-0000-0000-000000000031','tcp','0-65535','1719',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000032','h323-rtcp','h323-rtcp','object',1,'h323-rtcp protocol ( dynamic port )');
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000033','h323-rtp','h323-rtp','object',1,'h323-rtp protocol ( dynamic port )');
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000034','h323-t120','h323-t120','object',1,'h323-t120 protocol ( dynamic port )');
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000035','hostname','hostname','object',1,'tcp/101');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000028','50000000-0000-0000-0000-000000000035','tcp','0-65535','101',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000036','http','http','object',1,'tcp/80');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000029','50000000-0000-0000-0000-000000000036','tcp','0-65535','80',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000037','https','https','object',1,'tcp/443');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000030','50000000-0000-0000-0000-000000000037','tcp','0-65535','443',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000038','hwcc','hwcc','object',1,'udp/10000');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000031','50000000-0000-0000-0000-000000000038','udp','0-65535','10000',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000039','icmp','icmp','object',1,'icmp protocol (ID of internet protocol:1)');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000032','50000000-0000-0000-0000-000000000039','icmp',null,null,null,null,1);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000040','icmpv6','icmpv6','object',1,'icmpv6 protocol (ID of internet protocol:58)');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000033','50000000-0000-0000-0000-000000000040','icmpv6',null,null,null,null,null);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000041','igmp','igmp','object',1,'igmp protocol');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000034','50000000-0000-0000-0000-000000000041','ip',null,null,null,null,2);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000042','ils','ils','object',1,'tcp/1002');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000035','50000000-0000-0000-0000-000000000042','tcp','0-65535','1002',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000043','imap','imap','object',1,'tcp/143');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000036','50000000-0000-0000-0000-000000000043','tcp','0-65535','143',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000044','ipinip','ipinip','object',1,'ipinip protocol');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000037','50000000-0000-0000-0000-000000000044','ip',null,null,null,null,4);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000045','irc','irc','object',1,'tcp/194');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000038','50000000-0000-0000-0000-000000000045','tcp','0-65535','194',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000046','klogin','klogin','object',1,'tcp/543');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000039','50000000-0000-0000-0000-000000000046','tcp','0-65535','543',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000047','kshell','kshell','object',1,'tcp/544');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000040','50000000-0000-0000-0000-000000000047','tcp','0-65535','544',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000048','l2tp','l2tp','object',1,'udp/1701');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000041','50000000-0000-0000-0000-000000000048','udp','0-65535','1701',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000049','login','login','object',1,'tcp/513');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000042','50000000-0000-0000-0000-000000000049','tcp','0-65535','513',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000050','lpd','lpd','object',1,'tcp/515');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000043','50000000-0000-0000-0000-000000000050','tcp','0-65535','515',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000051','mgcp','mgcp','object',1,'udp/2727');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000044','50000000-0000-0000-0000-000000000051','udp','0-65535','2727',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000052','mms','mms','object',1,'tcp/1755');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000045','50000000-0000-0000-0000-000000000052','tcp','0-65535','1755',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000053','mms-rtcp','mms-rtcp','object',1,'mms-rtcp protocol ( dynamic port )');
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000054','mms-rtp','mms-rtp','object',1,'mms-rtp protocol ( dynamic port )');
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000055','mobileip-ag','mobileip-ag','object',1,'udp/434');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000046','50000000-0000-0000-0000-000000000055','udp','0-65535','434',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000056','mobileip-mn','mobileip-mn','object',1,'udp/435');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000047','50000000-0000-0000-0000-000000000056','udp','0-65535','435',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000057','msn','msn','object',1,'tcp/1863');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000048','50000000-0000-0000-0000-000000000057','tcp','0-65535','1863',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000058','msn-audio','msn-audio','object',1,'udp/7001');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000049','50000000-0000-0000-0000-000000000058','udp','0-65535','7001',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000059','msn-derived','msn-derived','object',1,'msn-derived protocol ( dynamic port )');
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000060','msn-discard','msn-discard','object',1,'udp/9');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000050','50000000-0000-0000-0000-000000000060','udp','0-65535','9',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000061','msn-stun','msn-stun','object',1,'udp/3478');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000051','50000000-0000-0000-0000-000000000061','udp','0-65535','3478',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000062','multihome','multihome','object',1,'sctp multihome table');
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000063','nameserver','nameserver','object',1,'udp/42');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000052','50000000-0000-0000-0000-000000000063','udp','0-65535','42',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000064','netbios-datagram','netbios-datagram','object',1,'udp/138');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000053','50000000-0000-0000-0000-000000000064','udp','0-65535','138',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000065','netbios-name','netbios-name','object',1,'udp/137');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000054','50000000-0000-0000-0000-000000000065','udp','0-65535','137',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000066','netbios-session','netbios-session','object',1,'tcp/139');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000055','50000000-0000-0000-0000-000000000066','tcp','0-65535','139',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000067','netbios-ssn','netbios-ssn','object',1,'udp/139');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000056','50000000-0000-0000-0000-000000000067','udp','0-65535','139',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000068','nntp','nntp','object',1,'tcp/119');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000057','50000000-0000-0000-0000-000000000068','tcp','0-65535','119',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000069','ntp','ntp','object',1,'udp/123');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000058','50000000-0000-0000-0000-000000000069','udp','0-65535','123',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000070','ospf','ospf','object',1,'ospf protocol');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000059','50000000-0000-0000-0000-000000000070','ip',null,null,null,null,89);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000071','p2p','p2p','object',1,'p2p protocol');
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000072','pop2','pop2','object',1,'tcp/109');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000060','50000000-0000-0000-0000-000000000072','tcp','0-65535','109',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000073','pop3','pop3','object',1,'tcp/110');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000061','50000000-0000-0000-0000-000000000073','tcp','0-65535','110',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000074','portalserver','portalserver','object',1,'udp/62314');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000062','50000000-0000-0000-0000-000000000074','udp','0-65535','62314',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000075','pptp','pptp','object',1,'tcp/1723');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000063','50000000-0000-0000-0000-000000000075','tcp','0-65535','1723',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000076','pptp-gre','pptp-gre','object',1,'pptp gre');
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000077','qq','qq','object',1,'udp/8000');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000064','50000000-0000-0000-0000-000000000077','udp','0-65535','8000',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000078','qq-derived','qq-derived','object',1,'qq-derived protocol ( dynamic port )');
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000079','radius','radius','object',1,'udp/1812');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000065','50000000-0000-0000-0000-000000000079','udp','0-65535','1812',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000080','radius-accounting','radius-accounting','object',1,'udp/1813');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000066','50000000-0000-0000-0000-000000000080','udp','0-65535','1813',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000081','ras','ras','object',1,'udp/1719');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000067','50000000-0000-0000-0000-000000000081','udp','0-65535','1719',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000082','rip','rip','object',1,'udp/520');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000068','50000000-0000-0000-0000-000000000082','udp','0-65535','520',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000083','rpc','rpc','object',1,'tcp/135, udp/135');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000069','50000000-0000-0000-0000-000000000083','udp','0-65535','135',null,null,17);
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000070','50000000-0000-0000-0000-000000000083','tcp','0-65535','135',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000084','rsh','rsh','object',1,'tcp/514');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000071','50000000-0000-0000-0000-000000000084','tcp','0-65535','514',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000085','rsh-data','rsh-data','object',1,'remote shell data protocol ( dynamic port )');
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000086','rtsp','rtsp','object',1,'udp/554, tcp/554');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000072','50000000-0000-0000-0000-000000000086','udp','0-65535','554',null,null,17);
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000073','50000000-0000-0000-0000-000000000086','tcp','0-65535','554',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000087','rtsp-rtcp','rtsp-rtcp','object',1,'rtcp protocol ( dynamic port )');
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000088','rtsp-rtp','rtsp-rtp','object',1,'rtp protocol ( dynamic port )');
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000089','sccp','sccp','object',1,'tcp/2000');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000074','50000000-0000-0000-0000-000000000089','tcp','0-65535','2000',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000090','sccp-rtp','sccp-rtp','object',1,'sccp-rtp ( dynamic port )');
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000091','sctp','sctp','object',1,'sctp packet');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000075','50000000-0000-0000-0000-000000000091','sctp','0-65535','0-65535',null,null,132);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000092','sctp-close','sctp-close','object',1,'sctp abort or shutdown packet');
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000093','sctp-init','sctp-init','object',1,'sctp init packet');
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000094','sip','sip','object',1,'udp/5060, tcp/5060');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000076','50000000-0000-0000-0000-000000000094','udp','0-65535','5060',null,null,17);
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000077','50000000-0000-0000-0000-000000000094','tcp','0-65535','5060',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000095','sip-rtcp','sip-rtcp','object',1,'sip-rtcp protocol ( dynamic port )');
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000096','sip-rtp','sip-rtp','object',1,'sip-rtp protocol ( dynamic port )');
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000097','smtp','smtp','object',1,'tcp/25');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000078','50000000-0000-0000-0000-000000000097','tcp','0-65535','25',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000098','snmp','snmp','object',1,'udp/161');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000079','50000000-0000-0000-0000-000000000098','udp','0-65535','161',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000099','snmptrap','snmptrap','object',1,'udp/162');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000080','50000000-0000-0000-0000-000000000099','udp','0-65535','162',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000100','sqlnet','sqlnet','object',1,'tcp/1521');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000081','50000000-0000-0000-0000-000000000100','tcp','0-65535','1521',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000101','sqlnet-data','sqlnet-data','object',1,'sqlnet-data protocol ( dynamic port )');
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000102','ssh','ssh','object',1,'tcp/22');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000082','50000000-0000-0000-0000-000000000102','tcp','0-65535','22',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000103','stun-derived','stun-derived','object',1,'stun-derived protocol ( dynamic port )');
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000104','sunrpc-tcp','sunrpc-tcp','object',1,'tcp/111');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000083','50000000-0000-0000-0000-000000000104','tcp','0-65535','111',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000105','sunrpc-udp','sunrpc-udp','object',1,'udp/111');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000084','50000000-0000-0000-0000-000000000105','udp','0-65535','111',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000106','syn','syn','object',1,'syn packet');
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000107','syslog','syslog','object',1,'udp/514');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000085','50000000-0000-0000-0000-000000000107','udp','0-65535','514',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000108','tacacs','tacacs','object',1,'tcp/49');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000086','50000000-0000-0000-0000-000000000108','tcp','0-65535','49',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000109','tacacs-ds','tacacs-ds','object',1,'udp/65');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000087','50000000-0000-0000-0000-000000000109','udp','0-65535','65',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000110','talk-tcp','talk-tcp','object',1,'tcp/517');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000088','50000000-0000-0000-0000-000000000110','tcp','0-65535','517',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000111','talk-udp','talk-udp','object',1,'udp/517');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000089','50000000-0000-0000-0000-000000000111','udp','0-65535','517',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000112','tcp','tcp','object',1,'tcp packet (ID of internet protocol:6)');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000090','50000000-0000-0000-0000-000000000112','tcp','0-65535','0-65535',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000113','telnet','telnet','object',1,'tcp/23');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000091','50000000-0000-0000-0000-000000000113','tcp','0-65535','23',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000114','tftp','tftp','object',1,'udp/69');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000092','50000000-0000-0000-0000-000000000114','udp','0-65535','69',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000115','time-tcp','time-tcp','object',1,'tcp/37');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000093','50000000-0000-0000-0000-000000000115','tcp','0-65535','37',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000116','time-udp','time-udp','object',1,'udp/37');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000094','50000000-0000-0000-0000-000000000116','udp','0-65535','37',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000117','udp','udp','object',1,'udp packet (ID of internet protocol:17)');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000095','50000000-0000-0000-0000-000000000117','udp','0-65535','0-65535',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000118','uucp','uucp','object',1,'tcp/540');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000096','50000000-0000-0000-0000-000000000118','tcp','0-65535','540',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000119','who','who','object',1,'udp/513');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000097','50000000-0000-0000-0000-000000000119','udp','0-65535','513',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000120','whois','whois','object',1,'tcp/43');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000098','50000000-0000-0000-0000-000000000120','tcp','0-65535','43',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000121','xdmcp','xdmcp','object',1,'udp/177');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000099','50000000-0000-0000-0000-000000000121','udp','0-65535','177',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000122','imaps','imaps','object',1,'tcp/993');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000100','50000000-0000-0000-0000-000000000122','tcp','0-65535','993',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000123','kerberos-tcp','kerberos-tcp','object',1,'tcp/88');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000101','50000000-0000-0000-0000-000000000123','tcp','0-65535','88',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000124','kerberos-udp','kerberos-udp','object',1,'udp/88');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000102','50000000-0000-0000-0000-000000000124','udp','0-65535','88',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000125','mgcp-rtcp','mgcp-rtcp','object',1,'mgcp-rtcp protocol ( dynamic port )');
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000126','mgcp-rtp','mgcp-rtp','object',1,'mgcp-rtp protocol ( dynamic port )');
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000127','mysql','mysql','object',1,'tcp/3306');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000103','50000000-0000-0000-0000-000000000127','tcp','0-65535','3306',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000128','pop3s','pop3s','object',1,'tcp/995');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000104','50000000-0000-0000-0000-000000000128','tcp','0-65535','995',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000129','rdp-tcp','rdp-tcp','object',1,'tcp/3389');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000105','50000000-0000-0000-0000-000000000129','tcp','0-65535','3389',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000130','rdp-udp','rdp-udp','object',1,'udp/3389');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000106','50000000-0000-0000-0000-000000000130','udp','0-65535','3389',null,null,17);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000131','smb','smb','object',1,'tcp/445');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000107','50000000-0000-0000-0000-000000000131','tcp','0-65535','445',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000132','smtps','smtps','object',1,'tcp/465');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000108','50000000-0000-0000-0000-000000000132','tcp','0-65535','465',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000133','sqlserver','sqlserver','object',1,'tcp/1433');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000109','50000000-0000-0000-0000-000000000133','tcp','0-65535','1433',null,null,6);
insert into tab_secm_serviceset_deploy (pkid,serviceset_name,serviceset_name_cn,serviceset_type,pre_defined,serviceset_desc) values('50000000-0000-0000-0000-000000000134','vxlan','vxlan','object',1,'udp/4789');
insert into tab_secm_serviceset_item_deploy (pkid,serviceset_id,protocol_type,source_port,dest_port,icmp_type,icmp_code,protocol_id) values('50000000-0000-0000-0000-000000000110','50000000-0000-0000-0000-000000000134','udp','0-65535','4789',null,null,17);



update tab_secm_serviceset_item_deploy set unique_code=0 where unique_code is null;
update tab_secm_serviceset_item_deploy set icmp_type=0 where icmp_type is null;
update tab_secm_serviceset_item_deploy set protocol_id=0 where protocol_id is null;


update tab_secm_serviceset_deploy set unique_code=0 where unique_code is null;
update tab_secm_serviceset_deploy set locked=0 where locked is null;
update tab_secm_serviceset_deploy set universal=true where pre_defined=1;
--19.3.0.032_END

--19.3.0.036_BEGIN
update tab_secm_serviceset_deploy set poly = 0 where poly is null;
--19.3.0.036_END

--19.2.1.001_BEGIN
select alter_columns('add','TAB_SECM_G_OBJ_SIGNATURE','status','smallint default 0');
--19.2.1.001_END

--19.2.0.001_BEGIN
select alter_columns('add','tab_secm_G_OBJ_URL_TYPE','old_name','varchar(3072)');
select alter_columns('add','tab_secm_G_OBJ_URL_TYPE','universal','boolean default false');
alter table tab_secm_G_OBJ_URL_TYPE rename uniqueCode TO unique_code;
alter table tab_secm_G_OBJ_URL_TYPE rename tenant_id TO adom_id;

select alter_columns('add','tab_secm_deploy_obj_url_type','adom_id','varchar(255)');
select alter_columns('add','tab_secm_deploy_obj_url_type','old_name','varchar(3072)');
select alter_columns('add','tab_secm_deploy_obj_url_type','universal','boolean default false');
alter table tab_secm_deploy_obj_url_type rename uniqueCode TO unique_code;

select alter_columns('add','tab_secm_ngfw_obj_url_type','adom_id','varchar(255)');
select alter_columns('add','tab_secm_ngfw_obj_url_type','old_name','varchar(3072)');
select alter_columns('add','tab_secm_ngfw_obj_url_type','universal','boolean default false');
alter table tab_secm_ngfw_obj_url_type rename uniqueCode TO unique_code;

update tab_secm_ngfw_obj_url_type set universal=false;

select alter_columns('add','TAB_SECM_G_OBJ_URL_TYPE','RELATION_TYPE_ID','varchar(64)');
select alter_columns('add','tab_secm_ngfw_obj_url_type','RELATION_TYPE_ID','varchar(64)');
select alter_columns('add','tab_secm_deploy_obj_url_type','RELATION_TYPE_ID','varchar(64)');
select alter_columns('drop','tab_secm_ngfw_obj_url_type','name_cn','not null');
insert into tab_secm_G_OBJ_URL_CATEGORY(pkid,name,name_cn,category_id,description,description_cn) values(60000000,'Custom','自定义',0,'Custom web site','自定义网站类型');

select alter_columns('add','TAB_SECM_NGFW_PF_URL_FILTER_USER','CATEGORY_NAME','character varying(255)');

-- tab_secm_deploy_obj_url_type URL分类部署表预置预定义数据
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000101,'P2P','P2P','Web sites that provide the introduction to and download of P2P resources. These Web sites are always bound to contain P2P tools such as Thunder and VeryCD, providing seed download, search, and release.','提供P2P资源下载、资源介绍的网站，该类网站常和一些P2P工具结合在一起，提供种子下载、搜索、发布，如迅雷、verycd等。',101,60000001,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000102,'e-Books','电子书下载','Web sites that provide e-book download and online reading.','提供电子书下载以及在线阅读的网站。',102,60000002,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000162,'Software Download','软件下载','Web sites that provides the download of various software resources. The Web sites providing hacker tool download may be grouped to the hacker category.','提供各种软件资源下载的网站，对于提供一些黑客工具下载的网站也有可能被分到黑客类中。',162,60000002,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000163,'Picture Download','图片下载','Web sites that provide the download of pictures, wallpapers, and themes.','提供图片资源、桌面墙纸、桌面主题等下载的网站。',163,60000002,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000164,'Music/Film Download','音乐/电影下载','Web sites that provide the download of music and movies. For the Web sites supporting online play, see the streaming media category.','提供各种音乐、电影下载的网站，但是涉及到在线播放的网站请参考流媒体分类。',164,60000002,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000165,'General Download','其他下载','Web sites that provide the download of other types of information, such as the ringtone and MMS.','提供其他类型的信息下载的网站，如铃声、彩信等。',165,60000002,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000103,'History/Culture','历史/文化','Web sites that are created by organizations such as museums, memorials, and art galleries to exhibit and propagate history and cultures.','包括但不限于由博物馆、纪念馆、艺术馆等机构创办的以展示和宣扬历史、文化为主要目的的网站。',103,60000003,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000166,'Literature','文学','Web sites that provide information about literature, for example, discussing, publishing, and exhibiting poems, prose, novels, and philosophy.','与文学相关的网站，如讨论、发表、展示诗词、散文、小说、哲学等文学作品的网站。',166,60000003,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000167,'Arts','艺术','Web sites that provide information about arts, for example, discussing and exhibiting drawings, calligraphy, sculptures, dramas, and dancing.','与艺术相关的网站，如讨论、展示绘画、书法、雕塑等作品的网站，戏剧、舞蹈等各类表演艺术的网站。',167,60000003,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000168,'Music','音乐','Web sites that provide an introduction to music, such as pop music, classical music, and musical instruments. These Web sites do not support song download and online play.','提供音乐信息介绍的网站，如流行歌曲、古典乐曲和乐器等的介绍网站。歌曲下载和在线播放等不属于音乐类网站。',168,60000003,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000104,'Competitive Sports','竞技体育','Web sites that provide information about competitive sports such as soccer, basketball, boxing, baseball, swimming, and extreme sports.','与竞技类体育活动相关的网站，如足球、篮球、拳击、垒球、游泳及极限运动等。',104,60000004,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000169,'Leisure Sports','休闲运动','Web sites that provide information about leisure sports such as wushu, qigong, fishing, hunting, mountain-climbing, fitness, and camping.','与休闲类体育活动相关的网站，如武术、气功、钓鱼、打猎、登山、健身和野营等。',169,60000004,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000170,'Sports Equipment','运动用品','Web sites that provide information about the tools, equipment, and clothes used for both competitive and leisure sports, for example, the cue, fishing gear, outdoor sports equipment, camping supplies, and sportswear. Transaction Web sites for sports facilities also belong to this category.','与体育运动（包括竞技体育和休闲运动）中所使用的工具、装备和衣物等相关的网站，如球杆、渔具、户外运动装备、野营用品和运动服装等。',170,60000004,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000105,'Charity/Public Welfare','慈善/公益','Web sites that provide information about public welfare and charity activities, including the organizations and communities for public welfare and charity, for example, Red Cross Society and Hope Project.','与公益和慈善活动相关的网站，包括以公益和慈善为目的的组织和团体，如红十字会、希望工程等。',105,60000005,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000171,'Ecology/Development/Energy','生态/发展/能源','Web sites that provide topics about ecology, development, and energy, for example, environment protection, sustainable development, and energy saving.','与生态、发展和能源相关的话题，如环境保护、可持续发展、节能等。',171,60000005,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000172,'Anti-Terrorism/Criminal Issue Discussion','反恐/犯罪问题讨论','Web sites that provide discussions on anti-terrorism and crime commitment, for example, terrorism, crime prevention, gun control, and death penalty.','讨论反恐或犯罪等相关问题的网站，如恐怖主义、预防犯罪、枪支管理、死刑问题等。',172,60000005,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000173,'Social Issue/Life Style','社会问题/生活方式','Web sites that provide information about the social issues uninvolved in the previous categories, for example, labor protection, social security, pension, Internet addiction, drug addiction, and suicide.','常见的除其它类别中所涉及的社会问题，如劳动保障、社会保障、养老、戒网瘾、毒瘾、自杀现象等。',173,60000005,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000174,'Human Rights/Racial Issue','人权/种族问题','Web sites that provide objective discussions on human rights and racial issues, for example, human rights, civil rights, civil liberty, racial relationship, and racial prejudice.','以客观态度讨论与人权和种族相关的话题，如人权、公民权益、公民自由、种族关系、种族偏见等，不带有明显的偏向一方的意见。',174,60000005,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000106,'Military','军事','Web sites that are created and sponsored by military organizations and provide information about military affairs, weapons, national defense, soldiers life, military history, and the life of demobilized soldiers and dependants.','由军事机关赞助创办的网站，包括但不限于与军事、兵器、国防、士兵生活、军事历史等，也包括退伍军人、军人家属生活介绍等。',106,60000006,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000108,'Blogs/Community','博客/社区','Webs sites that provide the functions of blogging and personal Web sites as well as online communities.','以提供博客、个人网站等为主要功能的网站及在线社区等网站。',108,60000007,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000251,'Micro Blog','微博','Webs sites that provide the functions of micro-blogging.','以提供微博为主要功能的网站。',251,60000007,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000177,'Online Photo/Network Albums','个人相册/网络相册','Web sites that provide the Web album function, through which you can upload and share your photos.','主要提供网络相册功能，可以上传、共享照片。',177,60000007,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000109,'Lottery','博彩','Web sites that provide the rule introduction, query, and purchase of legal lotteries, welfare lotteries, and soccer lotteries.','合法的彩票、福彩、足彩等，如提供规则介绍、查询、购买的网站。',109,60000008,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000110,'Dating/Personals','成人聊天/交友','Web sites that provide services such as adult chatting and friend making, involving online personals sites. Once registered, you can search for male or female members to communicate.','提供成人聊天、交友服务的网站，如注册后，提供查找异性或者同性会员进行交流，包括一些婚恋网站。',110,60000009,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000248,'Gay/Lesbian Dating','同性恋交友','Web sites that are mainly for Gay/Lesbian Dating','主要针对同性恋人群的交友网站',248,60000009,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000178,'Chat','聊天/交友','Web sites for other types of chatting or friend making, except the adult type.','除成人聊天交友之外的其他类型的聊天或交友网站。',178,60000009,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000111,'Cartoon/Animation','动漫','Web sites that provide information about cartoon and animation.','与卡通、动漫相关题材的网站。',111,60000009,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000112,'Adult Recreational Places','成人娱乐场所','Web sites that provide information about adult recreational places such as bars, dance halls, night pubs, and other adult-only recreational places.','各类成人娱乐场所，包括酒吧、舞厅、夜总会、以及各种儿童不宜的休闲会所等。',112,60000009,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000179,'Recreational Place_Others','其他娱乐场所','Web sites that provide information about recreational places of other types, such as parks, cinemas, and skiing resorts.','其他类型的娱乐场所，如各类公园、电影院、滑雪场等。',179,60000009,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000114,'Recreation','娱乐','Web sites that provide recreational information including movie stars, gossip, movie and music introduction, fun, greeting cards, and flashes.','主要提供娱乐信息，包括单不限于影视明星八卦信息、电影音乐介绍、搞笑、贺卡、flash欣赏等。',114,60000009,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000115,'Video Games','视频游戏','Web sites that provide information about video games, for example, introduction, download, and online play of PC games, online games, TV games, and other small games.','主要和视频游戏相关的网站，如介绍、下载、在线玩等，包括电脑单机游戏、电脑网络游戏、电视游戏机、在线小游戏等。',115,60000009,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000180,'Board and Card Games','棋牌游戏','Web sites that provide the download and online play of games such as cards, chess, and go.','以打牌、象棋、围棋为主要游戏内容的网站，提供下载、在线玩等。',180,60000009,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000181,'Other Games','其它游戏','Web sites that provide the information about the games of other types, such as paintball and live CS.','除视频游戏和棋牌游戏的其他类游戏，比如彩弹、真人CS等。',181,60000009,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000117,'Toys','玩具','Web sites that provide the introduction to and exhibition of tools, for example, the usage, refitting, and transaction of dolls, military models, airplane and automobile models, and navigation models.','介绍或者展示玩具的网站，如各种娃娃、军事模型、汽车飞机模型、航模等，包括如何使用、组装、交易等。',117,60000009,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000118,'Religion','宗教','Web sites that provide the propagation of or introduction to mainstream denominations such as Christianity, Catholicism, Buddhism, Islam, and Hinduism.','宣传或介绍各种主流教派的网站，如基督教、天主教、佛教、伊斯兰教、印度教等。',118,60000010,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000119,'Divining/Supernatural','占卜/超自然','Web sites that provide the information about divining and supernatural imagination, for example, constellation, glyphomancy, fortune-telling, UFO, and supernatural phenomena.','与占卜、超自然想象相关的网站，如星座、测字、算命、UFO、灵异现象等。',119,60000010,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000122,'Adult Suppliers','成人用品','Web sites that provide the exhibition or sales of adult suppliers and adult toys.','展示或者销售各种类型的成人用品、成人玩具的网站。',122,60000012,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000182,'Sexual Health/Tips','两性健康/资讯','Web sites that provide information about sexual health, venereal disease, and sexual skills.','提供与两性健康、性病、性爱技巧等相关资讯内容的网站。',182,60000012,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000183,'Nudity','裸体/人体艺术','Web sites that provide information about body arts, nude paintings, nudists, and nude activities.','提供人体艺术、裸体画，以及裸体主义者、裸体活动等的网站。',183,60000012,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000184,'Homosexual Subjects','同性恋话题','Web sites that provide information about homosexual subjects, friend making, and clubs.','与同性恋相关的话题、以及各种同性恋交友、同性恋俱乐部等的网站。',184,60000012,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000123,'Gardens/Yards','花园/庭院','Web sites that provide information about private gardens and yards, such as garden design, reconstruction, landscape, lawn, as well as tools and equipment involved in these activities.','与私人花园、庭院相关内容的网站，如花园设计、改造、景观、草坪以及进行这些活动所可能用到的工具、设备等。',123,60000013,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000186,'Household Appliances','家电','Web sites that provide the introduction to and sales of household appliance, for example, appliance shops and second-hand appliance transaction.','介绍、销售家用电器的网站，如电器商城、二手电器买卖等。',186,60000013,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000187,'Furniture/Daily Necessities','家具/日常用品','Web sites that provide the introduction to and sales of furniture and daily necessities such as desks, chairs, pots, pans, doors, windows, tableware, and bedding.','介绍、销售家具、日常用品的网站，如桌椅板凳、锅碗瓢盆、门窗、餐具、床上用品等。',187,60000013,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000188,'Housekeeping ','家政','Web sites that provide housekeeping information such as nursemaids, monthly baby sitters, cleaning services, sewer dredging services, and household appliance repair services.','提供各种家政信息的网站，如保姆、月嫂、清洁、疏通下水道、家电维修等。',188,60000013,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000189,'Decoration','装修','Web sites that provide information about decoration, including decoration materials and model demonstration.','与家庭装修相关的网站，包括但不限于装饰材料、样板展示。装修信息等。',189,60000013,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000124,'Real Estate Information','房产信息','Web sites that provide information about real estate transaction, renting, and second-hand houses.','提供房屋买卖、租赁、二手房等信息的网站。',124,60000013,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000125,'Job Search','求职招聘','Web sites that provide information about job hunting, recruitment, headhunting, human resources, work experience, careers, and interviews.','提供各种找工作、招聘、猎头、人力资源、职场经验、职业生涯、面试等相关内容的网站。',125,60000014,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000126,'Search Engines','搜索引擎','Web sites that provide professional search services, mainly searching for Web information. If a Web site only provides the search for a specific type of information, such as music or map, refer to the streaming media, P2P, or life category.','专业提供搜索服务的网站，主要指搜索网页信息。如果网站只提供搜索某特定类型的信息如音乐、地图等则请参考流媒体、P2P或者生活参考类。',126,60000015,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000190,'Portals','门户网站','Web sites that serve as comprehensive information platform, portals, and local information harbors.','各类综合信息平台、门户网站、地方信息港等。',190,60000015,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000127,'Governments/Governmental Departments','政府及职能部门','Web sites that are created by central and local governments and governmental departments, such as public security office, fire control, and tax bureau.','中央、地方政府及各政府职能部门创建的网站，如公安、消防、税务局等。',127,60000016,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000128,'Politics','政治观点','Web sites that are sponsored by political communities to propagate their political thoughts or focus on a specific field, for example, reformation towards a social public field, and attention to specific group. This category aims to propagate different political thoughts, and is not apt to anti-society and anti-human. You can compare this category with the hatred speech and cult category.','由政治团体资助，宣扬其政治思想或关注某特定领域，如针对社会公共领域的改革、特定群体关注等，此类重在宣扬不同的政治观点。',128,60000016,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000191,'Higher Education','高等教育','Web sites that provide information about formal education above high school education, including college and university Web sites, college students, graduation, and papers.','高中以上的正规教育，包括各大学、学院的网站，以及与大学生、毕业、论文等相关的话题。',191,60000017,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000192,'Skill Training/Examinations','技能培训/考试','Web sites that provide information about vocational skill training and examinations, such as adult education, distant education, lawyer and judicial examinations, grading examinations, and driving training.','提供各种职业技能培训和考试信息的站点，如成人教育、远程教育、律师、司法考试、等级考试以及驾校培训等。',192,60000017,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000193,'Science/Research','科学/研究','Web sites that provide information about scientific research institutes, laboratories, academy, astronomy, geography, physics, and chemistry.','各种类型的科研院所、实验室、研究院，以及与科学研究相关的天文、地理、物理、化学等学术性质的网站。',193,60000017,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000194,'Pre-School','学前教育','Web sites that provide information about preschool education, such as pre-schools, kindergartens, and nurseries.','与入小学之前相关的教育网站，如学前教育、幼儿园、托儿所等。',194,60000017,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000195,'General Education','一般性教育信息','Web sites that provide other types of comprehensive or general education information ungrouped into the previous categories.','不能归类到其他类别的提供综合或一般性教育信息的网站。',195,60000017,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000196,'Enrollment','招生信息','Web sites that provide information about enrollment at schools or training organizations.','提供或介绍各种学校或培训机构的招生信息的网站。',196,60000017,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000129,'Primary/Middle School Education','中小学教育','Web sites that provide information about middle school and primary school education, including school homepages and related education information.','与中学、小学教育相关的网站，如学校主页，以及相关的教育信息等。',129,60000017,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000130,'News/Media','新闻/媒体','Web sites that provide information about news and the homepages of varieties of media such as television stations, broadcasting/TV stations, and publications.','以提供新闻资讯为主的网站，以及各类媒体包括电视台、广播电视台和刊物的主页。',130,60000018,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000131,'Travel','旅游','Web sites that provide tourism information, introduction, and services including tourism companies, accommodation, and hotels.','提供旅游信息、旅游介绍、旅游服务包括旅游公司、住宿、酒店等的网站。',131,60000019,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000197,'Clothes','服装','Web sites that provide the information about clothes, shoes, and hats, excluding underwear and swimwear.','各种类型的服装、鞋帽，但不包括内衣和泳衣等暴露性服装。',197,60000020,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000198,'Jewelry','首饰/珠宝','Web sites that introduce or sell jewelries.','介绍或者销售首饰、珠宝的网站。',198,60000020,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000199,'Clothing Accessories','饰品/服装配件','Web sites that that introduce or sell clothing accessories such as glasses, hair accessories, bags, handbags, lighters, and watches.','介绍或者销售各种饰品或服装配件，如眼镜、头发饰品、包、手袋、打火机、手表等。',199,60000020,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000132,'Make-up/Cosmetics','美容/化妆','Web sites that provide the introduction to cosmetology or sales of cosmetology products, for example, cosmetology institutions, cosmetology techniques, and cosmetics.','介绍或者销售美容、化妆相关网站，如美容产品、美容机构、美容技术、化装品等。',132,60000020,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000227,'Lingerie','内衣/性感服饰','Web sites that that introduce or sell underwear, silk stockings, and sexy or alluring clothes.','出售或介绍内衣、丝袜以及性感的或带有诱惑性质的衣服的网站。',227,60000020,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000228,'Tattoos/Body Painting','纹身/刺青','Web sites that provide information about services such as body paintings, tattoos and piercing.','提供纹身、刺青以及穿孔等服务或相关信息的网站。',228,60000020,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000200,'General Fashion','其他时尚','Web sites that provide comprehensive fashion information ungrouped into the previous categories.','未归到上面类的其他时尚相关的网站。',200,60000020,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000133,'Automobiles','汽车','Web sites that provide information about automobile introduction, automobile transaction, second-hand automobiles, automobile parts, automobile decoration, and automobile repair.','提供汽车介绍、汽车买卖、二手车，以及汽车配件、汽车美容和汽车维修等信息的网站。',133,60000021,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000201,'Ships','船','Web sites that provide information about various ships, such as motorboats, yachts, and launches.','介绍各类船只，如摩托艇、游艇、汽艇等的网站。',201,60000021,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000202,'Airplanes','飞机','Web sites that provide information about airplanes, such as the hardstand, private airplanes, and aviation shows.','与飞机相关的网站，如停机场、私人飞机、航空展等。',202,60000021,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000204,'Motorcycles/Bicycles','摩托车/自行车','Web sites that provide information about the introduction to and sales of motorcycles and bicycles.','与摩托车、自行车的买卖、介绍相关的网站。',204,60000021,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000205,'Vehicle Renting','交通工具租赁','Web sites that provide information about the renting of automobiles, buses, airplanes, and ships.','与汽车租赁、巴士租赁、飞机和船租赁相关的网站。',205,60000021,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000134,'Laws','法律','Web sites that provide information about laws, such as layers, law offices, law introduction, and judicial expertise.','与法律相关的站点，如律师、律师事务所、法律介绍、司法鉴定等。',134,60000022,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000135,'Streaming Media','流媒体','Web sites that provide online audio and video services and Web cameras, excluding those providing online audio and video chats.','各类提供在线音视频服务的网站，以及网络摄像头网站，但不包括在线音视频聊天的网站。',135,60000023,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000136,'Disease/Medical Care','疾病/医疗','Web sites that provide information about diseases and medical care, such as disease information, medical care institution homepages, doctor information, and medical care information.','与疾病、医疗相关的网站，如疾病资讯、医疗机构的主页、大夫信息，医疗资讯等。',136,60000024,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000206,'Mental Health','心理健康','Web sites that provide information about mental health and the treatment, such as mental health, mental depression, insomnia, and anxiety.','涉及心理健康及其治疗的网站，如心理卫生、精神抑郁、压抑、失眠、焦虑等。',206,60000024,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000207,'Health Care','卫生/保健','Web sites that provide information about health care, such as nutrition information, health information, varieties of health care products, massage, and public health.','与卫生保健相关的，如营养资讯、保健资讯、各类保健品、按摩推拿以及公共卫生等。',207,60000024,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000208,'Medicine','药品','Web sites that that introduce or sell various medicines, including the Web sites of pharmacies.','提供介绍、销售各种药品信息的网站，包括药店的网站。',208,60000024,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000137,'Transportation Guide','出行指南','Web sites that provide information about travels, such as electronic maps, bus lines, train and flight schedules, and weather reports.','提供各类辅助出行信息的网站，如电子地图、公交线路、列车航班时刻、天气预报等。',137,60000024,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000209,'Ticket','票务信息','Web sites that provide information about tickets for coach/ship/airplane ticket, concert, movies, and scenic spots.','与票务信息相关的网站，包括车/船/飞机票、演唱会门票、电影票、旅游景点门票等。',209,60000024,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000210,'Reference Information','其他生活','Web sites that provide comprehensive information and or other types of reference information, such as encyclopedias, missing people notices, online translation, and postal code/phone/IP address query.','综合性的或其他类型的参考信息，如百科全书、寻人启事、在线翻译、邮编/电话/IP地址查询等。',210,60000024,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000138,'Family/Marriage','婚姻/家庭','Web sites that provide information about marriage, weddings, love, emotion, family trees, and family history.','包括婚姻介绍、婚庆相关，恋爱、情感以及家谱、家族历史。',138,60000024,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000139,'Pregnancy/Birth','育婴','Web sites that provide information about pregnancy knowledge, child-rearing knowledge, and prenatal education.','包括怀孕知识、育儿知识、胎教等相关的网站。',139,60000024,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000229,'Children/Teenagers','儿童/青少年','Web sites that are designed for children less than 10 years old.','以儿童青少年（十岁以下）为主要目标群进行设计的网站。',229,60000024,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000140,'Animals/Pets','动物','Web sites that provide information about animals (pets), including animal introduction, protection, research, and pet information.','与动物（宠物）相关的网站，包括动物介绍，动物保护，动物研究，以及宠物相关信息的网站。',140,60000024,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000141,'Going Abroad/Emigration','出国/移民','Web sites that provide information about going abroad, migration, studying abroad, working abroad, and intermediaries.','各类出国、移民、留学、出国工作或中介的网站。',141,60000024,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000142,'Software Technologies','软件技术','Web sites that provide the introduction to the usage of various types of software technologies, such as the operating system, programming, image processing, and tool software technologies.','介绍各种软件技术的使用的网站，如操作系统技术、编程技术、图像处理软件、工具软件等。',142,60000025,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000211,'Network/Communication','网络/通信','Web sites that provide information about Web sites or communication technologies, including Web site construction, Web site optimization, routers, switching technologies, Web page design, Web development, wireless networks, and mobile networks.','与网站或通信技术相关的网站，包括网站建设、网站优化、路由器、交换机技术、网页设计，Web开发以及无线网络、移动网络相关的网站。',211,60000025,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000212,'Hardware/Electron','硬件/电子','Web sites that provide the introduction, evaluation, sales, and refitting of computers, computer accessories, digital products, and varieties of electronic products.','介绍、评测、销售、组装各种计算机、计算机配件、数码产品、其他电子产品的网站。',212,60000025,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000143,'Hacker','黑客','Web sites that provide information about hacker technologies, encryption, and decryption, such as the hacker tool, vulnerability trading, and technology introduction.','与黑客技术、解密、破解等相关的网站，如黑客工具，漏洞交易，技术介绍等。',143,60000025,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000144,'Email','电子邮箱','Web sites that provide email services.','提供电子邮箱服务的站点。',144,60000025,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000145,'Web Communication','Web通信','Web sites that provide Web communication services, such as online video conference and online communication.','主要提供web通信的网站，如提供在线视频会议、在线通信等的网站。',145,60000025,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000240,'VoIP','VoIP','Web sites that provide the services of online calls or related information.','提供在线拨打电话或者提供相关信息的网站。',240,60000025,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000146,'HTTP Proxy','HTTP代理','Web sites that provide HTTP proxy lists or Web page proxy services.','提供HTTP代理列表或网页代理服务的网站。',146,60000025,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000213,'Domain Name/IDC Services','域名/IDC服务','Web sites that provide the services of domain name registration, domain name trading, host lease, and server hosting.','提供域名注册、域名买卖、主机租用、服务器托管等的网站。',213,60000025,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000147,'Online Storage','网络存储','Web sites that provide services for online upload and private file download, such as the Web disk.','提供在线上传、下载私人文件服务的网站，如网络硬盘等。',147,60000025,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000253,'Software Update','软件升级','Web sites that provide services for online update of software, such as the anti-virus,OS.','提供杀毒软件病毒特征库升级或者操作系统、程序升级服务的网站。',253,60000025,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000149,'Forum','论坛','Web sites of forums. If the theme of a forum is identified, the Web site is grouped into the corresponding theme category preferentially. For example, the hacker forum Web site is grouped into the hacker category. If a forum has multiple themes, or the theme is hard to identify, the Web site is grouped into the Forum category.','各种论坛网站，如果能够识别出论坛主题的则优先分到对应主题中，比如黑客论坛优先分到黑客类中。',149,60000026,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000150,'Shopping Guide','购物指南','Web sites that provide information about shopping guide, price comparison, and consumer evaluation.','提供购物指南、价格比较、消费者评价信息。',150,60000027,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000214,'Online Bookstore','图书','Web sites for selling books, such as online bookstores and presses.','以出售图书为主要业务的网站，如在线书店、出版社等。',214,60000027,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000215,'Flowers/Gifts','鲜花/礼品','Web sites that provide services for selling flowers and gifts, such as flower sales, flower delivery, and gift sales.','提供鲜花和礼品相关服务的网站，如出售鲜花、鲜花投递、出售礼品等。',215,60000027,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000216,'Audio/Video Products ','音像制品','Web sites for selling audio and video products such as CD, VCD, and DVD, as well as virtual carrier audio and video products such as the itunes shop.','出售各种音像制品，如CD、VCD、DVD等，也包括虚拟载体音像制品的销售，如itunes商店。',216,60000027,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000217,'General Shopping','其他购物','Web sites that provide comprehensive shopping platforms, flea markets, goods exchange, or general online shops.','综合的购物平台、跳蚤市场、物品交换网站或一般性的在线商铺等。',217,60000027,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000218,'Insurance','保险','Web sites that provides the sales of and introduction to various insurance services, such as insurance companies and insurance agent companies.','销售介绍各种保险业务的网站，如保险公司、保险代理公司等。',218,60000028,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000219,'Service','服务业','Web sites that provide information about the tertiary industries except industry and agriculture, including printing, business activity organization, exhibition planning, translation, ritual celebrations, and moving companies.','包括除工业、农业外的第三产业信息，如印刷、商务活动组织、展会策划、翻译服务、礼仪庆典、搬家公司等。',219,60000028,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000220,'Industry/Agriculture','工业/农业','Web sites that provide information about industry, agriculture, forestry, and fishery products, as well as the manufactures of these products.','各种工业、农业、林业、渔业产品，及生产这些产品的公司、企业。',220,60000028,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000221,'Transportation/Logistics','交通/物流','Web sites that provide information about transportation and logistics, such as the railway, aviation, navigation, express, and post services.','和物流交通相关的网站，如铁路、航空、船舶运输，快递、邮政服务。',221,60000028,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000222,'Special Industries','特殊行业','Web sites that provide information about special industries. Most of these industries are controversial and vulnerable to laws, such as debt collecting companies, crisis management, surrogate, private detectives, private lending, satellite TV installation, bodyguard companies, and credit card withdrawal.','某些特殊行业，这些行业存在一定的争议性，很多这些行业处在法律允许的边缘，如讨债公司、危机攻关、代孕、私家侦探、民间借贷等。',222,60000028,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000223,'Investment/Business','投资/商贸','Web sites that provide information about personal finance, money making, stocks, funds, futures, and business trades such as revenue, network marketing, economy and trade, and import and export.','与个人理财、赚钱、股票、基金、期货相关的网站；及与商业贸易相关的网站，如税收、网络营销、经贸、进出口等。',223,60000028,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000252,'Online Payment','在线支付','Web sites that provide a way to pay and get paid online.','提供在线支付、收款业务的网站或者与之相关的公司网站。',252,60000028,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000151,'Bank','银行','Web sites that provide bank-related information, such as official Web sites of banks, credit card information, and loan.','银行以及与银行相关的网站，如银行官网、信用卡信息、贷款等。',151,60000028,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000230,'Advertisement','广告','Web sites that provide information about advertisement and investment.','提供各种广告服务、招商信息等的网站。',230,60000028,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000152,'Tobacco','烟','Web sites that that introduce or sell cigarettes, cigars, and tobacco pipes.','介绍或出售各种香烟、雪茄、烟斗的网站。',152,60000029,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000238,'Alcohol ','酒','Web sites that that introduce or sell alcohol.','介绍或出售各种酒等的网站。',238,60000029,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000153,'Food','饮食','Web sites that provide information about diets, including food, beverage, snacks, recipes, restaurants, and fast food shops.','主要提供与饮食相关信息的网站，包括食品、饮料、零食，菜谱介绍，以及餐馆、快餐店等餐饮服务单位。',153,60000029,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000154,'Societies','团体组织','Web sites that are sponsored and created by enthusiasts or organizations of a field (except the political field) to propagate and communicate the information about this field, such as clubs and councils.','主要由在一些特定领域的爱好者或者相关组织赞助创建的，主要宣传该领域的一些知识信息，交流信息等，主要是指政治领域以外的一般领域。',154,60000030,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000155,'Disgusting/Horrible/Violence ','恶心/恐怖/暴力','Web sites that provide an exhibition or propagation or disgusting and horrible contents, such as ghost stories, body pictures, and sanguinary pictures.Such Web sites can also provide information about maltreatment or violent intrusion on people and animals.','主要展示或者宣扬恶心、恐怖内容的网站，如鬼故事、尸体照片、血腥图片等。这一类网站还包括虐待人、动物或者对其进行暴力侵犯。',155,60000031,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000224,'Alternative','另类','Web sites that provide alternative contents such as alternative arts, odd hair styles and clothes, and other alternative goods.','包括另类内容的网站，包括另类艺术、怪异发型、服装以及另类商品。',224,60000031,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000225,'Mixed_Adult','低俗','Web sites that provide other types of vulgar contents, such as beautiful ladies pictures, lingerie photos, body exposed photos, and adult jokes.','其他类型的低俗网站，如美女图片、内衣写真、偷拍走光、成人笑话等。',225,60000031,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000156,'Gambling','赌博','Web sites that provide gambling information and online gambling.','提供赌博信息、在线赌博的网站。',156,60000032,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000157,'Drugs','毒品','Web sites that provide information about drugs, including the process, materials, tools, and methods of drug making, planting technologies, and propagated information.','与毒品信息相关的网站，包括毒品的制作流程、制作材料、制作工具和制作方法，毒品的种植技术，以及毒品的宣扬信息等。',157,60000033,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000158,'Malicious Web Sites','恶意网页','Web sites that contain malicious code.','各种包含恶意代码等的网站。',158,60000034,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000231,'Phishing Sites','钓鱼网站','Phishing Web sites.','钓鱼网站。',231,60000034,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000232,'Malware Sites','恶意程序','Web sites that contain spyware and viruses.','各种包含间谍软件以及病毒的网站。',232,60000034,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000159,'Pornography','色情','Web sites that provide the description of naked sexual behaviors, online and offline pornographic services, or links such as pornographic pictures, novels, and movies. Some hidden pornographic Web sites are also grouped into this category, for example, those registered with pornographic domain names but empty contents, because they may be purchased in future to provide pornographic services. ','网站内容主要为描述赤裸裸的性行为的信息或者提供线上、线下色情服务或者提供链接，如色情图片、色情小说、色情电影等。',159,60000035,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000254,'Worst of List','Worst of List','domains distributing child sexual abuse material, provide by INTERPOL.','由国际刑警组织提供的包含有儿童色情相关内容的站点。',254,60000035,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000160,'Crime','犯罪','Web sites that provide or propagate criminal information and means.','提供或宣扬犯罪信息、犯罪手法的网站。',160,60000036,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000161,'Vacancy Web Sites','空置网站','Web sites that are under construction or those whose domain names have expired or are on sale.','因网站正在建设中或域名到期或该网站域名正在出售的网站。',161,60000037,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000176,'Weapon','武器','Web sites that provide an introduction to the usage, refitting, and purchase of various weapons such as guns, ammunition, knives, defibrillators, and self-defense devices.','介绍各类武器，如枪支、弹药、刀具、电击器、防身器械等，包括如何使用、改装、购买等。',176,60000038,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000226,'Fraud','欺诈','Web sites that provide information about cheating and deceiving, such as papers written by others, forged education, and forged certificates.','该类网站提供各种信息用于达到诸如作弊、欺骗等目的，如论文代写、代办学历、代办证件等。',226,60000039,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000234,'Abortion','流产','Web sites that provide the introduction to or discussion on abortion and related medical organizations.','介绍或讨论有关流产方面的内容，以及进行流产手术等的医疗机构的网站。',234,60000040,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000235,'Suicide','自杀','Web sites that provide the introduction to or discussion on suicide commitment, such as the methods and process of suicide.','介绍或讨论有关自杀方面的内容的网站，如介绍自杀方法、描述自杀过程等。',235,60000041,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000236,'Storage Server','存储服务器','Web sites that provide program services for other Web sites (in the same organization), such as picture storage, browser information analysis, traffic level assessment, and content filtering. Such Web sites are not displayed directly to end users or contain certain useless information.','从程序的角度为其他网站（一般属于同一组织）提供服务，如存储图片、分析浏览者信息、流量评级、内容过滤等,一般不直接对终端用户显示。',236,60000042,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000237,'Hatred Speech','仇恨言论','Web sites that advocate or propagate differences caused by races, genders, colors, beliefs, or other factors, and attack or discriminate against the inferior party, such as racial discrimination.','鼓吹或者宣扬由于种族、性别、肤色、信仰或者其他因素造成的差异，打击或者歧视差别的一方，如种族歧视等。',237,60000043,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000239,'Cult','邪教','Web sites that advocate or propagate that a god or person has special rights, to constrain the behaviors of believers and make them different from common people in terms or behaviors or life style, for example, living in groups. These Web sites exclude traditional religions.','传统宗教之外的一些宣扬或鼓吹某一神或者人具有特殊权利，约束信教者的行为，使其行为或者生活方式与平常人有较大差别，如群居等。',239,60000044,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000241,'General Sites','一般性站点','Web sites whose contents are available but indistinct or meaningless. For example, only the login page is available.','能够获取页面内容，但是页面特征不明显或者页面内容无具体意义的那些站点，如：某些站点打开后仅有一个登陆界面等。',241,60000045,1);
insert into tab_secm_deploy_obj_url_type(pkid,name,name_cn,description,description_cn,type_id,parent_id,pre_defined) values(60000233,'Others','其他类','Web sites which are not classified.','当前无法识别分类的站点。',233,60000099,1);
-- URL过滤北向接口新增来源字段
select alter_columns('add','tab_secm_pf_url_filter','producer','varchar(128)');
-- URL过滤与分类关联关系表新增category_name字段
select alter_columns('add','tab_secm_deploy_pf_url_filter_user','category_name','varchar(255)');

-- URL过滤新增全局对象字段
select alter_columns('add', 'tab_secm_pf_url_filter', 'universal', 'boolean default false');
update tab_secm_pf_url_filter set universal = true where pkid = '40000000-0000-0000-0000-000000000000';
update tab_secm_pf_url_filter set universal = false where universal is null;

--19.2.0.001_END

--19.2.0.021_BEGIN
-- 更改URL分类Custom的名字
update tab_secm_G_OBJ_URL_CATEGORY set name = 'User-defined Category', name_cn = '自定义分类' where pkid = '60000000';

--19.2.0.021_END






