--3.20.0.0.0060_BEGIN
delete from tab_dcn_fabric_service_fabric_template_item where device_model = 'CE6881-48T6CQ-K';
insert into tab_dcn_fabric_service_fabric_template_item(id,device_model,device_type,manufacturer,cap_key,cap_value,cap_max) values
('8d8267b4-ac68-4333-ad40-050000000001','CE6881-48T6CQ-K',0,'HUAWEI',1,128,1500),
('8d8267b4-ac68-4333-ad40-050000000002','CE6881-48T6CQ-K',0,'HUAWEI',2,128,512),
('8d8267b4-ac68-4333-ad40-050000000004','CE6881-48T6CQ-K',0,'HUAWEI',4,10000,10000),
('8d8267b4-ac68-4333-ad40-050000000007','CE6881-48T6CQ-K',0,'HUAWEI',7,5000,12000),
('8d8267b4-ac68-4333-ad40-050000000008','CE6881-48T6CQ-K',0,'HUAWEI',8,512,1000),
('8d8267b4-ac68-4333-ad40-050000000009','CE6881-48T6CQ-K',0,'HUAWEI',9,512,1000),
('8d8267b4-ac68-4333-ad40-050000000010','CE6881-48T6CQ-K',0,'HUAWEI',10,512,1000),
('8d8267b4-ac68-4333-ad40-050000000011','CE6881-48T6CQ-K',0,'HUAWEI',11,512,1000),
('8d8267b4-ac68-4333-ad40-050000000012','CE6881-48T6CQ-K',0,'HUAWEI',12,512,1000);


create table if not exists tab_dcn_fabric_device_capability (
  id VARCHAR(36) NOT NULL,
  device_model VARCHAR(128) NOT NULL,
  device_type INT NOT NULL,
  manufacturer VARCHAR(128) NOT NULL,
  multicast_capability boolean,
  create_time TIMESTAMP DEFAULT current_timestamp,
  CONSTRAINT pk_tab_dcn_fabric_device_capability PRIMARY KEY (id)
);

insert into tab_dcn_fabric_device_capability(id,device_model,device_type,manufacturer,multicast_capability) values
('8d8267b4-ac68-4333-ad40-049000000101','CE12804',0,'HUAWEI',true),
('8d8267b4-ac68-4333-ad40-049000000102','CE12804E',0,'HUAWEI',false),
('8d8267b4-ac68-4333-ad40-049000000103','CE12804S',0,'HUAWEI',true),
('8d8267b4-ac68-4333-ad40-049000000104','CE12808',0,'HUAWEI',true),
('8d8267b4-ac68-4333-ad40-049000000105','CE12808E',0,'HUAWEI',false),
('8d8267b4-ac68-4333-ad40-049000000106','CE12808S',0,'HUAWEI',true),
('8d8267b4-ac68-4333-ad40-049000000107','CE12812',0,'HUAWEI',true),
('8d8267b4-ac68-4333-ad40-049000000108','CE12816',0,'HUAWEI',true),
('8d8267b4-ac68-4333-ad40-049000000109','CE12816E',0,'HUAWEI',false),
('8d8267b4-ac68-4333-ad40-049000000110','CE12816M',0,'HUAWEI',true),
('8d8267b4-ac68-4333-ad40-049000000111','CE5880-48T6Q-EI',0,'HUAWEI',false),
('8d8267b4-ac68-4333-ad40-049000000112','CE6850-48S6Q-HI',0,'HUAWEI',true),
('8d8267b4-ac68-4333-ad40-049000000113','CE6850-48T6Q-HI',0,'HUAWEI',true),
('8d8267b4-ac68-4333-ad40-049000000114','CE6850U-24S2Q-HI',0,'HUAWEI',true),
('8d8267b4-ac68-4333-ad40-049000000115','CE6850U-48S6Q-HI',0,'HUAWEI',true),
('8d8267b4-ac68-4333-ad40-049000000116','CE6851-48S6Q-HI',0,'HUAWEI',true),
('8d8267b4-ac68-4333-ad40-049000000117','CE6855-48S6Q-HI',0,'HUAWEI',true),
('8d8267b4-ac68-4333-ad40-049000000118','CE6855-48T6Q-HI',0,'HUAWEI',true),
('8d8267b4-ac68-4333-ad40-049000000119','CE6856-48S6Q-HI',0,'HUAWEI',true),
('8d8267b4-ac68-4333-ad40-049000000120','CE6856-48T6Q-HI',0,'HUAWEI',true),
('8d8267b4-ac68-4333-ad40-049000000121','CE6857-48S6CQ-EI',0,'HUAWEI',true),
('8d8267b4-ac68-4333-ad40-049000000122','CE6860-48S18CQ-EI',0,'HUAWEI',true),
('8d8267b4-ac68-4333-ad40-049000000123','CE6860-48S8CQ-EI',0,'HUAWEI',true),
('8d8267b4-ac68-4333-ad40-049000000124','CE6863-48S6CQ',0,'HUAWEI',false),
('8d8267b4-ac68-4333-ad40-049000000125','CE6863-48S6CQ-K',0,'HUAWEI',false),
('8d8267b4-ac68-4333-ad40-049000000126','CE6865-48S8CQ-EI',0,'HUAWEI',true),
('8d8267b4-ac68-4333-ad40-049000000127','CE6870-24S6CQ-EI',0,'HUAWEI',true),
('8d8267b4-ac68-4333-ad40-049000000128','CE6870-48S6CQ-EI',0,'HUAWEI',true),
('8d8267b4-ac68-4333-ad40-049000000129','CE6870-48T6CQ-EI',0,'HUAWEI',true),
('8d8267b4-ac68-4333-ad40-049000000130','CE6875-48S4CQ-EI',0,'HUAWEI',true),
('8d8267b4-ac68-4333-ad40-049000000131','CE6875-48S4CQ-HI',0,'HUAWEI',true),
('8d8267b4-ac68-4333-ad40-049000000132','CE6880-24S4Q2CQ-EI',0,'HUAWEI',false),
('8d8267b4-ac68-4333-ad40-049000000133','CE6880-48S4Q2CQ-EI',0,'HUAWEI',false),
('8d8267b4-ac68-4333-ad40-049000000134','CE6880-48T4Q2CQ-EI',0,'HUAWEI',false),
('8d8267b4-ac68-4333-ad40-049000000135','CE6881-48S6CQ',0,'HUAWEI',false),
('8d8267b4-ac68-4333-ad40-049000000136','CE6881-48S6CQ-K',0,'HUAWEI',false),
('8d8267b4-ac68-4333-ad40-049000000137','CE6881E-48S6CQ',0,'HUAWEI',false),
('8d8267b4-ac68-4333-ad40-049000000138','CE7850-32Q-EI',0,'HUAWEI',true),
('8d8267b4-ac68-4333-ad40-049000000139','CE7855-32Q-EI',0,'HUAWEI',true),
('8d8267b4-ac68-4333-ad40-049000000140','CE8850-32CQ-EI',0,'HUAWEI',true),
('8d8267b4-ac68-4333-ad40-049000000141','CE8850-64CQ-EI',0,'HUAWEI',true),
('8d8267b4-ac68-4333-ad40-049000000142','CE8860-4C-EI',0,'HUAWEI',true),
('8d8267b4-ac68-4333-ad40-049000000143','CE8861-4C-EI',0,'HUAWEI',true),
('8d8267b4-ac68-4333-ad40-049000000144','CE8868-4C-EI',0,'HUAWEI',true),
('8d8267b4-ac68-4333-ad40-049000000145','CE16804',0,'HUAWEI',false),
('8d8267b4-ac68-4333-ad40-049000000146','CE16808',0,'HUAWEI',false),
('8d8267b4-ac68-4333-ad40-049000000147','CE16816',0,'HUAWEI',false);

select alter_columns('ADD','tab_dcn_fabric_device_resm_manage','device_model','VARCHAR(128)');
--3.20.0.0.0060_END

--3.20.0.0.0210_BEGIN
delete from tab_dcn_fabric_service_fabric_template_item where device_model = 'CE5881-48T6CQ';
insert into tab_dcn_fabric_service_fabric_template_item(id,device_model,device_type,manufacturer,cap_key,cap_value,cap_max) values
('8d8267b4-ac68-4333-ad40-051000000001','CE5881-48T6CQ',0,'HUAWEI',1,128,1500),
('8d8267b4-ac68-4333-ad40-051000000002','CE5881-48T6CQ',0,'HUAWEI',2,128,512),
('8d8267b4-ac68-4333-ad40-051000000004','CE5881-48T6CQ',0,'HUAWEI',4,10000,10000),
('8d8267b4-ac68-4333-ad40-051000000007','CE5881-48T6CQ',0,'HUAWEI',7,5000,12000),
('8d8267b4-ac68-4333-ad40-051000000008','CE5881-48T6CQ',0,'HUAWEI',8,512,1000),
('8d8267b4-ac68-4333-ad40-051000000009','CE5881-48T6CQ',0,'HUAWEI',9,512,1000),
('8d8267b4-ac68-4333-ad40-051000000010','CE5881-48T6CQ',0,'HUAWEI',10,512,1000),
('8d8267b4-ac68-4333-ad40-051000000011','CE5881-48T6CQ',0,'HUAWEI',11,512,1000),
('8d8267b4-ac68-4333-ad40-051000000012','CE5881-48T6CQ',0,'HUAWEI',12,512,1000);
--3.20.0.0.0210_END

--3.20.0.0.0250_BEGIN
select alter_columns('ADD','tab_dcn_fabric_service_spec','resource_sum','integer');
select alter_columns('ADD','tab_dcn_fabric_service_spec','alarm_threshold','integer default 90');
select alter_columns('ADD','tab_dcn_fabric_service_spec','recover_threshold','integer default 50');

create or replace function randUuid() RETURNS TEXT AS $body$
declare
         md5_value varchar;
         uuid_value varchar;
         v_currenttime number;
begin
    EXECUTE IMMEDIATE  'select floor(extract(epoch from((current_timestamp - timestamp ''1970-01-01 00:00:00'')*1000)))' into v_currenttime;
         md5_value := MD5((random()*v_currenttime)::text);
         uuid_value := substring(md5_value from 1 for 8) || '-' || substring(md5_value from 9 for 4) || '-' || substring(md5_value from 13 for 4) || '-' || substring(md5_value from 17 for 4) || '-' || substring(md5_value from 21 for 12);
         return uuid_value;
END;$body$ language plpgsql;
/

create or replace PROCEDURE p_fabric_init_new_spec(specName in varchar, originValue in integer, newValue in integer, alarmThreshold in integer, recoverThreshold in integer, specDescription in varchar) as
    oldValue integer;
    existCount integer;
begin
    EXECUTE IMMEDIATE 'select count(*) from tab_dcn_fabric_service_spec where NAME ='''|| specName || '''' INTO existCount;
    if existCount=0 then
        insert into tab_dcn_fabric_service_spec(id,name,spec,resource_sum,alarm_threshold,recover_threshold,description) values (randUuid(), specName, originValue, newValue, alarmThreshold, recoverThreshold, specDescription);
    ELSE
        EXECUTE IMMEDIATE 'select spec from tab_dcn_fabric_service_spec where NAME ='''|| specName || '''' INTO oldValue;
        UPDATE tab_dcn_fabric_service_spec set resource_sum = GREATEST(oldValue, newValue), spec = GREATEST(oldValue, originValue), alarm_threshold = alarmThreshold, recover_threshold = recoverThreshold where NAME = specName;
    end if;
end;
/

call p_fabric_init_new_spec('MAX_FABRIC_NUMBER', 1000, 32, 90, 50, 'the maximum number of fabric');
call p_fabric_init_new_spec('MAX_FABRIC_EGRESS_GATEWAY', 8, 8, 90, 50, 'the maximum number of fabric egress gateway');
call p_fabric_init_new_spec('MAX_GLOBAL_EGRESS_GATEWAY', 64, 64, 90, 50, 'the maximum number of global egress gateway');

update tab_dcn_fabric_service_spec set resource_sum = spec where resource_sum is null;
--3.20.0.0.0250_END


--3.20.0.0.0270_BEGIN
select alter_columns('alter','tab_dcn_fabric_service_route_policy_apply','value','nvarchar2(512)');

select alter_columns('ADD','tab_dcn_fabric_service_route_policy_apply','operate_action_type','integer');
select alter_columns('ADD','tab_dcn_fabric_service_route_policy_apply','origin_next_hop','boolean');
select alter_columns('ADD','tab_dcn_fabric_service_route_policy_apply','additive','boolean');
select alter_columns('ADD','tab_dcn_fabric_service_route_policy_apply','ip_version','varchar(36)');

select alter_columns('ADD','tab_dcn_fabric_resm_basicinfo','import_route_multi_path','boolean');

select alter_columns('ADD','tab_dcn_fabric_service_filter_index','action','integer');
select alter_columns('ADD','tab_dcn_fabric_service_filter_index','match','boolean');

select alter_columns('ADD','tab_dcn_fabric_service_route_policy_if_match','tag','nvarchar2(128)');

select alter_columns('ADD','tab_dcn_fabric_service_filter','index_preconfig','boolean');

select alter_columns('ADD','tab_dcn_fabric_service_logicrouter','type','character varying(32)');
select alter_columns('ADD','tab_dcn_fabric_service_logicrouter','import_static_policy','boolean');


select alter_columns('ADD','tab_dcn_fabric_manage_nodel3instance','import_route_multi_path','boolean');
select alter_columns('ADD','tab_dcn_fabric_manage_nodel3instance','type','character varying(32)');
select alter_columns('ADD','tab_dcn_fabric_manage_nodel3instance','import_static_policy','boolean');

create table if not exists tab_dcn_fabric_manage_ne_as_path_filter
(
  id nvarchar2(128) not null,
  device_id nvarchar2(36) not null,
  ne_id nvarchar2(128) not null,
  ne_type integer,
  node_as_path_filter_id nvarchar2(128),
  create_time timestamp default current_timestamp,
  constraint pk_dcn_fabric_manage_ne_as_path_filter primary key (id)
);

create table if not exists tab_dcn_fabric_manager_node_as_path_filter
(
id nvarchar2(128) not null,
as_path character varying(256)[],
filter_id nvarchar2(128),
tenant_id nvarchar2(128),
name nvarchar2(128),
fabric_id nvarchar2(64),
action integer,
filter_type integer,
node_id nvarchar2(36),
constraint pk_dcn_fabric_manager_node_as_path_filter primary key (id)
);

select alter_columns('add','tab_dcn_fabric_manage_l2l3link','protocol_ip','varchar(128)');
select alter_columns('add','tab_dcn_fabric_manage_l2l3link','protocol_ipv6','varchar(128)');
select alter_columns('add','tab_dcn_fabric_manage_nodel2l3link','protocol_ips','varchar(128)');
select alter_columns('add','tab_dcn_fabric_manage_nodel2l3link','protocol_ipv6s','varchar(128)');
select alter_columns('add','tab_dcn_fabric_service_routerport','protocol_ips','varchar(128)');
select alter_columns('add','tab_dcn_fabric_service_routerport','protocol_ipv6s','varchar(128)');
select alter_columns('add','tab_dcn_fabric_service_logicport','protocol_ips','varchar(128)');
select alter_columns('add','tab_dcn_fabric_service_logicport','protocol_ipv6s','varchar(128)');


delete from tab_dcn_fabric_device_capability where device_model = 'CE5880-48T6Q-EI';
delete from tab_dcn_fabric_device_capability where device_model = 'CE6881E-48S6CQ';
delete from tab_dcn_fabric_device_capability where device_model = 'CE7855-32Q-EI';
delete from tab_dcn_fabric_device_capability where device_model = 'CE8850-32CQ-EI';
delete from tab_dcn_fabric_device_capability where device_model = 'CE8850-64CQ-EI';

insert into tab_dcn_fabric_device_capability(id,device_model,device_type,manufacturer,multicast_capability) values
('8d8267b4-ac68-4333-ad40-049000000111','CE5880-48T6Q-EI',0,'HUAWEI',false),
('8d8267b4-ac68-4333-ad40-049000000137','CE6881E-48S6CQ',0,'HUAWEI',false),
('8d8267b4-ac68-4333-ad40-049000000139','CE7855-32Q-EI',0,'HUAWEI',true),
('8d8267b4-ac68-4333-ad40-049000000140','CE8850-32CQ-EI',0,'HUAWEI',true),
('8d8267b4-ac68-4333-ad40-049000000141','CE8850-64CQ-EI',0,'HUAWEI',true);

select alter_columns('add','tab_dcn_fabric_manage_ne_loopback','node_loopback_id','nvarchar2(128)');

create table if not exists tab_dcn_fabric_manage_node_loopback
(
id nvarchar2(128) not null,
description nvarchar2(256),
num integer,
logic_router_id nvarchar2(128),
node_id nvarchar2(36),
constraint pk_dcn_fabric_manage_node_loopback primary key (id)
);

create table if not exists tab_dcn_fabric_manage_global_bfd
(
  id nvarchar2(128) not null,
  name nvarchar2(256),
  description nvarchar2(256),
  fabric_id nvarchar2(128),
  node_ids character varying(36)[],
  delay_up_time bigint,
  dampen_init_time bigint,
  dampen_max_time bigint,
  dampen_second_time bigint,
  bundle_init_time bigint,
  bundle_max_time bigint,
  bundle_second_time bigint,
  bundle_l3_mode boolean,
  create_time timestamp default current_timestamp,
  constraint pk_dcn_fabric_manage_global_bfd primary key (id)
);

create table if not exists tab_dcn_fabric_manager_ospf_process_deploy
(
  id nvarchar2(128) not null,
  ospf_process_id nvarchar2(128),
  vrf_name nvarchar2(128),
  node_id nvarchar2(36),
  ne_id nvarchar2(36),
  ne_type integer,
  router_id nvarchar2(128),
  create_time timestamp default current_timestamp,
  constraint pk_dcn_fabric_manager_ospf_process_deploy primary key (id)
);

create table if not exists tab_dcn_fabric_service_ospf_process
(
  id nvarchar2(128) not null,
  logic_router_id nvarchar2(128),
  vrf_name nvarchar2(128),
  name nvarchar2(256),
  description nvarchar2(128),
  process_id bigint,
  node_id nvarchar2(36),
  device_router_id character varying(128)[],
  create_time timestamp default current_timestamp,
  node_ids varchar(128)[],
  constraint pk_dcn_fabric_service_ospf_process primary key (id)
);

create table if not exists tab_dcn_fabric_service_ospf_cfg
(
  id nvarchar2(128) not null,
  ospf_process_id nvarchar2(128),
  family nvarchar2(128),
  route_loop_disable boolean,
  stub_router boolean,
  stub_interval bigint,
  external_lsa boolean,
  external_cost bigint,
  band_pre bigint,
  protocol_pre bigint,
  ase_pre bigint,
  create_time timestamp default current_timestamp,
  constraint pk_dcn_fabric_service_ospf_cfg primary key (id)
);

create table if not exists tab_dcn_fabric_service_ospf_interval
(
  id nvarchar2(128) not null,
  ospf_process_id nvarchar2(128),
  ospf_cfg_id nvarchar2(128),
  interval_type nvarchar2(128),
  max_interval bigint,
  start_interval bigint,
  hold_interval bigint,
  arrival_flag boolean,
  arrival_interval bigint,
  create_time timestamp default current_timestamp,
  constraint pk_dcn_fabric_service_ospf_interval primary key (id)
);

create table if not exists tab_dcn_fabric_service_ospf_rtp
(
  id nvarchar2(128) not null,
  ospf_process_id nvarchar2(128),
  ospf_cfg_id nvarchar2(128),
  protocol_type nvarchar2(128),
  cost bigint,
  tag bigint,
  route_type nvarchar2(128),
  rtp_name nvarchar2(128),
  permit_ibgp boolean,
  always boolean,
  create_time timestamp default current_timestamp,
  constraint pk_dcn_fabric_service_ospf_rtp primary key (id)
);

create table if not exists tab_dcn_fabric_manager_ospf_peer_deploy
(
  id nvarchar2(128) not null,
  ospf_peer_id nvarchar2(128),
  ospf_process_id nvarchar2(128),
  if_name nvarchar2(128),
  source_ip nvarchar2(128),
  node_id nvarchar2(36),
  ne_id nvarchar2(36),
  ne_type integer,
  create_time timestamp default current_timestamp,
  constraint pk_dcn_fabric_manager_ospf_peer_deploy primary key (id)
);

create table if not exists tab_dcn_fabric_service_ospf_peer
(
  id nvarchar2(128) not null,
  logic_router_id nvarchar2(128),
  ospf_process_id nvarchar2(128),
  family nvarchar2(128),
  port_type integer,
  port_id nvarchar2(128),
  node_id nvarchar2(36),
  ne_id nvarchar2(36),
  area_id nvarchar2(128),
  network_type nvarchar2(128),
  dr_priority integer,
  cost bigint,
  hello_interval integer,
  dead_interval integer,
  bfd_enable boolean,
  tx_interval bigint,
  rx_interval bigint,
  multiplier bigint,
  auth_type nvarchar2(128),
  password_type nvarchar2(128),
  auth_value nvarchar2(128),
  key_id bigint,
  create_time timestamp default current_timestamp,
  constraint pk_dcn_fabric_service_ospf_peer primary key (id)
);

select alter_columns('add','tab_dcn_fabric_manage_track_session','bfd_session_id','nvarchar2(128)');
select alter_columns('add','tab_dcn_fabric_manage_track_session','bfd_mode','nvarchar2(128)');
select alter_columns('add','tab_dcn_fabric_manage_track_session','detect_multiplier','bigint');
select alter_columns('add','tab_dcn_fabric_manage_track_session','min_tx_interval','bigint');
select alter_columns('add','tab_dcn_fabric_manage_track_session','min_rx_interval','bigint');

create table if not exists tab_dcn_fabric_manage_bfd_session
(
  id nvarchar2(128) not null,
  name nvarchar2(128),
  description nvarchar2(128),
  session_name nvarchar2(128),
  logic_router_id nvarchar2(128),
  node_id nvarchar2(36),
  dst_addr nvarchar2(128),
  src_if_id nvarchar2(128),
  src_ip_type nvarchar2(128),
  bfd_mode nvarchar2(128),
  detect_multiple bigint,
  min_tx_interval bigint,
  min_rx_interval bigint,
  create_time timestamp default current_timestamp,
  constraint pk_dcn_fabric_manage_bfd_session primary key (id)
);

select alter_columns('alter','tab_dcn_fabric_service_switchport','device_ifs','nvarchar2(4000)');
select alter_columns('add','tab_dcn_fabric_service_staticroute','bfd_mode','nvarchar2(128)');
select alter_columns('add','tab_dcn_fabric_service_staticroute','loopback_ids','varchar(36)[]');
select alter_columns('add','tab_dcn_fabric_service_staticroute','bfd_mode','nvarchar2(128)');
select alter_columns('add','tab_dcn_fabric_service_staticroutedeploy','loopback_ids','varchar(36)[]');
select alter_columns('add','tab_dcn_fabric_service_bgplinkdeploy','loopback_ids','varchar(128)[]');
select alter_columns('add','tab_dcn_fabric_service_bgplink','loopback_ids','varchar(128)[]');
select alter_columns('rename','tab_dcn_fabric_service_route_policy_node','index','route_policy_index');

CREATE OR REPLACE FUNCTION fill_fabric_router_type() RETURNS INTEGER AS $body$
	DECLARE
	router_type character varying(32);
    begin
        DBMS_OUTPUT.PUT_LINE('begin to fill_fabric_router_type');
        if exists (select 1 from tab_dcn_fabric_service_logicrouter where trim(type) is null)  then
            FOR fabric_router in select id from tab_dcn_fabric_service_logicrouter where trim(type) is null LOOP
                DBMS_OUTPUT.PUT_LINE('begin to deal router type router id:'|| fabric_router.id);
				if exists (select 1 from tab_dcn_gbp_logic_router  where id = fabric_router.id) then
					select l23_router.type from tab_dcn_gbp_logic_router l23_router  where l23_router.id = fabric_router.id into router_type;
					update tab_dcn_fabric_service_logicrouter set type = router_type where id = fabric_router.id;
				end if;

            END LOOP;
        end if;
 RETURN 0;
END;
$body$ language plpgsql;
/
ALTER FUNCTION fill_fabric_router_type() OWNER TO ossdbuser;
select fill_fabric_router_type();
drop function if exists fill_fabric_router_type;
--3.20.0.0.0270_END
select alter_columns('RENAME','TAB_DCN_FABRIC_SERVICE_IPEPG','INDEX','EPG_INDEX');
select alter_columns('RENAME','TAB_DCN_FABRIC_SERVICE_EPG','INDEX','EPG_INDEX');

select alter_columns('RENAME','tab_dcn_fabric_manage_nodeipsegment','INDEX','IPSEGMENT_INDEX');
select alter_columns('RENAME','tab_dcn_fabric_manage_classifier_rule','INDEX','RULE_INDEX');

CREATE OR REPLACE FUNCTION fill_fabric_device_mode() RETURNS INTEGER AS $body$
	DECLARE
	v_device_mode character varying(128);
    begin
        DBMS_OUTPUT.PUT_LINE('begin to fill_fabric_device_mode');
        if exists (select 1 from tab_dcn_fabric_device_resm_manage where trim(device_model) is null)  then
            FOR device_res in select ne_id from tab_dcn_fabric_device_resm_manage where trim(device_model) is null LOOP
                DBMS_OUTPUT.PUT_LINE('begin to deal device id:'|| device_res.ne_id);
				if exists (select 1 from DEVICEDESCRIPTIONENTITY  where id = device_res.ne_id) then
					select DEVICEMODEL from DEVICEDESCRIPTIONENTITY where  id = device_res.ne_id into v_device_mode;
					update tab_dcn_fabric_device_resm_manage set device_model = v_device_mode where id = device_res.ne_id;
				end if;

            END LOOP;
        end if;
 RETURN 0;
END;
$body$ language plpgsql;
/
ALTER FUNCTION fill_fabric_device_mode() OWNER TO ossdbuser;
select fill_fabric_device_mode();
drop function if exists fill_fabric_device_mode;

update tab_dcn_fabric_manage_nodel3instance set import_route_multi_path = false where import_route_multi_path is null;
update tab_dcn_fabric_resm_basicinfo set import_route_multi_path = false where import_route_multi_path is null;

CREATE OR REPLACE FUNCTION fabric_table_add_column() RETURNS INTEGER AS $add_column$
    DECLARE
        v_cnt INTEGER := 0;
    begin
        select count(*) from information_schema.columns where TABLE_NAME = 'TAB_DCN_FABRIC_SERVICE_SWITCHPORT' and column_name = 'PORT_TYPE' into v_cnt;
        if v_cnt = 0 then
            alter table TAB_DCN_FABRIC_SERVICE_SWITCHPORT add PORT_TYPE varchar(32);
        end if;
        
        select count(*) from information_schema.columns where TABLE_NAME = 'TAB_DCN_FABRIC_SERVICE_LOGICPORT' and column_name = 'PORT_TYPE' into v_cnt;
        if v_cnt = 0 then
            alter table TAB_DCN_FABRIC_SERVICE_LOGICPORT add PORT_TYPE varchar(32);
        end if;
        
        select count(*) from information_schema.columns where TABLE_NAME = 'TAB_DCN_FABRIC_MANAGE_NODESERVICEPORT' and column_name = 'PORT_TYPE' into v_cnt;
        if v_cnt = 0 then
            alter table TAB_DCN_FABRIC_MANAGE_NODESERVICEPORT add PORT_TYPE varchar(32);
        end if;
        
        select count(*) from information_schema.columns where TABLE_NAME = 'TAB_DCN_FABRIC_MANAGE_SERVICEPORT' and column_name = 'IF_NAME_PREFIX' into v_cnt;
        if v_cnt = 0 then
            alter table TAB_DCN_FABRIC_MANAGE_SERVICEPORT add IF_NAME_PREFIX varchar(64);
        end if;
        
        select count(*) from information_schema.columns where TABLE_NAME = 'TAB_DCN_FABRIC_MANAGE_SERVICEPORT' and column_name = 'BEGIN_IF_NUMBER' into v_cnt;
        if v_cnt = 0 then
            alter table TAB_DCN_FABRIC_MANAGE_SERVICEPORT add BEGIN_IF_NUMBER INTEGER;
        end if;
        
        select count(*) from information_schema.columns where TABLE_NAME = 'TAB_DCN_FABRIC_MANAGE_SERVICEPORT' and column_name = 'END_IF_NUMBER' into v_cnt;
        if v_cnt = 0 then
            alter table TAB_DCN_FABRIC_MANAGE_SERVICEPORT add END_IF_NUMBER INTEGER;
        end if;

        update TAB_DCN_FABRIC_SERVICE_LOGICPORT set PORT_TYPE = 'Subinterface' where PORT_TYPE is null;
        update TAB_DCN_FABRIC_SERVICE_SWITCHPORT set PORT_TYPE = 'Subinterface' where PORT_TYPE is null;
        update TAB_DCN_FABRIC_MANAGE_NODESERVICEPORT set PORT_TYPE = 'Subinterface' where PORT_TYPE is null;
        update TAB_DCN_FABRIC_MANAGE_SERVICEPORT set BEGIN_IF_NUMBER = 0 where BEGIN_IF_NUMBER is null;
        update TAB_DCN_FABRIC_MANAGE_SERVICEPORT set END_IF_NUMBER = 0 where END_IF_NUMBER is null;
        
        return 0;
    end;
$add_column$ language plpgsql;
/
ALTER FUNCTION fabric_table_add_column() OWNER TO ossdbuser;
select fabric_table_add_column();
drop function if exists fabric_table_add_column;



