--3.20.0.0.0070_BEGIN
delete from tab_dcn_svo_spec_param where CODE = 'IPV4_MANUAL_ROUTE_LIMIT';
insert into tab_dcn_svo_spec_param values ('IPV4_MANUAL_ROUTE_LIMIT', 2000);
delete from tab_dcn_svo_spec_param where CODE = 'IPV6_MANUAL_ROUTE_LIMIT';
insert into tab_dcn_svo_spec_param values ('IPV6_MANUAL_ROUTE_LIMIT', 2000);
--3.20.0.0.0070_END

--3.20.0.0.0080_BEGIN
select alter_columns('add','tab_dcn_logic_switch','deploy_status','character varying(64)');
update tab_dcn_logic_switch set deploy_status='Done' where trim(deploy_status) is null;

delete from tab_dcn_svo_spec_param where code ='PORT_NUM_CALL_TASK';
insert into tab_dcn_svo_spec_param values ('PORT_NUM_CALL_TASK', 50);

select alter_columns('add','tab_dcn_gbp_logic_router_subnet','external_access_mode','integer');
--3.20.0.0.0080_END

--3.20.0.0.0100_BEGIN
select alter_columns('alter','tab_dcn_svo_dhcp_server_info','ip_address','varchar(128)');
select alter_columns('alter','tab_dcn_svo_ip_mac_binding_info','ip_address','varchar(128)');
--3.20.0.0.0100_END

--3.20.0.0.0110_BEGIN
delete from tab_dcn_svo_spec_param where CODE = 'MAX_LOGICPORT_NUM';
insert into tab_dcn_svo_spec_param values ('MAX_LOGICPORT_NUM', 480000);
--3.20.0.0.0110_END

--3.20.0.0.0250_BEGIN
select alter_columns('add','tab_dcn_svo_spec_param','spec','integer');
select alter_columns('add','tab_dcn_svo_spec_param','alarm_threshold','integer default 90');
select alter_columns('add','tab_dcn_svo_spec_param','recover_threshold','integer default 50');

create or replace PROCEDURE p_l2l3_init_new_spec(specCode in varchar, originValue in integer, newValue in integer, alarmThreshold in integer, recoverThreshold in integer) as
    oldValue integer;
    existCount integer;
begin
    EXECUTE IMMEDIATE 'select count(*) from tab_dcn_svo_spec_param where code ='''|| specCode || '''' INTO existCount;
    if existCount=0 then
        insert into tab_dcn_svo_spec_param(code, value, spec, alarm_threshold, recover_threshold) values (specCode, originValue, newValue, alarmThreshold, recoverThreshold);
    ELSE
        EXECUTE IMMEDIATE 'select value from tab_dcn_svo_spec_param where code ='''|| specCode || '''' INTO oldValue;
        UPDATE tab_dcn_svo_spec_param set value = GREATEST(originValue, oldValue), spec = GREATEST(oldValue, newValue), alarm_threshold = alarmThreshold, recover_threshold = recoverThreshold where code = specCode;
    end if;
end;
/

call p_l2l3_init_new_spec('BGP_MAX_NUM', 30000, 3000, 90, 50);
call p_l2l3_init_new_spec('BGP_KEEPALIVE_INTERVAL_MIN', 0, 0, 90, 50);
call p_l2l3_init_new_spec('BGP_KEEPALIVE_INTERVAL_MAX', 21845,21845, 90, 50);
call p_l2l3_init_new_spec('BGP_HOLD_INTERVAL_MIN', 3, 3, 90, 50);
call p_l2l3_init_new_spec('BGP_HOLD_INTERVAL_MAX', 65535, 65535, 90, 50);
call p_l2l3_init_new_spec('BGP_AUTHENTICATIN_TYPE_PWD', 1, 1, 90, 50);
call p_l2l3_init_new_spec('BGP_AUTHENTICATION_TYPE_KEYCHAIN', 0, 0, 90, 50);
call p_l2l3_init_new_spec('BGP_AUTHENTICATION_TYPE_NONE', 2, 2, 90, 50);
call p_l2l3_init_new_spec('BGP_PWD_TYPE_PLAIN', 0, 0, 90, 50);
call p_l2l3_init_new_spec('BGP_PWD_TYPE_CIPHER', 1, 1, 90, 50);
call p_l2l3_init_new_spec('BGP_PWD_TYPE_PLAIN_MIN_LENGTH', 1, 1, 90, 50);
call p_l2l3_init_new_spec('BGP_PWD_TYPE_PLAIN_MAX_LENGTH', 255, 255, 90, 50);
call p_l2l3_init_new_spec('BGP_PWD_TYPE_CIPHER_MIN_LENGTH', 1, 1, 90, 50);
call p_l2l3_init_new_spec('BGP_PWD_TYPE_CIPHER_MAX_LENGTH', 255, 255, 90, 50);
call p_l2l3_init_new_spec('BGP_KEYCHAINNAME_MIN_LENGTH', 1, 1, 90, 50);
call p_l2l3_init_new_spec('BGP_KEYCHAINNAME_MAX_LENGTH', 47, 47, 90, 50);
call p_l2l3_init_new_spec('DHCP_DESCRIPTION_MAX_LENGTH', 255, 255, 90, 50);
call p_l2l3_init_new_spec('DHCP_GROUP_MAX_NUM', 30000, 30000, 90, 50);
call p_l2l3_init_new_spec('DHCP_PAGE_SIZE_MAX_VALUE', 100, 100, 90, 50);
call p_l2l3_init_new_spec('EXCEL_MAX_ROW_NUM_30K', 30001, 30001, 90, 50);
call p_l2l3_init_new_spec('EXCEL_MAX_ROW_NUM_LOGICPORT_2K', 2001, 2001, 90, 50);
call p_l2l3_init_new_spec('EXTGW_FABRIC_MAX', 2, 2, 90, 50);
call p_l2l3_init_new_spec('EXTGW_MAX_EXTNET_WORK_LOCALPORT_NUM', 4, 4, 90, 50);
call p_l2l3_init_new_spec('EXTGW_STR_MAX_LENGTH', 255, 255, 90, 50);
call p_l2l3_init_new_spec('EXTGW_PUBLIC_GATEWAY_TYPE', 0, 0, 90, 50);
call p_l2l3_init_new_spec('EXTGW_PRIVATE_GATEWAY_TYPE', 1, 1, 90, 50);
call p_l2l3_init_new_spec('EXTGW_SYSTEM_DEFAULT_PRIORITY', 120, 120, 90, 50);
call p_l2l3_init_new_spec('EXTGW_FABRIC_BIND_GATEWAY_MAX', 1000, 1000, 90, 50);
call p_l2l3_init_new_spec('EXTGW_BGPEVPN_DYNAMIC_PREF', 230, 230, 90, 50);
call p_l2l3_init_new_spec('EXTGW_MAX_DEVICE_GROUP_NUM', 4, 4, 90, 50);
call p_l2l3_init_new_spec('EXTGW_CASCADE_UPDATE_ROUTER_LIMIT', 10, 10, 90, 50);
call p_l2l3_init_new_spec('EXTGW_MULTI_ACTIVE_MAX_DEVICE_NUM', 2, 2, 90, 50);
call p_l2l3_init_new_spec('EXTNW_NETWORK_DEFAULT_PRIORITY', 60, 60, 90, 50);
call p_l2l3_init_new_spec('EXTNW_PRI_DEVICEGROUP_MAX_SIZE', 16, 16, 90, 50);
call p_l2l3_init_new_spec('SERVICE_IP_NUM_MAX_LIMIT', 256, 256, 90, 50);
call p_l2l3_init_new_spec('MAX_PORT_DESCRIPTION', 242, 242, 90, 50);
call p_l2l3_init_new_spec('MAX_PAGE_PARAM', 100000, 100000, 90, 50);
call p_l2l3_init_new_spec('MAX_OVS_SG', 10, 10, 90, 50);
call p_l2l3_init_new_spec('MAX_PORT_PER_SG', 1000, 1000, 90, 50);
call p_l2l3_init_new_spec('SWITCH_SUBNET_SIZE', 256, 256, 90, 50);
call p_l2l3_init_new_spec('SWITCH_SUBNET_SIZE_BYIPV6', 16, 16, 90, 50);
call p_l2l3_init_new_spec('ROUTER_SUBNET_SIZE', 4000, 4000, 90, 50);
call p_l2l3_init_new_spec('MAX_SUBNET_SIZE', 90000, 90000, 90, 50);
call p_l2l3_init_new_spec('MAX_QUERY_BY_IDS', 30000, 30000, 90, 50);
call p_l2l3_init_new_spec('MAX_LOGICPORT_NUM', 480000, 300000, 90, 50);
call p_l2l3_init_new_spec('MAX_ENDPORT_NUM', 4000000, 4000000, 90, 50);
call p_l2l3_init_new_spec('MAX_LOGICROUTER_NUM', 30000, 30000, 90, 50);
call p_l2l3_init_new_spec('MAX_LOGICSWITCH_NUM', 300000, 90000, 90, 50);
call p_l2l3_init_new_spec('LN_TENANT_APPCOUNT_MAX', 1000, 1000, 90, 50);
call p_l2l3_init_new_spec('LN_AC_APPCOUNT_MAX', 30000, 30000, 90, 50);
call p_l2l3_init_new_spec('LN_PAGE_DEF_NUM', 30, 30, 90, 50);
call p_l2l3_init_new_spec('LN_PAGE_MAX_NUM', 100, 100, 90, 50);
call p_l2l3_init_new_spec('LR_DIST_BACKUP_PRIORITY', 245, 245, 90, 50);
call p_l2l3_init_new_spec('LR_ENDPORT_TRACKNAME_MAX_LENGTH', 64, 64, 90, 50);
call p_l2l3_init_new_spec('LR_MAX_VRRP_VRID', 255, 255, 90, 50);
call p_l2l3_init_new_spec('LR_MAX_VRRP_PRIORITY', 254, 254, 90, 50);
call p_l2l3_init_new_spec('LR_MAX_VRRP_PREEMPT', 3600, 3600, 90, 50);
call p_l2l3_init_new_spec('LR_MAX_VRRP_RECOVERY_DELAY', 3600, 3600, 90, 50);
call p_l2l3_init_new_spec('LR_MAX_DEVICE_NUM', 2, 2, 90, 50);
call p_l2l3_init_new_spec('QOS_MIN_IR', 8, 8, 90, 50);
call p_l2l3_init_new_spec('QOS_MAX_IR', 300000000, 300000000, 90, 50);
call p_l2l3_init_new_spec('QOS_MIN_BS', 10, 10, 90, 50);
call p_l2l3_init_new_spec('QOS_MAX_BS', 524288, 524288, 90, 50);
call p_l2l3_init_new_spec('QOS_MIN_NAME_LENGTH', 1, 1, 90, 50);
call p_l2l3_init_new_spec('QOS_MAX_NAME_LENGTH', 255, 255, 90, 50);
call p_l2l3_init_new_spec('QOS_MAX_NUM', 140000, 140000, 90, 80);
call p_l2l3_init_new_spec('QOS_VCENTER_MIN_RANGE', 1, 1, 90, 50);
call p_l2l3_init_new_spec('QOS_VCENTER_MAX_RANGE', 100000000, 100000000, 90, 50);
call p_l2l3_init_new_spec('QOS_SYSTEM_MIN_RANGE', 10000, 10000, 90, 50);
call p_l2l3_init_new_spec('QOS_SYSTEM_MAX_RANGE', 100000000, 100000000, 90, 50);
call p_l2l3_init_new_spec('QOS_HASHCODE_INITIALNONZEROODDNUMBER', 17, 17, 90, 50);
call p_l2l3_init_new_spec('QOS_HASHCODE_MULTIPLIERNONZEROODDNUMBER', 31, 31, 90, 50);
call p_l2l3_init_new_spec('QOS_DSCP_MIN', 0, 0, 90, 50);
call p_l2l3_init_new_spec('QOS_DSCP_MAX', 63, 63, 90, 50);
call p_l2l3_init_new_spec('VRF_NAME_MAX_LENGTH', 31, 31, 90, 50);
call p_l2l3_init_new_spec('VRF_NAME_MIN_LENGTH', 1, 1, 90, 50);
call p_l2l3_init_new_spec('VRF_MAX_TNL_POLICY_LENGTH', 39, 39, 90, 50);
call p_l2l3_init_new_spec('VRF_MAX_VSI_LENGTH', 31, 31, 90, 50);
call p_l2l3_init_new_spec('ROUTER_EXT_GATEWAY_NUM', 64, 64, 90, 50);
call p_l2l3_init_new_spec('EXT_GATEWAY_ROUTER_NUM', 4000, 4000, 90, 50);
call p_l2l3_init_new_spec('MAX_EXT_GW_NUM', 2000, 500, 90, 50);
call p_l2l3_init_new_spec('IPV4_MANUAL_ROUTE_LIMIT', 2000, 2000, 90, 80);
call p_l2l3_init_new_spec('IPV6_MANUAL_ROUTE_LIMIT', 2000, 2000, 90, 80);
call p_l2l3_init_new_spec('PORT_NUM_CALL_TASK', 50,50,100,100);
call p_l2l3_init_new_spec('MAX_LOGICPORTNUM_PER_LOGICSWITCH', 6000, 6000, 90, 50);
call p_l2l3_init_new_spec('MAX_PIM_TEMPLATE_NUM', 32, 32, 90, 50);
call p_l2l3_init_new_spec('MAX_IGMP_TEMPLATE_NUM', 32, 32, 90, 50);
call p_l2l3_init_new_spec('MAX_BGP_PER_LOGICROUTER', 16, 16, 90, 50);

update tab_dcn_svo_spec_param set spec = value where spec is null;
--3.20.0.0.0250_END

--3.20.0.0.0260_BEGIN
select alter_columns('add','tab_dcn_external_gateway','public_ip_route_mode','integer');
--3.20.0.0.0260_END

--3.20.0.0.0270_BEGIN
delete from tab_dcn_svo_spec_param where CODE = 'IP_PREFIX_FILTER_MAX_NUM';
insert into tab_dcn_svo_spec_param values ('IP_PREFIX_FILTER_MAX_NUM', 2000,2000,100,100);
delete from tab_dcn_svo_spec_param where CODE = 'ROUTE_POLICY_NODE_MAX_NUM';
insert into tab_dcn_svo_spec_param values ('ROUTE_POLICY_NODE_MAX_NUM', 64,64,100,100);
delete from tab_dcn_svo_spec_param where CODE = 'VNI_FILTER_MAX_NUM';
insert into tab_dcn_svo_spec_param values ('VNI_FILTER_MAX_NUM', 1000,1000,100,100);
delete from tab_dcn_svo_spec_param where CODE = 'SINGLE_COMMUNITY_VALUE_MAX_NUM';
insert into tab_dcn_svo_spec_param values ('SINGLE_COMMUNITY_VALUE_MAX_NUM', 16,16,100,100);
delete from tab_dcn_svo_spec_param where CODE = 'SINGLE_EXTCOMMUNITY_VALUE_MAX_NUM';
insert into tab_dcn_svo_spec_param values ('SINGLE_EXTCOMMUNITY_VALUE_MAX_NUM', 16,16,100,100);
delete from tab_dcn_svo_spec_param where CODE = 'SINGLE_APPLY_COMMUNITY_VALUE_MAX_NUM';
insert into tab_dcn_svo_spec_param values ('SINGLE_APPLY_COMMUNITY_VALUE_MAX_NUM', 16,16,100,100);
delete from tab_dcn_svo_spec_param where CODE = 'POLICY_NODE_COMMUNITY_MAX_NUM';
insert into tab_dcn_svo_spec_param values ('POLICY_NODE_COMMUNITY_MAX_NUM', 4,4,100,100);
delete from tab_dcn_svo_spec_param where CODE = 'GENERAL_ROUTE_POLICY_NUM';
insert into tab_dcn_svo_spec_param values ('GENERAL_ROUTE_POLICY_NUM', 4000,4000,100,100);

SELECT alter_columns('ALTER', 'tab_dcn_gbp_bgp_config', 'route_policy_name', 'varchar(256)');
select alter_columns('add','tab_dcn_gbp_bgp_config','import_route_policy_name','varchar(256)');
select alter_columns('add','tab_dcn_gbp_routes_config','ecmp','boolean');
select alter_columns('add','tab_dcn_gbp_routes_config','route_deploy_pos','varchar(36)');
select alter_columns('add','tab_dcn_svo_route_policy_filter','filter_index','bigint');
select alter_columns('add','tab_dcn_svo_route_policy_config','description','varchar(512)');
select alter_columns('add','tab_dcn_svo_route_policy_config','policy_index','integer');
select alter_columns('add','tab_dcn_svo_route_policy_config','read_only','boolean');
select alter_columns('add','tab_dcn_svo_route_policy_config','producer','varchar(36)');
select alter_columns('add','tab_dcn_svo_route_policy_node','tag','varchar(36)');
select alter_columns('add','tab_dcn_svo_route_policy_node','route_type','character varying(36)[]');
select alter_columns('add','tab_dcn_gbp_logic_router','import_static_route_policy','boolean');

create table if not exists tab_dcn_svo_route_policy_node_apply
(
  id varchar(36),
  routePolicyNode_id varchar(36),
  apply_type_enum varchar(36),
  value varchar(512),
  ext_data varchar(2000),
  is_additive boolean,
  operation varchar(36),
  ip_version varchar(36),
  create_time timestamp default current_timestamp,
  constraint pk_tab_dcn_svo_route_policy_node_apply primary key (id)
);
create table if not exists tab_dcn_svo_route_policy_filter_node
(
  id varchar(36),
  filter_id varchar(36),
  filter_node_index bigint,
  action varchar(36),
  filter_value character varying(2000)[],
  match_network boolean,
  mask_length_lower integer,
  mask_length_upper integer,
  create_time timestamp default current_timestamp,
  constraint pk_tab_dcn_svo_route_policy_filter_node primary key (id)
);

create table if not exists tab_dcn_svo_loopback(
  id VARCHAR(36) not null,
  name character varying(512),
  description character varying(512),
  owner_type integer,
  owner_id VARCHAR(128) not null,
  router_id character varying(36),
  interface_ip_enable boolean,
  loopback_bus_id VARCHAR(36),
  constraint pk_tab_dcn_svo_loopback primary key (id)
);

create table if not exists tab_dcn_svo_loopback_device_config(
  id VARCHAR(36) not null,
  loopback_bus_id  VARCHAR(36) not null,
  resource_id character varying(36),
  device_group_id character varying(36),
  device_id character varying(36),
  router_id character varying(36),
  ip character varying(128),
  constraint pk_tab_dcn_svo_loopback_device_config primary key (id)
);

create table if not exists tab_dcn_svo_ospf_bfd(
	id VARCHAR(36) not null,
	enable boolean,
	detect_multiplier integer,
	min_txinterval integer,
	min_rxinterval integer,
	constraint pk_tab_dcn_svo_ospf_bfd primary key (id)
);

create table if not exists tab_dcn_svo_ospf_default_route(
	id VARCHAR(36) not null,
	enable boolean,
	always boolean,
	constraint pk_tab_dcn_svo_ospf_default_route primary key (id)
);

create table if not exists tab_dcn_svo_ospf_if_auth(
	id VARCHAR(36) not null,
	mode integer,
	password_type integer,
	auth_text_simple character varying(256),
	auth_text_md5 character varying(256),
	key_id integer,
	password character varying(512),
	constraint pk_tab_dcn_svo_ospf_if_auth primary key (id)
);

create table if not exists tab_dcn_svo_ospf_import_route(
	id VARCHAR(36) not null,
	process_config_id character varying(36),
	protocol integer,
	cost integer,
	tag integer,
	type integer,
	permit_ibgp boolean,
	rtp_id character varying(36),
	tag_value bigint,
	constraint pk_tab_dcn_svo_ospf_import_route primary key (id)
);

create table if not exists  tab_dcn_svo_ospf_device_config(
	id VARCHAR(36) not null,
	device_id character varying(36),
	device_group_id character varying(36),
	ospf_router_id character varying(36),
	constraint pk_tab_dcn_svo_ospf_device_config primary key (id)
);

create table if not exists tab_dcn_svo_ospf_device_group(
	id VARCHAR(36) not null,
	device_group_id character varying(36),
	ospf_process_id character varying(36),
	constraint pk_tab_dcn_svo_ospf_device_group primary key (id)
);

create table if not exists tab_dcn_svo_ospf_peer(
	id VARCHAR(36) not null,
	router_id character varying(36),
	process_id character varying(36),
	peer_type integer,
	source_if_type integer,
	source_if_id character varying(36),
	area_id character varying(36),
	network_type integer,
	dr_priority integer,
	cost integer,
	hello_interval integer,
	dead_interval integer,
	bfd_id character varying(36),
	auth_id character varying(36),
	constraint pk_tab_dcn_svo_ospf_peer primary key (id)
);

create table if not exists tab_dcn_svo_ospf_process(
	id VARCHAR(36) not null,
	name character varying(512),
	description character varying(512),
	owner_type integer,
	router_id_enable boolean,
	router_id character varying(36),
	type integer,
	ospf_process_id character varying(36),
	ospf_cfg_id character varying(36),
	ospfv3_cfg_id character varying(36),
	constraint pk_tab_dcn_svo_ospf_process primary key (id)
);

create table if not exists tab_dcn_svo_ospf_process_item(
	id VARCHAR(36) not null,
	ospf_process_id character varying(36),
	vpn_capability boolean,
	bandwidth_reference integer,
	stub_router_id character varying(36),
	default_route_id character varying(36),
	export_evpn_rtp_id character varying(36),
	filter_import_rtp_id character varying(36),
	timer_id character varying(36),
	constraint pk_tab_dcn_svo_ospf_process_item primary key (id)
);

create table if not exists tab_dcn_svo_ospf_route_preference(
	id VARCHAR(36) not null,
	process_config_id character varying(36),
	route_type integer,
	preference integer,
	constraint pk_tab_dcn_svo_ospf_route_preference primary key (id)
);

create table if not exists tab_dcn_svo_ospf_stub_router(
	id VARCHAR(36) not null,
	enable boolean,
	interval integer,
	external_lsa boolean,
	external_cost integer,
	constraint pk_tab_dcn_svo_ospf_stub_router primary key (id)
);

create table if not exists tab_dcn_svo_ospf_timer_container(
	id VARCHAR(36) not null,
	timer_type integer,
	intelligent_timer_enable boolean,
	interval integer,
	max_interval integer,
	start_interval integer,
	hold_interval integer,
	constraint pk_tab_dcn_svo_ospf_timer_container primary key (id)
);

create table if not exists tab_dcn_svo_ospf_timer(
	id VARCHAR(36) not null,
	lsa_arrival_id character varying(36),
	lsa_originate_id character varying(36),
	spf_schedule_id character varying(36),
	constraint pk_tab_dcn_svo_ospf_timer primary key (id)
);

select alter_columns('add','tab_dcn_gbp_logic_router_subnet','protocol_ip','character varying(8000)[]');


create table if not exists tab_dcn_svo_bfd_session
(
    id varchar(36) primary key,
    name character varying(512),
    description character varying(512),
    logic_router_id character varying(36),
    session_name character varying(512),
    destination character varying(128),
    source_if_id character varying(36),
    device_group_id character varying(4096),
    vrrp_enable boolean default false,
    session_mode integer,
    detect_multiplier integer,
    send_min_interval integer,
    receive_min_Interval integer,
    session_type integer,
	DEPLOY_SOURCE_IP_ENUM int,
	LOCAL_DISCRIMINATOR varchar(512)
);

create table if not exists tab_dcn_svo_source_ip_config
(
    id varchar(36) primary key,
    device_group_id character varying(36) not null,
    device_id character varying(36) not null,
    source_ip character varying(128) not null,
    vrrp_id integer,
    business_type integer not null,
    business_id character varying(128) not null
);

delete from tab_dcn_svo_spec_param where CODE = 'BGP_MAX_NUM_IN_ROUTER';
insert into tab_dcn_svo_spec_param values ('BGP_MAX_NUM_IN_ROUTER', 128,128,90,50);
--3.20.0.0.0270_END

--3.20.0.0.0280_BEGIN
create table if not exists tab_dcn_svo_loopback_manager
(
  id varchar(36),
  loopback_id varchar(36),
  business_id varchar(255),
  business_type varchar(36),
  create_time timestamp default current_timestamp,
  constraint pk_tab_dcn_svo_loopback_manager primary key (id)
);
select alter_columns('add','tab_dcn_gbp_routes_config','loopback_id','varchar(255)');
--3.20.0.0.0280_END

--3.20.0.0.0290_BEGIN
create table if not exists tab_dcn_gbp_logic_router_connect_config
(
  id varchar(36) primary key not null,
  connect_mode varchar(36),
  external_cidr character varying(8000)[],
  internal_cidr character varying(8000)[]
);
select alter_columns('add','tab_dcn_svo_router_connection','export_rt','varchar(8000)');
select alter_columns('add','tab_dcn_svo_router_connection','import_rt','varchar(8000)');
select alter_columns('add','tab_dcn_svo_router_connection','route_policy_id','varchar(36)');

update tab_dcn_svo_spec_param set spec = 2000 where CODE='MAX_EXT_GW_NUM';

CREATE OR REPLACE FUNCTION reset_route_config_ecmp() RETURNS INTEGER AS $body$
    begin
        DBMS_OUTPUT.PUT_LINE('begin to reset_route_config_ecmp');
        if exists (select 1 from tab_dcn_gbp_routes_config where trim(end_port_id) is not null)  then
            FOR route_config in select id,logic_router_id from tab_dcn_gbp_routes_config where trim(end_port_id) is not null LOOP
                DBMS_OUTPUT.PUT_LINE('begin to deal end port route.route id:'|| route_config.id);
				if exists (select 1 from tab_dcn_gbp_logic_router router where router.id = route_config.logic_router_id and router.type='Nfvi') then
					update tab_dcn_gbp_routes_config set ecmp = true, route_deploy_pos ='EndPort' where id = route_config.id;
				else
					update tab_dcn_gbp_routes_config set ecmp = false, route_deploy_pos ='EndPort' where id = route_config.id;
				end if;

            END LOOP;
        end if;
 RETURN 0;
END;
$body$ language plpgsql;
/
ALTER FUNCTION reset_route_config_ecmp() OWNER TO ossdbuser;
select reset_route_config_ecmp();
drop function if exists reset_route_config_ecmp;

select alter_columns('alter','tab_dcn_logic_switch','subnet','character varying(4000)');
select alter_columns('add','tab_dcn_svo_end_port','vm_tags','character varying(2000)[]');
select alter_columns('add','tab_dcn_gbp_bgp_config','loopback_id','varchar(256)');

CREATE OR REPLACE FUNCTION get_route_policy_name(router_vrf varchar,policy_name varchar,peer_ip varchar) RETURNS varchar AS $body$
	declare
		route_policy_name varchar;
	begin
			if (select position(':' in peer_ip)) <> 0 then
				route_policy_name = router_vrf||policy_name||replace(peer_ip,':','_');
			else
				route_policy_name = router_vrf||policy_name||replace(peer_ip,'.','_');
			end if;
			DBMS_OUTPUT.PUT_LINE('the policy name'||route_policy_name);
		return route_policy_name;
	END;
$body$ language plpgsql;

drop index concurrently if exists IDX_TAB_DCN_SVO_ROUTE_POLICY_ROUTER_ID;
drop index concurrently if exists IDX_TAB_DCN_FABRIC_SERVICE_ROUTE_POLICY_NAME;
drop index concurrently if exists IDX_TAB_DCN_SVO_ROUTE_POLICY_FILTER_FILTER_NAME_OR_NUM;
drop index concurrently if exists IDX_TAB_DCN_FABRIC_SERVICE_FILTER_FILTER_NAME;
drop index concurrently if exists IDX_TAB_DCN_FABRIC_SERVICE_FILTER_INDEX_FILTER_ID;
CREATE INDEX IDX_TAB_DCN_SVO_ROUTE_POLICY_ROUTER_ID ON TAB_DCN_SVO_ROUTE_POLICY(ROUTER_ID);
CREATE INDEX IDX_TAB_DCN_FABRIC_SERVICE_ROUTE_POLICY_NAME ON TAB_DCN_FABRIC_SERVICE_ROUTE_POLICY(NAME);
CREATE INDEX IDX_TAB_DCN_SVO_ROUTE_POLICY_FILTER_FILTER_NAME_OR_NUM ON TAB_DCN_SVO_ROUTE_POLICY_FILTER(FILTER_NAME_OR_NUM);
CREATE INDEX IDX_TAB_DCN_FABRIC_SERVICE_FILTER_FILTER_NAME ON TAB_DCN_FABRIC_SERVICE_FILTER(FILTER_NAME);
CREATE INDEX IDX_TAB_DCN_FABRIC_SERVICE_FILTER_INDEX_FILTER_ID ON TAB_DCN_FABRIC_SERVICE_FILTER_INDEX(FILTER_ID);

CREATE OR REPLACE FUNCTION reset_router_policy_with_bgp() RETURNS INTEGER AS $body$
	DECLARE
	route_policy_node_id varchar;
	need_update boolean;
	policy_node_filters varchar[] =ARRAY[]::varchar[];
	filter_id varchar;
	node_action CHARACTER VARYING(16);
	export_policy varchar;
	import_policy varchar;
	record_logic_router tab_dcn_gbp_logic_router%ROWTYPE;
	router_vrf_name varchar;
	fabric_filter_value varchar[] =ARRAY[]::varchar[];
	node_route_policy_node_id varchar;
    begin
        DBMS_OUTPUT.PUT_LINE('begin to reset_router_policy_with_bgp');
        if exists (select 1 from tab_dcn_gbp_bgp_config where router_id in (select id from tab_dcn_gbp_logic_router where type='Normal' or type='Nfvi')) then
            FOR logic_router in select id,vrf_name from tab_dcn_gbp_logic_router where type='Normal' or type='Nfvi' LOOP

				if exists (select 1 from tab_dcn_svo_route_policy  where router_id = logic_router.id and name similar to (logic_router.vrf_name||'_indirect_disable_suppress_|'||logic_router.vrf_name||'_indirect_bgp_init_policy|'||logic_router.vrf_name||'_direct_enable_suppress_|'||logic_router.vrf_name||'_indirect_enable_suppress_|')||'%') then
					FOR policy_l23 in select id,name,TENANT_ID from tab_dcn_svo_route_policy where router_id = logic_router.id and name similar to (logic_router.vrf_name||'_indirect_disable_suppress_|'||logic_router.vrf_name||'_indirect_bgp_init_policy|'||logic_router.vrf_name||'_direct_enable_suppress_|'||logic_router.vrf_name||'_indirect_enable_suppress_|')||'%' LOOP
						need_update = false;
						DBMS_OUTPUT.PUT_LINE('-----need deal policy name 4 bgp:'|| policy_l23.name);
						--还原路由策略里的node信息--fabric
						FOR policy_fabric in select id,node,action,name,APPLY_TAG,ip_prefix_name from tab_dcn_fabric_service_route_policy where name=policy_l23.name LOOP
							route_policy_node_id = randUuid();
							if policy_fabric.node is not null then
								policy_node_filters =ARRAY[]::varchar[];
								need_update = true;
								--fabric
								node_action='Deny';
								if policy_fabric.action = 1 then
									node_action='Permit';
								end if;
								insert into tab_dcn_fabric_service_route_policy_node (id,tenant_id,ROUTE_POLICY_ID,ACTION,route_policy_index) values (route_policy_node_id,'00000000-0000-0000-0000-000000000000',policy_l23.id,policy_fabric.action - 1,policy_fabric.node);
								--L23
								insert into tab_dcn_svo_route_policy_node (id,index_num,tenant_id,routePolicy_id,action) values (route_policy_node_id,policy_fabric.node,'00000000-0000-0000-0000-000000000000',policy_l23.id,node_action);
									--node的设备实例化信息
									if exists (select 1 from tab_dcn_fabric_device_resm_manage where NE_ID in (select NE_ID from   tab_dcn_fabric_service_route_policy_deploy where  POLICY_NAME = policy_fabric.name)) then
										FOR dev_grp in select distinct NODE_ID from tab_dcn_fabric_device_resm_manage where NE_ID in (select NE_ID from   tab_dcn_fabric_service_route_policy_deploy where  POLICY_NAME = policy_fabric.name) LOOP
											node_route_policy_node_id = randUuid();
											insert into tab_dcn_fabric_manage_node_route_policy_node (id,POLICY_NODE_ID,NODE_ID,POLICY_NAME) values (node_route_policy_node_id,route_policy_node_id,dev_grp.NODE_ID::UUID,policy_fabric.name);
											--node子表
											FOR device_info in select ne_id,ne_type from tab_dcn_fabric_device_resm_manage where node_id = dev_grp.NODE_ID LOOP
												insert into tab_dcn_fabric_manage_ne_route_policy_node (id,device_id,ne_id,ne_type,node_route_policy_node_id) values (randUuid(),device_info.ne_id::UUID,device_info.ne_id,device_info.ne_type,node_route_policy_node_id);
											END LOOP;
										END LOOP;
									end if;
									--node的apply信息
									if policy_fabric.APPLY_TAG is not null then
										--fabric
										DBMS_OUTPUT.PUT_LINE('-----need deal APPLY_TAG');
										insert into tab_dcn_fabric_service_route_policy_apply (id,APPLY_TYPE,VALUE,ROUTE_POLICY_NODE_ID,ORIGIN_NEXT_HOP,ADDITIVE) values (randUuid(),1,policy_fabric.APPLY_TAG,route_policy_node_id,false,true);
										--L23
										insert into tab_dcn_svo_route_policy_node_apply (id,routePolicyNode_id,apply_type_enum,value,is_additive) values (randUuid(),route_policy_node_id,'Community',policy_fabric.APPLY_TAG,true);
									end if;
									
									DBMS_OUTPUT.PUT_LINE('-----delete name:'|| policy_fabric.name);
								--多个node时fabric存在多个策略，保持与L23一致
								delete from tab_dcn_fabric_service_route_policy where id = policy_fabric.id;

								--更新L23 filter 的nodeId
								if	exists(select 1 from tab_dcn_svo_route_policy_filter where filter_name_or_num= policy_fabric.ip_prefix_name) then
									update tab_dcn_svo_route_policy_filter set ROUTEPOLICYNODE_ID=route_policy_node_id where filter_name_or_num= policy_fabric.ip_prefix_name;
									--filterNode
									FOR filterNodes in select id,filter_index,action from tab_dcn_svo_route_policy_filter where filter_name_or_num= policy_fabric.ip_prefix_name LOOP
										select FILTER_VALUE  from tab_dcn_fabric_service_filter where id = filterNodes.id into fabric_filter_value;
										insert into tab_dcn_svo_route_policy_filter_node (id,filter_id,filter_node_index,action,filter_value) values (randUuid(),filterNodes.id,filterNodes.filter_index,filterNodes.action,fabric_filter_value);
									END LOOP;
								end if;
								--filter挂在node为100下面
								if policy_fabric.node = 100 and exists(select 1 from tab_dcn_fabric_service_filter where filter_name= policy_fabric.ip_prefix_name) then
									FOR filters in select id,ACTION from tab_dcn_fabric_service_filter where filter_name= policy_fabric.ip_prefix_name LOOP
										filter_id= filters.id;
										policy_node_filters = array_append(policy_node_filters,filter_id);
										--filter index 信息
										if exists (select 1 from tab_dcn_fabric_service_filter_index where FILTER_ID=filters.id) then
											update tab_dcn_fabric_service_filter_index set action = filters.ACTION where  FILTER_ID=filters.id;
											FOR filterIndexs in select FILTER_INDEX from tab_dcn_fabric_service_filter_index filterindex where filterindex.FILTER_ID=filter_id LOOP
												update tab_dcn_svo_route_policy_filter_node filterNode set filterNode.filter_node_index=filterIndexs.FILTER_INDEX where filterNode.filter_id=filter_id;
											END LOOP;
										end if;
									END LOOP;
								end if;
								--更新fabric node的filter信息
								update tab_dcn_fabric_service_route_policy_node set FILTER_IDS = policy_node_filters where id=route_policy_node_id;
							end if;
						END LOOP;
						delete from tab_dcn_fabric_service_route_policy_deploy where POLICY_NAME = policy_l23.name;
						--界面回显表
						if need_update = true then
							insert into tab_dcn_fabric_service_route_policy (id,name,TENANT_ID) values (policy_l23.id,policy_l23.name,policy_l23.TENANT_ID);
							insert into tab_dcn_svo_route_policy_config (id,name,policy_type,ip_version, producer) values (policy_l23.id,policy_l23.name,'General','Unknown', 'component-neutron');
						end if;
					END LOOP;
				end if;

            END LOOP;
			FOR bgp_config in select id,router_id,bgp_peer_type,ebgp_peer_tag,suppress,peer_ip from tab_dcn_gbp_bgp_config where router_id in (select id from tab_dcn_gbp_logic_router where type='Normal' or type='Nfvi') LOOP
				
				import_policy := null;
				export_policy := null;
				select id,app_id,name,description,CREATE_TYPE,type,EGRESS_GATEWAY,vrf_mode,vrf_name from tab_dcn_gbp_logic_router where id = bgp_config.router_id into record_logic_router;
				if bgp_config.bgp_peer_type = 1 then
					if bgp_config.ebgp_peer_tag = true then
						if bgp_config.suppress = true then
							import_policy = get_route_policy_name(record_logic_router.vrf_name,'_indirect_enable_suppress_',bgp_config.peer_ip);
						else
							import_policy = get_route_policy_name(record_logic_router.vrf_name,'_indirect_disable_suppress_',bgp_config.peer_ip);
						end if;
					else
						if record_logic_router.type = 'Nfvi' or (record_logic_router.type = 'Normal' and  bgp_config.suppress = true) then
							if bgp_config.suppress = true then
								import_policy = get_route_policy_name(record_logic_router.vrf_name,'_indirect_enable_suppress_',bgp_config.peer_ip);
							else
								import_policy = get_route_policy_name(record_logic_router.vrf_name,'_indirect_disable_suppress_',bgp_config.peer_ip);
							end if;
						end if;
					end if;
					export_policy := record_logic_router.vrf_name||'_indirect_bgp_init_policy';
				else
					if bgp_config.suppress = true or bgp_config.ebgp_peer_tag = true then
						import_policy = get_route_policy_name(record_logic_router.vrf_name,'_direct_enable_suppress_',bgp_config.peer_ip);
					end if;
				end if;
				if import_policy is not null then
					update tab_dcn_gbp_bgp_config set import_route_policy_name = import_policy where id = bgp_config.id;
				end if;
				if export_policy is not null then
					update tab_dcn_gbp_bgp_config set route_policy_name = export_policy where id = bgp_config.id;
				end if;
			END LOOP;
        end if;
 RETURN 0;
END;
$body$ language plpgsql;
/
ALTER FUNCTION reset_router_policy_with_bgp() OWNER TO ossdbuser;
select reset_router_policy_with_bgp();
drop function if exists reset_router_policy_with_bgp;
drop function if exists get_route_policy_name(varchar,varchar,varchar);


ALTER TABLE tab_dcn_svo_bfd_session  ALTER COLUMN LOGIC_ROUTER_ID DROP NOT NULL;
ALTER TABLE tab_dcn_svo_bfd_session  ALTER COLUMN SESSION_NAME DROP NOT NULL;
ALTER TABLE tab_dcn_svo_bfd_session  ALTER COLUMN DESTINATION DROP NOT NULL;
ALTER TABLE tab_dcn_svo_bfd_session  ALTER COLUMN SOURCE_IF_ID DROP NOT NULL;
ALTER TABLE tab_dcn_svo_bfd_session  ALTER COLUMN SESSION_MODE DROP NOT NULL;
ALTER TABLE tab_dcn_svo_bfd_session  ALTER COLUMN DETECT_MULTIPLIER DROP NOT NULL;
ALTER TABLE tab_dcn_svo_bfd_session  ALTER COLUMN SEND_MIN_INTERVAL DROP NOT NULL;
ALTER TABLE tab_dcn_svo_bfd_session  ALTER COLUMN RECEIVE_MIN_INTERVAL DROP NOT NULL;
ALTER TABLE tab_dcn_svo_bfd_session  ALTER COLUMN SESSION_TYPE DROP NOT NULL;

CREATE OR REPLACE FUNCTION rebuild_bfd_session_resource() RETURNS INTEGER AS $body$
	DECLARE
	dev_grp_id varchar;
	route_next_hop varchar;
	all_dev_grp_ids varchar[] =ARRAY[]::varchar[];
	temp_dev_id varchar;
    begin
        DBMS_OUTPUT.PUT_LINE('begin to rebuild_bfd_session_resource');
        if exists (select 1 from tab_dcn_gbp_routes_config where  end_port_track_name is not null)  then
            FOR route_config in select end_port_track_name,logic_router_id from tab_dcn_gbp_routes_config where  end_port_track_name is not null LOOP
                DBMS_OUTPUT.PUT_LINE('begin to deal tarck name :'|| route_config.end_port_track_name);
				all_dev_grp_ids = ARRAY[]::varchar[];
				if not exists (select 1 from tab_dcn_svo_bfd_session where session_name = route_config.end_port_track_name) then
					FOR tarck_name in select next_hop,device_group_ids,device_ids from tab_dcn_gbp_routes_config where  end_port_track_name = route_config.end_port_track_name LOOP
						--共享BFD+云网exroute保存设备组id
						route_next_hop = tarck_name.next_hop;
						if tarck_name.device_group_ids is not null then
							FOREACH dev_grp_id IN ARRAY tarck_name.device_group_ids LOOP
								if dev_grp_id = any(all_dev_grp_ids) then 
								--<>方法不能判断，故此处使用if/else判断
								else
									all_dev_grp_ids=array_append(all_dev_grp_ids,dev_grp_id);
								end if;
							END LOOP;
						end if;
						DBMS_OUTPUT.PUT_LINE('all dev grp id :'|| array_to_string(all_dev_grp_ids,','));
						--自动BFD保存设备ID
						
						if tarck_name.device_group_ids is null and tarck_name.device_ids is not null then
							DBMS_OUTPUT.PUT_LINE(' dev id '||array_to_string(tarck_name.device_ids,','));
							FOR dev_grroup_ids in select id,node_id from tab_dcn_fabric_device_resm_manage where ne_id = any(tarck_name.device_ids) LOOP
							temp_dev_id = dev_grroup_ids.node_id;
								if temp_dev_id = any(all_dev_grp_ids) then
								--<>方法不能判断，故此处使用if/else判断
								else
									all_dev_grp_ids = array_append(all_dev_grp_ids,temp_dev_id);
								end if;
							END LOOP;
						end if;
						DBMS_OUTPUT.PUT_LINE('all dev grp id :'|| array_to_string(all_dev_grp_ids,','));
					END LOOP;
					insert into tab_dcn_svo_bfd_session (id,name,logic_router_id,session_name,destination,device_group_id,vrrp_enable,session_mode,session_type) values (randUuid(),route_config.end_port_track_name,route_config.logic_router_id,route_config.end_port_track_name,route_next_hop,array_to_string(all_dev_grp_ids,','),false,1,2);
				end if;
            END LOOP;
        end if;
 RETURN 0;
END;
$body$ language plpgsql;
/
ALTER FUNCTION rebuild_bfd_session_resource() OWNER TO ossdbuser;
select rebuild_bfd_session_resource();
drop function if exists rebuild_bfd_session_resource;

create or replace function func_format_loopback_data() returns text as $body$
declare
    v_devId_ip_arr1 varchar[] := ARRAY[]::varchar[];
    v_devId_ip_arr2 varchar[] := ARRAY[]::varchar[];

begin
    DBMS_OUTPUT.PUT_LINE('begin func_format_loopback_data');
    drop table if exists tab_loopback_format_data_temp;
    create table tab_loopback_format_data_temp
    (
        id character varying(36),
        vrf_name character varying(512),
        dev_id1  character varying(72),
        lb_ip1  character varying(72),
        lb_id1 integer,
		lb_same1 boolean default false,
        dev_id2  character varying(72),
        lb_ip2  character varying(72),
        lb_id2 integer,
		lb_same2 boolean default false,
        is_same boolean default false,
        is_conflict boolean  default false
    );

    --处理bgp link的loopback 口
    for bgp in select distinct family_vpn_instance,local_interfaces from tab_dcn_fabric_service_bgplink  where local_interfaces is not null loop
		DBMS_OUTPUT.PUT_LINE('my bgp:'||bgp.family_vpn_instance);
        v_devId_ip_arr1= regexp_split_to_array(bgp.local_interfaces[1], ',');
        v_devId_ip_arr2= regexp_split_to_array(bgp.local_interfaces[2], ',');
        insert into tab_loopback_format_data_temp (id,vrf_name,dev_id1,lb_ip1,lb_id1,dev_id2,lb_ip2,lb_id2)
        select
            randUuid() id,
            bgp.family_vpn_instance vrf_name,
            v_devId_ip_arr1[1] dev_id1,
            v_devId_ip_arr1[2] lb_ip1,
            (select NUM from TAB_DCN_FABRIC_MANAGE_NE_LOOPBACK where VRF =bgp.family_vpn_instance and NE_ID=v_devId_ip_arr1[1] and ip=v_devId_ip_arr1[2]) lb_id1,
            v_devId_ip_arr2[1] dev_id2,
            v_devId_ip_arr2[2] lb_ip2,
            (select NUM from TAB_DCN_FABRIC_MANAGE_NE_LOOPBACK where VRF =bgp.family_vpn_instance and NE_ID=v_devId_ip_arr2[1] and ip=v_devId_ip_arr2[2]) lb_id2;
    end loop;
    
    --处理static route的loopback 口
    for static_route in select distinct lr.instance_name,t1.local_interfaces from (select route.logic_router_id, sr.local_interfaces from tab_dcn_fabric_service_staticroute sr left join tab_dcn_fabric_service_route route on sr.route_id=route.id where sr.local_interfaces is not null ) t1  left join tab_dcn_fabric_service_logicrouter lr on t1.logic_router_id = lr.id loop
        v_devId_ip_arr1= regexp_split_to_array(static_route.local_interfaces[1], ',');
        v_devId_ip_arr2= regexp_split_to_array(static_route.local_interfaces[2], ',');
        if exists (select 1 from tab_loopback_format_data_temp where vrf_name =static_route.instance_name and dev_id1 =v_devId_ip_arr1[1] and lb_ip1=v_devId_ip_arr1[2] and  dev_id2 =v_devId_ip_arr2[1] and lb_ip2=v_devId_ip_arr2[2]) then
            DBMS_OUTPUT.PUT_LINE('static route loopback has exists.vrf_name:'||static_route.instance_name||',dev_id1:'||v_devId_ip_arr1[1]||',lb_ip1:'||v_devId_ip_arr1[2]||',dev_id2:'||v_devId_ip_arr2[1]||',lb_ip2:'||v_devId_ip_arr2[2]);
            continue;
        end if;

        insert into tab_loopback_format_data_temp (id,vrf_name,dev_id1,lb_ip1,lb_id1,dev_id2,lb_ip2,lb_id2)
        select
            randUuid() id,
            static_route.instance_name vrf_name,
            v_devId_ip_arr1[1] dev_id1,
            v_devId_ip_arr1[2] lb_ip1,
            (select NUM from TAB_DCN_FABRIC_MANAGE_NE_LOOPBACK where VRF =static_route.instance_name and NE_ID=v_devId_ip_arr1[1] and ip=v_devId_ip_arr1[2]) lb_id1,
            v_devId_ip_arr2[1] dev_id2,
            v_devId_ip_arr2[2] lb_ip2,
            (select NUM from TAB_DCN_FABRIC_MANAGE_NE_LOOPBACK where VRF =static_route.instance_name and NE_ID=v_devId_ip_arr2[1] and ip=v_devId_ip_arr2[2]) lb_id2;
    end loop;
    
    --判定如果loop id一样 则设定is_same= true
    update tab_loopback_format_data_temp set is_same =true  where lb_id1 = lb_id2;

    --判定如果存在单边复用(dev1 loopback_ip )的情况，则设定is_conflict=true
    for loopback in select id,vrf_name,dev_id1,lb_ip1,dev_id2,lb_ip2 from tab_loopback_format_data_temp loop
        if exists (select 1 from tab_loopback_format_data_temp where id <>loopback.id and vrf_name =loopback.vrf_name and ((dev_id1=loopback.dev_id1 and lb_ip1= loopback.lb_ip1) or (dev_id2=loopback.dev_id2 and lb_ip2= loopback.lb_ip2)) ) then
            update tab_loopback_format_data_temp set is_conflict=true where vrf_name =loopback.vrf_name and dev_id1=loopback.dev_id1 and lb_ip1= loopback.lb_ip1 and dev_id2=loopback.dev_id2 and lb_ip2= loopback.lb_ip2;

			if exists (select 1 from tab_loopback_format_data_temp where id <>loopback.id and vrf_name =loopback.vrf_name and (dev_id1=loopback.dev_id1 and lb_ip1= loopback.lb_ip1 )) then
				DBMS_OUTPUT.PUT_LINE('set---1');
				update tab_loopback_format_data_temp set lb_same1=true where vrf_name =loopback.vrf_name and dev_id1=loopback.dev_id1 and lb_ip1= loopback.lb_ip1;
			end if;
			
			if exists (select 1 from tab_loopback_format_data_temp where id <>loopback.id and vrf_name =loopback.vrf_name and ((dev_id2=loopback.dev_id2 and lb_ip2= loopback.lb_ip2)) ) then
				DBMS_OUTPUT.PUT_LINE('set---2');
				update tab_loopback_format_data_temp set lb_same2=true where vrf_name =loopback.vrf_name and dev_id2=loopback.dev_id2 and lb_ip2= loopback.lb_ip2;
			end if;
        end if;
    end loop;
    
    DBMS_OUTPUT.PUT_LINE('end func_format_loopback_data');
    return 'success';
end;
$body$ language plpgsql;

ALTER FUNCTION func_format_loopback_data() OWNER TO ossdbuser;
select func_format_loopback_data();



CREATE OR REPLACE FUNCTION get_loopback_id_string(source_ips varchar,router_id varchar) RETURNS varchar[] AS $body$
	declare
		new_loopback_id varchar;
		all_loopback_ids varchar[] =ARRAY[]::varchar[];
		device_id_ips varchar[] =ARRAY[]::varchar[];
		router_vrf_name varchar;
		device_id_ip_char varchar;
		device_id_and_ip varchar[] =ARRAY[]::varchar[];
	begin
		device_id_ips = string_to_array(source_ips,';');
			all_loopback_ids =ARRAY[]::varchar[];
			select vrf_name from tab_dcn_gbp_logic_router where id = router_id into router_vrf_name;
			DBMS_OUTPUT.PUT_LINE('begin to deal device id:'||array_to_string(device_id_ips,'--'));
			FOREACH device_id_ip_char IN ARRAY device_id_ips LOOP
				device_id_and_ip = string_to_array(device_id_ip_char,',');
				DBMS_OUTPUT.PUT_LINE('---begin to deal device id:'||device_id_and_ip[1]||'---ip:'||device_id_and_ip[2]);
				if exists (select 1 from tab_dcn_fabric_manage_ne_loopback where ne_id = device_id_and_ip[1] and ip = device_id_and_ip[2] and vrf = router_vrf_name) then
					select NODE_LOOPBACK_ID from tab_dcn_fabric_manage_ne_loopback where ne_id = device_id_and_ip[1] and ip = device_id_and_ip[2] and vrf = router_vrf_name into new_loopback_id;
					if new_loopback_id = any(all_loopback_ids) then
						--<>方法不能判断，故此处使用if/else判断
					else
						all_loopback_ids=array_append(all_loopback_ids,new_loopback_id::varchar);
					end if;
				end if;
			END LOOP;
			DBMS_OUTPUT.PUT_LINE('get_loopback_id_list:'||array_to_string(all_loopback_ids,';'));
		return all_loopback_ids;
	END;
$body$ language plpgsql;
ALTER FUNCTION get_loopback_id_string() OWNER TO ossdbuser;

CREATE OR REPLACE FUNCTION rebuild_loopback_resource() RETURNS INTEGER AS $body$
	DECLARE
	new_loopback_id varchar;
	l23_loopback_bus_id varchar;
	loopback_router_id varchar;
	device_id_and_ip varchar[] =ARRAY[]::varchar[];
	router_vrf_name varchar;
	all_loopback_ids varchar[] =ARRAY[]::varchar[];
	loopback_index integer;
	complex_loop_dev varchar;
	complex_loop_ip varchar;
    begin
        DBMS_OUTPUT.PUT_LINE('begin to rebuild_loopback_resource');
        if exists (select 1 from tab_dcn_fabric_manage_ne_loopback where  NODE_LOOPBACK_ID is null)  then
            FOR loopback_temp in select id,VRF_NAME,is_conflict,dev_id1,lb_ip1,LB_ID1,lb_same1,dev_id2,lb_ip2,LB_ID2,lb_same2,is_same from tab_loopback_format_data_temp where LB_ID1 is not null or LB_ID2 is not null  LOOP
                DBMS_OUTPUT.PUT_LINE('begin to deal loopback');

				select id from tab_dcn_gbp_logic_router where vrf_name = loopback_temp.VRF_NAME into loopback_router_id;
				--存在单边复用时均拆解为两个、无单边复用时但环回口号不一致时也拆为两个
				if (loopback_temp.is_conflict = true) or (loopback_temp.is_same = false) then
					
					DBMS_OUTPUT.PUT_LINE('the loopback num:'||loopback_temp.LB_ID1||'--ip:'||loopback_temp.LB_ID2);
					if not exists (select 1 from tab_dcn_svo_loopback_device_config where resource_id = loopback_temp.LB_ID1 and router_id = loopback_router_id and device_id = loopback_temp.dev_id1) then
						DBMS_OUTPUT.PUT_LINE('deal with repeat use loopback dev1--:'||loopback_temp.dev_id1||'--ip:'||loopback_temp.lb_ip1);
						FOR loopback_num in select id,num,node_id,ne_id,ip from tab_dcn_fabric_manage_ne_loopback where  NODE_LOOPBACK_ID is null and vrf = loopback_temp.vrf_name and  ((NE_ID = loopback_temp.dev_id1 and ip = loopback_temp.lb_ip1)) LOOP
							--L23 环回口
							l23_loopback_bus_id=randUuid();
							DBMS_OUTPUT.PUT_LINE('create loopback num:'||loopback_num.num);
							new_loopback_id = randUuid();
							insert into tab_dcn_svo_loopback (id,name,description,owner_type,owner_id,router_id,interface_ip_enable,loopback_bus_id) values (new_loopback_id,'Db_Ups_'||loopback_num.num,'from_db_ups',0,loopback_router_id,loopback_router_id,false,l23_loopback_bus_id);

							insert into tab_dcn_fabric_manage_node_loopback (id,description,num,logic_router_id,node_id) values (new_loopback_id,'from_db_ups',loopback_num.num,loopback_router_id,loopback_num.node_id::varchar);

							update tab_dcn_fabric_manage_ne_loopback set NODE_LOOPBACK_ID = new_loopback_id where id = loopback_num.id;
							--L23 环回口设备IP信息
							insert into tab_dcn_svo_loopback_device_config (id,loopback_bus_id,resource_id,device_group_id,device_id,router_id,ip) values (randUuid(),l23_loopback_bus_id,loopback_num.num,loopback_num.node_id::varchar,loopback_num.ne_id,loopback_router_id,loopback_num.ip);
						END LOOP;
					end if;
					if not exists (select 1 from tab_dcn_svo_loopback_device_config where resource_id = loopback_temp.LB_ID2 and router_id = loopback_router_id and device_id = loopback_temp.dev_id2) then
						DBMS_OUTPUT.PUT_LINE('deal with repeat use loopback  dev2--:'||loopback_temp.dev_id2||'--ip:'||loopback_temp.lb_ip2);
						FOR loopback_num in select id,num,node_id,ne_id,ip from tab_dcn_fabric_manage_ne_loopback where  NODE_LOOPBACK_ID is null and vrf = loopback_temp.vrf_name and  ((NE_ID = loopback_temp.dev_id2 and ip = loopback_temp.lb_ip2)) LOOP
							--L23 环回口
							l23_loopback_bus_id=randUuid();
							DBMS_OUTPUT.PUT_LINE('createe loopback num:'||loopback_num.num);
							new_loopback_id = randUuid();
							insert into tab_dcn_svo_loopback (id,name,description,owner_type,owner_id,router_id,interface_ip_enable,loopback_bus_id) values (new_loopback_id,'Db_Ups_'||loopback_num.num,'from_db_ups',0,loopback_router_id,loopback_router_id,false,l23_loopback_bus_id);

							insert into tab_dcn_fabric_manage_node_loopback (id,description,num,logic_router_id,node_id) values (new_loopback_id,'from_db_ups',loopback_num.num,loopback_router_id,loopback_num.node_id::varchar);

							update tab_dcn_fabric_manage_ne_loopback set NODE_LOOPBACK_ID = new_loopback_id where id = loopback_num.id;
							--L23 环回口设备IP信息
							insert into tab_dcn_svo_loopback_device_config (id,loopback_bus_id,resource_id,device_group_id,device_id,router_id,ip) values (randUuid(),l23_loopback_bus_id,loopback_num.num,loopback_num.node_id::varchar,loopback_num.ne_id,loopback_router_id,loopback_num.ip);
						END LOOP;
					end if;
				else
					--L23 环回口
					l23_loopback_bus_id=randUuid();
					insert into tab_dcn_svo_loopback (id,name,description,owner_type,owner_id,router_id,interface_ip_enable,loopback_bus_id) values (loopback_temp.id,'Db_Ups_'||loopback_temp.LB_ID1,'from_db_ups',0,loopback_router_id,loopback_router_id,false,l23_loopback_bus_id);
					--fabric 环回口ID
					FOR loopback_num in select id,num,node_id,ne_id,ip from tab_dcn_fabric_manage_ne_loopback where  NODE_LOOPBACK_ID is null and vrf = loopback_temp.vrf_name and  ((NE_ID = loopback_temp.dev_id1 and ip = loopback_temp.lb_ip1) or (NE_ID = loopback_temp.dev_id2 and ip = loopback_temp.lb_ip2 )) LOOP
						if not exists (select 1 from tab_dcn_fabric_manage_node_loopback where id = loopback_temp.id) then
							insert into tab_dcn_fabric_manage_node_loopback (id,description,num,logic_router_id,node_id) values (loopback_temp.id,'from_db_ups',loopback_num.num,loopback_router_id,loopback_num.node_id::varchar);
						end if;
						update tab_dcn_fabric_manage_ne_loopback set NODE_LOOPBACK_ID = loopback_temp.id where id = loopback_num.id;
						--L23 环回口设备IP信息
						insert into tab_dcn_svo_loopback_device_config (id,loopback_bus_id,resource_id,device_group_id,device_id,router_id,ip) values (randUuid(),l23_loopback_bus_id,loopback_num.num,loopback_num.node_id::varchar,loopback_num.ne_id,loopback_router_id,loopback_num.ip);
					END LOOP;
				end if;

            END LOOP;
        end if;
		
		DBMS_OUTPUT.PUT_LINE('begin to rebuild_loopback_bgp_reference');
		if exists (select 1 from tab_dcn_gbp_bgp_config where  loopback_id is null and source_ips is not null)  then
			--处理环回口信息
			FOR bgp_config in select id,source_ips,router_id,peer_ip,bgp_route_id,peer_ip from tab_dcn_gbp_bgp_config where  loopback_id is null and source_ips is not null LOOP

				all_loopback_ids = get_loopback_id_string(bgp_config.source_ips,bgp_config.router_id);
				update tab_dcn_gbp_bgp_config set loopback_id = array_to_string(all_loopback_ids,';') where id =bgp_config.id;
				FOREACH new_loopback_id IN ARRAY all_loopback_ids LOOP
					insert into tab_dcn_svo_loopback_manager (id,loopback_id,business_id,business_type) values (randUuid(),new_loopback_id,bgp_config.bgp_route_id,'BGP');
				END LOOP;
				--Fabric bgp 相关表
				if exists ( select 1 from tab_dcn_fabric_service_bgplink where (ipv4_peer_ip = bgp_config.peer_ip or ipv6_peer_ip= bgp_config.peer_ip) and  protocol_id  in (select id from tab_dcn_fabric_service_protocol where route_id = bgp_config.bgp_route_id)) then
					FOR fabric_bgp_link in select id from tab_dcn_fabric_service_bgplink where (ipv4_peer_ip = bgp_config.peer_ip or ipv6_peer_ip= bgp_config.peer_ip) and  protocol_id  in (select id from tab_dcn_fabric_service_protocol where route_id = bgp_config.bgp_route_id) LOOP
						update tab_dcn_fabric_service_bgplink set LOOPBACK_IDS = all_loopback_ids where id = fabric_bgp_link.id;
					END LOOP;
				end if;
			END LOOP;
			--处理fabric connect-if信息
			if exists (select 1 from tab_dcn_fabric_service_bgplinkdeploy where connect_if is not null) then
				FOR fabric_bgp_link_deploy in select id,connect_if,logic_router_id from tab_dcn_fabric_service_bgplinkdeploy where connect_if is not null LOOP
					
					device_id_and_ip = string_to_array(fabric_bgp_link_deploy.connect_if,',');
					select vrf_name from tab_dcn_gbp_logic_router where id = fabric_bgp_link_deploy.logic_router_id into router_vrf_name;
					DBMS_OUTPUT.PUT_LINE('bgp connect if:'||device_id_and_ip[1]||'--'||device_id_and_ip[2]||'---'||router_vrf_name);
					if exists (select 1 from tab_dcn_fabric_manage_ne_loopback where ne_id = device_id_and_ip[1] and ip = device_id_and_ip[2] and vrf = router_vrf_name) then
						select num from tab_dcn_fabric_manage_ne_loopback where ne_id = device_id_and_ip[1] and ip = device_id_and_ip[2] and vrf = router_vrf_name into loopback_index;
						DBMS_OUTPUT.PUT_LINE('begin to rebuild bgp connect_if:'||loopback_index);
						if loopback_index is not null then
							update tab_dcn_fabric_service_bgplinkdeploy set connect_if =  loopback_index||','||device_id_and_ip[2] where id = fabric_bgp_link_deploy.id;
						end	if;
					end if;

				END LOOP;
			end if;
		end if;
		
		DBMS_OUTPUT.PUT_LINE('begin to rebuild_loopback_static_route_reference');
		if exists (select 1 from tab_dcn_gbp_routes_config where  loopback_id is null and source_ips is not null)  then
			FOR route_config in select id,source_ips,logic_router_id,route_id from tab_dcn_gbp_routes_config where  loopback_id is null and source_ips is not null LOOP

				all_loopback_ids = get_loopback_id_string(route_config.source_ips,route_config.logic_router_id);
				update tab_dcn_gbp_routes_config set loopback_id = array_to_string(all_loopback_ids,';') where id =route_config.id;
				FOREACH new_loopback_id IN ARRAY all_loopback_ids LOOP
					insert into tab_dcn_svo_loopback_manager (id,loopback_id,business_id,business_type) values (randUuid(),new_loopback_id,route_config.route_id,'ROUTE');
				END LOOP;
				--Fabric route 相关表
				if exists (select 1 from tab_dcn_fabric_service_staticroutedeploy where route_id = route_config.route_id) then
					update tab_dcn_fabric_service_staticroutedeploy set loopback_ids = all_loopback_ids where route_id = route_config.route_id;
				end if;
				if exists (select 1 from tab_dcn_fabric_service_staticroute where route_id = route_config.route_id) then
					update tab_dcn_fabric_service_staticroute set loopback_ids = all_loopback_ids where route_id = route_config.route_id;
				end if;
			END LOOP;
		end if;
 RETURN 0;
END;
$body$ language plpgsql;
/
ALTER FUNCTION rebuild_loopback_resource() OWNER TO ossdbuser;
select rebuild_loopback_resource();
drop function if exists rebuild_loopback_resource;
drop function if exists get_loopback_id_string(varchar,varchar);
drop function if exists func_format_loopback_data();


select alter_columns('add','tab_dcn_svo_route_policy_config','DEVICE_GROUP_ID','varchar(256)');

CREATE OR REPLACE FUNCTION get_fabric_id_by_router_id(router_id varchar) RETURNS varchar[] AS $body$
	declare
		all_faric_ids varchar[] =ARRAY[]::varchar[];
		v_cnt integer;
		v_fabric_id varchar;
		temp_faric_ids varchar[] =ARRAY[]::varchar[];
	begin
			--查找router的出口网关
			if exists (select 1 from tab_dcn_gbp_logic_router_fabric where logic_router_id = router_id) then
				FOR router_fabric in select fabric_id from tab_dcn_gbp_logic_router_fabric where logic_router_id = router_id LOOP
					if router_fabric.fabric_id = any(all_faric_ids) then 
						--<>方法不能判断，故此处使用if/else判断
					else
						all_faric_ids=array_append(all_faric_ids,router_fabric.fabric_id);
					end if;
				END LOOP;
			end if;
			if array_length(all_faric_ids,1) > 0 then
				DBMS_OUTPUT.PUT_LINE('get_fabric_id_by_router_id by router fabric');
				return all_faric_ids;
			end if;
			--查找router关联的外部网关
			if exists (select 1 from tab_dcn_external_gateway_fabric where externalGateway_id in (select externalGateway_id from tab_dcn_external_network where id in (select distinct peer_id::UUID from tab_dcn_gbp_logic_link where (type = 1 or type = 4) and local_id = router_id))) then
				FOR ext_fabric in select fabric_id::varchar from tab_dcn_external_gateway_fabric where externalGateway_id in (select externalGateway_id from tab_dcn_external_network where id in (select distinct peer_id::UUID from tab_dcn_gbp_logic_link where (type = 1 or type = 4) and local_id = router_id)) LOOP
					if ext_fabric.fabric_id = any(all_faric_ids) then 
						--<>方法不能判断，故此处使用if/else判断
					else
						all_faric_ids=array_append(all_faric_ids,ext_fabric.fabric_id);
					end if;
				END LOOP;
			end if;
			if array_length(all_faric_ids,1) > 0 then
				DBMS_OUTPUT.PUT_LINE('get_fabric_id_by_router_id by ext gw fabric');
				return all_faric_ids;
			end if;
			--查找ac Fabric
			select count(1) from tab_dcn_fabric_resm_basicinfo where 1 = 1 into v_cnt;
			if v_cnt = 1 then
				DBMS_OUTPUT.PUT_LINE('get_fabric_id_by_router_id by ac fabric');
				select id from tab_dcn_fabric_resm_basicinfo where 1 = 1 into v_fabric_id;
				all_faric_ids=array_append(all_faric_ids,ext_fabric.fabric_id);
				return all_faric_ids;
			end if;
			--查找租户fabric
			select count(1) from tab_dcn_tenant_fabric where tenant_id in (select tenant_id from tab_dcn_gbp_logic_router where id = router_id) into v_cnt;
			if v_cnt = 1 then
				DBMS_OUTPUT.PUT_LINE('get_fabric_id_by_router_id by tenant fabric');
				select used_fabric_id from tab_dcn_tenant_fabric where tenant_id in (select tenant_id from tab_dcn_gbp_logic_router where id = router_id) into v_fabric_id;
				all_faric_ids=array_append(all_faric_ids,ext_fabric.fabric_id);
				return all_faric_ids;
			end if;
			--查找vpc fabric_id
			if exists (select 1 from tab_dcn_logic_network where pk_dcn_id in (select app_id from tab_dcn_gbp_logic_router where id = router_id)) then
				FOR vpc in select fabric_id from tab_dcn_logic_network where pk_dcn_id in (select app_id from tab_dcn_gbp_logic_router where id = router_id) LOOP
					temp_faric_ids = regexp_split_to_array(vpc.fabric_id,';');
					if array_length(temp_faric_ids,1) = 1 then
						DBMS_OUTPUT.PUT_LINE('get_fabric_id_by_router_id by vpc fabric');
						all_faric_ids=array_append(all_faric_ids,vpc.fabric_id);
					end if;
				END LOOP;
			end if;
			
			DBMS_OUTPUT.PUT_LINE('get_fabric_id_by_router_id:'||array_to_string(all_faric_ids,','));
		return all_faric_ids;
	END;
$body$ language plpgsql;
ALTER FUNCTION get_fabric_id_by_router_id() OWNER TO ossdbuser;

create or replace function fill_route_to_svo_route_policy_config_dev_grp() returns integer as $body$
	declare
		v_dci_dev_grp varchar[] := array[]::varchar[];
		v_dci_fabric_id varchar[] := array[]::varchar[];
		v_already_fill boolean;
		v_dci_dev_grp_id varchar;
    begin
        DBMS_OUTPUT.PUT_LINE('begin to fill_route_to_svo_route_policy_config_dev_grp');
			--l2dci的互通switch保持dci网关设备组信息
			v_already_fill := false;
			if exists (select 1 from tab_dcn_svo_dci_connection where connector_type = 1)  then
				DBMS_OUTPUT.PUT_LINE('update by l2dci:');
				execute immediate  'select device_group_list from tab_dcn_logic_switch where pk_dcn_id in (select id from tab_dcn_svo_dci_connection where 1 = 1 limit 1 )' into v_dci_dev_grp;
				if exists (select 1 from tab_dcn_svo_route_policy_config where policy_type = 'Dci')  then
					if v_dci_dev_grp is not null then
						DBMS_OUTPUT.PUT_LINE('update by l2dci:'||array_to_string(v_dci_dev_grp,','));
						update tab_dcn_svo_route_policy_config set device_group_id = v_dci_dev_grp[1] where policy_type = 'Dci';
						v_already_fill := true;
					end if;
				end if;
			end if;
			--l3dci的互通需要查询租户router的网关设备
			if v_already_fill = false and exists (select 1 from tab_dcn_svo_dci_connection where connector_type = 0 or connector_type = 2) then
				DBMS_OUTPUT.PUT_LINE('update by l3dci');
					FOR tenant_router in select connector_id from tab_dcn_svo_dci_connection where connector_type = 0 or connector_type = 2 LOOP
						v_dci_fabric_id = get_fabric_id_by_router_id(tenant_router.connector_id);
						if array_length(v_dci_fabric_id,1) > 0 then
							if exists (select 1 from tab_dcn_fabric_resm_node where fabric_id in (array_to_string(v_dci_fabric_id,',')) and is_dci_enable = true) then
								execute immediate  'select id from tab_dcn_fabric_resm_node where fabric_id ='''||v_dci_fabric_id[1]||''' and is_dci_enable = true limit 1' into v_dci_dev_grp_id;
								DBMS_OUTPUT.PUT_LINE('update by l3dci grp id:'||v_dci_dev_grp_id);
								update tab_dcn_svo_route_policy_config set device_group_id = v_dci_dev_grp_id where policy_type = 'Dci';
							end if;
						end if;
					END LOOP;
			end if;

 return 0;
end;
$body$ language plpgsql;
alter function fill_route_to_svo_route_policy_config_dev_grp() owner to ossdbuser;
select fill_route_to_svo_route_policy_config_dev_grp();
drop function if exists fill_route_to_svo_route_policy_config_dev_grp;
drop function if exists get_fabric_id_by_router_id;

CREATE OR REPLACE FUNCTION fill_bgp_policy_4_escape() RETURNS INTEGER AS $body$
	DECLARE
	escape_policy character varying(256);
    begin
        DBMS_OUTPUT.PUT_LINE('begin to fill_bgp_policy_4_escape');
		if exists (select 1 from tab_dcn_svo_route_policy_config where policy_type ='BestEffortPath') then
			select name from tab_dcn_svo_route_policy_config where policy_type ='BestEffortPath' into escape_policy;
		end if;
		DBMS_OUTPUT.PUT_LINE('begin to fill_bgp_policy_4_escape name:'||escape_policy);
        if exists (select 1 from tab_dcn_svo_escape_link_deploy )  then
            FOR escape_link in select router_id,device_group_id from tab_dcn_svo_escape_link_deploy LOOP
                DBMS_OUTPUT.PUT_LINE('begin to deal esacpe  router id:'|| escape_link.router_id);
				if exists (select 1 from tab_dcn_fabric_service_bgplink where protocol_id in (select id from tab_dcn_fabric_service_protocol where route_id = escape_link.router_id|| escape_link.device_group_id)) then
					DBMS_OUTPUT.PUT_LINE('update escape bgp info:');
					FOR bgp_link in select id from tab_dcn_fabric_service_bgplink where protocol_id in (select id from tab_dcn_fabric_service_protocol where route_id = escape_link.router_id|| escape_link.device_group_id) LOOP
						DBMS_OUTPUT.PUT_LINE('update escape bgp link route policy:'||bgp_link.id);
						update tab_dcn_fabric_service_bgplink set rtp_pre_cfg = true, peer_export_route_policy = escape_policy where id = bgp_link.id;
						if exists (select 1 from tab_dcn_fabric_service_bgplinkdeploy where bgp_link_id = bgp_link.id) then
							update tab_dcn_fabric_service_bgplinkdeploy set rtp_pre_cfg = true , peer_export_route_policy = escape_policy where bgp_link_id = bgp_link.id;
						end if;
					END LOOP;
				end if;

            END LOOP;
        end if;
 RETURN 0;
END;
$body$ language plpgsql;
/
ALTER FUNCTION fill_bgp_policy_4_escape() OWNER TO ossdbuser;
select fill_bgp_policy_4_escape();
drop function if exists fill_bgp_policy_4_escape;

update  tab_dcn_gbp_routes_config  set priority=255 where  ecmp = true;
update tab_dcn_fabric_service_staticroute set preference =255 where ecmp_enable = true;
update tab_dcn_fabric_service_staticroutedeploy set preference =255 where ecmp_enable = true;
--3.20.0.0.0290_END

update tab_dcn_external_gateway set public_ip_route_mode = 0 where type = 4;

update tab_dcn_logic_network set type = 'Instance' where producer is null or producer <> 'Agile-Controller-MDC';

select alter_columns('add','tab_dcn_logic_port','vlan_alloc_type','varchar(36)');
update tab_dcn_logic_port set vlan_alloc_type='Manual' where create_type is null  and  vlan_id is not null and vlan_id <> 0 and vlan_alloc_type is null;

CREATE OR REPLACE FUNCTION build_ext_router_bind_dev_grp() RETURNS INTEGER AS $body$
    begin
        DBMS_OUTPUT.PUT_LINE('begin to build_ext_router_bind_dev_grp');
		if exists (select 1 from tab_dcn_external_gateway where interface_type = 0 and (type = 4 or type = 5)) then
			FOR ext_gw in select id from tab_dcn_external_gateway where interface_type = 0 and (type = 4 or type = 5) LOOP
				if exists (select 1 from tab_dcn_external_gateway_device_group where externalGateway_id = ext_gw.id) then
					FOR ext_dev in select externalGateway_id,device_group_id from tab_dcn_external_gateway_device_group where externalGateway_id = ext_gw.id LOOP
						if not exists (select 1 from tab_dcn_svo_router_bind_device_group where business_type = 1 and router_id = ext_dev.externalGateway_id::varchar and business_id = ext_dev.externalGateway_id::varchar and device_group_id = ext_dev.device_group_id::varchar) then
							DBMS_OUTPUT.PUT_LINE('insert router bind device group  router_id:'||ext_dev.externalGateway_id||'--device_group_id:'||ext_dev.device_group_id);
							insert into tab_dcn_svo_router_bind_device_group (id,router_id,device_group_id,business_type,business_id) values (randUuid(),ext_dev.externalGateway_id::varchar,ext_dev.device_group_id::varchar,1,ext_dev.externalGateway_id::varchar);
						end if;

					END LOOP;
				end if;
			END LOOP;
		end if;
		DBMS_OUTPUT.PUT_LINE('over to build_ext_router_bind_dev_grp');
 RETURN 0;
END;
$body$ language plpgsql;
/
ALTER FUNCTION build_ext_router_bind_dev_grp() OWNER TO ossdbuser;
select build_ext_router_bind_dev_grp();
drop function if exists build_ext_router_bind_dev_grp;

create table if not exists TAB_DCN_SVO_DEVICE_PORT_RANGE
(
  ID varchar(36) not null,
  HOST_CLUSTER_ID varchar(36),
  DEVICE_GROUP_ID varchar(36),
  DEVICE_GROUP_NAME varchar(255),
  DEVICE_ID varchar(36),
  DEVICE_NAME varchar(255),
  BEGIN_PORT_NAME varchar(255),
  END_PORT_NAME varchar(255),
  CREATE_TIME timestamp default current_timestamp,
  constraint PK_TAB_DCN_SVO_DEVICE_PORT_RANGE primary key (id)
);

CREATE OR REPLACE FUNCTION l2l3app_table_add_column() RETURNS INTEGER AS $add_column$
    DECLARE
        v_cnt INTEGER := 0;
    begin
        select count(*) from information_schema.columns where TABLE_NAME = 'TAB_DCN_SVO_HOST_CLUSTER_MEMBER' and column_name = 'DEVICE_PORT_RANGE_ID' into v_cnt;
        if v_cnt = 0 then
            alter table TAB_DCN_SVO_HOST_CLUSTER_MEMBER add DEVICE_PORT_RANGE_ID varchar(36);
        end if;

        select count(*) from information_schema.columns where TABLE_NAME = 'TAB_DCN_SVO_HOST_CLUSTER' and column_name = 'PORT_CLUSTER_TYPE' into v_cnt;
        if v_cnt = 0 then
            alter table TAB_DCN_SVO_HOST_CLUSTER add PORT_CLUSTER_TYPE varchar(36);
        end if;

        select count(*) from information_schema.columns where TABLE_NAME = 'TAB_DCN_LOGIC_PORT' and column_name = 'PORT_TYPE' into v_cnt;
        if v_cnt = 0 then
            alter table TAB_DCN_LOGIC_PORT add PORT_TYPE varchar(32);
        end if;

        select count(*) from information_schema.columns where TABLE_NAME = 'TAB_DCN_LOGIC_PORT' and column_name = 'HOST_CLUSTER_ID' into v_cnt;
        if v_cnt = 0 then
            alter table TAB_DCN_LOGIC_PORT add HOST_CLUSTER_ID varchar(36);
        end if;

        update TAB_DCN_LOGIC_PORT set PORT_TYPE ='Subinterface' where PORT_TYPE is null;
        update TAB_DCN_SVO_HOST_CLUSTER set PORT_CLUSTER_TYPE ='PortList' where PORT_CLUSTER_TYPE is null;

        return 0;
    end;
$add_column$ language plpgsql;
/
ALTER FUNCTION l2l3app_table_add_column() OWNER TO ossdbuser;
select l2l3app_table_add_column();
drop function if exists l2l3app_table_add_column;
