--3.20.0.0.0100_BEGIN
select alter_columns('ADD', 'tab_dcn_neutron_floating_ip', 'description', 'varchar(255)');
select alter_columns('ADD', 'tab_dcn_neutron_dnat', 'description', 'varchar(255)');
select alter_columns('ADD', 'tab_dcn_neutron_network', 'description', 'varchar(255)');
select alter_columns('ADD', 'tab_dcn_neutron_port', 'description', 'varchar(255)');
select alter_columns('ADD', 'tab_dcn_neutron_route', 'description', 'varchar(255)');
select alter_columns('ADD', 'tab_dcn_neutron_router', 'description', 'varchar(255)');
select alter_columns('ADD', 'tab_dcn_neutron_route_policy', 'description', 'varchar(255)');
select alter_columns('ADD', 'tab_dcn_neutron_snat', 'description', 'varchar(255)');
select alter_columns('ADD', 'tab_dcn_neutron_subnet', 'description', 'varchar(255)');
select alter_columns('ADD', 'tab_dcn_neutron_security_rule', 'description', 'varchar(255)');
select alter_columns('ADD', 'tab_dcn_neutron_l2br', 'description', 'varchar(255)');
--3.20.0.0.0100_END

--3.20.0.0.0250_BEGIN
select alter_columns('ADD', 'TAB_DCN_NEUTRON_NEW_SPEC', 'alarm_percent', 'integer');
select alter_columns('ADD', 'TAB_DCN_NEUTRON_NEW_SPEC', 'resume_percent', 'integer');

update TAB_DCN_NEUTRON_NEW_SPEC set alarm_percent=90 where alarm_percent is null;
update TAB_DCN_NEUTRON_NEW_SPEC set resume_percent=80 where resume_percent is null;

create table if not exists tab_dcn_neutron_bgp_route_policy
(
    id varchar(36) not null,
    name varchar(256) not null,
    constraint pk_tab_dcn_neutron_bgp_route_policy primary key (id)
);

alter table tab_dcn_neutron_bgp_route_policy add constraint if not exists neutron_bgp_route_policy_unique_key unique (name);
--3.20.0.0.0250_END

--3.20.0.0.0280_BEGIN
select alter_columns('ADD', 'tab_dcn_neutron_taas_tapflow', 'sdn_tapservice_name', 'varchar(255)');

select alter_columns('ADD','TAB_DCN_NEUTRON_FIREWALL_POLICY','RULES','clob');
update TAB_DCN_NEUTRON_FIREWALL_POLICY set RULES = array_to_string(FIREWALL_RULES,',');
ALTER TABLE TAB_DCN_NEUTRON_FIREWALL_POLICY DROP COLUMN IF EXISTS FIREWALL_RULES;
--3.20.0.0.0280_END

select alter_columns('ADD', 'tab_dcn_neutron_bgp_route', 'IMPORT_POLICY', 'varchar(256)');
select alter_columns('ADD', 'tab_dcn_neutron_bgp_route', 'EXPORT_POLICY', 'varchar(256)');

CREATE OR REPLACE FUNCTION fill_bgp_policy_4_neutron() RETURNS INTEGER AS $body$
    begin
        DBMS_OUTPUT.PUT_LINE('begin to fill_bgp_policy_4_neutron');
		if exists (select 1 from tab_dcn_neutron_bgp_route where IMPORT_POLICY is null and EXPORT_POLICY is null) then
			if exists (select 1 from tab_dcn_gbp_bgp_config where route_policy_name is not null or import_route_policy_name is not null) then
				FOR l23_bgp in select id,route_policy_name,import_route_policy_name from tab_dcn_gbp_bgp_config where route_policy_name is not null or import_route_policy_name is not null LOOP 
					DBMS_OUTPUT.PUT_LINE('begin to fill_bgp_policy_4_neutron bgp id'||l23_bgp.id);
					update tab_dcn_neutron_bgp_route neutron_bgp set neutron_bgp.IMPORT_POLICY = l23_bgp.import_route_policy_name, neutron_bgp.EXPORT_POLICY = l23_bgp.route_policy_name where neutron_bgp.UUID = l23_bgp.id::UUID;
				END LOOP;
			end if;
		end if;
 RETURN 0;
END;
$body$ language plpgsql;
/
ALTER FUNCTION fill_bgp_policy_4_neutron() OWNER TO ossdbuser;
select fill_bgp_policy_4_neutron();
drop function if exists fill_bgp_policy_4_neutron;

select alter_columns('ADD', 'TAB_DCN_NEUTRON_EXROUTE', 'ECMP_ENABLE', 'boolean');
UPDATE TAB_DCN_NEUTRON_EXROUTE ex SET ex.ecmp_enable = (SELECT CASE WHEN lc.TYPE = 'Nfvi' THEN TRUE ELSE FALSE END ecmp FROM tab_dcn_gbp_logic_router lc WHERE lc.id = cast(ex.router_id as CHARACTER VARYING)) WHERE ex.ECMP_ENABLE is NULL;

CREATE OR REPLACE FUNCTION recorrect_subnet_ext_access_mode() RETURNS INTEGER AS $body$
declare
    subnet_cursor refcursor;
    subnet_id UUID;
    subnet_cidr CHARACTER VARYING(128);
    subnet_ext_acc_mode INTEGER;
begin
    DBMS_OUTPUT.PUT_LINE('[recorrect_subnet_ext_access_mode] start');
    open subnet_cursor for execute 'select subnet.id,subnet.cidr,subnet.external_access_mode from tab_dcn_neutron_subnet subnet
                                    inner join tab_dcn_neutron_network innernet on subnet.network_id = innernet.id and innernet.EXTERNAL = false
                                    inner join tab_dcn_neutron_fixed_ips fixip on fixip.ip_address = subnet.gateway_ip
                                    inner join tab_dcn_neutron_port port on port.uuid = fixip.port_id and port.device_owner = ''network:router_interface''
                                    inner join tab_dcn_neutron_interfaces itf on itf.port_id = port.uuid and itf.subnet_id = subnet.id
                                    inner join tab_dcn_neutron_router router on router.uuid = itf.router_id and router.enable_snat = ''false'' and router.external_network_id is NOT NULL
                                    inner join tab_dcn_neutron_network extnet on extnet.id = router.external_network_id
                                    inner join tab_dcn_sfco_ext_conn extconn on extconn.router_id = cast(router.uuid as NVARCHAR2) and extconn.external_network_name = extnet.name
                                    inner join tab_dcn_external_gateway extgw on cast(extgw.id as NVARCHAR2) = extconn.external_gateway_id and extgw.vrf_name is not null
                                    where (subnet.external_access_mode is null or subnet.external_access_mode != 0) 
                                        and not exists (select 1 from tab_dcn_fabric_service_staticroutedeploy staroute where staroute.ip_dest_address = subnet.cidr and staroute.vrf_name = extgw.vrf_name);';
	loop
		fetch subnet_cursor into subnet_id, subnet_cidr, subnet_ext_acc_mode;
		if subnet_cursor%found then
            DBMS_OUTPUT.PUT_LINE('[recorrect_subnet_ext_access_mode] subnet(' || subnet_id  || ') cidr is ' || subnet_cidr|| ', external_access_mode is ' || subnet_ext_acc_mode || ' has no ingress route, update external_access_mode to 0.');
            update tab_dcn_neutron_subnet set external_access_mode = 0 where id = subnet_id;
        end if;
        exit when subnet_cursor%notfound;
	end loop;
	close subnet_cursor;
    DBMS_OUTPUT.PUT_LINE('[recorrect_subnet_ext_access_mode] end');
    RETURN 0;
END;
$body$ language plpgsql;
/
ALTER FUNCTION recorrect_subnet_ext_access_mode() OWNER TO ossdbuser;
select recorrect_subnet_ext_access_mode();
drop function if exists recorrect_subnet_ext_access_mode;