--1.3.5000.300_BEGIN
create table IF NOT EXISTS public.TAB_BP_L2TOPO_NODE
(
    nodeId VARCHAR2(128) not null primary key,
    resourceId VARCHAR2(128),
    name VARCHAR2(255),
    description VARCHAR2(255),
    deviceModel VARCHAR2(128),
    deviceType VARCHAR2(128),
    location VARCHAR2(128),
    manageIp VARCHAR2(128),
    manageMac VARCHAR2(128),
    contact VARCHAR2(255),
	esn VARCHAR2(512),
    operateStatus VARCHAR2(128)
);
ALTER TABLE public.TAB_BP_L2TOPO_NODE OWNER TO ossdbuser;

DROP INDEX IF EXISTS public.idx_bp_l2topo_node_manageMac;
CREATE INDEX idx_bp_l2topo_node_manageMac ON  public.TAB_BP_L2TOPO_NODE(manageMac);

DROP INDEX IF EXISTS public.idx_bp_l2topo_node_resourceId;
CREATE INDEX idx_bp_l2topo_node_resourceId ON  public.TAB_BP_L2TOPO_NODE(resourceId);

CREATE TABLE IF NOT EXISTS public.linkentity
(
    id VARCHAR2(128) not null PRIMARY KEY,
    name VARCHAR2(255),
    direction VARCHAR2(32),
    operateStatus VARCHAR2(32),
    autoCreateFlag Boolean,
    linkType VARCHAR2(32),
    type VARCHAR2(32),
    durable Boolean,
    providerIdEntity jsonB,
    leftNodeId VARCHAR2(128),
    leftNodeName VARCHAR2(255),
    leftNodeIp VARCHAR2(128),
    leftLtpId VARCHAR2(36),
    leftLtpName VARCHAR2(64),
    leftLtpIp VARCHAR2(15),
    leftLtpIpv6List text,
    leftLtpMac VARCHAR2(32),
    leftEthtrunk VARCHAR2(32),
    rightNodeId VARCHAR2(128),
    rightNodeMac VARCHAR2(128),
    rightNodeName VARCHAR2(255),
    rightNodeIp VARCHAR2(128),
    rightLtpId VARCHAR2(36),
    rightLtpName VARCHAR2(64),
    rightLtpIp VARCHAR2(15),
    rightLtpIpv6List text,
    rightLtpMac VARCHAR2(32),
    rightEthtrunk VARCHAR2(32),
    description VARCHAR2(512),
    userlabel VARCHAR2(255),
    adminStatus VARCHAR2(32),
    layer2Bandwith bigint,
    providerNetwork VARCHAR2(255),
    deleteFlag Boolean,
    belongDomainAcIp VARCHAR2(128),
    producer VARCHAR2(128),
    localLsrId VARCHAR2(128),
    layerRate VARCHAR2(128),
    teAttributeEntitys jsonB,
    annotations jsonB,
    refNum integer default 0,
    updateType integer,
    createTime VARCHAR2(128),
    updateTime VARCHAR2(128),
    leftResourceId VARCHAR2(128),
    rightResourceId VARCHAR2(128),
    rightSysDescription VARCHAR2(512),
    rightSysCapSupported VARCHAR2(128),
    rightSysCapEnabled VARCHAR2(128)
);
DROP INDEX IF EXISTS  idx_bp_linkentity_leftNodeId;
DROP INDEX IF EXISTS  idx_bp_linkentity_leftLtpId;
DROP INDEX IF EXISTS  idx_bp_linkentity_rightNodeId;
DROP INDEX IF EXISTS  idx_bp_linkentity_rightNodeName;
DROP INDEX IF EXISTS  idx_bp_linkentity_rightLtpMac;
DROP INDEX IF EXISTS  idx_bp_linkentity_link_identify;
DROP INDEX IF EXISTS  idx_bp_linkentity_discovery_link;
CREATE INDEX idx_bp_linkentity_leftNodeId ON  public.linkentity(leftNodeId);
CREATE INDEX idx_bp_linkentity_leftLtpId ON  public.linkentity(leftLtpId);
CREATE INDEX idx_bp_linkentity_rightNodeId ON  public.linkentity(rightNodeId);
CREATE INDEX idx_bp_linkentity_rightNodeName ON  public.linkentity(rightNodeName);
CREATE INDEX idx_bp_linkentity_rightLtpMac ON  public.linkentity(rightLtpMac);
CREATE INDEX idx_bp_linkentity_link_identify ON public.linkentity using btree (leftNodeId, leftLtpId, rightNodeId, rightLtpId);
CREATE INDEX idx_bp_linkentity_discovery_link ON  public.linkentity(leftNodeId, operateStatus, autoCreateFlag);
ALTER TABLE public.linkentity OWNER TO ossdbuser;


create table IF NOT EXISTS public.TAB_BP_L2TOPO_CONFIG
(
	configName VARCHAR2(128) not null primary key,
	configValue VARCHAR2(512)
);
ALTER TABLE public.TAB_BP_L2TOPO_CONFIG OWNER TO ossdbuser;  


  
DROP FUNCTION IF EXISTS h_int;
CREATE OR REPLACE FUNCTION h_int(text) RETURNS int as $$
    select ('x'||substr(md5($1),1,8))::bit(32)::int;
$$ language sql;
/
ALTER FUNCTION h_int(text) OWNER TO ossdbuser;

 
DROP FUNCTION IF EXISTS bulk_insert_l2topo_node;
CREATE OR REPLACE FUNCTION bulk_insert_l2topo_node(_id text, _resourceId text, _name text, _description text, _deviceModel text, _deviceType text, _location text, _manageIp text, _manageMac text, _contact text, _operateStatus text, _esn text) RETURNS boolean as $$ 
    declare 
        num int;
        dbResult tab_bp_l2topo_node;
    begin
        PERFORM pg_advisory_xact_lock(h_int('l2topo' || _manageMac));
        select count(*) into num from tab_bp_l2topo_node t where t.nodeId = _id;
        if num > 0 then
            select * into dbResult from tab_bp_l2topo_node t where t.nodeId = _id;
            if dbResult.deviceType != 'EDGE' then
                if dbResult.deviceType != 'HOST' then   
                    return true;
                end if;
            end if;
            
            update tab_bp_l2topo_node t set t.resourceId=_resourceId,t.name=_name,t.description=_description,t.deviceModel=_deviceModel,t.deviceType=_deviceType,t.location=_location,t.manageIp=_manageIp,t.manageMac=_manageMac,t.contact=_contact,t.esn=_esn,t.operateStatus=_operateStatus where t.nodeId = _id;
            if _operateStatus is not null then         
                update tab_bp_l2topo_node_status t set t.OPERATESTATUS=_operateStatus where t.nodeId = _id;
            end if;
        else
            insert into tab_bp_l2topo_node(NODEID, RESOURCEID, NAME, DESCRIPTION, DEVICEMODEL, DEVICETYPE, LOCATION, MANAGEIP, MANAGEMAC, CONTACT, ESN, OPERATESTATUS) values (_id, _resourceId, _name, _description, _deviceModel, _deviceType, _location, _manageIp, _manageMac, _contact, _esn, _operateStatus);
        end if;     
        return true;
        exception when others then
        return false;       
    end
$$ language plpgsql strict;
/
ALTER FUNCTION bulk_insert_l2topo_node(text,text,text,text,text,text,text,text,text,text,text,text) OWNER TO ossdbuser;

DROP FUNCTION IF EXISTS set_ne_mac_lock;
CREATE OR REPLACE FUNCTION set_ne_mac_lock(mac text) RETURNS boolean as $$ 
    begin
        PERFORM pg_advisory_xact_lock(h_int('l2topo' || mac));
        return true;
        exception when others then
        return false;   
    end 
$$ language plpgsql strict;
/
ALTER FUNCTION set_ne_mac_lock(text) OWNER TO ossdbuser;

CREATE TABLE IF NOT EXISTS public.lldptaskentity
(
  jsdoc jsonb
);
ALTER TABLE public.lldptaskentity OWNER TO ossdbuser;
DROP INDEX IF EXISTS  lldptaskentity_id;
CREATE UNIQUE INDEX lldptaskentity_id ON public.lldptaskentity ((jsdoc->>'_id'));
ALTER TABLE public.lldptaskentity DROP CONSTRAINT IF EXISTS lldptaskentity_id_not_null;
ALTER TABLE public.lldptaskentity ADD CONSTRAINT lldptaskentity_id_not_null CHECK ((jsdoc->>'_id') IS NOT NULL);

CREATE TABLE IF NOT EXISTS public.devicelockentity
(
  jsdoc jsonb
);
ALTER TABLE public.devicelockentity OWNER TO ossdbuser;
DROP INDEX IF EXISTS devicelockentity_id;
CREATE UNIQUE INDEX devicelockentity_id ON public.devicelockentity ((jsdoc->>'_id'));
ALTER TABLE public.devicelockentity DROP CONSTRAINT IF EXISTS devicelockentity_id_not_null;
ALTER TABLE public.devicelockentity ADD CONSTRAINT devicelockentity_id_not_null CHECK ((jsdoc->>'_id') IS NOT NULL);

--1.3.5000.300_END

--1.3.5100.013_BEGIN
ALTER TABLE TAB_BP_L2TOPO_NODE modify description VARCHAR2(512);
ALTER TABLE TAB_BP_L2TOPO_NODE modify location VARCHAR2(512);
ALTER TABLE TAB_BP_L2TOPO_NODE modify contact VARCHAR2(512);
ALTER TABLE linkentity modify name VARCHAR2(640);
--1.3.5100.013_END

--1.19.6000.260_BEGIN
--1.19.6000.260_END

--1.19.6000.301_BEGIN
BEGIN
	IF (select count(column_name) from information_schema.columns where table_name='LINKENTITY' and column_name='REMCHASSISIDSUBTYPE') = 0 THEN
        ALTER TABLE LINKENTITY ADD column REMCHASSISIDSUBTYPE VARCHAR2(32);
    END IF;
	
	IF (select count(column_name) from information_schema.columns where table_name='LINKENTITY' and column_name='REMCHASSISID') = 0 THEN
        ALTER TABLE LINKENTITY ADD column REMCHASSISID VARCHAR2(128);
    END IF;
	
	IF (select count(column_name) from information_schema.columns where table_name='LINKENTITY' and column_name='REMPORTIDSUBTYPE') = 0 THEN
        ALTER TABLE LINKENTITY ADD column REMPORTIDSUBTYPE VARCHAR2(128);
    END IF;
	
	IF (select count(column_name) from information_schema.columns where table_name='LINKENTITY' and column_name='REMPORTID') = 0 THEN
        ALTER TABLE LINKENTITY ADD column REMPORTID VARCHAR2(36);
    END IF;
END;
/
--1.19.6000.301_END

--1.19.6000.307_BEGIN
DROP FUNCTION IF EXISTS bulk_insert_l2topo_node;
CREATE OR REPLACE FUNCTION bulk_insert_l2topo_node(_id text, _resourceId text, _name text, _description text, _deviceModel text, _deviceType text, _location text, _manageIp text, _manageMac text, _contact text, _operateStatus text, _esn text) RETURNS boolean as $$ 
    declare 
        num int;
    begin
        PERFORM pg_advisory_xact_lock(h_int('l2topo' || _manageMac));
        select count(*) into num from tab_bp_l2topo_node t where t.nodeId = _id;
        if num > 0 then
            update tab_bp_l2topo_node t set t.resourceId=_resourceId,t.name=_name,t.description=_description,t.deviceModel=_deviceModel,t.deviceType=_deviceType,t.location=_location,t.manageIp=_manageIp,t.manageMac=_manageMac,t.contact=_contact,t.esn=_esn,t.operateStatus=_operateStatus where t.nodeId = _id;
        else
            insert into tab_bp_l2topo_node(NODEID, RESOURCEID, NAME, DESCRIPTION, DEVICEMODEL, DEVICETYPE, LOCATION, MANAGEIP, MANAGEMAC, CONTACT, ESN, OPERATESTATUS) values (_id, _resourceId, _name, _description, _deviceModel, _deviceType, _location, _manageIp, _manageMac, _contact, _esn, _operateStatus);
        end if;     
        return true;
        exception when others then
        return false;       
    end
$$ language plpgsql strict;
/
ALTER FUNCTION bulk_insert_l2topo_node(text,text,text,text,text,text,text,text,text,text,text,text) 
OWNER TO ossdbuser;
--1.19.6000.307_END

--1.19.6100.030_BEGIN
ALTER TABLE LINKENTITY ADD COLUMN SPREADFIELD text;
ALTER TABLE LINKENTITY ADD COLUMN EXTENDEDFIELD text;
UPDATE LINKENTITY SET EXTENDEDFIELD = SPREADFIELD;

--- 3.21.0.0_BEGIN
update linkentity set RIGHTLTPNAME=UPPER(RIGHTLTPNAME) where LINKTYPE = 'EDGE' and  RIGHTLTPNAME like '%:%';
update linkentity set RIGHTLTPNAME=replace(RIGHTLTPNAME, ':','-') where LINKTYPE = 'EDGE';
update linkentity set name=  (leftNodeName || '_' || leftLtpName || '--' || rightNodeName || '_' || rightLtpName) where LINKTYPE = 'EDGE';
--- 3.21.0.0_END

/*
 * Copyright (c) Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.
 */

--1.19.6100.030_END

--1.19.8000.001000_BEGIN
create table IF NOT EXISTS public.TAB_BP_L2TOPO_LINK_REFERENCE
(
    id VARCHAR2(512) not null primary key,
    linkId VARCHAR2(128),
    appName VARCHAR2(64),
    serviceId VARCHAR2(256),
    leftResourceId VARCHAR2(128),
    leftLtpName VARCHAR2(64),
    rightResourceId VARCHAR2(128),
    rightLtpName VARCHAR2(64),
    ts VARCHAR2(128)
);
ALTER TABLE public.TAB_BP_L2TOPO_LINK_REFERENCE OWNER TO ossdbuser;  
DROP INDEX IF EXISTS public.idx_bp_l2topo_link_reference_linkid;
CREATE INDEX idx_bp_l2topo_link_reference_linkid ON public.TAB_BP_L2TOPO_LINK_REFERENCE(linkId);
DROP INDEX IF EXISTS public.idx_bp_l2topo_link_reference_link_identify;
CREATE INDEX idx_bp_l2topo_link_reference_link_identify ON public.TAB_BP_L2TOPO_LINK_REFERENCE using btree (leftResourceId, leftLtpName, rightResourceId, rightLtpName);
--1.19.8000.001000_END