#!/bin/bash
CUR_PATH=$(cd "$(dirname "$0")"; pwd)
if [ -f "/opt/oss/manager/var/tenants/NCECOMMONE/containerlist.json" ]
then
    export TENANTS_ROOT=/opt/oss/manager/var/tenants/NCECOMMONE
else
    export TENANTS_ROOT=/opt/oss/manager/var/tenants/NCE
fi
export OSS_ROOT=/opt/oss/manager
export APP_NAME=SnbCertMmgtService

export _APP_LOG_DIR=$CUR_PATH/logs
if [ ! -d $_APP_LOG_DIR ]
then
    mkdir -p $_APP_LOG_DIR
    chmod 755 $_APP_LOG_DIR
fi

if [ ! -f $_APP_LOG_DIR/migrate_tool.log ]
then
    touch $_APP_LOG_DIR/migrate_tool.log
else
    echo >> $_APP_LOG_DIR/migrate_tool.log #增加一个分割空行
fi

CURTIME=`date '+%Y-%m-%d %H:%M:%S'`
echo "$CURTIME migrate common certs begin" | tee -a $_APP_LOG_DIR/migrate_tool.log
sh $CUR_PATH/migrate_common.sh
result=$?

unset TENANTS_ROOT
unset OSS_ROOT
unset APP_NAME

CURTIME=`date '+%Y-%m-%d %H:%M:%S'`
if [ $result -eq 0 ]
then
    echo "$CURTIME migrate common certs successfully." | tee -a $_APP_LOG_DIR/migrate_tool.log
else
    echo "$CURTIME migrate common certs exec failed,Please see the migrate_tool.log" | tee -a $_APP_LOG_DIR/migrate_tool.log
    exit 1
fi
unset _APP_LOG_DIR



