#!/bin/bash

CUR_PATH=$(cd "$(dirname "$0")"; pwd)
export APP_NAME=SnbCertMmgtService
export _APP_LOG_DIR=$CUR_PATH/logs

script_name=`basename $0`

SQL_USER_NAME=ossdbuser

migrate_log()
{
    local content=$*
    
    log_filename="$_APP_LOG_DIR/migrate_tool.log"
    
    CURTIME=`date '+%Y-%m-%d %H:%M:%S'`
    echo "$CURTIME $$ $script_name : $content" | tee -a $log_filename
}

get_dbip_port2() {
    dbinfo=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance -type zenith|grep -E "$1"|grep Master`

    if [ -z "$dbinfo" ]
    then
        migrate_log "$LINENO single db instance"
        dbinfo=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance -type zenith|grep -E "$1"`
        MACHINE_IP=`echo $dbinfo|awk '{print $6}'`
        port=`echo $dbinfo|awk '{print $7}'`
    else
        MACHINE_IP=`echo $dbinfo|awk '{print $6}'`
        port=`echo $dbinfo|awk '{print $7}'`
    fi
}


main(){
    #2. 数据备份路径
    SNB_TMP_DIR=/home/dbuser/migrate_r20c10_to_r21c00
    if [ -d $SNB_TMP_DIR ]
    then 
        rm -rf $SNB_TMP_DIR/*
    fi
    sudo -s -u dbuser<<EOF
        SNB_TMP_DIR=/home/dbuser/migrate_r20c10_to_r21c00
        if [ -d $SNB_TMP_DIR ]
        then
            rm -r $SNB_TMP_DIR
        fi
        mkdir -p $SNB_TMP_DIR
        echo "create SNB_TMP_DIR success"
        chmod 777 $SNB_TMP_DIR
EOF
    cp -rf $CUR_PATH/sql_increment $SNB_TMP_DIR
    #3. 连接数据库迁移
    #数据库实例对应关系
    instance_str=DCNService_dcnnwpersistentdb_dcnnwcommondb
    ins_map_array=(${instance_str//,/ })
    for ins_map_str in ${ins_map_array[@]}
    do
        ins_arr=(${ins_map_str//_/ })
        service_name=${ins_arr[0]}
        instance_sql_dir=${ins_arr[1]}
        instance_name=${ins_arr[2]}
        if [ "$instance_sql_dir" = "dcnsfcpersistentdb" ] ;then
          instance_sql_dir="dcnnwpersistentdb"
        fi
        tmp_inst_dir=" ${SNB_TMP_DIR}/sql_increment/${service_name}/${instance_sql_dir}"
        
        # 检测order.txt是否存在
        if [ ! -f "${CUR_PATH}/sql_increment/${service_name}/${instance_sql_dir}/order.txt" ]
        then
            echo "filename ${tmp_inst_dir}/order.txt do not exist"
            exit 1
        fi

        echo "start ${instance_sql_dir}"
        sudo -s -u dbuser cat ${tmp_inst_dir}/order.txt | while read line || [ -n "${line}" ]
        do  
            if [ -f "${tmp_inst_dir}/${line}" ]
            #这个日志别删
            echo "${tmp_inst_dir}/${line}"
            then
                # 获取数据库ip、port
                get_dbip_port2 ${instance_name} ${instance_sql_dir}
                # 获取数据库密码

                # get_db_info
                db_info=`. /opt/oss/manager/agent/bin/engr_profile.sh;python -c "import sys;sys.path.append('${CUR_PATH}/../../pyscripts/');import get_db_pass;pec=get_db_pass.epc;fmt='';pec1=pec.getLogger('db_info');pec_s=pec.StreamHandler();pec_s.setFormatter(fmt);pec1.addHandler(pec_s);pec1.critical(get_db_pass.main('${instance_name}', '${instance_sql_dir}', 'zenith'))" 2>&1`
                result=$?
                if [[ "${result}" == "0" ]]
                then
                    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get db_info successfully."
                    result_array=(${db_info//,/ })
                    adminPP=${result_array[2]}
                else
                    echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get db_info failed."
                    exit 1
                fi

                if [ -z "$adminPP" ]
                then
                    migrate_log "$LINENO $instance_sql_dir acquire DB passwd failed,exit"
                    exit 1
                else
                    migrate_log "$LINENO $instance_sql_dir acquire DB passwd success "
                fi
                echo "find ${instance_name} ${MACHINE_IP} DB port: $port"
                sudo -s -u dbuser<<EOF
				source /home/dbuser/.bashrc
                cd  /opt/zenith/app/bin
                ./zsql ${instance_sql_dir}/${adminPP}@${MACHINE_IP}:${port} -f ${tmp_inst_dir}/${line}  
EOF
                result=$?
                if [ $result -ne 0 ] ; then
                    echo "sqlfile exec fail, sourceDBInstance=${instance_sql_dir}, sql_file_path=${line}"
                    exit 1
                fi
            fi
        done
        result=$?
        if [ $result -ne 0 ] ; then
            exit 1
        fi
    done
    #5. 后置处理：清理中间文件等
    rm -rf $SNB_TMP_DIR/sql_increment
    sudo -u dbuser rm -rf $SNB_TMP_DIR
    migrate_log "$LINENO migrate service success and end"
}

main

