#!/bin/bash
CUR_PATH=$(cd "$(dirname "$0")"; pwd)
_APP_LOG_DIR=$CUR_PATH/rollback_bgp.log

script_name=`basename $0`

SQL_USER_NAME=ossdbuser
source_db_name=ncecommondb
source_db_instance_name=authadmindb

if [ -f "/opt/oss/manager/var/tenants/NCECOMMONE/containerlist.json" ]
then
    export TENANTS_ROOT=/opt/oss/manager/var/tenants/NCECOMMONE
else
    export TENANTS_ROOT=/opt/oss/manager/var/tenants/NCE
fi

migrate_log()
{
    local content=$*
    
    log_filename="$_APP_LOG_DIR"
    touch $_APP_LOG_DIR
    CURTIME=`date '+%Y-%m-%d %H:%M:%S'`
    echo "$CURTIME $$ $script_name : $content" | tee -a $log_filename
}


get_dbip_port() {
    #IP查询：先按照master的去过滤，如果没有则去掉master过滤条件，再查一遍
    dbinfo=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance -type gauss|grep -E "ncecommondb"|grep Master`

    if [ -z "$dbinfo" ]
    then
        migrate_log "$LINENO single db instance"
        dbinfo=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance -type gauss|grep -E "ncecommondb"`
        MACHINE_IP=`echo $dbinfo|awk '{print $6}'`
        port=`echo $dbinfo|awk '{print $7}'`
        db_master_name=`echo $dbinfo|awk '{print $3}'`
        db_slave_name=''
    else
        MACHINE_IP=`echo $dbinfo|awk '{print $6}'`
        port=`echo $dbinfo|awk '{print $7}'`
        db_master_name=`echo $dbinfo|awk '{print $3}'`
        db_slave_name=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance -type gauss|grep -E "ncecommondb"|grep Slave|awk '{print $3}'`
    fi
}


function main()
{
    echo $TENANTS_ROOT
    ###回退处理BGP权限点的问题
    #1.获取数据库的ip和port
    get_dbip_port
    migrate_log "$LINENO DB:$db_master_name ip: $MACHINE_IP status:$?"
    migrate_log "$LINENO DB port: $port"
    
    #2. 获取数据库密码
    db_info=`. /opt/oss/manager/agent/bin/engr_profile.sh;python -c "import sys;sys.path.append('${CUR_PATH}/../../pyscripts/');import get_db_pass;pec=get_db_pass.epc;fmt='';pec1=pec.getLogger('db_info');pec_s=pec.StreamHandler();pec_s.setFormatter(fmt);pec1.addHandler(pec_s);pec1.critical(get_db_pass.main('${source_db_name}', '${source_db_instance_name}', 'gauss'))" 2>&1`
    result=$?
    if [[ "${result}" == "0" ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get db_info successfully."
        result_array=(${db_info//,/ })
        adminPP=${result_array[2]}
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get db_info failed."
        exit 1
    fi
    if [ -z "$adminPP" ]
    then
        migrate_log "$LINENO acquire DB passwd failed,exit"
        exit 1
    else
        migrate_log "$LINENO acquire DB passwd success"
    fi
    #3.拷贝sql
    SNB_TMP_DIR=/home/dbuser/post_bgp_auth
    if [ -d $SNB_TMP_DIR ]
    then 
        rm -rf $SNB_TMP_DIR/*
    fi
    sudo -s -u dbuser<<EOF
        SNB_TMP_DIR=/home/dbuser/post_bgp_auth
        if [ -d $SNB_TMP_DIR ]
        then
            rm -r $SNB_TMP_DIR
        fi
        mkdir -p $SNB_TMP_DIR
        echo "create SNB_TMP_DIR success"
        chmod 777 $SNB_TMP_DIR
EOF
    cp $CUR_PATH/authadmindb.sql $SNB_TMP_DIR
    cp $CUR_PATH/authadmindb_del_bgp.sql $SNB_TMP_DIR
    #4. 执行sql脚本
    #判断是否为BGP场景
    if [ -f $CUR_PATH/bgp_ip.txt ]
    then
        rm -rf $CUR_PATH/bgp_ip.txt
    fi
    /opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global | grep BgpService >> bgp_ip.txt
    if [ ! -s bgp_ip.txt ]
    then
        echo "no bgp environment"
        sudo -s -u dbuser<<EOF
        source /home/dbuser/appgsdb.bashrc
        cd /home/dbuser/
        gsql -d ${source_db_instance_name} -p ${port} -U ${SQL_USER_NAME} -h ${MACHINE_IP} -W ${adminPP} -f $SNB_TMP_DIR/authadmindb_del_bgp.sql
EOF
    else
        echo "bgp environment"
        sudo -s -u dbuser<<EOF
        source /home/dbuser/appgsdb.bashrc
        cd /home/dbuser/
        gsql -d ${source_db_instance_name} -p ${port} -U ${SQL_USER_NAME} -h ${MACHINE_IP} -W ${adminPP} -f $SNB_TMP_DIR/authadmindb.sql
EOF
    fi
   
    #5. 后置处理：清理中间文件等
    rm -rf $SNB_TMP_DIR/authadmindb.sql
    rm -rf $SNB_TMP_DIR/authadmindb_del_bgp.sql
    sudo -u dbuser rm -rf $SNB_TMP_DIR
    migrate_log "$LINENO migrate authservice success and end"
}
main $@