#!/bin/bash
SCRIPT_PATH=$0
IPMC_USER=$(stat -c '%U' "${SCRIPT_PATH}")
CURRENT_USER=$(/usr/bin/id -u -n)
if [ "${IPMC_USER}" != "${CURRENT_USER}" ];then
    echo "[Warn] only ${IPMC_USER} can execute this script."
    exit 1
fi

# check whether AppController version in [22.10.X, 22.10.583]
cd /opt/oss/manager/apps/AppController/
fileName=`ls | grep AppController*unzipflag.txt`
cd - >/dev/null 2>&1
fileName=${fileName#AppController-}
fileName=${fileName%_unzipflag.txt}
echo "[Info] verison is ${fileName}."
preVersion=${fileName%.*}
lastVersion=${fileName##*.}
if [[ ${preVersion} != "22.10" ]];then
    echo "[Info] not target verison, nothing to do."
    exit 0
fi
if [[ ${lastVersion} -gt 583 ]];then
    echo "[Info] not target verison, nothing to do."
    exit 0
fi
echo "[Info] target verison to patch."

# check hiro num
hiroNum=`cat /opt/oss/manager/apps/MCHIROIRService/etc/sysconf/nodelist.json |grep IPAddresses |wc -l`
if [[ ${hiroNum} -lt 3 ]];then
    echo "[Info] hiro less then 3, nothing to do."
    exit 0
fi
echo "[Info] hiro number is 3, need patch."

# check patch exist or not
ret=`grep 'request.spec.expectedState === "activated"' /opt/oss/manager/apps/AppController/download/configurator/defaultRuntime_configurator/DefaultRuntime.js`
if [[ -n ${ret} ]];then
    echo "[Info] patch already exist, nothing to do."
    exit 0
fi

# check target file
ret=`cat -n /opt/oss/manager/apps/AppController/download/configurator/defaultRuntime_configurator/DefaultRuntime.js | sed -n '132p' |grep 'configHolder.internalConfigServiceMap.get(request.metadata.name)'`
if [[ -z ${ret} ]];then
    echo "[Info] not target file to patch."
    exit 0
fi

# start patch
sed -i '132 i\ \tif (request.spec.expectedState === "activated") {' /opt/oss/manager/apps/AppController/download/configurator/defaultRuntime_configurator/DefaultRuntime.js
sed -i '142 i\ \t}' /opt/oss/manager/apps/AppController/download/configurator/defaultRuntime_configurator/DefaultRuntime.js
echo "[Info] end patch."

echo "[Info] restart AppController."
/opt/oss/manager/agent/bin/ipmc_adm -cmd restartapp -app AppController -tenant manager 

exit 0





