#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
DB_TYPE="zenith"
scripts_path="/opt/oss/easysuite/easysuite/easysuite/plugins/iMasterNCE-Fabric/upgrade_online"
self_name="${0##*/}"
log_dir=`sh ${EXEC_HOME}/get_log_dir.sh`
log_file=${log_dir}/${self_name}.log
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}

function main()
{

    # 压缩包的目录删除掉
    DES_DIR=/opt/oss/easysuite/easysuite/var/temp/iMasterNCE-Fabric_zip_dir
    if [[ -d ${DES_DIR} ]]
    then
        rm -rf ${DES_DIR}
    fi

    # 重命名日志下的record
    . /opt/oss/manager/bin/engr_profile.sh
    log_dir=$(${PYTHONHOME}/bin/python -c "import os;print(os.path.split('${log_file}')[0])")
    record_log_dir=${log_dir}/record
    if [[ -d ${record_log_dir} ]]
    then
        now_time=$(date '+%Y%m%d%H%M%S')
        mv ${record_log_dir} ${record_log_dir}_${now_time}
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "the dir record has been renamed to ${record_log_dir}_${now_time}" >> ${log_file}
    fi

    if [[ -d /opt/oss/NCECOMMONE/apps ]]
    then
        tenant_name=NCECOMMONE
    else
        tenant_name=NCE
    fi
    result=$?
    if [[ "${result}" == "0" ]]
        then
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get tenant name successfully: ${tenant_name}"  >> ${log_file}
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get tenant name failed: ${tenant_name}" >> ${log_file}
            exit 1
    fi

    upgrade_path=$(${PYTHONHOME}/bin/python ${EXEC_HOME}/pyscripts/get_upgrade_path.py ${2})
    result=$?
    if [[ "${result}" == "0" ]]
        then
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get upgrade path successfully: ${upgrade_path}" >> ${log_file}
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get upgrade path failed: ${upgrade_path}" >> ${log_file}
            exit 1
    fi

    # 调用python，执行具体步骤
    cd ${EXEC_HOME}
    py_result=$(. /opt/oss/manager/agent/bin/engr_profile.sh;python -c "import read_config;print(read_config.main('${upgrade_path}', '${tenant_name}', '${log_file}', 'pre_custom'))")
    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "the result is:"  >> ${log_file}
    echo "$py_result"  >> ${log_file}
    echo "$py_result" 1>&2
    # 处理结果
    result_code=$(. /opt/oss/manager/agent/bin/engr_profile.sh;python ${EXEC_HOME}/pyscripts/get_result_code.py "$py_result")
    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "the result_code is: ${result_code}"  >> ${log_file}
    if [[ ${result_code} == "0" ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "${self_name} has been executed successfully."  >> ${log_file}
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "${self_name} has been executed failed."  >> ${log_file}
        exit 1
    fi


}

main $@
