# coding=utf-8
'''
bgp peer update tcphold
'''
import sys
import json
from utils import set_log
from utils import utils

LOG = set_log.set_log(stream=True)
SUCCESS = 0
REQ_FAILED = 1



def main():
    '''
    主函数
    :return:
    '''
    _ip = utils.get_local_ip()
    url = "/rest/bgp/v1/peers"
    result, response_content = utils.send_rest(_ip, 32018, url, mode="GET",
                                    log=LOG, sleep=6, retry_times=30, content="get bgp peers")
    if result == SUCCESS:
        response_content.decode(encoding='utf-8')
        str_content = json.loads(response_content)
        if len(str_content['bgpPeer']) == 0:
            return result
        for peer in str_content['bgpPeer']:
            peer['tcpHold'] = True
        result, _ = utils.send_rest(_ip, 32018, url, mode="POST", log=LOG,
                                    body=str_content, sleep=6, retry_times=30,
                                    content="update bgp peer tcphold")
    return result


sys.exit(main())
