'''
create_container_list.py
'''

import json


def main(containerlist_file, containerlist_file2, instance_names, db_type):
    '''
    :param containerlist_file:
    :param containerlist_file2:
    :param instance_names:
    :param db_type:
    :return:
    '''
    with open(containerlist_file, "rb") as _f:
        db_info = json.load(_f)

    # instance_name 和 instance_name_id的对应关系
    instance_primary_dict = {}
    instance_slave_dict = {}
    for instance_name_id in db_info:
        if db_info[instance_name_id]["containerType"] == db_type:
            if "dbList" in db_info[instance_name_id]:
                # 主实例
                instance_primary_dict[instance_name_id.split("-")[0].lower()] = instance_name_id
            else:
                # 备实例
                instance_slave_dict[instance_name_id.split("-")[0].lower()] = instance_name_id

    # 将被合并实例下的db_list，加入目标实例
    for instance_name_old in instance_names.split(","):
        instance_name_old = instance_name_old.strip()
        if instance_name_old == "ncelocaldb":
            instance_name = "dcnnwlocaldb"
        else:
            instance_name = "dcnnwcommondb"
        # instance_slave_dict单节点时为空
        if instance_slave_dict:
            del db_info[instance_slave_dict[instance_name_old]]
        instance_primary_info = db_info.pop(instance_primary_dict[instance_name_old])
        for db_name, db_name_info in instance_primary_info["dbList"].items():
            if db_name not in db_info[instance_primary_dict[instance_name]]["dbList"]:
                db_info[instance_primary_dict[instance_name]]["dbList"][db_name] = db_name_info

    with open(containerlist_file2, "w") as _f2:
        json.dump(db_info, _f2, indent="\t")





