# coding=utf-8
'''
export_containerlist.py
'''
import sys
import json
from util import common, httpclient

def main():
    '''
    main
    :return:
    '''
    product_name = sys.argv[1]
    out = sys.argv[2]

    for _ in range(5):
        client = httpclient.CommonHttpClient(
            common.getLocalIP(), common.getMgmtIRPort(), True, False)
        result = client.post(
            '/rest/plat/dbmgr/v1/main/instances/action?action-id=export-containerlist',
            {'tenant': product_name}
        )

        if result[0] == 200:
            response_json = json.loads(result[1])
            json_string = json.dumps(response_json, indent=4, separators=(',', ': '))
            f_w = open(out, 'w')
            f_w.write(json_string)
            f_w.close()
            return 0
    return 1

sys.exit(main())
