'''
get_cluster_id.py
'''
import os
import subprocess
import datetime
import re
from utils import set_log
from utils import common_method

my_log = set_log.set_log(stream=True)
temporary_path = common_method.get_temporary_path()


def get_error_info():
    '''
    :return:
    '''
    command = 'zgrep -h "The broker is trying to join the wrong cluster" /opt/oss/log/manager/SMPMQService/kafka-logs/server* | grep "Cluster ID" '
    my_log.info(command)
    status, result = subprocess.getstatusoutput(command)
    if status != 0:
        my_log.error("status is %s, result is %s", status, result)
        return None
    return result


def get_mc_restart_time():
    '''
    获取 MCZKService 服务的重启时间
    :return:
    '''
    file_name = os.path.join(temporary_path, "MCZKService_restart_time.txt")
    restart_time = ""
    if os.path.exists(file_name):
        with open(file_name, "r") as f:
            restart_time = f.read().strip()
    return restart_time


def get_need_cluster_id(error_info, restart_time):
    '''
    获取大于 MCZKService重启时间，且是最近时间的报错信息
    :param get_mc_restart_time:
    :param get_error_info:
    :return:
    '''
    cluster_id = ""
    last_error_time = datetime.datetime.strptime("1970-01-01 00:00:00", "%Y-%m-%d %H:%M:%S")
    restart_time_format = datetime.datetime.strptime(restart_time, "%Y-%m-%d %H:%M:%S")
    for error_line in error_info.split("\n"):
        error_time = datetime.datetime.strptime(error_line.split(",")[0], "%Y-%m-%d %H:%M:%S")
        if error_time >= restart_time_format and error_time >= last_error_time:
            last_error_time = error_time
            cluster_id = re.search(r"The Cluster ID (.*?) doesn", error_line).group(1).strip()
    return cluster_id


def main():
    # 获取错误信息
    error_info = get_error_info()
    if error_info is None:
        return ""
    elif error_info == "":
        my_log.info("can not match the string in server*.log, skip")
        return ""

    # 获取MCZKService重启时间
    restart_time = get_mc_restart_time()
    if not restart_time:
        my_log.info("can not find the file MCZKService_restart_time.txt")
        return ""
    my_log.info("restart_time is: %s", restart_time)

    # 获取cluster_id
    cluster_id = get_need_cluster_id(error_info, restart_time)
    if not cluster_id:
        my_log.info("can not find the cluster_id")
        raise ValueError

    return cluster_id







