# coding=utf-8 （coding=utf-8告诉Python解释器要按照utf-8编码的方式读取程序，如果不加这个声明，无论代码中还是注释中有中文都会报错）
'''
get_db_pass.py
'''

from __future__ import print_function
import logging as epc
import json
import os
from utils import set_log
from utils import utils
from util import ossext

LOG = set_log.set_log(stream=False)
SUCCESS = 0
REQ_FAILED = 1


def get_db_json(product_type="NCE"):
    '''
    主函数
    :return:
    '''
    if product_type == "NCE":
        if os.path.exists('/opt/oss/manager/var/tenants/NCECOMMONE'):
            product_name = 'NCECOMMONE'
        else:
            product_name = 'NCE'
    else:
        product_name = 'manager'
    input_param = {'tenant': product_name}
    _ip = utils.get_local_ip()
    port = utils.get_gmt_port()
    url = "/rest/plat/dbmgr/v1/main/instances/action?action-id=export-containerlist"
    result, ret = utils.send_rest(_ip, port, url, mode="POST",
                                log=LOG, body=input_param, sleep=3, retry_times=3,
                                content="get_db_json")
    return ret


def is_contain_db(dbinstance_name, db_name, db_type, product_type="NCE"):
    '''
    是否包含数据库
    :param dbinstance_name:
    :param db_name:
    :param db_type:
    :param product_type:
    :return:
    '''
    is_contain_db = "false"
    db_name = db_name.lower()
    db_info = json.loads(get_db_json(product_type))
    keys = list(db_info.keys())  # KEYS是个List
    for key in keys:
        if dbinstance_name in key and "dbList" in db_info[key] \
                and db_info[key]["containerType"] == db_type:
            if db_name in db_info[key]['dbList'] or db_name.upper() in db_info[key]['dbList']:
                is_contain_db = "true"
                break
    return is_contain_db


def main(dbinstance_name, db_name, db_type, product_type="NCE"):
    '''
    get db_info
    :return:
    '''
    db_name = db_name.lower()

    db_info = json.loads(get_db_json(product_type))
    keys = list(db_info.keys())  # KEYS是个List
    for key in keys:
        if dbinstance_name in key and "dbList" in db_info[key] \
                and db_info[key]["containerType"] == db_type:
            ip = db_info[key]["ip"]
            port = db_info[key]["port"]
            admin_pptmp = db_info[key]['dbList'][db_name]['dbUserPasswd']
            adminpp = ossext.Cipher.decrypt(admin_pptmp)
            break
    return "%s,%s,%s" % (ip, port, adminpp)


def main_sys(dbinstance_name, db_type):
    '''
    get db_info
    :return:
    '''
    db_info = json.loads(get_db_json())
    keys = list(db_info.keys())  # KEYS是个List
    for key in keys:
        if dbinstance_name in key and "dbList" in db_info[key] \
                and db_info[key]["containerType"] == db_type:
            admin_user = db_info[key]["adminUser"]
            admin_pptmp = db_info[key]["adminPassword"]
            adminpp = ossext.Cipher.decrypt(admin_pptmp)
            return "%s,%s" % (admin_user, adminpp)

