'''
IR_entlinkmgmt.py
'''
import json
import math
import sys
import time
import datetime
from utils import set_log
from utils import utils

SUCCESS = 0
REQ_FAILED = 1
REQ_NONE = 2
REQ_EXCEPTION = 3
REQ_NODEPLOY = 4
REQ_EMPTY = 5
LOG = set_log.set_log(stream=True)
LOG_FILE = set_log.set_log(stream=False, name="file_name")
LINK_IR = '/restconf/operations/huawei-ac-unisouth-l2topo:batch-query-l2topo-links'
_IP = utils.get_local_ip()


def getdcnsdata(page_size):
    '''
    get common link data
    '''
    input_param = {
        "input": {
            "query-l2topo-link": {
                "query-field-maps": [],
                "start": "1", "limit": "100"
            }
        }
    }
    links = input_param['input']['query-l2topo-link']
    links['start'] = page_size
    limit = int(links['limit'])
    result, response_content = utils.send_rest(_IP, 32018, LINK_IR, mode="POST", log=LOG,
                                               body=input_param, sleep=6, retry_times=30,
                                               content="IR_entlinkmgmt")
    if result == SUCCESS:
        str_content = response_content.decode(encoding='utf-8')
        data = json.loads(str_content)
        output = data['huawei-ac-unisouth-l2topo:output']
        LOG_FILE.info("dcnlink: %s", output)
        total = output['total']
        if total == 0:
            return [REQ_EMPTY]
        total_page_size = 1
        if page_size == 1 and total > limit:
            total_page_size = math.ceil(total / limit)
        LOG.info(
            "Successful query l2topo links,total: %s,pageSize:%s",
            total, page_size)
        return [SUCCESS, output, total_page_size]
    else:
        LOG.error("Failed to call the dcn interface")
        return [REQ_FAILED]


def dcndata2esight(output):
    ''' data change common to esight'''
    l2topo_link_oper = output['l2topo-links-oper']
    l2topo_links = l2topo_link_oper['l2topo-links-info']
    link_list = l2topo_links['l2topo-link-info']
    rest_param = paramstransfer(link_list)
    return rest_param


def timeformat(time_str):
    '''timeformat funtion'''
    date_time = datetime.datetime.strptime(time_str, "%Y-%m-%dT%H:%M:%S.%f%z")
    timestamp = int(time.mktime(date_time.timetuple()) * 1000.0)
    return timestamp


def paramstransfer(link_list):
    '''common link change to esight link'''
    trans_list = []
    for link in link_list:
        param_body = {}
        param_body["linkName"] = link.get('name', '')
        param_body["aliasName"] = link.get('name', '')
        param_body["aNeDn"] = link.get('left-resource-id', '')
        param_body["aNeName"] = link.get('left-node-name', '')
        param_body["aNeIp"] = link.get('left-node-ip', '')
        param_body["aPortDn"] = link.get('left-ltp-id', '')
        param_body["aPortName"] = link.get('left-ltp-name', '')
        param_body['aParentPortName'] = link.get('left-ethtrunk', '')
        param_body["zNeDn"] = link.get('right-resource-id', '')
        param_body["zNeName"] = link.get('right-node-name', '')
        param_body["zNeMac"] = link.get('right-node-mac', '')
        param_body["zNeIp"] = link.get('right-node-ip', '')
        param_body["zPortDn"] = link.get('right-ltp-id', '')
        param_body["zPortName"] = link.get('right-ltp-name', '')
        param_body['zParentPortName'] = link.get('right-ethtrunk', '')
        param_body['zNeSysDesc'] = link.get('right-sys-description', '')
        param_body["linkCategory"] = 2
        param_body["linkUsedStatus"] = "ACTIVE"
        param_body["linkSource"] = 2
        param_body["providerNetwork"] = link.get('provider-network', '')
        param_body["zChassisId"] = link.get('right-chassis-id', '')
        param_body["tenantId"] = "00000000-0000-0000-0000-000000000000"
        bii = {'INNER': 0, 'EDGE': 1, 'HOST': 2}
        if not link.get('link-type'):
            if link.get('right-node-ip') is not None:
                param_body["linkClassification"] = bii[link.get('link-type', 'INNER')]
            else:
                if link.get('right-node-mac') == link.get('right-ltp-mac'):
                    param_body["linkClassification"] = bii[link.get('link-type', 'HOST')]
                else:
                    param_body["linkClassification"] = bii[link.get('link-type', 'EDGE')]
        else:
            param_body["linkClassification"] = bii[link.get('link-type', 'INNER')]
        auto_flag = link.get('auto-create-flag', False)
        if auto_flag:
            param_body["linkType"] = 1
            param_body["custom"] = 1
        else:
            param_body["linkType"] = 99
            param_body["custom"] = 0
        trans_list.append(param_body)
    return trans_list


def post2esight(rest_param):
    '''use esight IR'''
    LOG_FILE.info("esightlink: /rest/entlinkmgmtservice/v1/links post rest_param %s", rest_param)
    url = "/rest/entlinkmgmtservice/v1/dcnlinks/migrate"
    for _ in range(5):
        result, response = utils.send_rest(_IP, 32018, url, mode="POST", log=LOG,
                                           body=rest_param, sleep=6, retry_times=30,
                                           content="entlinkmgmtservice")
        LOG_FILE.info("esightlink response: %s", response)
        try:
            error_code = json.loads(response.decode()).get("errorCode", 1)
            if error_code == 0 and result == SUCCESS:
                LOG.info("eSight Link Interface Call Successful")
                return SUCCESS
        except (AttributeError, json.decoder.JSONDecodeError):
            LOG_FILE.exception("exception logged")
        time.sleep(10)
    LOG.error("eSight link interface call failed")
    return REQ_FAILED


def main():
    '''main funtion'''
    res = getdcnsdata(1)
    if res[0] == 0:
        rest_param = dcndata2esight(res[1])
        post2esight_code = post2esight(rest_param)
        if post2esight_code != SUCCESS:
            return post2esight_code
        total_page_size = res[2]
        if total_page_size != 1:
            for current_size in range(2, total_page_size + 1):
                res = getdcnsdata(current_size)
                if res[0] != SUCCESS:
                    return res[0]
                rest_param = dcndata2esight(res[1])
                post2esight_code = post2esight(rest_param)
                if post2esight_code != SUCCESS:
                    return post2esight_code
    elif res[0] == 5:
        LOG.info("eSight link data is null, do not need migrate.")
        return SUCCESS
    else:
        return res[0]
    return SUCCESS


sys.exit(main())
