# coding=utf-8
'''
IR_networkinventory.py
'''
import json
import time
import sys
from utils import set_log
from utils import utils


SUCCESS = 0
REQ_FAILED = 1
REQ_NONE = 2
REQ_EXCEPTION = 3
REQ_NODEPLOY = 4
LOG = set_log.set_log(stream=True)
_IP = utils.get_local_ip()


def get_upgrading(upgrade_res_content):
    '''get if'''
    task_id = upgrade_res_content['error_msg']
    progress_url = '/rest/networkinventoryservice/v1/interfaces/upgrade/dcn/progress?id=' \
                  + task_id
    is_upgrading = True
    while is_upgrading:
        result, ret = utils.send_rest(_IP, 32018, progress_url, mode="GET",
                                      log=LOG, sleep=6, retry_times=30,
                                      content="networkinventoryservice")
        if result == SUCCESS:
            upgrade_res_content = json.loads(str(ret, encoding='utf-8'))
            if upgrade_res_content['error_code'] == 0:
                if upgrade_res_content['error_msg'] == "upgrading":
                    LOG.info(
                        'The networkinventory upgrade interface is being executed, waiting.')
                    time.sleep(5)
                elif upgrade_res_content['error_msg'] == "success":
                    LOG.info(
                        'The implementation of the networkinventory '
                        'upgrade interface was successful.'
                    )
                    return SUCCESS
                else:
                    LOG.error(upgrade_res_content['error_msg'])
                    return REQ_FAILED
            else:
                LOG.error(upgrade_res_content['error_msg'])
                return REQ_FAILED
        else:
            LOG.error('Get upgrade progress failed')
            return REQ_EXCEPTION
    return REQ_FAILED


def execute():
    '''execute'''
    url = "/rest/networkinventoryservice/v1/interfaces/upgrade/dcn"
    result, ret = utils.send_rest(_IP, 32018, url, mode="POST", log=LOG,
                                  sleep=6, retry_times=30,
                                  content="networkinventoryservice")
    if result == SUCCESS:
        upgrade_res_content = json.loads(str(ret, encoding='utf-8'))
        if upgrade_res_content['error_code'] == 0:
            upgrading_result = get_upgrading(upgrade_res_content)
            if upgrading_result != SUCCESS:
                return upgrading_result
            return SUCCESS
        else:
            LOG.info(upgrade_res_content['error_code'])
            return REQ_EXCEPTION
    else:
        LOG.error(
            'Failed to perform the networkinventory '
            'upgrade interface.'
        )
    return REQ_EXCEPTION


def main():
    '''main'''
    return execute()


sys.exit(main())
