# coding=utf-8
'''global'''
import json
import time
import sys
from utils import set_log
from utils import utils

SUCCESS = 0
REQ_FAILED = 1
REQ_NONE = 2
REQ_EXCEPTION = 3
REQ_NODEPLOY = 4
LOG = set_log.set_log(stream=True)
_IP = utils.get_local_ip()


def get_upgrading(upgrade_res_content):
    '''getupgrading'''
    task_id = upgrade_res_content['id']
    progress_url = '/rest/networkmgmtservice/v1/devices/upgrade/' \
                   + task_id
    is_upgrading = True
    while is_upgrading:
        result, ret = utils.send_rest(_IP, 32018, progress_url, mode="GET", log=LOG,
                                      sleep=6, retry_times=30,
                                      content="networkmgmtservice")
        if result == SUCCESS:
            upgrade_res_content = json.loads(str(ret, encoding='utf-8'))
            LOG.info(upgrade_res_content)
            if upgrade_res_content['errorCode'] == 0:
                if upgrade_res_content['status'] == "RUNNING":
                    LOG.info(
                        'The networkmgmt upgrade interface is being executed, waiting.'
                    )
                    time.sleep(5)
                elif upgrade_res_content['status'] == "SUCCESS":
                    LOG.info(
                        'The implementation of the networkmgmt upgrade interface was successful.'
                    )
                    return SUCCESS
                elif upgrade_res_content['status'] == "FAILED":
                    LOG.error(
                        'The implementation of the networkmgmt upgrade interface was failed.'
                    )
                    return REQ_FAILED
                else:
                    LOG.info(upgrade_res_content['errorMsg'])
                    return REQ_FAILED
            else:
                LOG.error(upgrade_res_content['errorMsg'])
                return REQ_FAILED
        else:
            LOG.error(
                'Get upgrade progress failed'
            )
            return REQ_EXCEPTION
    return REQ_FAILED


def start_upgrade(upgrade_res_content):
    '''start_upgrade'''
    task_id = upgrade_res_content['id']
    progress_url = '/rest/networkmgmtservice/v1/devices/upgrade/' \
                   + task_id
    result, _ = utils.send_rest(_IP, 32018, progress_url, mode="PUT", log=LOG,
                                sleep=6, retry_times=30,
                                content="networkmgmtservice")

    if result == SUCCESS:
        LOG.info(
            'The networkmgmt upgrade interface is starting'
        )
    else:
        LOG.error(
            'Failed start task'
        )
    return result


def execute():
    '''execute'''
    upgrade_url = '/rest/networkmgmtservice/v1/devices/upgrade'
    result, ret = utils.send_rest(_IP, 32018, upgrade_url, mode="POST", log=LOG,
                                  sleep=6, retry_times=30,
                                  content="networkmgmtservice")

    if result == SUCCESS:
        upgrade_res_content = json.loads(str(ret, encoding='utf-8'))
        if upgrade_res_content['errorCode'] == 0:
            start_upgrade_status = start_upgrade(upgrade_res_content)
            if start_upgrade_status != SUCCESS:
                return start_upgrade_status
            upgrading_result = get_upgrading(upgrade_res_content)
            if upgrading_result != SUCCESS:
                return upgrading_result
            return SUCCESS
        else:
            LOG.info(upgrade_res_content['error_code'])
            return REQ_EXCEPTION
    else:
        LOG.info(
            'Failed to perform the networkmgmt upgrade interface. Upgrade response is:%s', ret
        )
    return REQ_EXCEPTION


def check():
    '''
    检测服务是否启动
    :return:
    '''
    url = "/restconf/operations/huawei-ac-unisouth-l2topo:batch-query-l2topo-links"
    url2 = "/sdn/acdcn/ovs-consistency/dcnopenemservice/healthcheck"
    input_param = {
        "input": {
            "query-l2topo-link": {
                "query-field-maps": [],
                "start": "1", "limit": "100"
            }
        }
    }
    times = 0
    sleep_time = 20
    # 20min的时间
    while times <= 12 * 60 // sleep_time:
        result, _ = utils.send_rest(_IP, 32018, url, mode="POST", log=LOG,
                                    sleep=0, retry_times=0, body=input_param,
                                    content="check dcnsevice")
        result2, _ = utils.send_rest(_IP, 32018, url2, mode="GET", log=LOG,
                                     sleep=0, retry_times=0, content="check openemsevice")
        if result == SUCCESS and result2 == SUCCESS:
            LOG.info("service start success")
            return True
        LOG.info("service starting")
        time.sleep(sleep_time)
        times += 1
    LOG.info("service start failed")
    return False


def main():
    '''main'''
    check()
    for _ in range(20):
        result = execute()
        if result == SUCCESS:
            return result
        time.sleep(30)
    return REQ_FAILED


sys.exit(main())
