# coding=utf-8
'''
modify_bgp_nic_usage
'''

import sys
import json
from utils import set_log
from utils import utils

NETWORK_JSON_FILE = sys.argv[1]
UPGRADE_OR_ROLLBACK = sys.argv[2]

LOG = set_log.set_log(stream=True)
SUCCESS = 0
REQ_FAILED = 1

def main():
    '''
    主函数
    :return:
    '''
    if UPGRADE_OR_ROLLBACK == "upgrade":
        BGPUSAGE_1 = "BGP_FLOATIP"
    else:
        BGPUSAGE_1 = "BGPSouthBound"
    _ip = utils.get_local_ip()
    port = utils.get_gmt_port()
    result = SUCCESS
    url = "/rest/plat/maintenanceservice/v1/commissioning/silence/IP"
    input_param = {"actionkey": "modifyFloatingIP", "startProduct": "true", "datalist": []}
    with open(NETWORK_JSON_FILE, "rb") as _f:
        network_json = json.load(_f)
        network_json_list = network_json.get("floatingip", [])
    for float_ip_data in network_json_list:
        usages_str = float_ip_data.get("usage")
        if BGPUSAGE_1 in usages_str:
            if UPGRADE_OR_ROLLBACK == "upgrade":
                new_usage = usages_str.replace("BGP_FLOATIP", "BGPSouthBound")
            else:
                new_usage = usages_str.replace("BGPSouthBound", "BGP_FLOATIP")
            nic = float_ip_data["nodelist"][0]["networkinfo"]["nic"]
            mgrip = float_ip_data["nodelist"][0]["nodemgrip"]
            input_param["datalist"].append({
                "oldnodemgrip": mgrip,
                "newnodemgrip": mgrip,
                "networkinfo": json.dumps([{
                    "nic": nic,
                    "oldip": float_ip_data["floatingip"],
                    "newip": float_ip_data["floatingip"],
                    "oldnetmask": float_ip_data["netmask"],
                    "newnetmask": float_ip_data["netmask"],
                    "oldusage": float_ip_data["usage"],
                    "newusage": new_usage
                }])
            })
            result, _ = utils.send_rest(_ip, port, url, mode="POST",
                                    log=LOG, body=input_param, sleep=6, retry_times=30,
                                    content="Modify bgp nic usage")

    return result


sys.exit(main())
