# coding=utf-8
'''
modify_bgp_nic_usage
'''
import sys
import json
import time
from utils import set_log
from utils import utils

NETWORK_JSON_FILE = sys.argv[1]

LOG = set_log.set_log(stream=True)
SUCCESS = 0
REQ_FAILED = 1

def main():
    '''
    主函数
    :return:
    '''
    _ip = utils.get_local_ip()
    port = utils.get_gmt_port()
    result = SUCCESS
    url = "/rest/plat/maintenanceservice/v1/commissioning/silence/IP"
    input_param = {"actionkey": "modifyFloatingIP", "startProduct": "false", "datalist": []}
    with open(NETWORK_JSON_FILE, "rb") as _f:
        network_json = json.load(_f)
        network_json_list = network_json.get("floatingip", [])
    need_modify = False
    for float_ip_data in network_json_list:
        usages_str = float_ip_data.get("usage")
        if "BGPSouthBound" in usages_str and "LOCALHA" in usages_str:
            LOG.info("need change bgp_float_ip")
            need_modify = True
            for bgp_float_ip_data in float_ip_data.get("nodelist"):
                nic = bgp_float_ip_data["networkinfo"]["nic"]
                mgrip = bgp_float_ip_data["nodemgrip"]
                old_usage = float_ip_data.get("usage")
                new_usage_list = usages_str.split(":")
                new_usage_list.remove("LOCALHA")
                new_usage = ":".join(new_usage_list)
                new_usage = new_usage.replace("BGPSouthBound", "BGP_FLOATIP")
                input_param["datalist"].append({
                    "oldnodemgrip": mgrip,
                    "newnodemgrip": mgrip,
                    "networkinfo": json.dumps([{
                        "nic": nic,
                        "oldip": float_ip_data["floatingip"],
                        "newip": float_ip_data["floatingip"],
                        "oldnetmask": float_ip_data["netmask"],
                        "newnetmask": float_ip_data["netmask"],
                        "oldusage": old_usage,
                        "newusage": new_usage
                    }])
                })

    if not need_modify:
        LOG.info("do not need modify bgp usage")
        return
    LOG.info(input_param)
    task_id = None
    for _ in range(30):
        result, result_info = utils.send_rest(_ip, port, url, mode="POST",
                                              log=LOG, body=input_param, sleep=6, retry_times=0,
                                              content="modify bgp usage")
        LOG.info(json.loads(result_info))
        if result == 0:
            task_id = json.loads(result_info).get("taskid")
            if task_id is not None:
                LOG.info("create task success, task id is %s", task_id)
                break
            time.sleep(6)

    if task_id is not None and task_id != "":
        if not query_task_res(task_id):
            LOG.info("execute timeout.")
            sys.exit(1)
    else:
        LOG.info("execute failed.")
        sys.exit(1)

    return result


def query_task_res(task_id):
    """
        query task process
    """
    _ip = utils.get_local_ip()
    port = utils.get_gmt_port()
    url = "/rest/plat/maintenanceservice/v1/commissioning/silence/IP"
    input_param = {"actionkey": "queryProgress", "datalist": [{"taskid": task_id}]}
    idx = 0
    while idx < 180:
        result, _ = utils.send_rest(_ip, port, url, mode="POST",
                                    log=LOG, body=input_param, sleep=0, retry_times=0,
                                    content="Check float ip")
        if result == 0:
            if json.loads(_).get("progress") == 100:
                return True
        idx += 1
        time.sleep(10)
    return False


sys.exit(main())
