# coding=utf-8
'''
modify_product_info.py
'''
import sys
import json
import os

NOW_PRODUCT_NAME = "iMasterNCE-Fabric"
BEFORE_PRODUCT_NAME = "AgileController-DCN"
PRODUCT_JSON = sys.argv[1]
UPGRADE_TYPE = sys.argv[2]
LOG_DIR = sys.argv[3]
PRODUCT_LOG_FILE = os.path.join(LOG_DIR, "product_name_before_upgrade.json")

FR_PRODUCT_JSON = open(PRODUCT_JSON, 'r')
JSON_PRODUCT = json.loads(FR_PRODUCT_JSON.read())
FR_PRODUCT_JSON.close()

if UPGRADE_TYPE == "upgrade":
    if os.path.exists(PRODUCT_LOG_FILE):
        os.remove(PRODUCT_LOG_FILE)
    if JSON_PRODUCT["productdesc"] == BEFORE_PRODUCT_NAME:
        PRODUCT_INFO = {"productdesc": BEFORE_PRODUCT_NAME,
                        "productext": JSON_PRODUCT["productext"]["productsubtype"]}
        with open(PRODUCT_LOG_FILE, "w") as P_F:
            P_F.write(json.dumps(PRODUCT_INFO, indent=4, separators=(',', ': ') ))

        JSON_PRODUCT["productdesc"] = NOW_PRODUCT_NAME
        JSON_PRODUCT["productext"]["productsubtype"] = NOW_PRODUCT_NAME

        JSON_DATA_STRING = json.dumps(JSON_PRODUCT, indent=4, separators=(',', ': '))
        F_W = open(PRODUCT_JSON, 'w')
        F_W.write(JSON_DATA_STRING)
        F_W.close()
        print("change")
    else:
        print("no change")
elif UPGRADE_TYPE == "rollback":
    if os.path.exists(PRODUCT_LOG_FILE):
        with open(PRODUCT_LOG_FILE, "r") as P_F:
            PRODUCT_INFO = json.loads(P_F.read())
        if PRODUCT_INFO["productdesc"] == BEFORE_PRODUCT_NAME:
            JSON_PRODUCT["productdesc"] = BEFORE_PRODUCT_NAME
            JSON_PRODUCT["productext"]["productsubtype"] = PRODUCT_INFO["productext"]

            JSON_DATA_STRING = json.dumps(JSON_PRODUCT, indent=4, separators=(',', ': '))
            F_W = open(PRODUCT_JSON, 'w')
            F_W.write(JSON_DATA_STRING)
            F_W.close()
            print("change")
        else:
            print("no change")
        os.remove(PRODUCT_LOG_FILE)
    else:
            print("no change")
else:
    print("no change")
