'''
restore_redis_info.py
'''

import os
import subprocess
import py_zenith
import get_db_pass
from utils import set_log


my_log = set_log.set_log(stream=True)


def get_tenant_name():
    '''
        get_tenant_name
    '''
    if os.path.exists("/opt/oss/NCECOMMONE/apps/"):
        return "NCECOMMONE"
    else:
        return "NCE"


def get_ip_and_port(db_instance):
    '''
    :return:
    '''
    _ip = ""
    port = ""
    command = "/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep -E %s |grep Master" % db_instance
    my_log.info(command)
    result, result_str = subprocess.getstatusoutput(command)
    my_log.info(result_str)
    if result == 0 and result_str:
        _ip = result_str.split()[5]
        port = result_str.split()[6]
    else:
        my_log.info("single db instance")
        command = "/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep -E %s" % db_instance
        my_log.info(command)
        result, result_str = subprocess.getstatusoutput(command)
        my_log.info(result_str)
        if result == 0 and result_str:
            _ip = result_str.split()[5]
            port = result_str.split()[6]
    return _ip, port


def create_table(zenith_connect, upgrade_type):
    '''
    :param zenith_connect:
    :return:
    '''
    sql = "create table if not exists zenith_instance_info (instance_id varchar(50), instance_name varchar(50), " \
          "ip varchar(50), port varchar(20), is_master varchar(20), status varchar(20), upgrade_type varchar(20))"
    zenith_connect.excute(sql)
    if upgrade_type == "before_upgrade":
        sql = "delete from zenith_instance_info"
        zenith_connect.excute(sql)
    else:
        sql = "delete from zenith_instance_info where upgrade_type='%s'" % upgrade_type
        zenith_connect.excute(sql)


def restore_redis(zenith_connect, upgrade_type, tenant_name):
    '''
    :param zenith_connect:
    :param upgrade_type:
    :return:
    '''
    command = "/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance -tenant %s | grep redis" % tenant_name
    result, result_str = subprocess.getstatusoutput(command)
    my_log.info(result_str)
    if result == 0 and result_str.strip():
        for redis_info in result_str.split("\n"):
            if redis_info.strip():
                instance_id = redis_info.split()[0]
                instance_name = redis_info.split()[2]
                _ip = redis_info.split()[5]
                port = redis_info.split()[6]
                is_master = redis_info.split()[10]
                status = redis_info.split()[11]
                sql = "insert into zenith_instance_info " \
                      "values('%s', '%s', '%s', '%s', '%s', '%s', '%s')" % (instance_id, instance_name,
                                                                            _ip, port, is_master,
                                                                            status, upgrade_type)
                my_log.info(sql)
                zenith_connect.excute(sql)


def delete_redis_instance(zenith_connect, cur_path, tenant_name):
    '''
    :param zenith_connect:
    :param cur_path:
    :return:
    '''
    before_upgrade_sql = "select instance_name from zenith_instance_info where upgrade_type='before_upgrade'"
    after_upgrade_sql = "select instance_name from zenith_instance_info where upgrade_type='after_upgrade'"
    before_upgrade_redis_instance_set = set()
    after_upgrade_redis_instance_set = set()
    for row in zenith_connect.select(before_upgrade_sql):
        before_upgrade_redis_instance_set.add(row[0].split("-")[0])
    for row in zenith_connect.select(after_upgrade_sql):
        after_upgrade_redis_instance_set.add(row[0].split("-")[0])
    result = after_upgrade_redis_instance_set.difference(before_upgrade_redis_instance_set)
    command = '''/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance -tenant %s|grep ''' % tenant_name
    for instance_name in result:
        command += "-e %s " % instance_name
    command += '''|grep Master|awk '{print $1 "\t" $6}' >> %s/dbinstance_redis.txt''' % cur_path
    my_log.info(command)
    result_code, _ = subprocess.getstatusoutput(command)
    return result_code


def main(upgrade_type, cur_path=""):
    '''
    upgrade_type: 升级前还是升级后，还是回滚
    action: 存储还是删除
    :return:
    '''
    db_instance = "dcnnwlocaldb"
    db_name = "dcnnwlocalpersistentdb"
    zenith_connect = None
    try:
        # 获取租户
        tenant_name = get_tenant_name()
        # 获取数据库连接
        _ip, port = get_ip_and_port(db_instance)
        password = get_db_pass.main(db_instance, db_name, "zenith", product_type="NCE").split(',')[-1]
        if not _ip or not port or not password:
            my_log.info("get ip or port or password failed")
            return 2
        zenith_connect = py_zenith.Zenith(
            host=_ip,
            username=db_name,
            password=password,
            port=str(port))

        create_table(zenith_connect, upgrade_type)
        restore_redis(zenith_connect, upgrade_type, tenant_name)
        if upgrade_type == "rollback":
            if not cur_path:
                my_log.error("failed, cur_path is empty")
                return 1
            path = os.path.join(cur_path, 'dbinstance_redis_all.txt')
            with open(path, 'w') as _f:
                query_all_sql = "select * from zenith_instance_info"
                res = zenith_connect.select(query_all_sql)
                for row in res:
                    _f.write(str(row) + "\n")
            return delete_redis_instance(zenith_connect, cur_path, tenant_name)
        return 0
    except:
        my_log.exception("Exception log:")
        return 3
    finally:
        if zenith_connect:
            zenith_connect.close()
