# coding=utf-8
'''
modify_bgp_nic_usage
'''

import sys
import json
import time
import get_ip_by_num
from utils import set_log
from utils import utils

NETWORK_JSON_FILE = sys.argv[1]

LOG = set_log.set_log(stream=True)
SUCCESS = 0
REQ_FAILED = 1
SLAVE_IP = get_ip_by_num.get_ip('1')


def main():
    '''
    主函数
    :return:
    '''
    _ip = utils.get_local_ip()
    port = utils.get_gmt_port()
    result = SUCCESS
    url = "/rest/plat/maintenanceservice/v1/commissioning/silence/IP"
    input_param = {"actionkey": "modifyFloatingIP", "startProduct": "true", "datalist": []}
    with open(NETWORK_JSON_FILE, "rb") as _f:
        network_json = json.load(_f)
        network_json_list = network_json.get("floatingip", [])
    for float_ip_data in network_json_list:
        usages_str = float_ip_data.get("usage")
        if "BGP_FLOATIP" in usages_str and 3 == len(float_ip_data.get("nodelist")):
            for bgp_float_ip_data in float_ip_data.get("nodelist"):
                nic = bgp_float_ip_data["networkinfo"]["nic"]
                mgrip = bgp_float_ip_data["nodemgrip"]
                input_param["datalist"].append({
                    "oldnodemgrip": mgrip,
                    "newnodemgrip": mgrip,
                    "networkinfo": json.dumps([{
                        "nic": nic,
                        "oldip": "",
                        "newip": float_ip_data["floatingip"],
                        "oldnetmask": "",
                        "newnetmask": float_ip_data["netmask"],
                        "oldusage": "",
                        "newusage": usages_str
                    }])
                })
                result, _ = utils.send_rest(_ip, port, url, mode="POST",
                                        log=LOG, body=input_param, sleep=6, retry_times=30,
                                        content="Modify north float ip usage")
                if result == 0:
                    task_id = json.loads(_).get("taskid")
                if task_id != "":
                    if not query_task_res(task_id):
                        print("execute timeout.")
                        sys.exit(1)
                else:
                    print("execute failed.")
                    sys.exit(1)
    return result


def query_task_res(task_id):
    """
        query task process
    """
    _ip = utils.get_local_ip()
    port = utils.get_gmt_port()
    url = "/rest/plat/maintenanceservice/v1/commissioning/silence/IP"
    input_param = {"actionkey": "queryProgress", "datalist": [{"taskid": task_id}]}
    idx = 0
    while idx < 180:
        result, _ = utils.send_rest(_ip, port, url, mode="POST",
                                    log=LOG, body=input_param, sleep=6, retry_times=30,
                                    content="Delete float ip")
        if result == 0:
            if json.loads(_).get("progress") == 100:
                return True
        idx += 1
        time.sleep(10)
    return False


sys.exit(main())
