# encoding=utf-8
"""
功 能：方案和参数规划校验参数
版权信息：华为技术有限公司，版本所有(C) 2019-2029
修改记录：2019-12-11 12:00 创建
"""
import os
import json
import subprocess
from easysuite import settings
from func.upgrade.upgrade_operation_mgr.dao.upgrade_maintask_dao import UpgradeMainTaskDao


def exe(kvs):
    """
    功能说明:检验升级参数
    :param kvs
    :return 校验成功返回200, '';失败返回 500, 附上国际化后的报错信息
    """
    plugin_dir = "/opt/oss/easysuite/easysuite/easysuite/plugins/iMasterNCE-Fabric/upgrade_online"
    flag_file = os.path.join(plugin_dir, "service/scripts/flag_dir/is_hybrid_telecom_cloud_scenario.txt")
    if os.path.exists(flag_file):
        os.remove(flag_file)
    is_hybrid_telecom_cloud_scenario = kvs.get('is_hybrid_telecom_cloud_scenario_confirm')
    if is_hybrid_telecom_cloud_scenario == 'YES':
        result = subprocess.call(["touch", flag_file])
        if result != 0:
            return 500, {'status': 'failed', 'item_result': "touch flag_file failed"}
    else:
        # 不是电信云场景，要去删除文件，因为有可能重新点参数校验
        if os.path.exists(flag_file):
            os.remove(flag_file)

    modify_upgrade_os_type(kvs)
    return 200, ''


def modify_upgrade_os_type(kvs):
    """
    :param param: 修改os升级方式
    """
    if "id_two_hop_upgrade" in kvs.get("upgrade_item"):
        task_id = kvs.get("easysuite.task_id", "")
        old_params = json.loads(UpgradeMainTaskDao.query(task_id)[0].get("params", {}))
        old_params.update({"os_upgrade_online": "false"})
        UpgradeMainTaskDao.modify(task_id, {"params": json.dumps(old_params)})


def modify_step(kvs):
    """
    :param param: 修改os升级方式
    """
    task_id = kvs.get("easysuite.task_id", "")
    old_params = json.loads(UpgradeMainTaskDao.query(task_id)[0].get("params", {}))
    is_secondphase = old_params.get("is_secondphase", "false")
    if is_secondphase == "true":
        product = kvs.get('product')
        json_base_path_dr = os.path.join(settings.VAR_DIR, 'task_config', str(task_id), str(product),
                                         'service', 'config', 'upgradebusiness_drsite.json')
        json_base_path_one = os.path.join(settings.VAR_DIR, 'task_config', str(task_id), str(product),
                                          'service', 'config', 'upgradebusiness_onesite.json')
        modify_step_file(json_base_path_one)
        modify_step_file(json_base_path_dr)


def modify_step_file(json_base_path):
    '''
    修改流程
    :param json_base_path:
    :return:
    '''
    with open(json_base_path, "rb") as _f:
        content = json.load(_f)

    for step in content["steps"]:
        if "child_steps_task_flow" in step:
            tasks1 = step["child_steps_task_flow"]["stage1"]["tasks1"]
            if "upgrade_db_software" in tasks1:
                tasks1.remove("upgrade_db_software")
            if "update_mgr_db" in tasks1:
                tasks1.remove("update_mgr_db")
            tasks1.append("upgrade_db_software")
            tasks1.append("update_mgr_db")

    with open(json_base_path, "w") as _f_w:
        _f_w.write(json.dumps(content, indent=4, separators=(',', ': ')))

