#!/bin/bash
# logic rep shutdown shell.
# Copyright © Huawei Technologies Co., Ltd. 2010-2019. All rights reserved.

curr_path=$(dirname $(readlink -f $0))
os_user=$(whoami)
file_user=`ls -l ${curr_path}"/shutdown.sh" | awk '{print $3}'`

if [[ ${file_user} != ${os_user} ]] || [[ ${os_user} == root ]]; then
    echo "Can't run shutdown.sh, because it does not belong to the current user or the user is root."
    exit 1
fi

#receive parameters
while getopts "n:f" opt; do
    case $opt in
        n)
            REPNAME=$OPTARG
            REPNAMETAG="yes"
        ;;
        f)
            FORCETAG="yes"
        ;;
        \?)
            echo "Invalid option: -$OPTARG"
            exit 1
        ;;
   esac
done

sequence_num="1611"
real_rep_name=$REPNAME$sequence_num

if [[ "$REPNAMETAG" == "yes" && "$FORCETAG" == "yes"  ]]; then
    ps -ux |grep ZLogCatcherMain |grep -v grep|grep "${curr_path}"|grep "${real_rep_name}"|awk -F ' ' '{print $2}'|xargs kill -9
    echo "Close logic replication name=$REPNAME process successfully with -f."
elif [ "$REPNAMETAG" == "yes" ]; then
    ps -ux |grep ZLogCatcherMain |grep -v grep|grep "${curr_path}"|grep "${real_rep_name}"|awk -F ' ' '{print $2}'|xargs kill -15
echo "Logical replication name=$REPNAME process is stopping, please wait......"
    run_time=0
    var2="$(ps -ux |grep ZLogCatcherMain |grep -v grep|grep "${curr_path}"|grep "${real_rep_name}"|awk -F ' ' '{print $2}')"
    while [ "$var2" != "" ]
    do
        sleep 5
        var2="$(ps -ux |grep ZLogCatcherMain |grep -v grep|grep "${curr_path}"|grep "${real_rep_name}"|awk -F ' ' '{print $2}')"
        if [ "$var2" != "" ]; then
            ps -ux |grep ZLogCatcherMain |grep -v grep|grep "${curr_path}"|grep "${real_rep_name}"|awk -F ' ' '{print $2}'|xargs kill -15
        else
            break;
        fi
        run_time=$run_time+1
        if [ $run_time == 6 ]; then
           echo "It takes too long to stop the logical replication process,we will use the kill -9 command to kill it."
           ps -ux |grep ZLogCatcherMain |grep -v grep|grep "${curr_path}"|grep "${real_rep_name}"|awk -F ' ' '{print $2}'|xargs kill -9
           sleep 5
           break
        fi
    done
    echo "Close logic replication name=$REPNAME process successfully."
else
    echo "Close logic replication process failed, please specify logic replication name which you want to shutdown with -n parameter."
fi
exit 0 
