#!/bin/bash
# start logic replication watchdog process shell.
# Copyright © Huawei Technologies Co., Ltd. 2010-2020. All rights reserved.

set +e

# find app home directory
APP_HOME=$(cd `dirname $0`;pwd)

curr_path=$(dirname $(readlink -f $0))
os_user=$(whoami)
file_user=`ls -l ${curr_path}"/watchdog_logicrep.sh" | awk '{print $3}'`

if [[ ${file_user} != ${os_user} ]] || [[ ${os_user} == root ]]; then
    echo "Can't run watchdog_logicrep.sh, because it does not belong to the current user or the user is root."
    exit 1
fi

sh startup.sh $*
if [ $? -ne 0 ]; then
	echo "start logic replication progress failed!"
	exit 1
fi

#receive parameters
while getopts "n:a:u:t:m:g:qc" opt; do
  case $opt in
    n)
	  REPNAME=$OPTARG
      ;;
    \?)
      echo "Invalid option: -$OPTARG"
      exit 1	  
      ;;
  esac
done

sequence_num="1611"
real_rep_name=$REPNAME$sequence_num
var1="$(ps -ux |grep ZLogCatcherMain |grep -v grep|grep "${curr_path}"|grep "${real_rep_name}"|awk -F ' ' '{print $2}')"

# wait for startup information
i=0
while :
do
    sleep 30
    var2="$(ps -ux |grep ZLogCatcherMain |grep -v grep|grep "${curr_path}"|grep "${real_rep_name}"|awk -F ' ' '{print $2}')"
    if [ "$var2" != "" ]; then
	    i=0;
	    continue
	else
	    sh startup.sh -n "${REPNAME}"
        i=$(expr $i + 1)
    fi
	
	if [ $i -eq 3 ];then
        echo "Logical replication tool process failed to start after 3 attempts, repname is ${REPNAME}."
	    break
	fi
done

cat "${APP_HOME}"/log/console.log
set -e
exit 0