#!/bin/bash
# shutdown logic replication watchdog process shell.
# Copyright © Huawei Technologies Co., Ltd. 2010-2020. All rights reserved.

curr_path=$(dirname $(readlink -f $0))
os_user=$(whoami)
file_user=`ls -l ${curr_path}"/watchdog_shutdown.sh" | awk '{print $3}'`

if [[ ${file_user} != ${os_user} ]] || [[ ${os_user} == root ]]; then
    echo "Can't run watchdog_shutdown.sh, because it does not belong to the current user or the user is root."
    exit 1
fi

#receive parameters
while getopts "n:f" opt; do
    case $opt in
        n)
            REPNAME=$OPTARG
            REPNAMETAG="yes"
        ;;
        f)
            FORCETAG="yes"
        ;;
        \?)
            echo "Invalid option: -$OPTARG"
            exit 1
        ;;
   esac
done

watchdogNum=`ps -ux |grep watchdog_logicrep |grep -v grep|grep "${REPNAME}"|wc -l`
if [ "$watchdogNum" -gt 1 ]; then
    echo "Please manually kill the watchdog_logicrep.sh process because the number of processes under the same user and repName is greater than 1"
    exit 1
fi

if [[ "$REPNAMETAG" == "yes" && "$FORCETAG" == "yes"  ]]; then
    ps -ux |grep watchdog_logicrep |grep -v grep|grep "${REPNAME}"|awk -F ' ' '{print $2}'|xargs kill -9
    echo "Close logic replication watchdog=$REPNAME process successfully with -f."
elif [ "$REPNAMETAG" == "yes" ]; then
    ps -ux |grep watchdog_logicrep |grep -v grep|grep "${REPNAME}"|awk -F ' ' '{print $2}'|xargs kill -15
    echo "Logical replication watchdog=$REPNAME process is stopping, please wait......"
    run_time=0
    ps -ux |grep watchdog_logicrep |grep -v grep|grep "${REPNAME}"|awk -F ' ' '{print $2}'|while read line
    do
        sleep 2
        run_time=$run_time+1
        if [ $run_time == 15 ]; then
           echo "It takes too long to stop the logical replication watchdog process,we will use the kill -9 command to kill its process."
           ps -ux |grep watchdog_logicrep |grep -v grep|grep "${REPNAME}"|awk -F ' ' '{print $2}'|xargs kill -9
           break
        fi
    done
    echo "Close logic replication watchdog=$REPNAME process successfully."
else
    echo "Close logic replication watchdog process failed, please specify logic replication name for watchdog which you want to shutdown with -n parameter."
fi
exit 0 
