#!/bin/bash

CONFIG_FILE=$1
DB_TYPE=$2
DS_TYPE=$3
DS_URL=$4
DS_NSERNAME=$5
DS_PASSWD=$6
encrypted_passwd="default_value"

encrypt_pwd(){

passwd=$1
#-f 指定随机密钥因子
#-k 指定工作密钥

f_key1=`cat $LOGICREP_HOME/conf/sec/key1.properties | awk -F"key=" '{print $2}'`
k_key2=`cat $LOGICREP_HOME/conf/sec/key2.properties | awk -F"key=" '{print $2}'`

/usr/bin/expect << EOF 2>&1 >> tmp_encrypt_file
spawn zencrypt -e AES256 -f $f_key1 -k $k_key2

expect "Please enter password to encrypt:*"
send -- "$passwd\r"

expect "Please input password again:*"
send -- "$passwd\r"
expect eof
EOF

encrypted_passwd=`cat tmp_encrypt_file |grep Cipher|awk -F":" '{print $2}'| sed s/[[:space:]]//g`
rm -rf tmp_encrypt_file

if [[ ${encrypted_passwd} == "" ]] || [[ ${encrypted_passwd} == NULL ]]
then 
    echo "fail to encrypt the password"
    exit 1
fi
}

confige_srcdb(){
    srcdb_ds_type=$1
    srcdb_ds_url=$2
    srcdb_ds_username=$3
    srcdb_ds_passwd=$4
    encrypt_pwd $srcdb_ds_passwd
    change_confige $srcdb_ds_type $srcdb_ds_url $srcdb_ds_username $encrypted_passwd
}

confige_dstdb(){
    dstdb_ds_type=$1
    dstdb_ds_url=$2
    dstdb_ds_username=$3
    dstdb_ds_passwd=$4
    encrypt_pwd $dstdb_ds_passwd
    change_confige $dstdb_ds_type $dstdb_ds_url $dstdb_ds_username $encrypted_passwd
}

change_confige(){
    ds_type=$1
    ds_url=$2
    ds_username=$3
    ds_passwd=$4
    #db位置
    db_line=`cat $CONFIG_FILE |grep -n $DB_TYPE | awk -F":" '{print $1}'`
    #替换ds.type
    let 'db_line+=1'
    s_ds_type=`sed -n "$db_line p" $CONFIG_FILE|awk -F"=" '{print $2}'`
    sed -i "$db_line s/$s_ds_type/$ds_type/g" $CONFIG_FILE
    s_ds_type2=`sed -n "$db_line p" $CONFIG_FILE|awk -F"=" '{print $2}'`    
    #替换ds.url
    let 'db_line+=1'
    s_ds_url=`sed -n "$db_line p" $CONFIG_FILE|awk -F"=" '{print $2}'`
    s_ds_url2=`sed -i "$db_line s/$s_ds_url/$ds_url/g" $CONFIG_FILE`
    #替换ds.username
    let 'db_line+=1'
    s_ds_username=`sed -n "$db_line p" $CONFIG_FILE|awk -F"=" '{print $2}'`
    s_ds_username2=`sed -i "$db_line s/$s_ds_username/$ds_username/g" $CONFIG_FILE`
    #替换ds.passwd
    let 'db_line+=1'
    let 'db_line+=1'
    s_ds_passwd=`sed -n "$db_line p" $CONFIG_FILE|awk -F"ds.passwd=" '{print $2}'`
    if [[ ${s_ds_passwd} == "" ]] || [[ ${s_ds_passwd} == NULL ]]
    then
        s_ds_passwd2=`sed -i "$db_line s#=#=$ds_passwd#g" $CONFIG_FILE`
    else
        s_ds_passwd2=`sed -i "$db_line s#$s_ds_passwd#$ds_passwd#g" $CONFIG_FILE`
    fi
    exit 0
}
sed -i s/"^transaction.buffer.size=.*"/"transaction.buffer.size=2000"/g conf/init.properties
sed -i s/"^transaction.buffer.memory.size=.*"/"transaction.buffer.memory.size=50"/g conf/init.properties
sed -i s/"^replay.batch.buffer.size=.*"/"replay.batch.buffer.size=10"/g conf/init.properties
sed -i s/"^replayer.thread.number=.*"/"replayer.thread.number=4"/g conf/init.properties
sed -i s/"^replay.mode=.*"/"replay.mode=single"/g conf/init.properties
if [[ ${DB_TYPE} == "srcdb" ]]
then
    echo "begine to confige srcdb"
    confige_srcdb $DS_TYPE $DS_URL $DS_NSERNAME $DS_PASSWD
elif [[ ${DB_TYPE} == "dstdb" ]]
then
    echo "begine to confige dstdb"
    confige_dstdb $DS_TYPE $DS_URL $DS_NSERNAME $DS_PASSWD
else
    echo "please check input, only srcdb or dstdb allows to be modified"
    exit 1
fi
echo "confige success"    
exit 0