#!/bin/bash
if [ `echo $0 | grep -c "/"` -gt 0 ];then
    cd ${0%/*}     
fi
################################################################################
# Function    : fn_verify_os_type
# Description : check the os version.
# parameter list: os_type
# Output      : None
# Return      : 0 success
#               1 failed
################################################################################
function fn_verify_os_type
{
    local os_type=${1}
    local os_version_info=`cat /etc/system-release`
    if [ -z "${os_version_info}" ];
    then
        os_version_info=`cat /etc/os-release | grep  'VERSION_ID=' | awk -F '"' '{print $2}'`
    fi
    local supported_version=()
    case ${os_type} in
        'sles') supported_version=${suse_supported_version[*]}
        ;;
        'euleros') supported_version=${euler_supported_version[*]}
        ;;
        'centos') supported_version=${centos_supported_version[*]}
        ;;
        'bclinux') supported_version=${bclinux_supported_version[*]}
        ;;
        *)  print_log "INFO" "Supported os version list is SUSE,Euler,centOS,BCLinux."
			print_log "ERROR" "Current os type is ${os_type}, It is not supported."
            return 2
    esac
	print_log "INFO" "support version are ${supported_version[*]}."
    for os_version in ${supported_version[*]}
    do 
        if [[ `echo ${os_version_info} | grep ${os_version}` ]];then
			print_log "INFO" "OS version verified successfully. Current OS type is ${os_type}, version type is ${os_version}."
            return 0
        fi
    done
	print_log "ERROR" "OS version verified failed. Current OS type is ${os_type}, version type is not supported. supported version are ${supported_version[*]}."
    return 1
}

################################################################################
# Function    : check_os_version
# Description : check the os version.
# parameter list:null
# Output      : None
# Return      : 0 success
#               1 failed
################################################################################
function check_os_version
{
    local os_release_info=`cat /etc/os-release`
    local os_type=`echo ${os_release_info} | egrep -o '(\sID|^ID)=\"[a-zA-Z]+\"' | awk -F '"' '{print $2}'`
	print_log "INFO" "os release version information is ${os_type}."
    # 验证操作系统版本
    fn_verify_os_type ${os_type}
    return $?
}

