#!/bin/bash

num=$#
if [[ "$num" != 0 ]]
then
    for i in {1..32}
    do	
		  [[ ${1#-} == "plane" ]] && { plane=$2;shift 2;continue; }
      [[ ${1#-} == "netcard_south" ]] && { netcard_south=$2;shift 2;continue; }
      [[ ${1#-} == "netcard_north" ]] && { netcard_north=$2;shift 2;continue; }
      [[ ${1#-} == "netcard_internal" ]] && { netcard_internal=$2;shift 2;continue; }
      [[ ${1#-} == "netcard_second_south" ]] && { netcard_second_south=$2;shift 2;continue; }
      [[ ${1#-} == "north_netcard_ip" ]] && { north_netcard_ip=$2;shift 2;continue; }
      [[ ${1#-} == "north_netcard_v6ip" ]] && { north_netcard_v6ip=$2;shift 2;continue; }
      [[ ${1#-} == "south_netcard_ip" ]] && { south_netcard_ip=$2;shift 2;continue; }
      [[ ${1#-} == "south_netcard_v6ip" ]] && { south_netcard_v6ip=$2;shift 2;continue; }
      [[ ${1#-} == "internal_netcard_ip" ]] && { internal_netcard_ip=$2;shift 2;continue; }
      [[ ${1#-} == "internal_netcard_v6ip" ]] && { internal_netcard_v6ip=$2;shift 2;continue; }
      [[ ${1#-} == "south_second_netcard_ip" ]] && { south_second_netcard_ip=$2;shift 2;continue; }
      [[ ${1#-} == "south_second_netcard_v6ip" ]] && { south_second_netcard_v6ip=$2;shift 2;continue; }
      [[ ${1#-} == "north_netcard_mask" ]] && { north_netcard_mask=$2;shift 2;continue; }
      [[ ${1#-} == "north_netcard_mask_v6ip" ]] && { north_netcard_mask_v6ip=$2;shift 2;continue; }
      [[ ${1#-} == "south_netcard_mask" ]] && { south_netcard_mask=$2;shift 2;continue; }
      [[ ${1#-} == "south_netcard_mask_v6ip" ]] && { south_netcard_mask_v6ip=$2;shift 2;continue; }
      [[ ${1#-} == "south_second_netcard_mask" ]] && { south_second_netcard_mask=$2;shift 2;continue; }
      [[ ${1#-} == "south_second_netcard_mask_ipv6" ]] && { south_second_netcard_mask_ipv6=$2;shift 2;continue; }
      [[ ${1#-} == "north_stack_mode" ]] && { north_stack_mode=$2;shift 2;continue; }
      [[ ${1#-} == "south_stack_mode" ]] && { south_stack_mode=$2;shift 2;continue; }
      [[ ${1#-} == "internal_stack_mode" ]] && { internal_stack_mode=$2;shift 2;continue; }
    done
fi
tmp_hostname="controller-${north_netcard_ip}"
hostname=${tmp_hostname//./-}

sed -i "s/user_plane/${plane}/g" controller.inc
sed -i "s/user_internal_netcard_ip/${internal_netcard_ip}/g" controller.inc
sed -i "s/user_south_netcard_ip/${south_netcard_ip}/g" controller.inc
sed -i "s/user_north_netcard_ip/${north_netcard_ip}/g" controller.inc
sed -i "s/user_second_south_netcard_ip/${south_second_netcard_ip}/g" controller.inc

sed -i "s/user_internal_netcard_v6ip/${internal_netcard_v6ip}/g" controller.inc
sed -i "s/user_south_netcard_v6ip/${south_netcard_v6ip}/g" controller.inc
sed -i "s/user_north_netcard_v6ip/${north_netcard_v6ip}/g" controller.inc
sed -i "s/user_second_south_netcard_v6ip/${south_second_netcard_v6ip}/g" controller.inc

sed -i "s/user_internal_nic/${netcard_internal}/g" controller.inc
sed -i "s/user_south_nic/${netcard_south}/g" controller.inc
sed -i "s/user_north_nic/${netcard_north}/g" controller.inc
sed -i "s/user_second_south_nic/${netcard_second_south}/g" controller.inc


sed -i "s/user_south_mask/${south_netcard_mask}/g" controller.inc
sed -i "s/user_north_mask/${north_netcard_mask}/g" controller.inc
sed -i "s/user_second_south_mask/${south_second_netcard_mask}/g" controller.inc

sed -i "s/user_south_float_ip_v6mask2/${south_netcard_mask_v6ip}/g" controller.inc
sed -i "s/user_north_visipv6_mask/${north_netcard_mask_v6ip}/g" controller.inc
sed -i "s/user_south_second_v6float_mask/${south_second_netcard_mask_ipv6}/g" controller.inc
