#!/bin/bash
#########################################################
# Copyright © Huawei Technologies Co., Ltd. 2020-2020. All rights reserved.
# File name: check_linux_cmd
# Description: 检查linux命令
# Others: 其它内容的说明 
###########################################################
. ./controller.inc

function check_linux_cmd
{  
    #用户不存在则创建临时testuser
    add_user_flag=0
    user=$(cat /etc/passwd | grep "testuser")
    if [ $? -ne 0 ];then
        print_log "INFO" "testuser user is not exist, create testuser user"
        add_user=$(useradd testuser)
        if [ $? -ne 0 ]
        then
            print_log "ERROR" "add testuser user failed."
            return 1
        fi
        print_log "INFO" "add testuser user success."
        add_user_flag=1
    fi
	

    chmod_cmd=$(touch testcmd.txt && chown testuser:users testcmd.txt 2>/dev/null)
    if [ $? -ne 0 ]
    then
        print_log "ERROR" "exec chmod cmd fail."
        return 1
    else
        owner=$(echo $(ls -l testcmd.txt 2>/dev/nullt) | awk '{print $3}') 
        if [ "${owner}" != "testuser" ]
        then
            print_log "ERROR" "Linux cmd chown is not available in the envirment, please check."
            return 1
        fi
        print_log "INFO" "exec chmod cmd successfully, cmd is ok."
    fi

    # 用完删掉用户
    if [ "${add_user_flag}" == "1" ]
    then
        del=$(userdel -r testuser)
        if [ $? -eq 0 ]
        then
            print_log "INFO" "remove testuser user successfully."
        else
            print_log "ERROR" "remove testuser user fail, maybe user testuser is currently used by process,please check."
            return 1
        fi
    fi

    
    #删除文件
    rm -f testcmd.txt
    if [ $? -eq 0 ]
    then
        print_log "INFO" "remove testcmd file successfully."
    else
        print_log "ERROR" "remove testcmd test file fail."
        return 1
    fi
    print_log "INFO" "check linux cmd successfully."
    return 0
}


